/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.constraint;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.LayoutCell;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Layout
extends Constraints {
    private static final Layout layoutConstraint;
    static final boolean DEBUG = false;
    private static final ArrayList cellInfos;
    private static final HashMap tempRigid;
    private static boolean wasChangesQuiet;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Layout() {
    }

    public static Layout getConstraint() {
        return layoutConstraint;
    }

    public static void changesQuiet(boolean quiet) {
        wasChangesQuiet = true;
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        wasChangesQuiet = false;
        cellInfos.clear();
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Layout.newCellInfo(cell);
            }
        }
        tempRigid.clear();
    }

    public void endBatch() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (wasChangesQuiet) {
                    cell.getBounds();
                    continue;
                }
                Layout.getCellInfo(cell).compute();
            }
        }
        cellInfos.clear();
        tempRigid.clear();
    }

    public void modifyNodeInst(NodeInst ni, ImmutableNodeInst oD) {
        Layout.getCellInfo(ni.getParent()).modifyNodeInst(ni, oD);
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        Layout.getCellInfo(ai.getParent()).modifyArcInst(ai);
    }

    public void modifyExport(Export pp, PortInst oldPi) {
        Layout.getCellInfo((Cell)pp.getParent()).modifyExport(pp, oldPi);
    }

    public void newObject(ElectricObject obj) {
        Cell cell = obj.whichCell();
        if (obj == cell) {
            Layout.newCellInfo(cell);
        } else if (cell != null) {
            Layout.getCellInfo(cell).newObject(obj);
        }
    }

    public void newVariable(ElectricObject obj, Variable var) {
    }

    public static void setTempRigid(ArcInst ai, boolean tempRigid) {
        Job.checkChanging();
        Layout.tempRigid.put(ai, tempRigid);
    }

    public static void removeTempRigid(ArcInst ai) {
        Job.checkChanging();
        tempRigid.remove(ai);
    }

    static boolean isRigid(ArcInst ai) {
        Boolean override = (Boolean)tempRigid.get(ai);
        return override != null ? override.booleanValue() : ai.isRigid();
    }

    static Poly oldPortPosition(PortInst pi) {
        NodeInst ni = pi.getNodeInst();
        PortProto pp = pi.getPortProto();
        AffineTransform subrot = Layout.makeOldRot(ni);
        if (subrot == null) {
            return null;
        }
        NodeInst bottomNi = ni;
        PortProto bottomPP = pp;
        while (bottomNi.getProto() instanceof Cell) {
            AffineTransform localtran = Layout.makeOldTrans(bottomNi);
            subrot.concatenate(localtran);
            PortInst bottomPi = Layout.getOldOriginalPort((Export)bottomPP);
            bottomNi = bottomPi.getNodeInst();
            bottomPP = bottomPi.getPortProto();
            localtran = Layout.makeOldRot(bottomNi);
            subrot.concatenate(localtran);
        }
        ImmutableNodeInst d = Layout.getOldD(bottomNi);
        if (!$assertionsDisabled && d == null) {
            throw new AssertionError();
        }
        if (d != bottomNi.getD()) {
            bottomNi = NodeInst.makeDummyInstance(bottomNi.getProto());
            bottomNi.lowLevelModify(d);
        }
        PrimitiveNode np = (PrimitiveNode)bottomNi.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(bottomNi, (PrimitivePort)bottomPP);
        poly.transform(subrot);
        return poly;
    }

    private static AffineTransform makeOldRot(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        return d.orient.rotateAbout(cX, cY);
    }

    private static AffineTransform makeOldTrans(NodeInst ni) {
        ImmutableNodeInst d = Layout.getOldD(ni);
        if (d == null) {
            return null;
        }
        AffineTransform transform = new AffineTransform();
        double cX = d.anchor.getX();
        double cY = d.anchor.getY();
        transform.translate(cX, cY);
        return transform;
    }

    static PortInst getOldOriginalPort(Export e) {
        return Layout.getCellInfo((Cell)e.getParent()).getOldOriginalPort(e);
    }

    static ImmutableNodeInst getOldD(NodeInst ni) {
        return Layout.getCellInfo(ni.getParent()).getOldD(ni);
    }

    private static void newCellInfo(Cell cell) {
        int cellIndex = cell.getCellIndex();
        while (cellInfos.size() <= cellIndex) {
            cellInfos.add(null);
        }
        if (!$assertionsDisabled && cellInfos.get(cellIndex) != null) {
            throw new AssertionError();
        }
        cellInfos.set(cellIndex, new LayoutCell(cell));
    }

    static LayoutCell getCellInfo(Cell cell) {
        return (LayoutCell)cellInfos.get(cell.getCellIndex());
    }

    static {
        $assertionsDisabled = !Layout.class.desiredAssertionStatus();
        layoutConstraint = new Layout();
        cellInfos = new ArrayList();
        tempRigid = new HashMap();
        wasChangesQuiet = false;
    }
}

