/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ParasiticTab
extends PreferencePanel {
    private HashMap layerResistanceOptions;
    private HashMap layerCapacitanceOptions;
    private HashMap layerEdgeCapacitanceOptions;
    private HashMap techMinResistance;
    private HashMap techMinCapacitance;
    private HashMap techGateLengthShrink;
    private HashMap techIncludeGateInResistance;
    private HashMap techIncludeGroundNetwork;
    private JList layerList;
    private DefaultListModel layerListModel;
    private boolean changing;
    private JCheckBox backannotateLayout;
    private JTextField capacitance;
    private JTextField edgeCapacitance;
    private JCheckBox extractPowerGround;
    private JButton factoryReset;
    private JTextField gateLengthSubtraction;
    private JPanel globalValues;
    private JCheckBox includeGate;
    private JCheckBox includeGround;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel maxDist;
    private JTextField maxDistValue;
    private JTextField maxSeriesResistance;
    private JTextField minCapacitance;
    private JTextField minResistance;
    private JPanel parasiticPanel;
    private JTextField resistance;
    private JPanel simpleParasiticOptions;
    private JScrollPane spiceLayer;
    private JComboBox techSelection;
    private JPanel techValues;
    private JPanel topPanel;
    private JCheckBox verboseNaming;

    public ParasiticTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.topPanel;
    }

    public String getName() {
        return "Parasitic";
    }

    public void init() {
        this.changing = false;
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParasiticTab.this.layerListClick();
            }
        });
        this.layerResistanceOptions = new HashMap();
        this.layerCapacitanceOptions = new HashMap();
        this.layerEdgeCapacitanceOptions = new HashMap();
        this.techMinResistance = new HashMap();
        this.techMinCapacitance = new HashMap();
        this.techGateLengthShrink = new HashMap();
        this.techIncludeGateInResistance = new HashMap();
        this.techIncludeGroundNetwork = new HashMap();
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            this.techSelection.addItem(tech.getTechName());
            this.techMinResistance.put(tech, Pref.makeDoublePref(null, null, tech.getMinResistance()));
            this.techMinCapacitance.put(tech, Pref.makeDoublePref(null, null, tech.getMinCapacitance()));
            this.techGateLengthShrink.put(tech, Pref.makeDoublePref(null, null, tech.getGateLengthSubtraction()));
            this.techIncludeGateInResistance.put(tech, Pref.makeBooleanPref(null, null, tech.isGateIncluded()));
            this.techIncludeGroundNetwork.put(tech, Pref.makeBooleanPref(null, null, tech.isGroundNetIncluded()));
            Iterator lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                this.layerResistanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getResistance()));
                this.layerCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getCapacitance()));
                this.layerEdgeCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getEdgeCapacitance()));
            }
        }
        this.techSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.techChanged();
            }
        });
        this.techSelection.setSelectedItem(Technology.getCurrent().getTechName());
        this.resistance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerResistanceOptions, this));
        this.capacitance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerCapacitanceOptions, this));
        this.edgeCapacitance.getDocument().addDocumentListener(new ParasiticLayerDocumentListener(this.layerEdgeCapacitanceOptions, this));
        this.minResistance.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.minCapacitance.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.gateLengthSubtraction.getDocument().addDocumentListener(new ParasiticTechDocumentListener(this));
        this.includeGate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.updateTechnologyGlobals();
            }
        });
        this.includeGround.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.updateTechnologyGlobals();
            }
        });
        this.maxSeriesResistance.setText(TextUtils.formatDouble(Simulation.getSpiceMaxSeriesResistance()));
        this.verboseNaming.setSelected(Simulation.isParasiticsUseVerboseNaming());
        this.backannotateLayout.setSelected(Simulation.isParasiticsBackAnnotateLayout());
        this.extractPowerGround.setSelected(Simulation.isParasiticsExtractPowerGround());
        this.extractPowerGround.setEnabled(false);
        this.maxDistValue.setText(TextUtils.formatDouble(ParasiticTool.getMaxDistance()));
        this.parasiticPanel.setVisible(false);
    }

    private void techChanged() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        Pref pref = (Pref)this.techMinResistance.get(tech);
        this.minResistance.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = (Pref)this.techMinCapacitance.get(tech);
        this.minCapacitance.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = (Pref)this.techGateLengthShrink.get(tech);
        this.gateLengthSubtraction.setText(TextUtils.formatDouble(pref.getDouble()));
        pref = (Pref)this.techIncludeGateInResistance.get(tech);
        this.includeGate.setSelected(pref.getBoolean());
        pref = (Pref)this.techIncludeGroundNetwork.get(tech);
        this.includeGround.setSelected(pref.getBoolean());
        this.layerListModel.clear();
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.layerListModel.addElement(layer.getName());
        }
        this.layerList.setSelectedIndex(0);
        this.layerListClick();
        this.changing = false;
    }

    private void layerListClick() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        String layerName = (String)this.layerList.getSelectedValue();
        Layer layer = tech.findLayer(layerName);
        if (layer != null) {
            Pref resistancePref = (Pref)this.layerResistanceOptions.get(layer);
            this.resistance.setText(TextUtils.formatDouble(resistancePref.getDouble()));
            Pref capacitancePref = (Pref)this.layerCapacitanceOptions.get(layer);
            this.capacitance.setText(TextUtils.formatDouble(capacitancePref.getDouble()));
            Pref edgeCapacitancePref = (Pref)this.layerEdgeCapacitanceOptions.get(layer);
            this.edgeCapacitance.setText(TextUtils.formatDouble(edgeCapacitancePref.getDouble()));
        }
        this.changing = false;
    }

    private void updateTechnologyGlobals() {
        if (this.changing) {
            return;
        }
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        Pref pref = (Pref)this.techMinResistance.get(tech);
        pref.setDouble(TextUtils.atof(this.minResistance.getText()));
        pref = (Pref)this.techMinCapacitance.get(tech);
        pref.setDouble(TextUtils.atof(this.minCapacitance.getText()));
        pref = (Pref)this.techGateLengthShrink.get(tech);
        pref.setDouble(TextUtils.atof(this.gateLengthSubtraction.getText()));
        pref = (Pref)this.techIncludeGateInResistance.get(tech);
        pref.setBoolean(this.includeGate.isSelected());
        pref = (Pref)this.techIncludeGroundNetwork.get(tech);
        pref.setBoolean(this.includeGround.isSelected());
    }

    public void term() {
        boolean b;
        ParasiticTool.setMaxDistance(Double.parseDouble(this.maxDistValue.getText()));
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            Pref pref = (Pref)this.techMinResistance.get(tech);
            if (pref != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setMinResistance(pref.getDouble());
            }
            if ((pref = (Pref)this.techMinCapacitance.get(tech)) != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setMinCapacitance(pref.getDouble());
            }
            if ((pref = (Pref)this.techGateLengthShrink.get(tech)) != null && pref.getDoubleFactoryValue() != pref.getDouble()) {
                tech.setGateLengthSubtraction(pref.getDouble());
            }
            if ((pref = (Pref)this.techIncludeGateInResistance.get(tech)) != null && pref.getBooleanFactoryValue() != pref.getBoolean()) {
                tech.setGateIncluded(pref.getBoolean());
            }
            if ((pref = (Pref)this.techIncludeGroundNetwork.get(tech)) != null && pref.getBooleanFactoryValue() != pref.getBoolean()) {
                tech.setGroundNetIncluded(pref.getBoolean());
            }
            Iterator lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Pref edgeCapacitancePref;
                Pref capacitancePref;
                Layer layer = (Layer)lIt.next();
                Pref resistancePref = (Pref)this.layerResistanceOptions.get(layer);
                if (resistancePref != null && resistancePref.getDoubleFactoryValue() != resistancePref.getDouble()) {
                    layer.setResistance(resistancePref.getDouble());
                }
                if ((capacitancePref = (Pref)this.layerCapacitanceOptions.get(layer)) != null && capacitancePref.getDoubleFactoryValue() != capacitancePref.getDouble()) {
                    layer.setCapacitance(capacitancePref.getDouble());
                }
                if ((edgeCapacitancePref = (Pref)this.layerEdgeCapacitanceOptions.get(layer)) == null || edgeCapacitancePref.getDoubleFactoryValue() == edgeCapacitancePref.getDouble()) continue;
                layer.setEdgeCapacitance(edgeCapacitancePref.getDouble());
            }
        }
        double doubleNow = TextUtils.atof(this.maxSeriesResistance.getText());
        if (Simulation.getSpiceMaxSeriesResistance() != doubleNow) {
            Simulation.setSpiceMaxSeriesResistance(doubleNow);
        }
        if ((b = this.verboseNaming.isSelected()) != Simulation.isParasiticsUseVerboseNaming()) {
            Simulation.setParasiticsUseVerboseNaming(b);
        }
        if ((b = this.backannotateLayout.isSelected()) != Simulation.isParasiticsBackAnnotateLayout()) {
            Simulation.setParasiticsBackAnnotateLayout(b);
        }
        if ((b = this.extractPowerGround.isSelected()) != Simulation.isParasiticsExtractPowerGround()) {
            Simulation.setParasiticsExtractPowerGround(b);
        }
    }

    private void factoryResetActionPerformed(ActionEvent evt) {
        int ret = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all layers to their default resistance and capacitance values?", "Factory Reset", 2, 2);
        if (ret == 0) {
            Iterator it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = (Technology)it.next();
                Iterator lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer layer = (Layer)lIt.next();
                    layer.resetToFactoryParasitics();
                }
            }
            this.init();
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.techValues = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resistance = new JTextField();
        this.jLabel12 = new JLabel();
        this.capacitance = new JTextField();
        this.edgeCapacitance = new JTextField();
        this.factoryReset = new JButton();
        this.parasiticPanel = new JPanel();
        this.maxDist = new JLabel();
        this.maxDistValue = new JTextField();
        this.globalValues = new JPanel();
        this.jLabel20 = new JLabel();
        this.minResistance = new JTextField();
        this.jLabel21 = new JLabel();
        this.minCapacitance = new JTextField();
        this.jLabel5 = new JLabel();
        this.gateLengthSubtraction = new JTextField();
        this.includeGate = new JCheckBox();
        this.includeGround = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.maxSeriesResistance = new JTextField();
        this.simpleParasiticOptions = new JPanel();
        this.verboseNaming = new JCheckBox();
        this.backannotateLayout = new JCheckBox();
        this.extractPowerGround = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.techSelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new GridBagLayout());
        this.techValues.setLayout(new GridBagLayout());
        this.techValues.setBorder(new TitledBorder("Layer Values"));
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel2.setText("Perimeter Cap (fF/um):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel2, gridBagConstraints);
        this.resistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.resistance, gridBagConstraints);
        this.jLabel12.setText("Area Cap (fF/um^2):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel12, gridBagConstraints);
        this.capacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.capacitance, gridBagConstraints);
        this.edgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.edgeCapacitance, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.factoryResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.techValues.add((Component)this.factoryReset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topPanel.add((Component)this.techValues, gridBagConstraints);
        this.parasiticPanel.setLayout(new GridBagLayout());
        this.parasiticPanel.setBorder(new TitledBorder("Parasitic Coupling Options"));
        this.parasiticPanel.setEnabled(false);
        this.maxDist.setText("Maximum distance (lambda)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDist, gridBagConstraints);
        this.maxDistValue.setColumns(6);
        this.maxDistValue.setText("20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDistValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.parasiticPanel, gridBagConstraints);
        this.globalValues.setLayout(new GridBagLayout());
        this.globalValues.setBorder(new TitledBorder("Global Values"));
        this.jLabel20.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.jLabel20, gridBagConstraints);
        this.minResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.minResistance, gridBagConstraints);
        this.jLabel21.setText("Min. Capacitance (fF):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.globalValues.add((Component)this.jLabel21, gridBagConstraints);
        this.minCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.globalValues.add((Component)this.minCapacitance, gridBagConstraints);
        this.jLabel5.setText("Gate Length Shrink (Subtraction) um:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.globalValues.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.globalValues.add((Component)this.gateLengthSubtraction, gridBagConstraints);
        this.includeGate.setText("Include Gate In Resistance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.includeGate, gridBagConstraints);
        this.includeGround.setText("Include Ground Network");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.includeGround, gridBagConstraints);
        this.jLabel1.setText("Max. Series Resistance: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.globalValues.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.maxSeriesResistance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.globalValues, gridBagConstraints);
        this.simpleParasiticOptions.setLayout(new GridBagLayout());
        this.simpleParasiticOptions.setBorder(new TitledBorder("Simple Parasitic Options"));
        this.verboseNaming.setText("Use Verbose Naming");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.verboseNaming, gridBagConstraints);
        this.backannotateLayout.setText("Back-Annotate Layout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.backannotateLayout, gridBagConstraints);
        this.extractPowerGround.setText("Extract Power/Ground");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractPowerGround, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.simpleParasiticOptions, gridBagConstraints);
        this.jLabel3.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.techSelection, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    public static void main(String[] args) {
        new ParasiticTab((Frame)new JFrame(), true).setVisible(true);
    }

    private static class ParasiticTechDocumentListener
    implements DocumentListener {
        private ParasiticTab dialog;

        ParasiticTechDocumentListener(ParasiticTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.updateTechnologyGlobals();
        }
    }

    private static class ParasiticLayerDocumentListener
    implements DocumentListener {
        private ParasiticTab dialog;
        private HashMap map;

        ParasiticLayerDocumentListener(HashMap map, ParasiticTab dialog) {
            this.dialog = dialog;
            this.map = map;
        }

        private void change(DocumentEvent e) {
            String text;
            if (this.dialog.changing) {
                return;
            }
            String techName = (String)this.dialog.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            String layerName = (String)this.dialog.layerList.getSelectedValue();
            Layer layer = tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            Pref pref = (Pref)this.map.get(layer);
            double v = TextUtils.atof(text);
            pref.setDouble(v);
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }
}

