/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GDSTab
extends ProjSettingsPanel {
    private JList gdsLayersList;
    private DefaultListModel gdsLayersModel;
    private boolean changingGDS = false;
    private HashMap<Foundry, HashMap<Layer, String>> layerMap;
    private JComboBox foundrySelection;
    private JPanel gds;
    private JTextField gdsCellNameLenMax;
    private JTextField gdsDefaultTextLayer;
    private JLabel gdsFoundryName;
    private JScrollPane gdsLayerList;
    private JTextField gdsLayerNumber;
    private JTextField gdsLayerType;
    private JCheckBox gdsOutputConvertsBracketsInExports;
    private JCheckBox gdsOutputMergesBoxes;
    private JCheckBox gdsOutputUpperCase;
    private JCheckBox gdsOutputWritesExportPins;
    private JTextField gdsPinLayer;
    private JTextField gdsPinType;
    private JTextField gdsTextLayer;
    private JTextField gdsTextType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox technologySelection;

    public GDSTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.gds;
    }

    public String getName() {
        return "GDS";
    }

    public void init() {
        this.gdsOutputMergesBoxes.setSelected(IOTool.isGDSOutMergesBoxes());
        this.gdsOutputWritesExportPins.setSelected(IOTool.isGDSOutWritesExportPins());
        this.gdsOutputUpperCase.setSelected(IOTool.isGDSOutUpperCase());
        this.gdsDefaultTextLayer.setText(Integer.toString(IOTool.getGDSOutDefaultTextLayer()));
        this.gdsOutputConvertsBracketsInExports.setSelected(IOTool.getGDSOutputConvertsBracketsInExports());
        this.gdsCellNameLenMax.setText(Integer.toString(IOTool.getGDSCellNameLenMax()));
        this.gdsLayersModel = new DefaultListModel();
        this.gdsLayersList = new JList(this.gdsLayersModel);
        this.gdsLayersList.setSelectionMode(0);
        this.gdsLayerList.setViewportView(this.gdsLayersList);
        this.gdsLayersList.clearSelection();
        this.gdsLayersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GDSTab.this.gdsClickLayer();
            }
        });
        this.layerMap = new HashMap();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technologySelection.addItem(new TechGDSTab(tech));
            Iterator<Foundry> itF = tech.getFoundries();
            while (itF.hasNext()) {
                Foundry foundry = itF.next();
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer layer = lIt.next();
                    String gdsLayer = foundry.getGDSLayer(layer);
                    this.put(foundry, layer, gdsLayer);
                }
            }
        }
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.techChanged();
            }
        });
        this.technologySelection.setSelectedItem(Technology.getCurrent());
        this.foundrySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.foundryChanged();
            }
        });
        this.techChanged();
        GDSDocumentListener myDocumentListener = new GDSDocumentListener(this);
        this.gdsLayerNumber.getDocument().addDocumentListener(myDocumentListener);
        this.gdsLayerType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextType.getDocument().addDocumentListener(myDocumentListener);
    }

    private void put(Foundry f, Layer l, String s) {
        HashMap<Layer, String> table = this.layerMap.get(f);
        if (table == null) {
            table = new HashMap();
            this.layerMap.put(f, table);
        }
        table.put(l, s);
    }

    private String get(Foundry f, Layer l) {
        HashMap<Layer, String> table = this.layerMap.get(f);
        if (table == null) {
            return "";
        }
        return table.get(l);
    }

    private void foundryChanged() {
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        this.gdsLayersModel.clear();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer = lIt.next();
            String str = layer.getName();
            String gdsLayer = this.get(foundry, layer);
            if (gdsLayer != null) {
                str = str + " (" + gdsLayer + ")";
            }
            this.gdsLayersModel.addElement(str);
        }
        this.gdsLayersList.setSelectedIndex(0);
        this.gdsClickLayer();
    }

    private void setFoundries(Technology tech) {
        this.foundrySelection.removeAllItems();
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            this.foundrySelection.addItem(itF.next());
        }
        this.foundrySelection.setSelectedItem(tech.getSelectedFoundry());
        this.foundryChanged();
    }

    private void techChanged() {
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return;
        }
        this.setFoundries(tech);
    }

    private void gdsClickLayer() {
        this.changingGDS = true;
        String str = (String)this.gdsLayersList.getSelectedValue();
        GDSLayers numbers = this.gdsGetNumbers(str);
        if (numbers == null) {
            return;
        }
        if (numbers.getNumLayers() == 0) {
            this.gdsLayerNumber.setText("");
            this.gdsLayerType.setText("");
        } else {
            Integer gdsValue = numbers.getFirstLayer();
            int layerNum = gdsValue & 0xFFFF;
            int layerType = gdsValue >> 16 & 0xFFFF;
            this.gdsLayerNumber.setText(Integer.toString(layerNum));
            this.gdsLayerType.setText(Integer.toString(layerType));
        }
        if (numbers.getPinLayer() == -1) {
            this.gdsPinLayer.setText("");
            this.gdsPinType.setText("");
        } else {
            this.gdsPinLayer.setText(Integer.toString(numbers.getPinLayer() & 0xFFFF));
            this.gdsPinType.setText(Integer.toString(numbers.getPinLayer() >> 16 & 0xFFFF));
        }
        if (numbers.getTextLayer() == -1) {
            this.gdsTextLayer.setText("");
            this.gdsTextType.setText("");
        } else {
            this.gdsTextLayer.setText(Integer.toString(numbers.getTextLayer() & 0xFFFF));
            this.gdsTextType.setText(Integer.toString(numbers.getTextLayer() >> 16 & 0xFFFF));
        }
        this.changingGDS = false;
    }

    private GDSLayers gdsGetNumbers(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return null;
        }
        String gdsNumbers = str.substring(openParen + 1, closeParen);
        GDSLayers numbers = GDSLayers.parseLayerString(gdsNumbers);
        return numbers;
    }

    private Layer gdsGetLayer(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return null;
        }
        String layerName = str.substring(0, openParen - 1);
        Layer layer = tech.findLayer(layerName);
        return layer;
    }

    private void gdsNumbersChanged() {
        if (this.changingGDS) {
            return;
        }
        String str = (String)this.gdsLayersList.getSelectedValue();
        Layer layer = this.gdsGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = this.gdsLayerNumber.getText().trim();
        int layerType = TextUtils.atoi(this.gdsLayerType.getText().trim());
        if (layerType != 0) {
            newLine = newLine + "/" + layerType;
        }
        String pinLayer = this.gdsPinLayer.getText().trim();
        int pinType = TextUtils.atoi(this.gdsPinType.getText().trim());
        if (pinLayer.length() > 0 || pinType != 0) {
            newLine = newLine + "," + pinLayer;
            if (pinType != 0) {
                newLine = newLine + "/" + pinType;
            }
            newLine = newLine + "p";
        }
        String textLayer = this.gdsTextLayer.getText().trim();
        int textType = TextUtils.atoi(this.gdsTextType.getText().trim());
        if (textLayer.length() > 0 || textType != 0) {
            newLine = newLine + "," + textLayer;
            if (textType != 0) {
                newLine = newLine + "/" + textType;
            }
            newLine = newLine + "t";
        }
        String wholeLine = layer.getName() + " (" + newLine + ")";
        int index = this.gdsLayersList.getSelectedIndex();
        this.gdsLayersModel.set(index, wholeLine);
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        this.put(foundry, layer, newLine);
    }

    public void term() {
        int currentCellNameLen;
        int currentTextLayer;
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            Iterator<Foundry> itF = tech.getFoundries();
            while (itF.hasNext()) {
                Foundry foundry = itF.next();
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    GDSLayers oldNumbers;
                    Layer layer = lIt.next();
                    String str = this.get(foundry, layer);
                    GDSLayers numbers = GDSLayers.parseLayerString(str);
                    if (numbers == null || (oldNumbers = GDSLayers.parseLayerString(foundry.getGDSLayer(layer))).equals(numbers)) continue;
                    String currentGDSNumbers = "";
                    Iterator<Integer> it = numbers.getLayers();
                    while (it.hasNext()) {
                        Integer layVal = it.next();
                        int layNum = layVal & 0xFFFF;
                        int layType = layVal >> 16 & 0xFFFF;
                        currentGDSNumbers = currentGDSNumbers + Integer.toString(layNum);
                        if (layType == 0) continue;
                        currentGDSNumbers = currentGDSNumbers + "/" + layType;
                    }
                    if (numbers.getPinLayer() != -1) {
                        currentGDSNumbers = currentGDSNumbers + "," + (numbers.getPinLayer() & 0xFFFF);
                        int pinType = numbers.getPinLayer() >> 16 & 0xFFFF;
                        if (pinType != 0) {
                            currentGDSNumbers = currentGDSNumbers + "/" + pinType;
                        }
                        currentGDSNumbers = currentGDSNumbers + "p";
                    }
                    if (numbers.getTextLayer() != -1) {
                        currentGDSNumbers = currentGDSNumbers + "," + (numbers.getTextLayer() & 0xFFFF);
                        int textType = numbers.getTextLayer() >> 16 & 0xFFFF;
                        if (textType != 0) {
                            currentGDSNumbers = currentGDSNumbers + "/" + textType;
                        }
                        currentGDSNumbers = currentGDSNumbers + "t";
                    }
                    foundry.setGDSLayer(layer, currentGDSNumbers);
                }
            }
        }
        boolean currentValue = this.gdsOutputMergesBoxes.isSelected();
        if (currentValue != IOTool.isGDSOutMergesBoxes()) {
            IOTool.setGDSOutMergesBoxes(currentValue);
        }
        if ((currentValue = this.gdsOutputWritesExportPins.isSelected()) != IOTool.isGDSOutWritesExportPins()) {
            IOTool.setGDSOutWritesExportPins(currentValue);
        }
        if ((currentValue = this.gdsOutputUpperCase.isSelected()) != IOTool.isGDSOutUpperCase()) {
            IOTool.setGDSOutUpperCase(currentValue);
        }
        if ((currentValue = this.gdsOutputConvertsBracketsInExports.isSelected()) != IOTool.getGDSOutputConvertsBracketsInExports()) {
            IOTool.setGDSOutputConvertsBracketsInExports(currentValue);
        }
        if ((currentTextLayer = TextUtils.atoi(this.gdsDefaultTextLayer.getText())) != IOTool.getGDSOutDefaultTextLayer()) {
            IOTool.setGDSOutDefaultTextLayer(currentTextLayer);
        }
        if ((currentCellNameLen = TextUtils.atoi(this.gdsCellNameLenMax.getText())) != IOTool.getGDSCellNameLenMax()) {
            IOTool.setGDSCellNameLenMax(currentCellNameLen);
        }
    }

    private void initComponents() {
        this.gds = new JPanel();
        this.gdsLayerList = new JScrollPane();
        this.jLabel6 = new JLabel();
        this.gdsLayerNumber = new JTextField();
        this.jLabel7 = new JLabel();
        this.gdsPinLayer = new JTextField();
        this.jLabel8 = new JLabel();
        this.gdsTextLayer = new JTextField();
        this.gdsOutputMergesBoxes = new JCheckBox();
        this.gdsOutputWritesExportPins = new JCheckBox();
        this.gdsOutputUpperCase = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.gdsDefaultTextLayer = new JTextField();
        this.jLabel29 = new JLabel();
        this.gdsOutputConvertsBracketsInExports = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.gdsLayerType = new JTextField();
        this.gdsPinType = new JTextField();
        this.gdsTextType = new JTextField();
        this.jLabel3 = new JLabel();
        this.gdsCellNameLenMax = new JTextField();
        this.technologySelection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.gdsFoundryName = new JLabel();
        this.foundrySelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GDSTab.this.closeDialog(evt);
            }
        });
        this.gds.setLayout(new GridBagLayout());
        this.gdsLayerList.setMinimumSize(new Dimension(200, 200));
        this.gdsLayerList.setOpaque(false);
        this.gdsLayerList.setPreferredSize(new Dimension(200, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerList, gridBagConstraints);
        this.jLabel6.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel6, gridBagConstraints);
        this.gdsLayerNumber.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerNumber, gridBagConstraints);
        this.jLabel7.setText("Pin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel7, gridBagConstraints);
        this.gdsPinLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinLayer, gridBagConstraints);
        this.jLabel8.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.jLabel8, gridBagConstraints);
        this.gdsTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextLayer, gridBagConstraints);
        this.gdsOutputMergesBoxes.setText("Output merges Boxes (slow)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputMergesBoxes, gridBagConstraints);
        this.gdsOutputWritesExportPins.setText("Output writes export Pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputWritesExportPins, gridBagConstraints);
        this.gdsOutputUpperCase.setText("Output all upper-case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputUpperCase, gridBagConstraints);
        this.jLabel9.setText("Output default text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.jLabel9, gridBagConstraints);
        this.gdsDefaultTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsDefaultTextLayer, gridBagConstraints);
        this.jLabel29.setText("Negative layer values generate no GDS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.gds.add((Component)this.jLabel29, gridBagConstraints);
        this.gdsOutputConvertsBracketsInExports.setText("Output converts brackets in exports");
        this.gdsOutputConvertsBracketsInExports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.gdsOutputConvertsBracketsInExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsOutputConvertsBracketsInExports, gridBagConstraints);
        this.jLabel1.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.gds.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsLayerType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsPinType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)this.gdsTextType, gridBagConstraints);
        this.jLabel3.setText("Max chars in output cell name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gds.add((Component)this.gdsCellNameLenMax, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel4.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.jLabel4, gridBagConstraints);
        this.gdsFoundryName.setText("Foundry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.gds.add((Component)this.gdsFoundryName, gridBagConstraints);
        this.foundrySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.foundrySelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.gds.add((Component)this.foundrySelection, gridBagConstraints);
        this.getContentPane().add((Component)this.gds, new GridBagConstraints());
        this.pack();
    }

    private void foundrySelectionActionPerformed(ActionEvent evt) {
    }

    private void gdsOutputConvertsBracketsInExportsActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class GDSDocumentListener
    implements DocumentListener {
        GDSTab dialog;

        GDSDocumentListener(GDSTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }
    }

    private static class TechGDSTab {
        public Technology tech;

        TechGDSTab(Technology t) {
            this.tech = t;
        }

        public String toString() {
            return this.tech.getTechName();
        }
    }
}

