/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TempPref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AntennaRulesTab
extends PreferencePanel {
    private JList antennaArcList;
    private DefaultListModel antennaArcListModel;
    private Map<ArcProto, TempPref> antennaOptions;
    private boolean antennaRatioChanging = false;
    private boolean empty;
    private JScrollPane antArcList;
    private JTextField antMaxRatio;
    private JPanel antennaRules;
    private JLabel jLabel66;
    private JLabel jLabel68;
    private JComboBox technologySelection;

    public AntennaRulesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.antMaxRatio);
    }

    public JPanel getPanel() {
        return this.antennaRules;
    }

    public String getName() {
        return "Antenna Rules";
    }

    public void init() {
        this.antennaArcListModel = new DefaultListModel();
        this.antennaArcList = new JList(this.antennaArcListModel);
        this.antennaArcList.setSelectionMode(0);
        this.antArcList.setViewportView(this.antennaArcList);
        this.antennaArcList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AntennaRulesTab.this.antennaArcListClick();
            }
        });
        this.antMaxRatio.getDocument().addDocumentListener(new AntennaRatioDocumentListener(this));
        this.antennaOptions = new HashMap<ArcProto, TempPref>();
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                ArcProto.Function fun = ap.getFunction();
                if (!fun.isMetal() && fun != ArcProto.Function.POLY1) continue;
                double ratio = ERC.getERCTool().getAntennaRatio(ap);
                TempPref pref = TempPref.makeDoublePref(ratio);
                this.antennaOptions.put(ap, pref);
            }
        }
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AntennaRulesTab.this.newTechSelected();
            }
        });
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
    }

    private void newTechSelected() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.empty = true;
        this.antennaArcListModel.clear();
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            TempPref pref = this.antennaOptions.get(ap);
            if (pref == null) continue;
            this.antennaArcListModel.addElement(ap.getName() + " (" + pref.getDouble() + ")");
            this.empty = false;
        }
        if (!this.empty) {
            this.antennaArcList.setSelectedIndex(0);
            this.antennaArcListClick();
        }
    }

    private void antennaArcListClick() {
        ArcProto ap;
        if (this.empty) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String arcName = (String)this.antennaArcList.getSelectedValue();
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        if ((ap = tech.findArcProto(arcName)) != null) {
            TempPref pref = this.antennaOptions.get(ap);
            if (pref == null) {
                return;
            }
            this.antennaRatioChanging = true;
            this.antMaxRatio.setText(TextUtils.formatDouble(pref.getDouble()));
            this.antennaRatioChanging = false;
        }
    }

    private void antennaValueChanged() {
        ArcProto ap;
        if (this.empty) {
            return;
        }
        if (this.antennaRatioChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String arcName = (String)this.antennaArcList.getSelectedValue();
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        if ((ap = tech.findArcProto(arcName)) == null) {
            return;
        }
        TempPref pref = this.antennaOptions.get(ap);
        if (pref == null) {
            return;
        }
        double ratio = TextUtils.atof(this.antMaxRatio.getText());
        pref.setDouble(ratio);
        int lineNo = this.antennaArcList.getSelectedIndex();
        this.antennaArcListModel.setElementAt(ap.getName() + " (" + ratio + ")", lineNo);
    }

    public void term() {
        for (ArcProto ap : this.antennaOptions.keySet()) {
            TempPref pref = this.antennaOptions.get(ap);
            if (pref.getDoubleFactoryValue() == pref.getDouble()) continue;
            ERC.getERCTool().setAntennaRatio(ap, pref.getDouble());
        }
    }

    public void reset() {
        ERC erc = ERC.getERCTool();
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                ArcProto.Function fun = ap.getFunction();
                if (!fun.isMetal() && fun != ArcProto.Function.POLY1 || erc.getFactoryAntennaRatio(ap) == erc.getAntennaRatio(ap)) continue;
                erc.setAntennaRatio(ap, erc.getFactoryAntennaRatio(ap));
            }
        }
    }

    private void initComponents() {
        this.antennaRules = new JPanel();
        this.jLabel66 = new JLabel();
        this.antArcList = new JScrollPane();
        this.jLabel68 = new JLabel();
        this.antMaxRatio = new JTextField();
        this.technologySelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AntennaRulesTab.this.closeDialog(evt);
            }
        });
        this.antennaRules.setLayout(new GridBagLayout());
        this.jLabel66.setText("Arcs in technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.jLabel66, gridBagConstraints);
        this.antArcList.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.antArcList, gridBagConstraints);
        this.jLabel68.setText("Maximum antenna ratio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.jLabel68, gridBagConstraints);
        this.antMaxRatio.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.antMaxRatio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.technologySelection, gridBagConstraints);
        this.getContentPane().add((Component)this.antennaRules, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class AntennaRatioDocumentListener
    implements DocumentListener {
        AntennaRulesTab dialog;

        AntennaRatioDocumentListener(AntennaRulesTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }
    }
}

