/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.Environment;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Tool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot {
    public final IdManager idManager;
    public final int snapshotId;
    public final Tool tool;
    public final ImmutableArrayList<CellBackup> cellBackups;
    public final int[] cellGroups;
    public final CellId[] groupMainSchematics;
    public final ImmutableArrayList<LibraryBackup> libBackups;
    public final Environment environment;
    public final TechPool techPool;
    private final ERectangle[] cellBounds;

    private Snapshot(IdManager idManager, int snapshotId, Tool tool, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, CellId[] groupMainSchematics, ImmutableArrayList<LibraryBackup> libBackups, Environment environment, ERectangle[] cellBounds) {
        this.idManager = idManager;
        this.snapshotId = snapshotId;
        this.tool = tool;
        this.cellBackups = cellBackups;
        this.cellGroups = cellGroups;
        this.groupMainSchematics = groupMainSchematics;
        this.libBackups = libBackups;
        this.environment = environment;
        this.techPool = environment.techPool;
        this.cellBounds = new ERectangle[cellBackups.size()];
        for (int cellIndex = 0; cellIndex < cellBounds.length; ++cellIndex) {
            ERectangle r = cellBounds[cellIndex];
            if (r == null) continue;
            if (cellBackups.get(cellIndex) == null) {
                throw new IllegalArgumentException();
            }
            this.cellBounds[cellIndex] = r;
        }
    }

    public Snapshot(IdManager idManager) {
        this(idManager, 0, null, CellBackup.EMPTY_LIST, new int[0], new CellId[0], LibraryBackup.EMPTY_LIST, idManager.getInitialEnvironment(), ERectangle.NULL_ARRAY);
    }

    public Snapshot with(Tool tool, Environment environment, CellBackup[] cellBackupsArray, ERectangle[] cellBoundsArray, LibraryBackup[] libBackupsArray) {
        boolean namesChanged;
        if (environment == null) {
            environment = this.environment;
        }
        TechPool techPool = environment.techPool;
        ImmutableArrayList<CellBackup> cellBackups = Snapshot.copyArray(cellBackupsArray, this.cellBackups);
        ImmutableArrayList<LibraryBackup> libBackups = Snapshot.copyArray(libBackupsArray, this.libBackups);
        boolean bl = namesChanged = this.libBackups != libBackups || this.cellBackups.size() != cellBackups.size();
        if (!namesChanged && this.environment == environment && this.cellBackups == cellBackups) {
            if (cellBoundsArray != null) {
                for (int cellIndex = 0; cellIndex < cellBoundsArray.length; ++cellIndex) {
                    ERectangle r = cellBoundsArray[cellIndex];
                    if (r == null) continue;
                    this.setCellBounds(((CellBackup)cellBackups.get((int)cellIndex)).cellRevision.d.cellId, r);
                }
            }
            return this;
        }
        boolean needCheckRecursion = false;
        BitSet newUsedTechs = new BitSet();
        for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellId cellId;
            CellBackup newBackup = (CellBackup)cellBackups.get(cellIndex);
            CellRevision newRevision = null;
            CellBackup oldBackup = this.getCell(cellIndex);
            if (newBackup != null) {
                if (newBackup.withTechPool(techPool) != newBackup) {
                    throw new IllegalArgumentException();
                }
                newRevision = newBackup.cellRevision;
                if (oldBackup == null || newRevision.d.groupName != oldBackup.cellRevision.d.groupName || newRevision.d.params != oldBackup.cellRevision.d.params) {
                    namesChanged = true;
                }
                newUsedTechs.or(newRevision.techUsages);
                cellId = newRevision.d.cellId;
                if (oldBackup == null || newRevision.cellUsages != oldBackup.cellRevision.cellUsages) {
                    needCheckRecursion = true;
                    for (int i = 0; i < newRevision.cellUsages.length; ++i) {
                        CellRevision.CellUsageInfo cui = newRevision.cellUsages[i];
                        if (cui == null) continue;
                        if (oldBackup != null) {
                            CellRevision.CellUsageInfo oldCui;
                            CellRevision oldRevision = oldBackup.cellRevision;
                            if (i < oldRevision.cellUsages.length && (oldCui = oldRevision.cellUsages[i]) != null && cui.usedExports == oldCui.usedExports) continue;
                        }
                        CellUsage u = cellId.getUsageIn(i);
                        CellRevision protoRevision = ((CellBackup)cellBackups.get((int)u.protoId.cellIndex)).cellRevision;
                        cui.checkUsage(protoRevision);
                    }
                }
            } else {
                if (oldBackup == null) continue;
                cellId = oldBackup.cellRevision.d.cellId;
                namesChanged = true;
            }
            if (oldBackup == null) continue;
            CellRevision oldRevision = oldBackup.cellRevision;
            if (newRevision != null && newRevision.definedExportsLength >= oldRevision.definedExportsLength && (newRevision.deletedExports == oldRevision.deletedExports || !newRevision.deletedExports.intersects(oldRevision.definedExports)) && newRevision.d.params == oldRevision.d.params) continue;
            int numUsages = cellId.numUsagesOf();
            for (int i = 0; i < numUsages; ++i) {
                CellRevision.CellUsageInfo cui;
                CellBackup parentBackup;
                CellUsage u = cellId.getUsageOf(i);
                int parentCellIndex = u.parentId.cellIndex;
                if (parentCellIndex >= cellBackups.size() || (parentBackup = (CellBackup)cellBackups.get(parentCellIndex)) == null) continue;
                CellRevision parentRevision = parentBackup.cellRevision;
                if (u.indexInParent >= parentRevision.cellUsages.length || (cui = parentRevision.cellUsages[u.indexInParent]) == null) continue;
                cui.checkUsage(newBackup.cellRevision);
            }
        }
        if (needCheckRecursion) {
            Snapshot.checkRecursion(cellBackups);
        }
        for (int techIndex = 0; techIndex < newUsedTechs.length(); ++techIndex) {
            TechId techId;
            if (!newUsedTechs.get(techIndex) || techPool.getTech(techId = this.idManager.getTechId(techIndex)) != null) continue;
            throw new IllegalArgumentException();
        }
        int[] cellGroups = this.cellGroups;
        Object[] groupMainSchematics = this.groupMainSchematics;
        if (namesChanged) {
            cellGroups = new int[cellBackups.size()];
            Snapshot.checkNames(this.idManager, cellBackups, cellGroups, libBackups);
            if (Arrays.equals(this.cellGroups, cellGroups)) {
                cellGroups = this.cellGroups;
            } else {
                int maxGroup = -1;
                for (int groupIndex : cellGroups) {
                    maxGroup = Math.max(maxGroup, groupIndex);
                }
                groupMainSchematics = new CellId[maxGroup + 1];
                for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
                    int groupIndex;
                    Object mainSchematics;
                    CellId cellId;
                    CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
                    if (cellBackup == null || !(cellId = cellBackup.cellRevision.d.cellId).isSchematic() || (mainSchematics = groupMainSchematics[groupIndex = cellGroups[cellIndex]]) != null && cellId.cellName.compareTo(((CellId)mainSchematics).cellName) >= 0) continue;
                    groupMainSchematics[groupIndex] = cellId;
                }
                if (Arrays.equals(this.groupMainSchematics, groupMainSchematics)) {
                    groupMainSchematics = this.groupMainSchematics;
                }
            }
        }
        if (cellBoundsArray == null) {
            cellBoundsArray = this.cellBounds;
        }
        Snapshot snapshot = new Snapshot(this.idManager, this.idManager.newSnapshotId(), tool, cellBackups, cellGroups, (CellId[])groupMainSchematics, libBackups, environment, cellBoundsArray);
        return snapshot;
    }

    public void setCellBounds(CellId cellId, ERectangle r) {
        if (r == null) {
            throw new NullPointerException();
        }
        CellBackup cellBackup = this.getCell(cellId);
        if (cellBackup == null) {
            throw new IllegalArgumentException();
        }
        int cellIndex = cellId.cellIndex;
        ERectangle oldR = this.cellBounds[cellIndex];
        if (oldR != null && oldR != r) {
            throw new IllegalArgumentException();
        }
        this.cellBounds[cellIndex] = r;
    }

    private static <T> ImmutableArrayList<T> copyArray(T[] newArray, ImmutableArrayList<T> oldList) {
        int l;
        if (newArray == null) {
            return oldList;
        }
        for (l = newArray.length; l > 0 && newArray[l - 1] == null; --l) {
        }
        if (l == oldList.size()) {
            int i;
            for (i = 0; i < oldList.size() && newArray[i] == oldList.get(i); ++i) {
            }
            if (i == l) {
                return oldList;
            }
        }
        return new ImmutableArrayList<T>(newArray, 0, l);
    }

    public Snapshot withRenamedIds(IdMapper idMapper, CellId fromGroup, String toGroup) {
        int maxCellIndex = -1;
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            maxCellIndex = Math.max(maxCellIndex, idMapper.get((CellId)cellBackup.cellRevision.d.cellId).cellIndex);
        }
        int maxLibIndex = -1;
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            maxLibIndex = Math.max(maxLibIndex, idMapper.get((LibId)libBackup.d.libId).libIndex);
        }
        CellBackup[] cellBackupsArray = new CellBackup[maxCellIndex + 1];
        ERectangle[] cellBoundsArray = new ERectangle[maxCellIndex + 1];
        LibraryBackup[] libBackupsArray = new LibraryBackup[maxLibIndex + 1];
        BitSet cellBackupsChangedInLib = new BitSet();
        boolean cellIdsChanged = false;
        BitSet fromGroupCellIds = new BitSet();
        BitSet toGroupCellIds = new BitSet();
        CellName fromGroupName = null;
        CellName toGroupName = null;
        if (fromGroup != null) {
            assert (this.getCell(fromGroup) != null);
            CellId toGroupCellId = idMapper.get(fromGroup);
            assert (toGroupCellId != null);
            assert (this.getCell(toGroupCellId) == null);
            int fromGroupIndex = this.cellGroups[fromGroup.cellIndex];
            assert (fromGroupIndex >= 0);
            int toGroupIndex1 = -1;
            int toGroupIndex2 = -1;
            if (toGroup == null) {
                toGroupIndex2 = fromGroupIndex;
            }
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null) continue;
                CellId cellId = cellBackup.cellRevision.d.cellId;
                if (cellId.libId != fromGroup.libId) continue;
                if (cellId.cellName.getName().equals(toGroupCellId.cellName.getName())) {
                    toGroupIndex1 = this.cellGroups[cellIndex];
                }
                if (toGroup == null || !cellId.cellName.getName().equals(toGroup)) continue;
                toGroupIndex2 = this.cellGroups[cellIndex];
            }
            ArrayList<CellName> fromCellNames = new ArrayList<CellName>();
            ArrayList<CellName> toCellNames = new ArrayList<CellName>();
            toGroupCellIds.set(toGroupCellId.cellIndex);
            toCellNames.add(toGroupCellId.cellName);
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null || cellIndex == fromGroup.cellIndex) continue;
                CellId cellId = cellBackup.cellRevision.d.cellId;
                if (this.cellGroups[cellIndex] == fromGroupIndex) {
                    fromGroupCellIds.set(cellIndex);
                    fromCellNames.add(cellId.cellName);
                }
                if (this.cellGroups[cellIndex] != toGroupIndex1 && this.cellGroups[cellIndex] != toGroupIndex2) continue;
                toGroupCellIds.set(cellIndex);
                toCellNames.add(cellId.cellName);
            }
            if (!fromCellNames.isEmpty()) {
                fromGroupName = Snapshot.makeCellGroupName(fromCellNames);
            }
            if (!toCellNames.isEmpty()) {
                toGroupName = Snapshot.makeCellGroupName(toCellNames);
            }
        }
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            int newCellIndex;
            CellBackup newCellBackup;
            CellBackup oldCellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (oldCellBackup == null) continue;
            CellName newGroupName = oldCellBackup.cellRevision.d.groupName;
            if (fromGroup != null) {
                if (toGroupCellIds.get(cellIndex) || cellIndex == fromGroup.cellIndex) {
                    newGroupName = toGroupName;
                } else if (fromGroupCellIds.get(cellIndex)) {
                    newGroupName = fromGroupName;
                }
            }
            if ((newCellBackup = oldCellBackup.withRenamedIds(idMapper, newGroupName)) != oldCellBackup) {
                cellBackupsChangedInLib.set(newCellBackup.cellRevision.d.cellId.libId.libIndex);
            }
            if ((newCellIndex = newCellBackup.cellRevision.d.cellId.cellIndex) != cellIndex) {
                cellIdsChanged = true;
            }
            cellBackupsArray[newCellIndex] = newCellBackup;
            cellBoundsArray[newCellIndex] = this.cellBounds[cellIndex];
        }
        if (cellBackupsChangedInLib.isEmpty()) {
            cellBackupsArray = null;
        }
        if (!cellIdsChanged) {
            cellBoundsArray = null;
        }
        boolean libBackupsChanged = false;
        for (int libIndex = 0; libIndex < this.libBackups.size(); ++libIndex) {
            LibraryBackup oldLibBackup = (LibraryBackup)this.libBackups.get(libIndex);
            if (oldLibBackup == null) continue;
            LibraryBackup newLibBackup = oldLibBackup.withRenamedIds(idMapper);
            if (cellBackupsChangedInLib.get(libIndex)) {
                newLibBackup = newLibBackup.withModified();
            }
            if (newLibBackup != oldLibBackup) {
                libBackupsChanged = true;
            }
            libBackupsArray[newLibBackup.d.libId.libIndex] = newLibBackup;
        }
        if (!libBackupsChanged) {
            libBackupsArray = null;
        }
        if (cellBackupsArray == null && this.cellBounds == null && this.libBackups == null) {
            return this;
        }
        return this.with(this.tool, null, cellBackupsArray, cellBoundsArray, libBackupsArray);
    }

    public List<LibId> getChangedLibraries(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        if (this.idManager != oldSnapshot.idManager) {
            throw new IllegalArgumentException();
        }
        List<LibId> changed = null;
        if (oldSnapshot.libBackups != this.libBackups) {
            int numLibs = Math.max(oldSnapshot.libBackups.size(), this.libBackups.size());
            for (int i = 0; i < numLibs; ++i) {
                LibraryBackup newBackup;
                LibraryBackup oldBackup = oldSnapshot.getLib(i);
                if (oldBackup == (newBackup = this.getLib(i))) continue;
                if (changed == null) {
                    changed = new ArrayList<LibId>();
                }
                changed.add(this.idManager.getLibId(i));
            }
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public List<CellId> getChangedCells(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        List<CellId> changed = null;
        int numCells = Math.max(oldSnapshot.cellBackups.size(), this.cellBackups.size());
        for (int i = 0; i < numCells; ++i) {
            CellBackup newBackup;
            CellBackup oldBackup = oldSnapshot.getCell(i);
            if (oldBackup == (newBackup = this.getCell(i))) continue;
            if (changed == null) {
                changed = new ArrayList<CellId>();
            }
            changed.add(this.idManager.getCellId(i));
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public Collection<CellId> getCellsDownTop() {
        LinkedHashSet<CellId> order = new LinkedHashSet<CellId>();
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            this.getCellsDownTop(cellBackup.cellRevision.d.cellId, order);
        }
        return order;
    }

    private void getCellsDownTop(CellId root, LinkedHashSet<CellId> order) {
        if (order.contains(root)) {
            return;
        }
        CellBackup cellBackup = this.getCell(root);
        CellRevision cellRevision = cellBackup.cellRevision;
        for (int i = 0; i < cellRevision.cellUsages.length; ++i) {
            if (cellRevision.cellUsages[i] == null) continue;
            CellUsage cu = root.getUsageIn(i);
            this.getCellsDownTop(cu.protoId, order);
        }
        boolean added = order.add(root);
        assert (added);
    }

    public CellBackup getCell(CellId cellId) {
        if (cellId.getIdManager() != this.idManager) {
            throw new IllegalArgumentException();
        }
        return this.getCell(cellId.cellIndex);
    }

    public CellRevision getCellRevision(CellId cellId) {
        CellBackup cellBackup = this.getCell(cellId);
        return cellBackup != null ? cellBackup.cellRevision : null;
    }

    public CellBackup getCell(int cellIndex) {
        return cellIndex < this.cellBackups.size() ? (CellBackup)this.cellBackups.get(cellIndex) : null;
    }

    public CellRevision getCellRevision(int cellIndex) {
        CellBackup cellBackup = this.getCell(cellIndex);
        return cellBackup != null ? cellBackup.cellRevision : null;
    }

    public static CellName makeCellGroupName(Collection<CellName> cellNames) {
        String name;
        if (cellNames.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String groupName = null;
        for (CellName cellName : cellNames) {
            if (!cellName.isSchematic()) continue;
            name = cellName.getName();
            if (groupName != null && TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0) continue;
            groupName = name;
        }
        if (groupName == null) {
            for (CellName cellName : cellNames) {
                name = cellName.getName();
                if (groupName != null && name.length() >= groupName.length() && (name.length() != groupName.length() || TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0)) continue;
                groupName = name;
            }
        }
        assert (groupName != null);
        return CellName.parseName(groupName + "{sch}");
    }

    public ERectangle getCellBounds(CellId cellId) {
        return this.getCellBounds(cellId.cellIndex);
    }

    public ERectangle getCellBounds(int cellIndex) {
        return cellIndex < this.cellBounds.length ? this.cellBounds[cellIndex] : null;
    }

    public TechPool getTechPool() {
        return this.techPool;
    }

    public Technology getTech(TechId techId) {
        return this.techPool.getTech(techId);
    }

    public Artwork getArtwork() {
        return this.techPool.getArtwork();
    }

    public Generic getGeneric() {
        return this.techPool.getGeneric();
    }

    public Schematics getSchematics() {
        return this.techPool.getSchematics();
    }

    public Map<Setting, Object> getSettings() {
        return this.environment.getSettings();
    }

    private void gatherSettings(Map<Setting, Object> map, Collection<Setting> c) {
        for (Setting setting : c) {
            map.put(setting, setting.getValue());
        }
    }

    public LibraryBackup getLib(LibId libId) {
        return this.getLib(libId.libIndex);
    }

    private LibraryBackup getLib(int libIndex) {
        return libIndex < this.libBackups.size() ? (LibraryBackup)this.libBackups.get(libIndex) : null;
    }

    public void writeDiffs(IdWriter writer, Snapshot oldSnapshot) throws IOException {
        int i;
        Object newBackup;
        assert (oldSnapshot.cellBoundsDefined());
        assert (this.cellBoundsDefined());
        writer.writeDiffs();
        writer.writeInt(this.snapshotId);
        writer.writeBoolean(this.tool != null);
        if (this.tool != null) {
            writer.writeTool(this.tool);
        }
        this.environment.writeDiff(writer, oldSnapshot.environment);
        boolean libsChanged = oldSnapshot.libBackups != this.libBackups;
        writer.writeBoolean(libsChanged);
        if (libsChanged) {
            writer.writeInt(this.libBackups.size());
            for (int i2 = 0; i2 < this.libBackups.size(); ++i2) {
                LibraryBackup oldBackup = oldSnapshot.getLib(i2);
                if (oldBackup == (newBackup = this.getLib(i2))) continue;
                if (oldBackup == null) {
                    writer.writeInt(i2);
                    ((LibraryBackup)newBackup).write(writer);
                    continue;
                }
                if (newBackup == null) {
                    writer.writeInt(~i2);
                    continue;
                }
                writer.writeInt(i2);
                ((LibraryBackup)newBackup).write(writer);
            }
            writer.writeInt(Integer.MAX_VALUE);
        }
        writer.writeInt(this.cellBackups.size());
        boolean boundsChanged = oldSnapshot.cellBounds.length != this.cellBounds.length;
        for (int cellIndex = 0; cellIndex < this.cellBounds.length; ++cellIndex) {
            if (this.cellBackups.get(cellIndex) == null) continue;
            boundsChanged = boundsChanged || this.cellBounds[cellIndex] != oldSnapshot.cellBounds[cellIndex];
        }
        writer.writeBoolean(boundsChanged);
        for (i = 0; i < this.cellBackups.size(); ++i) {
            CellBackup newBackup2;
            CellBackup oldBackup = oldSnapshot.getCell(i);
            if (oldBackup == (newBackup2 = this.getCell(i))) continue;
            if (oldBackup == null) {
                writer.writeInt(i);
                newBackup2.write(writer);
                continue;
            }
            if (newBackup2 == null) {
                writer.writeInt(~i);
                continue;
            }
            writer.writeInt(i);
            newBackup2.write(writer);
        }
        writer.writeInt(Integer.MAX_VALUE);
        if (boundsChanged) {
            for (i = 0; i < this.cellBackups.size(); ++i) {
                newBackup = this.getCell(i);
                if (newBackup == null) continue;
                ERectangle oldBounds = oldSnapshot.getCellBounds(i);
                ERectangle newBounds = this.getCellBounds(i);
                assert (newBounds != null);
                if (oldBounds == newBounds) continue;
                writer.writeInt(i);
                writer.writeRectangle(newBounds);
            }
            writer.writeInt(Integer.MAX_VALUE);
        }
        boolean cellGroupsChanged = this.cellGroups != oldSnapshot.cellGroups;
        writer.writeBoolean(cellGroupsChanged);
        if (cellGroupsChanged) {
            assert (this.cellGroups.length == this.cellBackups.size());
            for (int cellIndex = 0; cellIndex < this.cellGroups.length; ++cellIndex) {
                writer.writeInt(this.cellGroups[cellIndex]);
            }
            for (int groupIndex = 0; groupIndex < this.groupMainSchematics.length; ++groupIndex) {
                CellId mainSchematics = this.groupMainSchematics[groupIndex];
                writer.writeInt(mainSchematics != null ? mainSchematics.cellIndex : -1);
            }
        }
    }

    public static Snapshot readSnapshot(IdReader reader, Snapshot oldSnapshot) throws IOException {
        int cellIndex;
        assert (reader.idManager == oldSnapshot.idManager);
        assert (oldSnapshot.cellBoundsDefined());
        reader.readDiffs();
        int snapshotId = reader.readInt();
        boolean hasTool = reader.readBoolean();
        Tool tool = hasTool ? reader.readTool() : null;
        Environment environment = Environment.readEnvironment(reader, oldSnapshot.environment);
        TechPool techPool = environment.techPool;
        boolean technologiesChanged = techPool != oldSnapshot.techPool;
        ImmutableArrayList<LibraryBackup> libBackups = oldSnapshot.libBackups;
        boolean libsChanged = reader.readBoolean();
        if (libsChanged) {
            int libIndex;
            int libLen = reader.readInt();
            LibraryBackup[] libBackupsArray = new LibraryBackup[libLen];
            int numLibs = Math.min(oldSnapshot.libBackups.size(), libLen);
            for (libIndex = 0; libIndex < numLibs; ++libIndex) {
                libBackupsArray[libIndex] = (LibraryBackup)oldSnapshot.libBackups.get(libIndex);
            }
            while ((libIndex = reader.readInt()) != Integer.MAX_VALUE) {
                if (libIndex >= 0) {
                    LibraryBackup newBackup;
                    libBackupsArray[libIndex] = newBackup = LibraryBackup.read(reader);
                    continue;
                }
                assert (libBackupsArray[libIndex ^= 0xFFFFFFFF] != null);
                libBackupsArray[libIndex] = null;
            }
            libBackups = new ImmutableArrayList<LibraryBackup>(libBackupsArray);
        }
        int cellLen = reader.readInt();
        int cellMax = Math.min(oldSnapshot.cellBackups.size(), cellLen);
        CellBackup[] cellBackupsArray = new CellBackup[cellLen];
        for (int cellIndex2 = 0; cellIndex2 < cellMax; ++cellIndex2) {
            cellBackupsArray[cellIndex2] = (CellBackup)oldSnapshot.cellBackups.get(cellIndex2);
        }
        boolean boundsChanged = reader.readBoolean();
        ERectangle[] cellBoundsArray = oldSnapshot.cellBounds;
        if (boundsChanged) {
            cellBoundsArray = new ERectangle[cellLen];
            int numCells = Math.min(oldSnapshot.cellBounds.length, cellLen);
            for (cellIndex = 0; cellIndex < numCells; ++cellIndex) {
                cellBoundsArray[cellIndex] = oldSnapshot.cellBounds[cellIndex];
            }
        }
        if (technologiesChanged) {
            for (cellIndex = 0; cellIndex < cellLen; ++cellIndex) {
                CellBackup cellBackup = cellBackupsArray[cellIndex];
                if (cellBackup == null) continue;
                cellBackupsArray[cellIndex] = cellBackup.withTechPool(techPool);
            }
        }
        while ((cellIndex = reader.readInt()) != Integer.MAX_VALUE) {
            if (cellIndex >= 0) {
                CellBackup newBackup;
                cellBackupsArray[cellIndex] = newBackup = CellBackup.read(reader, techPool);
                continue;
            }
            assert (cellBackupsArray[cellIndex ^= 0xFFFFFFFF] != null);
            cellBackupsArray[cellIndex] = null;
            assert (boundsChanged);
            assert (cellBoundsArray[cellIndex] != null);
            cellBoundsArray[cellIndex] = null;
        }
        ImmutableArrayList<CellBackup> cellBackups = new ImmutableArrayList<CellBackup>(cellBackupsArray);
        if (boundsChanged) {
            int cellIndex3;
            while ((cellIndex3 = reader.readInt()) != Integer.MAX_VALUE) {
                ERectangle newBounds;
                cellBoundsArray[cellIndex3] = newBounds = reader.readRectangle();
            }
        }
        int[] cellGroups = oldSnapshot.cellGroups;
        CellId[] groupMainSchematics = oldSnapshot.groupMainSchematics;
        boolean cellGroupsChanged = reader.readBoolean();
        if (cellGroupsChanged) {
            cellGroups = new int[cellBackups.size()];
            int maxGroup = -1;
            for (int cellIndex4 = 0; cellIndex4 < cellGroups.length; ++cellIndex4) {
                int groupIndex = reader.readInt();
                maxGroup = Math.max(maxGroup, groupIndex);
                cellGroups[cellIndex4] = groupIndex;
            }
            groupMainSchematics = new CellId[maxGroup + 1];
            for (int groupIndex = 0; groupIndex < groupMainSchematics.length; ++groupIndex) {
                CellId mainSchematics = null;
                int cellIndex5 = reader.readInt();
                if (cellIndex5 >= 0) {
                    mainSchematics = reader.idManager.getCellId(cellIndex5);
                }
                groupMainSchematics[groupIndex] = mainSchematics;
            }
        }
        for (int i = 0; i < cellBackups.size(); ++i) {
            assert (cellBackups.get(i) != null == (cellBoundsArray[i] != null));
            assert (cellBackups.get(i) != null == cellGroups[i] >= 0);
        }
        return new Snapshot(oldSnapshot.idManager, snapshotId, tool, cellBackups, cellGroups, groupMainSchematics, libBackups, environment, cellBoundsArray);
    }

    public boolean cellBoundsDefined() {
        assert (this.cellBackups.size() == this.cellBounds.length);
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            if (this.cellBackups.get(cellIndex) == null || this.cellBounds[cellIndex] != null) continue;
            return false;
        }
        return true;
    }

    public void check() {
        this.techPool.check();
        this.environment.check();
        assert (this.environment.techPool == this.techPool);
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            libBackup.check();
        }
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            cellBackup.check();
        }
        if (this.libBackups.size() > 0) assert (this.libBackups.get(this.libBackups.size() - 1) != null);
        if (this.cellBackups.size() > 0) assert (this.cellBackups.get(this.cellBackups.size() - 1) != null);
        Snapshot.checkRecursion(this.cellBackups);
        int[] cellGroups = new int[this.cellBackups.size()];
        Snapshot.checkNames(this.idManager, this.cellBackups, cellGroups, this.libBackups);
        assert (Arrays.equals(this.cellGroups, cellGroups));
        int maxGroup = -1;
        for (int groupIndex : cellGroups) {
            maxGroup = Math.max(maxGroup, groupIndex);
        }
        assert (this.groupMainSchematics.length == maxGroup + 1);
        BitSet foundMainSchematics = new BitSet();
        for (CellBackup cellBackup : this.cellBackups) {
            CellId cellId;
            if (cellBackup == null || !(cellId = cellBackup.cellRevision.d.cellId).isSchematic()) continue;
            int groupIndex = cellGroups[cellId.cellIndex];
            int cmp = cellId.cellName.compareTo(this.groupMainSchematics[groupIndex].cellName);
            assert (cmp >= 0);
            if (cmp != 0) continue;
            assert (this.groupMainSchematics[groupIndex] == cellId);
            foundMainSchematics.set(groupIndex);
        }
        for (int groupIndex = 0; groupIndex < this.groupMainSchematics.length; ++groupIndex) {
            assert (foundMainSchematics.get(groupIndex) == (this.groupMainSchematics[groupIndex] != null));
        }
        assert (this.cellBackups.size() == this.cellBounds.length);
        BitSet checkUsedTechs = new BitSet();
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (cellBackup == null) {
                assert (this.cellBounds[cellIndex] == null);
                continue;
            }
            CellRevision cellRevision = cellBackup.cellRevision;
            checkUsedTechs.or(cellRevision.techUsages);
            CellId cellId = cellBackup.cellRevision.d.cellId;
            for (int i = 0; i < cellRevision.cellUsages.length; ++i) {
                CellRevision.CellUsageInfo cui = cellRevision.cellUsages[i];
                if (cui == null) continue;
                CellUsage u = cellId.getUsageIn(i);
                int subCellIndex = u.protoId.cellIndex;
                cui.checkUsage(((CellBackup)this.cellBackups.get((int)subCellIndex)).cellRevision);
            }
            assert (cellBackup.techPool == this.techPool.restrict(cellRevision.techUsages, cellBackup.techPool));
        }
        assert (this.techPool.idManager == this.idManager);
        for (int techIndex = 0; techIndex < checkUsedTechs.length(); ++techIndex) {
            if (!checkUsedTechs.get(techIndex)) continue;
            TechId techId = this.idManager.getTechId(techIndex);
            assert (techId != null);
            assert (this.techPool.getTech(techId) != null);
        }
    }

    private static void checkNames(IdManager idManager, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, ImmutableArrayList<LibraryBackup> libBackups) {
        HashSet<String> libNames = new HashSet<String>();
        ArrayList protoNameToGroupName = new ArrayList();
        ArrayList cellNames = new ArrayList();
        ArrayList groupNameToGroupIndex = new ArrayList();
        for (int libIndex = 0; libIndex < libBackups.size(); ++libIndex) {
            LibraryBackup libBackup = (LibraryBackup)libBackups.get(libIndex);
            if (libBackup == null) {
                protoNameToGroupName.add(null);
                cellNames.add(null);
                groupNameToGroupIndex.add(null);
                continue;
            }
            protoNameToGroupName.add(new HashMap());
            cellNames.add(new HashSet());
            groupNameToGroupIndex.add(new HashMap());
            if (libBackup.d.libId != idManager.getLibId(libIndex)) {
                throw new IllegalArgumentException("LibId");
            }
            String libName = libBackup.d.libId.libName;
            if (!libNames.add(libName)) {
                throw new IllegalArgumentException("duplicate libName");
            }
            for (LibId libId : libBackup.referencedLibs) {
                if (libId == ((LibraryBackup)libBackups.get((int)libId.libIndex)).d.libId) continue;
                throw new IllegalArgumentException("LibId in referencedLibs");
            }
        }
        assert (protoNameToGroupName.size() == libBackups.size() && cellNames.size() == libBackups.size() && groupNameToGroupIndex.size() == libBackups.size());
        assert (cellBackups.size() == cellGroups.length);
        Arrays.fill(cellGroups, -1);
        ArrayList<ImmutableCell> groupParamOwners = new ArrayList<ImmutableCell>();
        for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
            if (cellBackup == null) continue;
            ImmutableCell d = cellBackup.cellRevision.d;
            CellId cellId = d.cellId;
            if (cellId != idManager.getCellId(cellIndex)) {
                throw new IllegalArgumentException("CellId");
            }
            LibId libId = d.getLibId();
            int libIndex = libId.libIndex;
            if (libId != ((LibraryBackup)libBackups.get((int)libIndex)).d.libId) {
                throw new IllegalArgumentException("LibId in ImmutableCell");
            }
            HashMap cellNameToGroupNameInLibrary = (HashMap)protoNameToGroupName.get(libId.libIndex);
            HashSet cellNamesInLibrary = (HashSet)cellNames.get(libId.libIndex);
            HashMap groupNameToGroupIndexInLibrary = (HashMap)groupNameToGroupIndex.get(libId.libIndex);
            String protoName = cellId.cellName.getName();
            CellName groupName = (CellName)cellNameToGroupNameInLibrary.get(protoName);
            if (groupName == null) {
                groupName = d.groupName;
                cellNameToGroupNameInLibrary.put(protoName, groupName);
            } else if (!d.groupName.equals(groupName)) {
                throw new IllegalArgumentException("cells with same proto name in different groups");
            }
            Integer gn = (Integer)groupNameToGroupIndexInLibrary.get(groupName);
            if (gn == null) {
                gn = groupParamOwners.size();
                groupParamOwners.add(null);
                groupNameToGroupIndexInLibrary.put(groupName, gn);
            }
            cellGroups[cellIndex] = gn;
            if (!cellNamesInLibrary.add(cellId.cellName)) {
                throw new IllegalArgumentException("duplicate CellName in library");
            }
            if (!d.paramsAllowed()) continue;
            ImmutableCell paramOwner = (ImmutableCell)groupParamOwners.get(gn);
            if (paramOwner != null) {
                d.checkSimilarParams(paramOwner);
                continue;
            }
            groupParamOwners.set(gn, paramOwner);
        }
    }

    private static void checkRecursion(ImmutableArrayList<CellBackup> cellBackups) {
        BitSet visited = new BitSet();
        BitSet checked = new BitSet();
        for (CellBackup cellBackup : cellBackups) {
            if (cellBackup == null) continue;
            Snapshot.checkRecursion(cellBackup.cellRevision.d.cellId, cellBackups, visited, checked);
        }
        assert (visited.equals(checked));
    }

    private static void checkRecursion(CellId cellId, ImmutableArrayList<CellBackup> cellBackups, BitSet visited, BitSet checked) {
        int cellIndex = cellId.cellIndex;
        if (checked.get(cellIndex)) {
            return;
        }
        assert (!visited.get(cellIndex));
        visited.set(cellIndex);
        CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
        CellRevision cellRevision = cellBackup.cellRevision;
        for (int i = 0; i < cellRevision.cellUsages.length; ++i) {
            CellRevision.CellUsageInfo cui = cellRevision.cellUsages[i];
            if (cui == null) continue;
            CellUsage u = cellId.getUsageIn(i);
            int subCellIndex = u.protoId.cellIndex;
            if (checked.get(subCellIndex)) continue;
            if (visited.get(subCellIndex)) {
                throw new IllegalArgumentException("Recursive instance of " + u.protoId + " in " + u.parentId);
            }
            Snapshot.checkRecursion(u.protoId, cellBackups, visited, checked);
        }
        checked.set(cellIndex);
    }
}

