/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamClient
extends Client {
    private final IdWriter writer;
    private Snapshot currentSnapshot = EDatabase.serverDatabase().getInitialSnapshot();
    private final ServerEventDispatcher dispatcher;
    private final ClientReader reader;
    private static final long STACK_SIZE_EVENT = StreamClient.isOSMac() ? 0L : 20480L;
    private static final int STACK_SIZE_READER = StreamClient.isOSMac() ? 0 : 1024;

    StreamClient(int connectionId, InputStream inputStream, OutputStream outputStream) {
        super(connectionId);
        this.writer = new IdWriter(IdManager.stdIdManager, new DataOutputStream(outputStream));
        this.dispatcher = new ServerEventDispatcher();
        this.reader = inputStream != null ? new ClientReader(inputStream) : null;
    }

    void start() {
        this.dispatcher.start();
    }

    private void writeSnapshot(Snapshot newSnapshot) throws IOException {
        this.writer.writeByte((byte)1);
        newSnapshot.writeDiffs(this.writer, this.currentSnapshot);
        this.currentSnapshot = newSnapshot;
    }

    private class ClientReader
    extends Thread {
        private final DataInputStream in;

        private ClientReader(InputStream inputStream) {
            super(null, null, "ClientReader-" + StreamClient.this.connectionId, STACK_SIZE_READER);
            this.in = new DataInputStream(new BufferedInputStream(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    EditingPreferences clientEp = null;
                    block10: while (true) {
                        byte tag = this.in.readByte();
                        switch (tag) {
                            case 1: {
                                int jobId = this.in.readInt();
                                Job.Type jobType = Job.Type.valueOf(this.in.readUTF());
                                String jobName = this.in.readUTF();
                                int len = this.in.readInt();
                                byte[] bytes = new byte[len];
                                this.in.readFully(bytes);
                                EJob ejob = new EJob(StreamClient.this, jobId, jobType, jobName, bytes);
                                ejob.editingPreferences = clientEp;
                                Job.jobManager.addJob(ejob, false);
                                continue block10;
                            }
                            case 2: {
                                byte[] serializedEp = new byte[this.in.readInt()];
                                this.in.readFully(serializedEp);
                                try {
                                    EDatabase database = EDatabase.serverDatabase();
                                    EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(serializedEp), database);
                                    EditingPreferences ep = (EditingPreferences)in.readObject();
                                    in.close();
                                    clientEp = ep;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                continue block10;
                            }
                        }
                        if (!$assertionsDisabled) break;
                    }
                    throw new AssertionError();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    StreamClient.this.dispatcher.interrupt();
                }
            }
            catch (Throwable throwable) {
                StreamClient.this.dispatcher.interrupt();
                throw throwable;
            }
        }
    }

    class ServerEventDispatcher
    extends Thread {
        private Client.ServerEvent lastEvent;

        private ServerEventDispatcher() {
            super(null, null, "Dispatcher-" + StreamClient.this.connectionId, STACK_SIZE_EVENT);
            this.lastEvent = Client.getQueueTail();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    if (StreamClient.this.reader != null) {
                        StreamClient.this.reader.start();
                    }
                    StreamClient.this.writer.writeInt(19);
                    StreamClient.this.writer.writeInt(StreamClient.this.connectionId);
                    StreamClient.this.writeSnapshot(this.lastEvent.getSnapshot());
                    StreamClient.this.writer.flush();
                    while (true) {
                        this.lastEvent = Client.getEvent(this.lastEvent);
                        if (this.lastEvent.getSnapshot() != StreamClient.this.currentSnapshot) {
                            StreamClient.this.writeSnapshot(this.lastEvent.getSnapshot());
                        }
                        this.lastEvent.write(StreamClient.this.writer);
                        StreamClient.this.writer.flush();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.lastEvent = null;
                    Job.jobManager.connectionClosed();
                }
            }
            catch (Throwable throwable) {
                this.lastEvent = null;
                Job.jobManager.connectionClosed();
                throw throwable;
            }
        }
    }
}

