/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Schematics;
import java.util.Arrays;
import java.util.IdentityHashMap;

class ImmutableNetLayout {
    final int numExports;
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;
    private CellBackup cellBackup;
    private CellRevision cellRevision;
    private IdentityHashMap<NodeProtoId, NodeProtoInfo> nodeProtoInfos;
    private IdentityHashMap<PortProtoId, Object> isolatedPorts;
    int[] ni_pi;
    int[] netMap;
    private static final int[] EQUIV_PORTS_1 = new int[]{0};

    ImmutableNetLayout(CellTree cellTree) {
        this.cellBackup = cellTree.top;
        this.numExports = cellTree.top.cellRevision.exports.size();
        this.initConnections(cellTree);
        this.equivPortsN = this.computePortsN();
        this.equivPortsP = this.computePortsP();
        this.equivPortsA = this.computePortsA();
        this.cellBackup = null;
        this.cellRevision = null;
        this.nodeProtoInfos = null;
        this.isolatedPorts = null;
        this.ni_pi = null;
        this.netMap = null;
    }

    private int[] computePortsN() {
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(n, npi.equivPortsN);
        }
        return this.equivMap(null);
    }

    private int[] computePortsP() {
        TechPool techPool = this.cellBackup.techPool;
        Schematics schemTech = techPool.getSchematics();
        PrimitiveNodeId schemResistor = schemTech != null ? schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.equivPortsP == npi.equivPortsN || n.protoId == schemResistor && n.techBits != 0 || !this.connectInternals(n, npi.equivPortsP)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsN) : this.equivPortsN;
    }

    private int[] computePortsA() {
        TechPool techPool = this.cellBackup.techPool;
        Schematics schemTech = techPool.getSchematics();
        PrimitiveNodeId schemResistor = schemTech != null ? schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.equivPortsA == npi.equivPortsP && (n.protoId != schemResistor || n.techBits == 0) || !this.connectInternals(n, npi.equivPortsA)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsP) : this.equivPortsP;
    }

    private boolean connectInternals(ImmutableNodeInst n, int[] equivPorts) {
        boolean changed = false;
        int nodeBase = this.ni_pi[n.nodeId];
        for (int i = 1; i < equivPorts.length; ++i) {
            int eq2 = equivPorts[i];
            if (eq2 == i || !ImmutableNetLayout.connectMap(this.netMap, nodeBase + i, nodeBase + eq2)) continue;
            changed = true;
        }
        return changed;
    }

    private void initConnections(CellTree cellTree) {
        this.cellRevision = this.cellBackup.cellRevision;
        int maxNodeId = -1;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            maxNodeId = Math.max(maxNodeId, n.nodeId);
        }
        this.ni_pi = new int[maxNodeId + 1];
        this.nodeProtoInfos = new IdentityHashMap();
        this.initNetMap(cellTree);
        this.connectExports();
        this.connectArcs();
    }

    private void initNetMap(CellTree cellTree) {
        TechPool techPool = this.cellBackup.techPool;
        Schematics schemTech = techPool.getSchematics();
        int nodeBase = this.numExports;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            this.ni_pi[n.nodeId] = nodeBase;
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi == null) {
                PrimitiveNode pn;
                npi = new NodeProtoInfo(cellTree, n.protoId);
                this.nodeProtoInfos.put(n.protoId, npi);
                if (n.protoId instanceof PrimitiveNodeId && (pn = techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)).getTechnology() == schemTech) {
                    for (PrimitivePort pp : ArrayIterator.i2i(pn.getPrimitivePorts())) {
                        if (!pp.isIsolated()) continue;
                        if (this.isolatedPorts == null) {
                            this.isolatedPorts = new IdentityHashMap();
                        }
                        this.isolatedPorts.put(pp.getId(), null);
                    }
                }
            }
            nodeBase += npi.numPorts;
        }
        this.netMap = ImmutableNetLayout.initMap(nodeBase);
    }

    private void connectExports() {
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e = (ImmutableExport)this.cellRevision.exports.get(exportIndex);
            ImmutableNetLayout.connectMap(this.netMap, exportIndex, this.mapIndex(e.originalNodeId, e.originalPortId));
        }
    }

    private void connectArcs() {
        TechPool techPool = this.cellBackup.techPool;
        Schematics schemTech = techPool.getSchematics();
        PrimitivePortId busPinPortId = schemTech != null ? schemTech.busPinNode.getPort(0).getId() : null;
        ArcProto busArc = schemTech != null ? schemTech.bus_arc : null;
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            ArcProto ap = techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || this.isolatedPorts != null && (this.isolatedPorts.containsKey(a.tailPortId) || this.isolatedPorts.containsKey(a.headPortId)) || (a.tailPortId == busPinPortId || a.headPortId == busPinPortId) && ap != busArc) continue;
            ImmutableNetLayout.connectMap(this.netMap, this.mapIndex(a.tailNodeId, a.tailPortId), this.mapIndex(a.headNodeId, a.headPortId));
        }
    }

    private int mapIndex(int nodeId, PortProtoId portId) {
        NodeProtoInfo npi = this.nodeProtoInfos.get(portId.parentId);
        return this.ni_pi[nodeId] + npi.portIndexByChron[portId.chronIndex];
    }

    private int[] equivMap(int[] oldMap) {
        ImmutableNetLayout.closureMap(this.netMap);
        if (oldMap != null && oldMap.length == this.numExports) {
            boolean eq2 = true;
            for (int i = 0; i < this.numExports; ++i) {
                if (this.netMap[i] == oldMap[i]) continue;
                eq2 = false;
                break;
            }
            if (eq2) {
                return oldMap;
            }
        }
        int[] map2 = new int[this.numExports];
        System.arraycopy(this.netMap, 0, map2, 0, this.numExports);
        return map2;
    }

    static int[] initMap(int size2) {
        int[] map2 = new int[size2];
        for (int i = 0; i < map2.length; ++i) {
            map2[i] = i;
        }
        return map2;
    }

    static boolean connectMap(int[] map2, int a1, int a2) {
        int k;
        int m1 = a1;
        while (map2[m1] != m1) {
            m1 = map2[m1];
        }
        int m2 = a2;
        while (map2[m2] != m2) {
            m2 = map2[m2];
        }
        boolean changed = m1 != m2;
        int m = m1 < m2 ? m1 : m2;
        while (true) {
            k = map2[a1];
            map2[a1] = m;
            if (a1 == k) break;
            a1 = k;
        }
        while (true) {
            k = map2[a2];
            map2[a2] = m;
            if (a2 == k) break;
            a2 = k;
        }
        return changed;
    }

    static void closureMap(int[] map2) {
        for (int i = 0; i < map2.length; ++i) {
            map2[i] = map2[map2[i]];
        }
    }

    private static class NodeProtoInfo {
        final int numPorts;
        final int[] equivPortsN;
        final int[] equivPortsP;
        final int[] equivPortsA;
        final int[] portIndexByChron;
        final EquivPorts subNet;

        private NodeProtoInfo(CellTree cellTree, NodeProtoId nodeProtoId) {
            if (nodeProtoId instanceof CellId) {
                CellUsage cu = cellTree.top.cellRevision.d.cellId.getUsageIn((CellId)nodeProtoId);
                CellTree subTree = cellTree.subTrees[cu.indexInParent];
                this.subNet = subTree.getEquivPorts();
                this.numPorts = this.subNet.numExports;
                this.equivPortsN = this.subNet.equivPortsN;
                this.equivPortsP = this.subNet.equivPortsP;
                this.equivPortsA = this.subNet.equivPortsA;
                this.portIndexByChron = subTree.top.cellRevision.exportIndex;
            } else {
                PrimitivePort pp;
                int portIndex;
                this.subNet = null;
                PrimitiveNode pn = cellTree.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId);
                this.numPorts = pn.getNumPorts();
                int maxChronId = -1;
                for (portIndex = 0; portIndex < pn.getNumPorts(); ++portIndex) {
                    pp = pn.getPort(portIndex);
                    maxChronId = Math.max(maxChronId, pp.getId().chronIndex);
                }
                this.portIndexByChron = new int[maxChronId + 1];
                Arrays.fill(this.portIndexByChron, -1);
                portIndex = 0;
                while (portIndex < pn.getNumPorts()) {
                    pp = pn.getPort(portIndex);
                    this.portIndexByChron[pp.getId().chronIndex] = portIndex++;
                }
                if (pn.getNumPorts() == 1) {
                    this.equivPortsA = EQUIV_PORTS_1;
                    this.equivPortsP = this.equivPortsA;
                    this.equivPortsN = this.equivPortsA;
                } else {
                    this.equivPortsN = ImmutableNetLayout.initMap(pn.getNumPorts());
                    for (int i = 0; i < pn.getNumPorts(); ++i) {
                        for (int j = i + 1; j < pn.getNumPorts(); ++j) {
                            if (pn.getPort(i).getTopology() != pn.getPort(j).getTopology()) continue;
                            ImmutableNetLayout.connectMap(this.equivPortsN, i, j);
                        }
                    }
                    ImmutableNetLayout.closureMap(this.equivPortsN);
                    PrimitiveNode.Function fun = pn.getFunction();
                    if (fun == PrimitiveNode.Function.RESIST) {
                        assert (this.equivPortsN.length == 2);
                        this.equivPortsA = new int[]{0, 0};
                        this.equivPortsP = this.equivPortsA;
                    } else if (fun.isComplexResistor()) {
                        this.equivPortsP = this.equivPortsN;
                        this.equivPortsA = new int[]{0, 0};
                    } else {
                        this.equivPortsA = this.equivPortsN;
                        this.equivPortsP = this.equivPortsN;
                    }
                }
            }
        }
    }
}

