/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.concurrency;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar2.concurrency.RouteJob;
import com.sun.electric.tool.routing.experimentalAStar2.datastructures.Point3D;
import com.sun.electric.tool.routing.experimentalAStar2.goal.SimpleGoal;
import com.sun.electric.tool.routing.experimentalAStar2.machine.AStarMachineFast;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.AStarNodeObjectPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRouteJob
implements Callable<LocalRouteJob> {
    public Point3D from;
    public Point3D to;
    public List<Point3D> path;
    public RouteJob routeJob;
    public AStarRegionNode regionalNode;
    public int numberInGlobalPath = -1;

    public LocalRouteJob() {
    }

    public LocalRouteJob(Point3D from2, Point3D to2) {
        this.from = from2;
        this.to = to2;
        this.path = null;
    }

    public List<Point3D> getPath() {
        return this.path;
    }

    @Override
    public LocalRouteJob call() {
        this.path = null;
        AStarMachineFast machine = new AStarMachineFast(new AStarNodeObjectPool());
        SimpleGoal goal = new SimpleGoal();
        goal.setMaximumRevolutions(300000);
        machine.setUpSearchSpace(this.regionalNode.routingMap, goal);
        List path = machine.findPath(this.from.getX(), this.from.getY(), this.from.getZ(), this.to.getX(), this.to.getY(), this.to.getZ());
        if (path != null) {
            this.path = new ArrayList<Point3D>();
            for (AStarNode node : path) {
                this.regionalNode.removePathForNode(node.getX(), node.getY());
                this.path.add(new Point3D(node.getX(), node.getY(), node.getZ()));
            }
            this.regionalNode.setEntryPoint(null);
            this.regionalNode.setExitPoint(null);
        }
        return this;
    }
}

