/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Inv_passgate {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double wireWithPolyPitch = 8.0;
    private static final double wirePitch = 7.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double enY = -4.0;
    private static final double inY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        double lamPerSz;
        double totWidP;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "inv_passgate";
        sz = stdCell.checkMinStrength(sz, 0.5, nm);
        double pmosBot = 8.5;
        double spaceAvail = stdCell.getCellTop() - 6.0 - pmosBot;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWidP = sz * (lamPerSz = 6.0), 1);
        Inv_passgate.error(fwP == null, "can't make " + nm + " this small: " + sz);
        double nmosTop = -8.5;
        spaceAvail = nmosTop - (stdCell.getCellBot() + 1.5 + 4.0 + 2.5);
        lamPerSz = 6.0;
        double elecWidN = sz * lamPerSz;
        int nbPullDnFolds = (int)Math.ceil(elecWidN / spaceAvail);
        if (nbPullDnFolds % 2 == 0) {
            ++nbPullDnFolds;
        }
        double gateWidN = Math.rint(elecWidN / (double)nbPullDnFolds * 2.0) / 2.0;
        gateWidN = Math.min(gateWidN, spaceAvail);
        double srcDrnWidN = Math.max(gateWidN, 5.0);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double invOutX = 3.5;
        double inX = invOutX + 7.0;
        double mosX = inX + 7.0;
        double nmosY = nmosTop - srcDrnWidN / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, nbPullDnFolds * 2, 1, gateWidN, inv, tech, ep);
        double pmosY = pmosBot + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, inv, tech, ep);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, inv);
        LayoutLib.newExport(inv, "gnd", ep, PortCharacteristic.GND, tech.m2(), 10.0, mosX, stdCell.getGndY());
        TrackRouterH gnd = new TrackRouterH(tech.m2(), stdCell.getGndWidth(), tech, ep, inv);
        gnd.connect(inv.findExport("gnd"));
        for (int i2 = 0; i2 < nbPullDnFolds; i2 += 2) {
            gnd.connect(nmos.getSrcDrn(i2));
        }
        PortInst invOut = LayoutLib.newNodeInst(tech.m1pin(), ep, invOutX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, inv).getOnlyPortInst();
        TrackRouterH invOutHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, inv);
        invOutHi.connect(invOut);
        for (int i3 = 1; i3 < pmos.nbSrcDrns(); i3 += 2) {
            invOutHi.connect(pmos.getSrcDrn(i3));
        }
        TrackRouterH invOutLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, inv);
        invOutLo.connect(invOut);
        for (int i4 = 1; i4 < nmos.nbSrcDrns(); i4 += 2) {
            invOutLo.connect(nmos.getSrcDrn(i4));
        }
        LayoutLib.newExport(inv, "in", ep, PortCharacteristic.IN, tech.m1(), 4.0, inX, 4.0);
        TrackRouterH in = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, inv);
        in.connect(inv.findExport("in"));
        for (i = 0; i < pmos.nbGates(); ++i) {
            in.connect(pmos.getGate(i, 'B'));
        }
        for (i = 0; i < nbPullDnFolds; ++i) {
            in.connect(nmos.getGate(i, 'T'));
        }
        double jogX = StdCellParams.getRightDiffX(nmos, pmos) + 7.0;
        double enX = jogX + 7.0;
        double outX = enX + 7.0;
        double outM1Y = nmosTop - srcDrnWidN - 2.5 - 2.0;
        TrackRouterH outLo = new TrackRouterH(tech.m1(), 3.0, outM1Y, tech, ep, inv);
        for (int i5 = nbPullDnFolds + 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        PortInst jog = LayoutLib.newNodeInst(tech.m1pin(), ep, jogX, -11.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, inv).getOnlyPortInst();
        outLo.connect(jog);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 3.0, -11.0, tech, ep, inv);
        outHi.connect(jog);
        LayoutLib.newExport(inv, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, -11.0);
        outHi.connect(inv.findExport("out"));
        LayoutLib.newExport(inv, "en", ep, PortCharacteristic.IN, tech.m1(), 4.0, enX, -4.0);
        TrackRouterH en = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, inv);
        en.connect(inv.findExport("en"));
        for (int i6 = nbPullDnFolds; i6 < nbPullDnFolds * 2; ++i6) {
            en.connect(nmos.getGate(i6, 'T'));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

