/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.CompileVerilogStruct;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.net.URL;
import java.util.BitSet;
import java.util.Map;

public class VerilogReader
extends Input<Object> {
    public VerilogReader(EditingPreferences ep, VerilogPreferences ap) {
        super(ep);
    }

    public static class VerilogPreferences
    extends Input.InputPreferences {
        public boolean runPlacement = SimulationTool.getFactoryVerilogRunPlacementTool();
        public boolean makeLayoutCells = IOTool.isFactoryVerilogMakeLayoutCells();
        public Placement.PlacementPreferences placementPrefs;
        public IconParameters iconParameters;

        public VerilogPreferences(boolean factory) {
            super(factory);
            if (!factory) {
                this.runPlacement = SimulationTool.getVerilogRunPlacementTool();
                this.makeLayoutCells = IOTool.isVerilogMakeLayoutCells();
            }
            this.placementPrefs = new Placement.PlacementPreferences(factory);
            this.iconParameters = IconParameters.makeInstance(!factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            File f2 = TextUtils.getFile(fileURL);
            CompileVerilogStruct cvs = new CompileVerilogStruct(f2, false);
            Cell cell = cvs.genCell(lib, !this.makeLayoutCells, ep, this.iconParameters);
            if (lib != null && this.runPlacement) {
                Placement.placeCellNoJob(cell, ep, this.placementPrefs, true, job);
            }
            return lib;
        }
    }
}

