/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetlister1;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LETool
extends Tool {
    private static LETool tool = new LETool();
    private static final boolean DEBUG = false;
    private static final Pattern celecDefaultNamePattern = Pattern.compile("^(\\D+)(\\d+)$");
    private static AnalyzeCell lastLEJobExecuted = null;
    private static double DEFAULT_GLOBALFANOUT = 4.7;
    private static double DEFAULT_EPSILON = 0.001;
    private static int DEFAULT_MAXITER = 30;
    private static double DEFAULT_KEEPERRATIO = 0.1;

    private LETool() {
        super("logeffort");
    }

    public static LETool getLETool() {
        return tool;
    }

    @Override
    public void init() {
        EvalJavaBsh.evalJavaBsh.setVariable("LE", tool);
    }

    public Object getdrive() throws VarContext.EvalException {
        return this.getdrive(null, Double.MIN_VALUE);
    }

    public Object getdrive(double defaultValue) throws VarContext.EvalException {
        return this.getdrive(null, defaultValue);
    }

    public Object getdrive(String varName, double defaultValue) throws VarContext.EvalException {
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            if (defaultValue != Double.MIN_VALUE) {
                return new Double(defaultValue);
            }
            throw new VarContext.EvalException("getdrive(): Not enough hierarchy");
        }
        VarContext context = EvalJavaBsh.evalJavaBsh.getCurrentContext();
        if (context == null) {
            throw new VarContext.EvalException("getdrive(): null VarContext");
        }
        Nodable ni = (Nodable)info;
        Object val = null;
        if (ni instanceof NodeInst && ni.getNameKey().busWidth() > 1) {
            Name name = ni.getNameKey();
            ArrayList<Object> sizes = new ArrayList<Object>();
            for (int i = 0; i < name.busWidth(); ++i) {
                Nodable no = Netlist.getNodableFor((NodeInst)ni, i);
                Variable var = this.getLEDRIVE(ni, context.push(no));
                Object size2 = null;
                if (defaultValue != Double.MIN_VALUE) {
                    size2 = new Double(defaultValue);
                }
                if (var != null) {
                    size2 = var.getObject();
                }
                if (varName != null && size2 instanceof String) {
                    size2 = this.getSCOTValue(var, varName);
                }
                sizes.add(size2);
            }
            if (sizes.size() > 5) {
                Object[] objs = new Object[]{sizes.get(0), "...", sizes.get(sizes.size() - 1)};
                val = objs;
            } else {
                val = sizes.toArray();
            }
        } else {
            Variable var = this.getLEDRIVE(ni, context.push(ni));
            if (var == null) {
                var = this.getLEDRIVE_old(ni, context);
            }
            if (var == null && defaultValue != Double.MIN_VALUE) {
                return new Double(defaultValue);
            }
            if (var == null) {
                throw new VarContext.EvalException("getdrive(): no size");
            }
            val = var.getObject();
            if (varName != null && val instanceof String) {
                val = this.getSCOTValue(var, varName);
            }
        }
        if (val == null) {
            throw new VarContext.EvalException("getdrive(): size null");
        }
        return val;
    }

    public Object subdrive(String nodeName, String parName) throws VarContext.EvalException {
        VarContext context;
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy information");
        }
        Nodable no = (Nodable)info;
        if (no == null) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy");
        }
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            Cell parent = no.getParent();
            if (parent == null) {
                throw new VarContext.EvalException("subdrive(): null parent");
            }
            int arrayIndex = 0;
            no = Netlist.getNodableFor(ni, arrayIndex);
            if (no == null) {
                throw new VarContext.EvalException("subdrive(): can't get equivalent schematic");
            }
        }
        if ((context = EvalJavaBsh.evalJavaBsh.getCurrentContext()) == null) {
            throw new VarContext.EvalException("subdrive(): null context");
        }
        NodeProto np = no.getProto();
        if (np == null) {
            throw new VarContext.EvalException("subdrive(): null nodeProto");
        }
        if (!no.isCellInstance()) {
            throw new VarContext.EvalException("subdrive(): NodeProto not a Cell");
        }
        Cell cell = (Cell)np;
        NodeInst ni = cell.findNode(nodeName);
        if (ni == null && (ni = cell.findNode(LETool.convertToJElectricDefaultName(nodeName))) == null) {
            throw new VarContext.EvalException("subdrive(): no nodeInst named " + nodeName);
        }
        Variable var = ni.getParameterOrVariable(parName);
        if (var == null) {
            throw new VarContext.EvalException(parName.replaceFirst("ATTR_", "") + " not found");
        }
        return context.push(no).evalVarRecurse(var, ni);
    }

    private Variable getLEDRIVE_old(Nodable no, VarContext context) {
        String drive = LETool.makeDriveStrOLDRecurse(context);
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive + ";0;S");
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(59);
            if (i == -1) break;
            drive = drive.substring(i + 1);
        }
        if ((var = no.getVar(Variable.newKey("LEDRIVE_0;S"))) != null) {
            return var;
        }
        return null;
    }

    private Variable getLEDRIVE(Nodable no, VarContext context) {
        Variable var = null;
        var = this.getLEDRIVEtop(no, context);
        if (var == null) {
            var = this.getLEDRIVEleaf(no, context);
        }
        return var;
    }

    private Variable getLEDRIVEtop(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Nodable topno = no;
        while (context != VarContext.globalContext) {
            topno = context.getNodable();
            context = context.pop();
        }
        Cell parent = topno.getParent();
        Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
        if (key == null) {
            return null;
        }
        Variable var = parent.getVar(key);
        return var;
    }

    private Object getSCOTValue(Variable var, String varName) {
        String[] valsparts;
        if (var == null || varName == null) {
            return null;
        }
        Object val = var.getObject();
        if (!(val instanceof String)) {
            return null;
        }
        String vals = (String)val;
        for (String s : valsparts = vals.split("/")) {
            if (!(s = s.trim()).startsWith(varName)) continue;
            String[] parts = s.split("=");
            if (parts.length != 2) {
                return null;
            }
            return parts[1].trim();
        }
        return null;
    }

    private Variable getLEDRIVEleaf(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(46);
            if (i == -1) {
                return null;
            }
            drive = drive.substring(i + 1);
        }
        return null;
    }

    private static String makeDriveStr(VarContext context) {
        return "LEDRIVE_" + context.getInstPath(".");
    }

    private static String makeDriveStrOLD(VarContext context) {
        String s = "LEDRIVE_" + LETool.makeDriveStrOLDRecurse(context) + ";0;S";
        return s;
    }

    private static String makeDriveStrOLDRecurse(VarContext context) {
        if (context == VarContext.globalContext) {
            return "";
        }
        String prefix = context.pop() == VarContext.globalContext ? "" : LETool.makeDriveStrOLDRecurse(context.pop());
        Nodable no = context.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        String name = LETool.getCElectricDefaultName(no);
        String me = name + ",0";
        if (prefix.equals("")) {
            return me;
        }
        return prefix + ";" + me;
    }

    private static String getCElectricDefaultName(Nodable no) {
        String name = no.getNodeInst().getName();
        int at = name.indexOf(64);
        if (at != -1 && at + 1 < name.length()) {
            String num = name.substring(at + 1, name.length());
            try {
                Integer i = new Integer(num);
                name = name.substring(0, at) + (i + 1);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return name;
    }

    private static String convertToJElectricDefaultName(String celectricDefaultName) {
        Matcher mat = celecDefaultNamePattern.matcher(celectricDefaultName);
        if (mat.matches()) {
            try {
                Integer i = new Integer(mat.group(2));
                int ii = i - 1;
                if (ii >= 0) {
                    celectricDefaultName = mat.group(1) + "@" + ii;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return celectricDefaultName;
    }

    protected static Variable getMFactor(Nodable no) {
        Variable var = no.getVar(SimulationTool.M_FACTOR_KEY);
        if (var == null) {
            var = no.getParameter(SimulationTool.M_FACTOR_KEY);
        }
        return var;
    }

    public static double quantize(double d, double error, double minValue) {
        if (d <= minValue) {
            return minValue;
        }
        double power = Math.log10(d) / Math.log10(1.0 + error);
        long p = Math.round(power);
        long quan = Math.round(Math.pow(1.0 + error, p));
        return quan;
    }

    public void optimizeEqualGateDelays(Cell cell, VarContext context, boolean newAlg) {
        AnalyzeCell acjob = new AnalyzeCell(LESizer.Alg.EQUALGATEDELAYS, cell, context, newAlg);
        acjob.startJob(false);
    }

    public static void printResults(Nodable no, VarContext context) {
        LENetlister netlister;
        if (lastLEJobExecuted != null && (netlister = lastLEJobExecuted.getNetlister()).printResults(no, context)) {
            return;
        }
        System.out.println("No existing completed sizing jobs contain info about " + no.getName());
    }

    public static void clearStoredSizesJob(NodeInst ni) {
        ClearStoredSizes job = new ClearStoredSizes(ni);
    }

    public static void clearStoredSizesJob(Library lib) {
        ClearStoredSizesLibrary job = new ClearStoredSizesLibrary(lib);
    }

    private static void clearStoredSizes(Cell cell) {
        Iterator<Serializable> it = cell.getNodes();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
        it = cell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            cell.delVar(var.getKey());
        }
    }

    private static void clearStoredSizes(Library lib) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
    }

    private static void clearStoredSizes(NodeInst ni) {
        Iterator<Variable> it = ni.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            ni.delVar(var.getKey());
        }
    }

    public static boolean isUseLocalSettings() {
        return LETool.getUseLocalSettingsSetting().getBoolean();
    }

    public static Setting getUseLocalSettingsSetting() {
        return ToolSettings.getUseLocalSettingsSetting();
    }

    public static double getGlobalFanout() {
        return LETool.getGlobalFanoutSetting().getDouble();
    }

    public static Setting getGlobalFanoutSetting() {
        return ToolSettings.getGlobalFanoutSetting();
    }

    public static double getConvergenceEpsilon() {
        return LETool.getConvergenceEpsilonSetting().getDouble();
    }

    public static Setting getConvergenceEpsilonSetting() {
        return ToolSettings.getConvergenceEpsilonSetting();
    }

    public static int getMaxIterations() {
        return LETool.getMaxIterationsSetting().getInt();
    }

    public static Setting getMaxIterationsSetting() {
        return ToolSettings.getMaxIterationsSetting();
    }

    public static double getKeeperRatio() {
        return LETool.getKeeperRatioSetting().getDouble();
    }

    public static Setting getKeeperRatioSetting() {
        return ToolSettings.getKeeperRatioSetting();
    }

    public static double getX1InverterNWidth() {
        return LETool.getX1InverterNWidthSetting().getDouble();
    }

    public static double getX1InverterPWidth() {
        return LETool.getX1InverterPWidthSetting().getDouble();
    }

    public static double getX1InverterLength() {
        return LETool.getX1InverterLengthSetting().getDouble();
    }

    public static Setting getX1InverterNWidthSetting() {
        return ToolSettings.getX1InverterNWidthSetting();
    }

    public static Setting getX1InverterPWidthSetting() {
        return ToolSettings.getX1InverterPWidthSetting();
    }

    public static Setting getX1InverterLengthSetting() {
        return ToolSettings.getX1InverterLengthSetting();
    }

    public static class ClearStoredSizesLibrary
    extends Job {
        private Library lib;

        public ClearStoredSizesLibrary(Library lib) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.lib);
            return true;
        }
    }

    public static class ClearStoredSizes
    extends Job {
        private NodeInst ni;

        public ClearStoredSizes(NodeInst ni) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.ni);
            return true;
        }
    }

    private static class UniqueCell {
        private Set<String> relevantNodeNames;
        private Map<String, Cell> uniqueCells;
        private Cell originalCell;
        private boolean verbose = false;

        private UniqueCell(Cell cell, Map<String, Cell> relevantNodes) {
            this.originalCell = cell;
            this.relevantNodeNames = relevantNodes.keySet();
            this.uniqueCells = new HashMap<String, Cell>();
            String key = this.getKey(relevantNodes);
            this.uniqueCells.put(key, cell);
            this.prMsg("Registering original cell " + this.originalCell.describe(false) + " under key " + key);
        }

        public String getKey(Map<String, Cell> relevantNodes) {
            StringBuffer buf = new StringBuffer();
            for (String s : this.relevantNodeNames) {
                Cell c = relevantNodes.get(s);
                if (c == null) continue;
                buf.append(c.getLibrary().getName());
                buf.append(c.getName());
            }
            return buf.toString();
        }

        public Cell getUniqueCell(Map<String, Cell> relevantNodes, EditingPreferences ep) {
            String key = this.getKey(relevantNodes);
            this.prMsg("Checking against original cell " + this.originalCell.describe(false) + " with new key " + key);
            Cell c = this.uniqueCells.get(key);
            if (c == null) {
                c = UniqueCell.duplicate(this.originalCell, ep);
                this.prMsg("Duplicating " + this.originalCell.describe(false));
                this.uniqueCells.put(key, c);
            }
            return c;
        }

        public static Cell duplicate(Cell cell, EditingPreferences ep) {
            String pname;
            assert (cell.isSchematic());
            Library lib = cell.getLibrary();
            String newpname = pname = cell.getName().replaceAll("_[0-9]+$", "");
            int i = 1;
            for (i = 1; i < 100; ++i) {
                String temp = pname + "_" + i;
                if (lib.findNodeProto(temp) != null) continue;
                newpname = temp;
                break;
            }
            if (i == 100) {
                System.out.println("Error: Unable to uniquify cell " + cell.describe(false) + ", too many versions already");
                return cell;
            }
            Cell icon = cell.iconView();
            Cell newicon = null;
            if (icon != null && (newicon = Cell.copyNodeProto(icon, lib, newpname, true)) == null) {
                System.out.println("Error: Unable to copy " + icon.describe(false) + " to " + newpname);
                return cell;
            }
            Cell newcell = Cell.copyNodeProto(cell, lib, newpname, true);
            if (newcell == null) {
                System.out.println("Error: Unable to copy " + cell.describe(false) + " to " + newpname);
                return cell;
            }
            if (icon != null && newicon != null) {
                Iterator<NodeInst> it = newcell.getNodes();
                while (it.hasNext()) {
                    NodeInst nni = it.next();
                    if (nni.getProto() != icon) continue;
                    nni.replace(newicon, ep, true, true);
                }
            }
            return newcell;
        }

        public void prMsg(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }
    }

    private static class Uniquifier {
        private UniqueNodeMap uniqueNodeMap;
        private Map<Cell, UniqueCell> uniqueCellMap;
        private boolean hierarchyError = false;
        private boolean verbose = false;

        public Uniquifier(UniqueNodeMap leafCellNodeMap) {
            this.uniqueNodeMap = leafCellNodeMap;
            this.uniqueCellMap = new HashMap<Cell, UniqueCell>();
        }

        public void registerCellsToUniquify(Cell cell, VarContext context, EditingPreferences ep) {
            Netlist netlist = cell.getNetlist();
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                Cell subproto;
                Nodable no = it.next();
                if (!no.isCellInstance() || (subproto = (Cell)no.getProto()).isIconOf(cell)) continue;
                Cell schcell = subproto.getMainSchematicInGroup();
                this.registerCellsToUniquify(schcell, context.push(no), ep);
            }
            HashMap<String, Cell> relevantNodes = new HashMap<String, Cell>();
            HashMap<NodeInst, Cell> arrayedNodeConflicts = new HashMap<NodeInst, Cell>();
            Iterator<Nodable> it2 = netlist.getNodables();
            while (it2.hasNext()) {
                VarContext nocontext;
                Cell iconCell;
                Nodable no = it2.next();
                if (!no.isCellInstance() || (iconCell = this.uniqueNodeMap.get(nocontext = context.push(no))) == null) continue;
                this.prMsg("Found Cell " + iconCell.describe(false) + " for context " + nocontext.getInstPath("."));
                relevantNodes.put(no.getName(), iconCell);
                Cell mappedIconCell = (Cell)arrayedNodeConflicts.get(no.getNodeInst());
                if (mappedIconCell == null) {
                    arrayedNodeConflicts.put(no.getNodeInst(), iconCell);
                    continue;
                }
                if (mappedIconCell == iconCell) continue;
                System.out.println("ERROR: Arrayed node: " + nocontext.getInstPath("."));
                System.out.println("       Has different sizes or different sizes in sub nodes; array must be flattened");
                this.hierarchyError = true;
            }
            if (context == VarContext.globalContext) {
                return;
            }
            if (relevantNodes.size() > 0) {
                UniqueCell uniqueCell = this.uniqueCellMap.get(cell);
                if (uniqueCell == null) {
                    uniqueCell = new UniqueCell(cell, relevantNodes);
                    this.uniqueCellMap.put(cell, uniqueCell);
                }
                Cell newcell = uniqueCell.getUniqueCell(relevantNodes, ep);
                this.uniqueNodeMap.put(context, newcell.iconView());
            }
        }

        public void uniquify(Cell cell, VarContext context, EditingPreferences ep) {
            Netlist netlist = cell.getNetlist();
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                VarContext nocontext;
                Cell newIcon;
                Nodable no = it.next();
                if (!no.isCellInstance()) continue;
                NodeInst ni = no.getNodeInst();
                Cell subcell = (Cell)no.getProto();
                if (subcell.isIconOf(cell) || (newIcon = this.uniqueNodeMap.get(nocontext = context.push(no))) == null || newIcon == ni.getProto()) continue;
                if (ni.isLinked()) {
                    ni.replace(newIcon, ep, true, true);
                    this.prMsg("Replaced " + nocontext.getInstPath(".") + " with " + newIcon.describe(false));
                }
                boolean found = false;
                Iterator<Nodable> it2 = netlist.getNodables();
                while (it2.hasNext()) {
                    Nodable no2 = it2.next();
                    if (no.getNameKey() != no2.getNameKey()) continue;
                    nocontext = context.push(no2);
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("ERROR: Could not find new nodable for " + context.getInstPath(".") + "." + no.getName());
            }
        }

        public boolean isHierarchyError() {
            return this.hierarchyError;
        }

        public void prMsg(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }
    }

    public static class UniqueNodeMap {
        private Map<String, Cell> nodeMap = new HashMap<String, Cell>();

        public void put(VarContext context, Cell cell) {
            this.nodeMap.put(UniqueNodeMap.getKey(context), cell);
        }

        public Cell get(VarContext context) {
            return this.nodeMap.get(UniqueNodeMap.getKey(context));
        }

        public int size() {
            return this.nodeMap.size();
        }

        private static String getKey(VarContext context) {
            return context.getInstPath(".");
        }
    }

    private static class UpdateSizes
    extends Job {
        private List<Float> sizes;
        private List<String> varNames;
        private List<NodeInst> nodes;
        private List<VarContext> contexts;
        private Cell cell;
        private double standardCellErrorTolerancePrint = 0.1;

        private UpdateSizes(List<Float> sizes, List<String> varNames, List<NodeInst> nodes, List<VarContext> contexts, Cell cell, double standardCellErrorTolerancePrint) {
            super("Update LE Sizes", tool, Job.Type.CHANGE, null, cell, Job.Priority.USER);
            this.sizes = sizes;
            this.varNames = varNames;
            this.nodes = nodes;
            this.contexts = contexts;
            this.cell = cell;
            this.standardCellErrorTolerancePrint = standardCellErrorTolerancePrint;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            UniqueNodeMap standardCellNodeMap = new UniqueNodeMap();
            boolean standardCellArrayError = false;
            System.out.println("Standard cell quantization errors over " + this.standardCellErrorTolerancePrint * 100.0 + "%:");
            StringBuffer errBuf = new StringBuffer();
            for (int i = 0; i < this.sizes.size(); ++i) {
                Float f2;
                VarContext context;
                NodeInst ni = this.nodes.get(i);
                Cell standardCell = this.getStandardCell(ni, context = this.contexts.get(i), (f2 = this.sizes.get(i)).doubleValue());
                if (standardCell != null) {
                    VarContext nicontext = context.push(ni);
                    Cell previousStandardCell = standardCellNodeMap.get(nicontext);
                    if (previousStandardCell != null && previousStandardCell != standardCell.iconView()) {
                        errBuf.append("ERROR: Arrayed Standard Cell " + context.getInstPath(".") + "." + ni.getName() + "\n");
                        errBuf.append("       cannot yield separate sizes for nodes in array: " + previousStandardCell.getName() + " vs " + standardCell.getName() + "\n");
                        standardCellArrayError = true;
                    }
                    VarContext nocontext = context.push(Netlist.getNodableFor(ni, 0));
                    standardCellNodeMap.put(nocontext, standardCell.iconView());
                    continue;
                }
                String varName = this.varNames.get(i);
                this.cell.newVar(varName, (Object)f2, ep);
            }
            if (standardCellNodeMap.size() > 0) {
                Uniquifier uniquifier = new Uniquifier(standardCellNodeMap);
                uniquifier.registerCellsToUniquify(this.cell, VarContext.globalContext, ep);
                if (uniquifier.isHierarchyError() || standardCellArrayError) {
                    System.out.println(errBuf);
                    System.out.println("Error with hierarchy, please fix first: Standard Cell Sizes Not Updated");
                    return false;
                }
                uniquifier.uniquify(this.cell, VarContext.globalContext, ep);
            }
            System.out.println("Sizes updated. Sizing Finished.");
            this.fieldVariableChanged("cell");
            return true;
        }

        private Cell getStandardCell(NodeInst ni, VarContext context, double targetsize) {
            Cell mainSchematic;
            Cell np = null;
            if (ni.isCellInstance()) {
                np = (Cell)ni.getProto();
            }
            if (np != null && (mainSchematic = np.getMainSchematicInGroup()) != null && mainSchematic.getVar(SCLibraryGen.STANDARDCELL) != null) {
                int tail = np.getName().indexOf("_X");
                String type = np.getName().substring(0, tail);
                double diff2 = Double.MAX_VALUE;
                double chosensize = 0.0;
                Cell chosencell = null;
                Iterator<Cell> it = np.getLibrary().getCells();
                while (it.hasNext()) {
                    String cname;
                    Cell c = it.next();
                    if (!c.isSchematic() || !(cname = c.getName()).startsWith(type + "_X")) continue;
                    double size2 = 0.0;
                    try {
                        size2 = Double.parseDouble(cname.substring(type.length() + 2));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    double tempdiff = targetsize - size2;
                    if (!(Math.abs(tempdiff) < Math.abs(diff2))) continue;
                    diff2 = tempdiff;
                    chosensize = size2;
                    chosencell = c;
                }
                if (chosencell == null) {
                    System.out.println("Unable to find standard cell for " + ni.describe(false));
                    return null;
                }
                double percentdiff = diff2 / targetsize;
                if (Math.abs(percentdiff) > this.standardCellErrorTolerancePrint) {
                    String p = TextUtils.formatDouble(100.0 * percentdiff, 1);
                    String ideal = TextUtils.formatDouble(targetsize, 2);
                    String used = TextUtils.formatDouble(chosensize, 2);
                    String strcontext = context.push(ni).getInstPath(".");
                    System.out.println("  " + p + "%: " + ideal + " (ideal) vs " + used + " (used); for " + strcontext);
                }
                return chosencell;
            }
            return null;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.findWindow(this.cell);
            if (wnd != null) {
                wnd.fullRepaint();
            }
        }
    }

    public static class AnalyzeCell
    extends Job {
        private String progress = null;
        private Cell cell;
        private VarContext context;
        private LESizer.Alg algorithm;
        private LENetlister netlister;
        private boolean newAlg;

        public AnalyzeCell(LESizer.Alg algorithm, Cell cell, VarContext context, boolean newAlg) {
            super("Analyze " + cell, tool, Job.Type.CLIENT_EXAMINE, null, cell, Job.Priority.USER);
            this.algorithm = algorithm;
            this.cell = cell;
            this.context = context;
            this.newAlg = newAlg;
        }

        @Override
        public boolean doIt() throws JobException {
            if (lastLEJobExecuted != null) {
                lastLEJobExecuted.remove();
            }
            lastLEJobExecuted = this;
            this.setProgress("building equations");
            System.out.print("Building equations...");
            Technology layoutTech = this.cell.getTechnology();
            if (layoutTech == Schematics.tech()) {
                layoutTech = Schematics.getDefaultSchematicTechnology();
            }
            this.netlister = this.newAlg ? new LENetlister2(this, layoutTech) : new LENetlister1(this, layoutTech);
            boolean success2 = this.netlister.netlist(this.cell, this.context, true);
            if (!success2) {
                return false;
            }
            this.timer.end();
            System.out.println("done (" + this.timer + ")");
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            System.out.println("Starting iterations: ");
            this.setProgress("iterating");
            boolean success22 = this.netlister.size(this.algorithm);
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            if (success22) {
                System.out.println("Sizing finished, updating sizes...");
                this.netlister.printStatistics();
                ArrayList<Float> sizes = new ArrayList<Float>();
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
                ArrayList<VarContext> contexts = new ArrayList<VarContext>();
                this.netlister.getSizes(sizes, varNames, nodes, contexts);
                for (int i = 0; i < sizes.size(); ++i) {
                    float f2 = ((Float)sizes.get(i)).floatValue();
                    NodeInst ni = (NodeInst)nodes.get(i);
                    VarContext context = (VarContext)contexts.get(i);
                    if (!(f2 < 1.0f)) continue;
                    String msg = "WARNING: Instance " + ni + " has size " + TextUtils.formatDouble(f2, 3) + " less than 1";
                    System.out.println(msg);
                    if (ni == null) continue;
                    this.netlister.getErrorLogger().logWarning(msg, ni, ni.getParent(), context, 2);
                }
                new UpdateSizes(sizes, varNames, nodes, contexts, this.cell, 0.1);
                this.netlister.getErrorLogger().termLogging(true);
            } else {
                System.out.println("Sizing failed, sizes unchanged");
                this.netlister.done();
            }
            return true;
        }

        protected boolean checkAbort(String msg) {
            boolean aborted = super.checkAbort();
            if (aborted) {
                if (msg != null) {
                    System.out.println("LETool aborted: " + msg);
                } else {
                    System.out.println("LETool aborted: no changes made");
                }
            }
            return aborted;
        }

        @Override
        public String getInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getInfo());
            if (this.getScheduledToAbort()) {
                buf.append("  Job aborted, no changes made\n");
            } else {
                buf.append("  Job completed successfully\n");
            }
            return buf.toString();
        }

        public LENetlister getNetlister() {
            return this.netlister;
        }
    }
}

