/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.Name;
import com.sun.electric.tool.simulation.test.NanosimModel;
import com.sun.electric.tool.simulation.test.SubchainNode;
import java.util.ArrayList;
import java.util.List;

public abstract class NanosimJtag
extends JtagTester {
    protected final NanosimModel nm;
    protected float tapVolt;
    protected double delay;
    private static final boolean DEBUG = false;

    NanosimJtag(NanosimModel nm) {
        this.nm = nm;
    }

    @Override
    void configure(float tapVolt, long kiloHerz) {
        this.tapVolt = tapVolt;
        this.delay = 1.0 / (double)kiloHerz * 1000000.0 / 2.0;
    }

    @Override
    void disconnect() {
    }

    @Override
    void setLogicOutput(int index, boolean newLevel) {
        System.out.println("Nanosim JtagTester does not support 'setLogicOutput(" + index + ", " + newLevel + "). Use LogicSettable instead.");
    }

    public boolean isBypassScanning() {
        return this.nm.isBypassScanning();
    }

    protected void doBypassScanning(ChainNode chain2, boolean readEnable, boolean writeEnable) {
        if (chain2.getOutBitsExpected().isInvalid()) {
            chain2.getOutBits().set(0, chain2.getOutBitsExpected().getNumBits(), false);
        } else {
            chain2.getOutBits().put(0, chain2.getOutBitsExpected());
        }
        if (readEnable) {
            chain2.getOutBits().put(0, this.readDirect(chain2));
        }
        if (writeEnable) {
            this.writeDirect(chain2);
            this.checkDataNets(chain2, 0);
            this.checkDataNets(chain2, 1);
        }
    }

    protected static List getDataNets(SubchainNode chain2, int set) {
        MyTreeNode system = chain2.getParent().getParent();
        MyTreeNode scanchainnets = MyTreeNode.getNode(system, "scanChainDataNets");
        if (scanchainnets == null) {
            return NanosimJtag.getDataNetsOld(chain2, set);
        }
        SubchainNode datachain = (SubchainNode)MyTreeNode.getNode(scanchainnets, chain2.getName());
        if (datachain == null) {
            MyTreeNode chip = chain2.getParent();
            datachain = (SubchainNode)MyTreeNode.getNode(scanchainnets, chip.getName() + "_" + chain2.getName());
        }
        if (datachain == null) {
            return NanosimJtag.getDataNetsOld(chain2, set);
        }
        ArrayList<SubchainNode.DataNet> datanets = new ArrayList<SubchainNode.DataNet>();
        for (int i = 0; i < datachain.getChildCount(); ++i) {
            SubchainNode subnode = (SubchainNode)datachain.getChildAt(i);
            if (set == 0) {
                datanets.add(subnode.getDataNet());
                continue;
            }
            datanets.add(subnode.getDataNet2());
        }
        return datanets;
    }

    protected static List getDataNetsOld(SubchainNode chain2, int set) {
        if (chain2.getChildCount() == 0) {
            ArrayList<SubchainNode.DataNet> list2 = new ArrayList<SubchainNode.DataNet>();
            SubchainNode.DataNet dataNet = set == 0 ? chain2.getDataNet() : chain2.getDataNet2();
            if (dataNet == null || dataNet.getName().equals("")) {
                for (int i = 0; i < chain2.getLength(); ++i) {
                    list2.add(null);
                }
                return list2;
            }
            MyTreeNode[] hier = chain2.getParent().getHierarchy();
            StringBuffer newPath = new StringBuffer();
            for (int j = 0; j < hier.length; ++j) {
                if (j < 3) continue;
                newPath.append("X" + hier[j].getName() + ".");
            }
            boolean fakeChain = false;
            if (chain2.getParentChain().getOpcode().equals("fakeChain")) {
                fakeChain = true;
            }
            Name netName = Name.findName(dataNet.getName());
            if (fakeChain) {
                for (int j = 0; j < netName.busWidth(); ++j) {
                    String net = netName.subname(j).toString();
                    SubchainNode.DataNet singleNet = new SubchainNode.DataNet(newPath.toString() + net, dataNet.isReadable(), dataNet.isWriteable(), dataNet.isInverted());
                    list2.add(singleNet);
                }
            } else {
                Name dataName = Name.findName(chain2.getName());
                for (int i = 0; i < dataName.busWidth(); ++i) {
                    netName = Name.findName(dataNet.getName());
                    for (int j = 0; j < netName.busWidth(); ++j) {
                        String net = "x" + dataName.subname(i).toString() + "." + netName.subname(j).toString();
                        SubchainNode.DataNet singleNet = new SubchainNode.DataNet(newPath.toString() + net, dataNet.isReadable(), dataNet.isWriteable(), dataNet.isInverted());
                        list2.add(singleNet);
                    }
                }
            }
            if (list2.size() != chain2.getLength()) {
                System.out.println("Error: data net list of size " + list2.size() + " does not match length of chain " + chain2.getName() + " of length " + chain2.getLength());
                list2.clear();
                for (int i = 0; i < chain2.getLength(); ++i) {
                    list2.add(null);
                }
                return list2;
            }
            return list2;
        }
        ArrayList list3 = new ArrayList();
        for (int i = 0; i < chain2.getChildCount(); ++i) {
            SubchainNode subnode = (SubchainNode)chain2.getChildAt(i);
            list3.addAll(NanosimJtag.getDataNets(subnode, set));
        }
        return list3;
    }

    protected boolean checkDataNets(ChainNode chain2, int set) {
        boolean foundDiscrepancy = false;
        List dataNets = NanosimJtag.getDataNets(chain2, set);
        for (int i = 0; i < dataNets.size(); ++i) {
            int setState;
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            if (dataNet == null || !dataNet.isWriteable()) continue;
            int simState = this.nm.getNodeState(dataNet.getName());
            int n = setState = chain2.getInBits().get(i) ? 1 : 0;
            if (dataNet.isInverted()) {
                int n2 = setState = setState == 1 ? 0 : 1;
            }
            if (simState == setState) continue;
            System.out.println("Error! Attempted to set bit '" + dataNet.getName() + "' to " + setState + " via the scan chain, but its state is " + simState);
            foundDiscrepancy = true;
        }
        return foundDiscrepancy;
    }

    protected BitVector readDirect(ChainNode chain2) {
        List dataNets = NanosimJtag.getDataNets(chain2, 0);
        List dataNets2 = NanosimJtag.getDataNets(chain2, 1);
        BitVector outBits = new BitVector(chain2.getOutBits().getNumBits(), "outBits");
        int bitsRead = 0;
        for (int i = 0; i < outBits.getNumBits(); ++i) {
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            SubchainNode.DataNet dataNet2 = (SubchainNode.DataNet)dataNets2.get(i);
            int state = this.readDirect(dataNet);
            int state2 = this.readDirect(dataNet2);
            if (state >= 0 && state2 >= 0 && state != state2) {
                System.out.println("Error! Inconsistency reading directly from scan chain data bit " + i + " of chain '" + chain2.getName() + "', " + dataNet.getName() + " is " + state + " and " + dataNet2.getName() + " is " + state2);
            }
            if (state < 0) {
                state = state2;
            }
            if (state < 0) {
                int n = state = chain2.getInBits().get(i) ? 1 : 0;
                if (state == -2) {
                    ++bitsRead;
                }
            } else {
                ++bitsRead;
            }
            outBits.set(i, state == 1);
        }
        if (this.printInfo) {
            System.out.println("Info: Read directly " + bitsRead + " bits from chain '" + chain2.getName() + "' of length " + chain2.getOutBits().getNumBits() + " bits (others unchanged).");
        }
        return outBits;
    }

    private int readDirect(SubchainNode.DataNet dataNet) {
        if (dataNet == null) {
            return -1;
        }
        if (!dataNet.isReadable()) {
            return -1;
        }
        int state = this.nm.getNodeState(dataNet.getName());
        if (state == -2) {
            System.out.println("Warning, read intermediate (undefined) voltage state from net " + dataNet.getName());
        }
        if (state < 0) {
            return state;
        }
        if (dataNet.isInverted()) {
            state = state == 1 ? 0 : 1;
        }
        return state;
    }

    protected void writeDirect(ChainNode chain2) {
        List dataNets = NanosimJtag.getDataNets(chain2, 0);
        List dataNets2 = NanosimJtag.getDataNets(chain2, 1);
        int dataNetsWritten = 0;
        int dataNet2sWritten = 0;
        for (int i = 0; i < chain2.getInBits().getNumBits(); ++i) {
            int state = chain2.getInBits().get(i) ? 1 : 0;
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            SubchainNode.DataNet dataNet2 = (SubchainNode.DataNet)dataNets2.get(i);
            if (this.writeDirect(dataNet, state)) {
                ++dataNetsWritten;
            }
            if (!this.writeDirect(dataNet2, state)) continue;
            ++dataNet2sWritten;
        }
        this.nm.waitNS(this.delay * 4.0);
        if (!chain2.getOpcode().equals("fakeChain")) {
            this.nm.releaseNodes(NanosimJtag.getNames(dataNets));
            this.nm.releaseNodes(NanosimJtag.getNames(dataNets2));
        }
        if (this.printInfo) {
            System.out.println("Info: Wrote directly " + dataNetsWritten + " bits and " + dataNet2sWritten + " secondary bits from scan chain '" + chain2.getName() + "' of length " + chain2.getInBits().getNumBits() + " bits.");
        }
    }

    private boolean writeDirect(SubchainNode.DataNet dataNet, int state) {
        if (dataNet == null) {
            return false;
        }
        if (!dataNet.isWriteable()) {
            return false;
        }
        int setState = state;
        if (dataNet.isInverted()) {
            state = state == 1 ? 0 : 1;
        }
        this.nm.setNodeState(dataNet.getName(), setState);
        return true;
    }

    private static List getNames(List dataNets) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < dataNets.size(); ++i) {
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            if (dataNet == null) continue;
            names.add(dataNet.getName());
        }
        return names;
    }
}

