/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.math.FixpTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class Geometry
extends Output {
    protected int numVisited;
    protected int numCells;
    protected Cell topCell;
    protected HashMap<Cell, CellGeom> cellGeoms;

    Geometry() {
    }

    @Override
    public boolean writeCell(Cell cell, VarContext context) {
        this.writeCell(cell, context, new Visitor(this, Geometry.getMaxHierDepth(cell)));
        return false;
    }

    public boolean writeCell(Cell cell, VarContext context, Visitor visitor) {
        this.numVisited = 0;
        this.numCells = HierarchyEnumerator.getNumUniqueChildCells(cell) + 1;
        this.topCell = cell;
        this.cellGeoms = new HashMap();
        this.start();
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
        this.done();
        return false;
    }

    protected abstract void start();

    protected abstract void done();

    protected abstract void writeCellGeom(CellGeom var1);

    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return false;
    }

    protected boolean includeGeometric() {
        return false;
    }

    public static int getMaxHierDepth(Cell cell) {
        return Geometry.hierCellsRecurse(cell, 0, 0);
    }

    private static int hierCellsRecurse(Cell cell, int depth, int maxDepth) {
        if (depth > maxDepth) {
            maxDepth = depth;
        }
        EDatabase database = cell.getDatabase();
        Iterator<CellUsage> uit = cell.getUsagesIn();
        while (uit.hasNext()) {
            CellUsage u = uit.next();
            Cell subCell = u.getProto(database);
            if (subCell.isIcon()) continue;
            maxDepth = Geometry.hierCellsRecurse(subCell, depth + 1, maxDepth);
        }
        return maxDepth;
    }

    public class Visitor
    extends HierarchyEnumerator.Visitor {
        private Geometry outGeom;
        protected CellGeom cellGeom = null;
        private CellGeom[] outGeomStack;
        private int maxHierDepth;
        private int curHierDepth;

        public Visitor(Geometry outGeom, int maxHierDepth) {
            this.outGeom = outGeom;
            this.maxHierDepth = maxHierDepth;
            this.outGeomStack = new CellGeom[maxHierDepth + 1];
            this.curHierDepth = 0;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.curHierDepth > this.maxHierDepth) {
                return false;
            }
            this.outGeomStack[this.curHierDepth] = this.cellGeom;
            Cell cell = info.getCell();
            if (Geometry.this.cellGeoms.containsKey(cell)) {
                return false;
            }
            this.cellGeom = new CellGeom(cell, this.outGeom);
            Geometry.this.cellGeoms.put(info.getCell(), this.cellGeom);
            ++this.curHierDepth;
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                this.addArcInst(ai);
            }
            boolean merge = this.outGeom.mergeGeom(this.maxHierDepth - this.curHierDepth);
            if (merge) {
                this.cellGeom.mergeCellGeom();
            }
            this.outGeom.writeCellGeom(this.cellGeom);
            --this.curHierDepth;
            this.cellGeom = this.outGeomStack[this.curHierDepth];
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (!no.isCellInstance()) {
                NodeInst ni = (NodeInst)no;
                if (ni.getProto() == Generic.tech().cellCenterNode) {
                    return false;
                }
                FixpTransform trans = ni.rotateOut();
                this.addNodeInst(ni, trans);
                return false;
            }
            this.cellGeom.nodables.add(no);
            return true;
        }

        public void addNodeInst(NodeInst ni, FixpTransform trans) {
            this.cellGeom.addNodeInst(ni, trans);
        }

        public void addArcInst(ArcInst ai) {
            this.cellGeom.addArcInst(ai);
        }
    }

    public static class CellGeom {
        protected HashMap<Layer, List<Object>> polyMap = new HashMap();
        protected List<Nodable> nodables = new ArrayList<Nodable>();
        protected Cell cell;
        protected boolean nonUniqueName;
        private Geometry geometry;

        protected CellGeom(Cell cell, Geometry geometry) {
            this.cell = cell;
            this.geometry = geometry;
            this.nonUniqueName = false;
            this.checkLayoutCell();
            this.determineUniqueness();
        }

        private void determineUniqueness() {
            Iterator<Library> lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library lib = lIt.next();
                if (lib.isHidden() || lib == this.cell.getLibrary()) continue;
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell oCell = cIt.next();
                    if (this.cell.getView() != oCell.getView() || !this.cell.getName().equalsIgnoreCase(oCell.getName())) continue;
                    this.nonUniqueName = true;
                    break;
                }
                if (!this.nonUniqueName) continue;
                break;
            }
        }

        private void checkLayoutCell() {
            PrimitiveNode universalPin = Generic.tech().universalPinNode;
            int numUniversalPins = 0;
            int numNodes = this.cell.getNumNodes();
            for (int i = 0; i < numNodes; ++i) {
                NodeInst ni = this.cell.getNode(i);
                NodeProto np = ni.getProto();
                if (np != universalPin) continue;
                ++numUniversalPins;
            }
            if (numUniversalPins > 0) {
                System.out.println("Geometry: Layout " + this.cell + " has " + numUniversalPins + " " + universalPin.describe(true) + " nodes");
            }
            ArcProto universalArc = Generic.tech().universal_arc;
            int numUniversalArcs = 0;
            ArcProto unroutedArc = Generic.tech().unrouted_arc;
            int numUnroutedArcs = 0;
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                ArcProto ap = ai.getProto();
                if (ap == universalArc) {
                    ++numUniversalArcs;
                }
                if (ap != unroutedArc) continue;
                ++numUnroutedArcs;
            }
            if (numUniversalArcs > 0) {
                System.out.println("Geometry: Layout " + this.cell + " has " + numUniversalArcs + " " + universalArc.describe() + " arcs");
            }
            if (numUnroutedArcs > 0) {
                System.out.println("Geometry: Layout " + this.cell + " has " + numUnroutedArcs + " " + unroutedArc.describe() + " arcs");
            }
        }

        public void addNodesAndArcs() {
            Iterator<Object> it = this.cell.getNodables();
            while (it.hasNext()) {
                Nodable no = it.next();
                if (!no.isCellInstance()) {
                    NodeInst ni = (NodeInst)no;
                    if (ni.getProto() == Generic.tech().cellCenterNode) continue;
                    FixpTransform trans = ni.rotateOut();
                    this.addNodeInst(ni, trans);
                    continue;
                }
                this.nodables.add(no);
            }
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                this.addArcInst(ai);
            }
        }

        public void addNodeInst(NodeInst ni, FixpTransform trans) {
            PrimitiveNode prim = (PrimitiveNode)ni.getProto();
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                polys[i].transform(trans);
            }
            this.addPolys(polys, ni);
        }

        public void addArcInst(ArcInst ai) {
            ArcProto ap = ai.getProto();
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            this.addPolys(polys, ai);
        }

        protected void addPolys(Poly[] polys, Geometric geom) {
            for (int i = 0; i < polys.length; ++i) {
                if (polys[i].isPseudoLayer()) continue;
                List<Object> list2 = this.polyMap.get(polys[i].getLayer());
                if (list2 == null) {
                    list2 = new ArrayList<Object>();
                    this.polyMap.put(polys[i].getLayer(), list2);
                }
                if (this.geometry != null && this.geometry.includeGeometric()) {
                    PolyWithGeom pg = new PolyWithGeom(polys[i], geom);
                    list2.add(pg);
                    continue;
                }
                list2.add(polys[i]);
            }
        }

        public void mergeCellGeom() {
            GeometryHandler gMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1000);
            Set<Layer> layers = this.polyMap.keySet();
            for (Layer layer : layers) {
                List<Object> polyList = this.polyMap.get(layer);
                for (Object polyObj : polyList) {
                    Poly poly = (Poly)polyObj;
                    gMerge.add(layer, poly);
                }
            }
            gMerge.postProcess(true);
            for (Layer layer : layers) {
                Collection<PolyBase> polysC = gMerge.getObjects(layer, false, false);
                ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
                for (PolyBase pb : polysC) {
                    polys.add(pb);
                }
                this.polyMap.put(layer, polys);
            }
        }
    }

    protected static class PolyWithGeom {
        Poly poly;
        Geometric geom;

        PolyWithGeom(Poly poly, Geometric geom) {
            this.poly = poly;
            this.geom = geom;
        }
    }
}

