/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.Version;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEditWizard.WideWizardField;
import com.sun.electric.tool.user.tecEditWizard.WizardField;
import com.sun.electric.tool.user.tecEditWizard.WizardRuleFields;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TechEditWizardData {
    private static final boolean POLY_CONTACT_SAME_AS_DIFF_CONTACT = false;
    private static int[] nullPattern = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private String tech_name;
    private String tech_description;
    private int num_metal_layers = 2;
    private int stepsize = 100;
    private double resolution;
    private boolean pSubstrateProcess = false;
    private boolean horizontalFlag = true;
    private int caseFlag = 0;
    private boolean analogElementsFlag = false;
    private boolean secondPolyFlag = false;
    private boolean shortNameFlag = false;
    private boolean defaultSquareContacts = false;
    private WizardField diff_width = new WizardField();
    private WizardField diff_poly_overhang = new WizardField();
    private WizardField diff_contact_overhang = new WizardField();
    private WizardField diff_contact_overhang_min_short = new WizardField();
    private WizardField diff_contact_overhang_min_long = new WizardField();
    private WizardField diff_spacing = new WizardField();
    private WizardField poly_width = new WizardField();
    private WizardField poly_endcap = new WizardField();
    private WizardField poly_spacing = new WizardField();
    private WizardField poly_diff_spacing = new WizardField();
    private WizardField poly_protection_spacing = new WizardField();
    private WizardField gate_length = new WizardField();
    private WizardField gate_width = new WizardField();
    private WizardField gate_spacing = new WizardField();
    private WizardField gate_contact_spacing = new WizardField();
    private WizardField gate_od18_length = new WizardField();
    private WizardField gate_od18_width = new WizardField();
    private WizardField[] od18_diff_overhang = new WizardField[]{new WizardField(), new WizardField()};
    private WizardField gate_nt_length = new WizardField();
    private WizardField gate_nt_width = new WizardField();
    private WizardField poly_nt_endcap = new WizardField();
    private WizardField nt_diff_overhang = new WizardField();
    private WizardField vthl_diff_overhang = new WizardField();
    private WizardField vthl_poly_overhang = new WizardField();
    private WizardField contact_size = new WizardField();
    private WizardField contact_spacing = new WizardField();
    private WizardField contact_array_spacing = new WizardField();
    private WizardField contact_metal_overhang_inline_only = new WizardField();
    private WizardField contact_metal_overhang_all_sides = new WizardField();
    private WizardField contact_poly_overhang = new WizardField();
    private WizardField polycon_diff_spacing = new WizardField();
    private WizardField nplus_width = new WizardField();
    private WizardField nplus_overhang_diff = new WizardField();
    private WizardField nplus_overhang_strap = new WizardField();
    private WizardField nplus_overhang_poly = new WizardField();
    private WizardField nplus_spacing = new WizardField();
    private WizardField pplus_width = new WizardField();
    private WizardField pplus_overhang_diff = new WizardField();
    private WizardField pplus_overhang_strap = new WizardField();
    private WizardField pplus_overhang_poly = new WizardField();
    private WizardField pplus_spacing = new WizardField();
    private WizardField nwell_width = new WizardField();
    private WizardField nwell_overhang_diff_p = new WizardField();
    private WizardField nwell_overhang_diff_n = new WizardField();
    private WizardField nwell_spacing = new WizardField();
    private WizardField[] metal_width;
    private WizardField[] metal_spacing;
    private WizardField[] metal_minarea;
    private WizardField[] metal_enclosedarea;
    private List<WideWizardField> wide_metal_spacing = new ArrayList<WideWizardField>();
    private WizardField[] via_size;
    private WizardField[] via_inline_spacing;
    private WizardField[] via_array_spacing;
    private WizardField[] via_overhang;
    private Map<String, List<Element>> metalContacts;
    private Map<String, List<Element>> otherContacts;
    private Map<String, List<Element>> otherTransistors;
    private Map<String, List<Element>> noMultiContacts;
    private Map<String, List<Element>> generalContacts;
    private Map<String, List<Element>> capacitors;
    private static Map<String, Xml.ArcProto> allArcs;
    private double poly_antenna_ratio;
    private double[] metal_antenna_ratio;
    private static ColorProperties fromColor;
    private LayerInfo diff_layer = new LayerInfo("Diff");
    private LayerInfo poly_layer = new LayerInfo("Poly");
    private LayerInfo poly2_layer = new LayerInfo("Polysilicon-2");
    private LayerInfo nplus_layer = new LayerInfo("NPlus");
    private LayerInfo pplus_layer = new LayerInfo("PPlus");
    private LayerInfo nwell_layer = new LayerInfo("N-Well");
    private LayerInfo contact_layer = new LayerInfo("Contact");
    private LayerInfo[] metal_layers;
    private LayerInfo[] via_layers;
    private LayerInfo marking_layer = new LayerInfo("DeviceMark", 100);
    private List<LayerInfo> extraLayers;
    private List<LayerInfo> textLayers;
    private static List<WizardField> extraVariables;
    private static List<WizardRuleFields> extraDoubleFields;
    private static final PrimitiveNodeGroupSort primitiveNodeGroupSort;
    private static final NodeLayerSort nodeLayerSort;

    LayerInfo[] getBasicLayers() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        layers.add(this.diff_layer);
        layers.add(this.poly_layer);
        layers.addAll(this.extraLayers);
        layers.addAll(this.textLayers);
        layers.add(this.nplus_layer);
        layers.add(this.pplus_layer);
        layers.add(this.nwell_layer);
        layers.add(this.contact_layer);
        layers.add(this.marking_layer);
        LayerInfo[] array = new LayerInfo[layers.size()];
        layers.toArray(array);
        return array;
    }

    public TechEditWizardData() {
        this.allocateVariables();
    }

    public void allocateVariables() {
        int i;
        if (fromColor == null) {
            fromColor = new ColorProperties(Color.class);
        }
        this.metal_width = new WizardField[this.num_metal_layers];
        this.metal_spacing = new WizardField[this.num_metal_layers];
        this.metal_minarea = new WizardField[this.num_metal_layers];
        this.metal_enclosedarea = new WizardField[this.num_metal_layers];
        this.via_size = new WizardField[this.num_metal_layers - 1];
        this.via_inline_spacing = new WizardField[this.num_metal_layers - 1];
        this.via_array_spacing = new WizardField[this.num_metal_layers - 1];
        this.via_overhang = new WizardField[this.num_metal_layers - 1];
        this.metal_antenna_ratio = new double[this.num_metal_layers];
        this.metal_layers = new LayerInfo[this.num_metal_layers];
        this.via_layers = new LayerInfo[this.num_metal_layers - 1];
        for (i = 0; i < this.num_metal_layers; ++i) {
            this.metal_width[i] = new WizardField();
            this.metal_spacing[i] = new WizardField();
            this.metal_minarea[i] = new WizardField();
            this.metal_enclosedarea[i] = new WizardField();
            this.metal_layers[i] = new LayerInfo(this.getMetalName() + (i + 1));
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            this.via_size[i] = new WizardField();
            this.via_inline_spacing[i] = new WizardField();
            this.via_array_spacing[i] = new WizardField();
            this.via_overhang[i] = new WizardField();
            this.via_layers[i] = new LayerInfo(this.getViaName() + (i + 1));
        }
        this.extraLayers = new ArrayList<LayerInfo>();
        this.textLayers = new ArrayList<LayerInfo>();
        this.metalContacts = new HashMap<String, List<Element>>();
        this.otherContacts = new HashMap<String, List<Element>>();
        this.otherTransistors = new HashMap<String, List<Element>>();
        this.noMultiContacts = new HashMap<String, List<Element>>();
        this.generalContacts = new HashMap<String, List<Element>>();
        this.capacitors = new HashMap<String, List<Element>>();
        allArcs = new HashMap<String, Xml.ArcProto>();
    }

    public void addExtraLayer(LayerInfo l, boolean isText) {
        if (isText) {
            this.textLayers.add(l);
        } else {
            this.extraLayers.add(l);
        }
    }

    public void addContact(Element con, String lay1, String lay2, boolean isMetal) {
        this.addItemToElementMap(con, lay1, lay2, isMetal ? this.metalContacts : this.noMultiContacts);
    }

    String getTechName() {
        return this.tech_name;
    }

    public void setTechName(String s) {
        this.tech_name = TechEditWizardData.stripQuotes(s);
    }

    String getTechDescription() {
        return this.tech_description;
    }

    public void setTechDescription(String s) {
        this.tech_description = TechEditWizardData.stripQuotes(s);
    }

    int getStepSize() {
        return this.stepsize;
    }

    public void setStepSize(int n) {
        this.stepsize = n;
    }

    double getResolution() {
        return this.resolution;
    }

    public void setResolution(double n) {
        this.resolution = n;
    }

    int getNumMetalLayers() {
        return this.num_metal_layers;
    }

    public void setNumMetalLayers(int n) {
        int i;
        int i2;
        int i3;
        int i4;
        if (n < 1) {
            System.out.println("Setting zero as number of metal layers");
            this.num_metal_layers = 0;
            return;
        }
        int smallest = Math.min(n, this.num_metal_layers);
        WizardField[] new_metal_width = new WizardField[n];
        WizardField[] new_metal_spacing = new WizardField[n];
        WizardField[] new_metal_minarea = new WizardField[n];
        WizardField[] new_metal_enclosedarea = new WizardField[n];
        double[] new_metal_antenna_ratio = new double[n];
        for (i4 = 0; i4 < smallest; ++i4) {
            new_metal_width[i4] = this.metal_width[i4];
            new_metal_spacing[i4] = this.metal_spacing[i4];
            new_metal_minarea[i4] = this.metal_minarea[i4];
            new_metal_enclosedarea[i4] = this.metal_enclosedarea[i4];
            new_metal_antenna_ratio[i4] = this.metal_antenna_ratio[i4];
        }
        for (i4 = smallest; i4 < n; ++i4) {
            new_metal_width[i4] = new WizardField();
            new_metal_spacing[i4] = new WizardField();
            new_metal_minarea[i4] = new WizardField();
            new_metal_enclosedarea[i4] = new WizardField();
        }
        this.metal_width = new_metal_width;
        this.metal_spacing = new_metal_spacing;
        this.metal_minarea = new_metal_minarea;
        this.metal_enclosedarea = new_metal_enclosedarea;
        this.metal_antenna_ratio = new_metal_antenna_ratio;
        WizardField[] new_via_size = new WizardField[n - 1];
        WizardField[] new_via_spacing = new WizardField[n - 1];
        WizardField[] new_via_array_spacing = new WizardField[n - 1];
        WizardField[] new_via_overhang_inline = new WizardField[n - 1];
        for (i3 = 0; i3 < smallest - 1; ++i3) {
            new_via_size[i3] = this.via_size[i3];
            new_via_spacing[i3] = this.via_inline_spacing[i3];
            new_via_array_spacing[i3] = this.via_array_spacing[i3];
            new_via_overhang_inline[i3] = this.via_overhang[i3];
        }
        for (i3 = smallest - 1; i3 < n - 1; ++i3) {
            new_via_size[i3] = new WizardField();
            new_via_spacing[i3] = new WizardField();
            new_via_array_spacing[i3] = new WizardField();
            new_via_overhang_inline[i3] = new WizardField();
        }
        this.via_size = new_via_size;
        this.via_inline_spacing = new_via_spacing;
        this.via_array_spacing = new_via_array_spacing;
        this.via_overhang = new_via_overhang_inline;
        LayerInfo[] new_gds_metal_layer = new LayerInfo[n];
        for (i2 = 0; i2 < smallest; ++i2) {
            new_gds_metal_layer[i2] = this.metal_layers[i2];
        }
        for (i2 = smallest - 1; i2 < n; ++i2) {
            new_gds_metal_layer[i2] = new LayerInfo(this.getMetalName() + (i2 + 1));
        }
        this.metal_layers = new_gds_metal_layer;
        LayerInfo[] new_gds_via_layer = new LayerInfo[n - 1];
        for (i = 0; i < smallest - 1; ++i) {
            new_gds_via_layer[i] = this.via_layers[i];
        }
        for (i = smallest - 1; i < n - 1; ++i) {
            new_gds_via_layer[i] = new LayerInfo(this.getViaName() + (i + 1));
        }
        this.via_layers = new_gds_via_layer;
        this.num_metal_layers = n;
    }

    boolean getPSubstratelProcess() {
        return this.pSubstrateProcess;
    }

    void setPSubstratelProcess(boolean b) {
        this.pSubstrateProcess = b;
    }

    boolean getHorizontalTransistors() {
        return this.horizontalFlag;
    }

    void setHorizontalTransistors(boolean b) {
        this.horizontalFlag = b;
    }

    private boolean isComplexCase() {
        return this.withExtraDummyLayers() || this.withExtraTransistors();
    }

    private boolean withExtraDummyLayers() {
        return this.caseFlag >= 1;
    }

    private boolean withExtraTransistors() {
        return this.caseFlag > 1;
    }

    private boolean withDefaultSquareMetals() {
        return this.defaultSquareContacts;
    }

    private boolean isBasicCase() {
        return this.caseFlag == -1;
    }

    public void setCaseFlag(int b) {
        assert (b > -2 && b < 3);
        this.caseFlag = b;
    }

    private void setShortNameFlag(boolean b) {
        this.shortNameFlag = b;
    }

    private void setDefaultSquareContactsFlag(boolean b) {
        this.defaultSquareContacts = b;
    }

    private String getMetalName() {
        return this.shortNameFlag ? "M" : "Metal-";
    }

    private String getViaName() {
        return this.shortNameFlag ? "VIA" : "Via-";
    }

    private String getDName() {
        return this.shortNameFlag ? "D" : "DMY-";
    }

    private String getExclName(String s) {
        return this.shortNameFlag ? "D" + s + "EXCL" : "DEXCL-" + s;
    }

    private boolean getAnalogFlag() {
        return this.analogElementsFlag;
    }

    private void setAnalogFlag(boolean b) {
        this.analogElementsFlag = b;
    }

    private boolean getSecondPolyFlag() {
        return this.secondPolyFlag;
    }

    private void setSecondPolyFlag(boolean b) {
        this.secondPolyFlag = b;
    }

    WizardField getDiffWidth() {
        return this.diff_width;
    }

    void setDiffWidth(WizardField v) {
        this.diff_width = v;
    }

    WizardField getDiffPolyOverhang() {
        return this.diff_poly_overhang;
    }

    void setDiffPolyOverhang(WizardField v) {
        this.diff_poly_overhang = v;
    }

    WizardField getDiffContactOverhang() {
        return this.diff_contact_overhang;
    }

    void setDiffContactOverhang(WizardField v) {
        this.diff_contact_overhang = v;
    }

    WizardField getDiffSpacing() {
        return this.diff_spacing;
    }

    void setDiffSpacing(WizardField v) {
        this.diff_spacing = v;
    }

    WizardField getPolyWidth() {
        return this.poly_width;
    }

    void setPolyWidth(WizardField v) {
        this.poly_width = v;
    }

    WizardField getPolyEndcap() {
        return this.poly_endcap;
    }

    void setPolyEndcap(WizardField v) {
        this.poly_endcap = v;
    }

    WizardField getPolySpacing() {
        return this.poly_spacing;
    }

    void setPolySpacing(WizardField v) {
        this.poly_spacing = v;
    }

    WizardField getPolyDiffSpacing() {
        return this.poly_diff_spacing;
    }

    void setPolyDiffSpacing(WizardField v) {
        this.poly_diff_spacing = v;
    }

    WizardField getPolyProtectionSpacing() {
        return this.poly_protection_spacing;
    }

    void setPolyProtectionSpacing(WizardField v) {
        this.poly_protection_spacing = v;
    }

    WizardField getGateLength() {
        return this.gate_length;
    }

    void setGateLength(WizardField v) {
        this.gate_length = v;
    }

    WizardField getGateWidth() {
        return this.gate_width;
    }

    void setGateWidth(WizardField v) {
        this.gate_width = v;
    }

    WizardField getGateSpacing() {
        return this.gate_spacing;
    }

    void setGateSpacing(WizardField v) {
        this.gate_spacing = v;
    }

    WizardField getGateContactSpacing() {
        return this.gate_contact_spacing;
    }

    void setGateContactSpacing(WizardField v) {
        this.gate_contact_spacing = v;
    }

    WizardField getContactSize() {
        return this.contact_size;
    }

    void setContactSize(WizardField v) {
        this.contact_size = v;
    }

    WizardField getContactSpacing() {
        return this.contact_spacing;
    }

    void setContactSpacing(WizardField v) {
        this.contact_spacing = v;
    }

    WizardField getContactArraySpacing() {
        return this.contact_array_spacing;
    }

    void setContactArraySpacing(WizardField v) {
        this.contact_array_spacing = v;
    }

    WizardField getContactMetalOverhangInlineOnly() {
        return this.contact_metal_overhang_inline_only;
    }

    void setContactMetalOverhangInlineOnly(WizardField v) {
        this.contact_metal_overhang_inline_only = v;
    }

    WizardField getContactMetalOverhangAllSides() {
        return this.contact_metal_overhang_all_sides;
    }

    void setContactMetalOverhangAllSides(WizardField v) {
        this.contact_metal_overhang_all_sides = v;
    }

    WizardField getContactPolyOverhang() {
        return this.contact_poly_overhang;
    }

    void setContactPolyOverhang(WizardField v) {
        this.contact_poly_overhang = v;
    }

    WizardField getPolyconDiffSpacing() {
        return this.polycon_diff_spacing;
    }

    void setPolyconDiffSpacing(WizardField v) {
        this.polycon_diff_spacing = v;
    }

    WizardField getNPlusWidth() {
        return this.nplus_width;
    }

    void setNPlusWidth(WizardField v) {
        this.nplus_width = v;
    }

    WizardField getNPlusOverhangDiff() {
        return this.nplus_overhang_diff;
    }

    void setNPlusOverhangDiff(WizardField v) {
        this.nplus_overhang_diff = v;
    }

    WizardField getNPlusOverhangStrap() {
        return this.nplus_overhang_strap;
    }

    void setNPlusOverhangStrap(WizardField v) {
        this.nplus_overhang_strap = v;
    }

    WizardField getNPlusOverhangPoly() {
        return this.nplus_overhang_poly;
    }

    void setNPlusOverhangPoly(WizardField v) {
        this.nplus_overhang_poly = v;
    }

    WizardField getNPlusSpacing() {
        return this.nplus_spacing;
    }

    void setNPlusSpacing(WizardField v) {
        this.nplus_spacing = v;
    }

    WizardField getPPlusWidth() {
        return this.pplus_width;
    }

    void setPPlusWidth(WizardField v) {
        this.pplus_width = v;
    }

    WizardField getPPlusOverhangDiff() {
        return this.pplus_overhang_diff;
    }

    void setPPlusOverhangDiff(WizardField v) {
        this.pplus_overhang_diff = v;
    }

    WizardField getPPlusOverhangStrap() {
        return this.pplus_overhang_strap;
    }

    void setPPlusOverhangStrap(WizardField v) {
        this.pplus_overhang_strap = v;
    }

    WizardField getPPlusOverhangPoly() {
        return this.pplus_overhang_poly;
    }

    void setPPlusOverhangPoly(WizardField v) {
        this.pplus_overhang_poly = v;
    }

    WizardField getPPlusSpacing() {
        return this.pplus_spacing;
    }

    void setPPlusSpacing(WizardField v) {
        this.pplus_spacing = v;
    }

    WizardField getNWellWidth() {
        return this.nwell_width;
    }

    void setNWellWidth(WizardField v) {
        this.nwell_width = v;
    }

    WizardField getNWellOverhangDiffP() {
        return this.nwell_overhang_diff_p;
    }

    void setNWellOverhangDiffP(WizardField v) {
        this.nwell_overhang_diff_p = v;
    }

    WizardField getNWellOverhangDiffN() {
        return this.nwell_overhang_diff_n;
    }

    void setNWellOverhangDiffN(WizardField v) {
        this.nwell_overhang_diff_n = v;
    }

    WizardField getNWellSpacing() {
        return this.nwell_spacing;
    }

    void setNWellSpacing(WizardField v) {
        this.nwell_spacing = v;
    }

    WizardField[] getMetalWidth() {
        return this.metal_width;
    }

    void setMetalWidth(int met, WizardField value2) {
        this.metal_width[met] = value2;
    }

    WizardField[] getMetalSpacing() {
        return this.metal_spacing;
    }

    void setMetalSpacing(int met, WizardField value2) {
        this.metal_spacing[met] = value2;
    }

    WizardField[] getViaSize() {
        return this.via_size;
    }

    void setViaSize(int via, WizardField value2) {
        this.via_size[via] = value2;
    }

    WizardField[] getViaSpacing() {
        return this.via_inline_spacing;
    }

    void setViaSpacing(int via, WizardField value2) {
        this.via_inline_spacing[via] = value2;
    }

    WizardField[] getViaArraySpacing() {
        return this.via_array_spacing;
    }

    void setViaArraySpacing(int via, WizardField value2) {
        this.via_array_spacing[via] = value2;
    }

    WizardField[] getViaOverhangInline() {
        return this.via_overhang;
    }

    void setViaOverhangInline(int via, WizardField value2) {
        this.via_overhang[via] = value2;
    }

    public double getPolyAntennaRatio() {
        return this.poly_antenna_ratio;
    }

    void setPolyAntennaRatio(double v) {
        this.poly_antenna_ratio = v;
    }

    public double[] getMetalAntennaRatio() {
        return this.metal_antenna_ratio;
    }

    void setMetalAntennaRatio(int met, double value2) {
        this.metal_antenna_ratio[met] = value2;
    }

    public static int[] getGDSValuesFromString(String s) {
        int[] vals = new int[6];
        StringTokenizer parse = new StringTokenizer(s, ",", false);
        while (parse.hasMoreTokens()) {
            String v = parse.nextToken();
            int pos = 0;
            int index = v.indexOf("/");
            if (v.contains("p")) {
                pos = 2;
            } else if (v.contains("t")) {
                pos = 4;
            }
            if (index != -1) {
                vals[pos] = TextUtils.atoi(v.substring(0, index));
                vals[pos + 1] = TextUtils.atoi(v.substring(index + 1));
                continue;
            }
            vals[pos] = TextUtils.atoi(v);
        }
        return vals;
    }

    LayerInfo[] getGDSMetal() {
        return this.metal_layers;
    }

    LayerInfo[] getGDSVia() {
        return this.via_layers;
    }

    private String errorInData() {
        int i;
        if (this.tech_name == null || this.tech_name.length() == 0) {
            return "General panel: No technology name";
        }
        if (this.stepsize == 0) {
            return "General panel: Invalid unit size";
        }
        if (!this.isBasicCase()) {
            if (this.diff_width.value == 0.0) {
                return "Active panel: Invalid width";
            }
            if (this.poly_width.value == 0.0) {
                return "Poly panel: Invalid width";
            }
            if (this.gate_width.value == 0.0) {
                return "Gate panel: Invalid width";
            }
            if (this.gate_length.value == 0.0) {
                return "Gate panel: Invalid length";
            }
            if (this.contact_size.value == 0.0) {
                return "Contact panel: Invalid size";
            }
            if (this.nplus_width.value == 0.0) {
                return "Well/Implant panel: Invalid NPlus width";
            }
            if (this.pplus_width.value == 0.0) {
                return "Well/Implant panel: Invalid PPlus width";
            }
            if (this.nwell_width.value == 0.0) {
                return "Well/Implant panel: Invalid NWell width";
            }
        }
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (this.metal_width[i].value != 0.0) continue;
            return "Metal panel: Invalid " + this.getMetalName() + (i + 1) + " width";
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (this.via_size[i].value != 0.0) continue;
            return "Via panel: Invalid " + this.getViaName() + (i + 1) + " size";
        }
        return null;
    }

    public boolean importDataFromWizardFormat() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, "Technology Wizard File");
        if (fileName == null) {
            return false;
        }
        return this.importDataFromWizardFormat(fileName);
    }

    public boolean parseParameter(String buf, LineNumberReader lineReader, boolean semiColonCheck, String[] values2) {
        String varValue;
        int spacePos = buf.indexOf(32);
        int equalsPos = buf.indexOf(61);
        if (equalsPos < 0) {
            Job.getUserInterface().showErrorMessage("Missing '=' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
            return false;
        }
        spacePos = spacePos < 0 ? equalsPos : Math.min(spacePos, equalsPos);
        String varName = buf.substring(0, spacePos);
        ++equalsPos;
        if (semiColonCheck) {
            int semiPos = buf.indexOf(59);
            if (semiColonCheck && semiPos < 0) {
                Job.getUserInterface().showErrorMessage("Missing ';' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                return false;
            }
            while (equalsPos < semiPos && buf.charAt(equalsPos) == ' ') {
                ++equalsPos;
            }
            varValue = buf.substring(equalsPos, semiPos);
        } else {
            varValue = buf.substring(equalsPos).trim();
        }
        boolean valid = true;
        if (varValue.indexOf("(") != -1 && varValue.indexOf(")") == -1) {
            valid = this.readUntilKeyfound(")", lineReader);
        }
        values2[0] = varName.toUpperCase();
        values2[1] = TechEditWizardData.stripQuotes(varValue.toUpperCase());
        return valid;
    }

    public boolean readUntilKeyfound(String key, LineNumberReader lineReader) {
        boolean found = false;
        try {
            while (!found) {
                String buf = lineReader.readLine();
                found = buf.indexOf(key) != -1;
            }
        }
        catch (IOException e) {
            System.out.println("Error while looking for '" + key + "'");
        }
        return found;
    }

    public boolean importDataFromWizardFormat(String fileName) {
        URL url = TextUtils.makeURLToFile(fileName);
        this.allocateVariables();
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            boolean validFile = false;
            while ((buf = lineReader.readLine()) != null) {
                if ((buf = buf.trim()).length() == 0 || buf.startsWith("#") || !buf.startsWith("$") && !buf.startsWith("@")) continue;
                validFile = true;
                int spacePos = buf.indexOf(32);
                int equalsPos = buf.indexOf(61);
                if (equalsPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing '=' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    validFile = false;
                    break;
                }
                spacePos = spacePos < 0 ? equalsPos : Math.min(spacePos, equalsPos);
                String varName = buf.substring(1, spacePos);
                boolean single = buf.startsWith("$");
                int semiPos = buf.indexOf(59);
                if (semiPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing ';' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    validFile = false;
                    break;
                }
                ++equalsPos;
                while (equalsPos < semiPos && buf.charAt(equalsPos) == ' ') {
                    ++equalsPos;
                }
                String varValue = buf.substring(equalsPos, semiPos);
                if (varName.equalsIgnoreCase("tech_libname")) continue;
                if (varName.equalsIgnoreCase("tech_name")) {
                    this.setTechName(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("tech_description")) {
                    this.setTechDescription(TechEditWizardData.stripQuotes(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("num_metal_layers")) {
                    this.setNumMetalLayers(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("psubstrate_process")) {
                    this.setPSubstratelProcess(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("horizontal_transistors")) {
                    this.setHorizontalTransistors(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("extra_info")) {
                    this.setCaseFlag(Integer.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("shortnames")) {
                    this.setShortNameFlag(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("defaultsquarecontacts")) {
                    this.setDefaultSquareContactsFlag(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("stepsize")) {
                    this.setStepSize(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("resolution")) {
                    this.setResolution(TextUtils.atof(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("analog_elements")) {
                    this.setAnalogFlag(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("second_poly")) {
                    this.setSecondPolyFlag(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width")) {
                    this.diff_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width_rule")) {
                    this.diff_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang")) {
                    this.diff_poly_overhang.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang_rule")) {
                    this.diff_poly_overhang.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang")) {
                    this.diff_contact_overhang.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_rule")) {
                    this.diff_contact_overhang.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_short_min")) {
                    this.diff_contact_overhang_min_short.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_short_min_rule")) {
                    this.diff_contact_overhang_min_short.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_long_min")) {
                    this.diff_contact_overhang_min_long.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_long_min_rule")) {
                    this.diff_contact_overhang_min_long.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing")) {
                    this.diff_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing_rule")) {
                    this.diff_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width")) {
                    this.poly_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width_rule")) {
                    this.poly_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap")) {
                    this.poly_endcap.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap_rule")) {
                    this.poly_endcap.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing")) {
                    this.poly_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing_rule")) {
                    this.poly_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing")) {
                    this.poly_diff_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing_rule")) {
                    this.poly_diff_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_protection_spacing")) {
                    this.poly_protection_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_protection_spacing_rule")) {
                    this.poly_protection_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length")) {
                    this.gate_length.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length_rule")) {
                    this.gate_length.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width")) {
                    this.gate_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width_rule")) {
                    this.gate_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing")) {
                    this.gate_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing_rule")) {
                    this.gate_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing")) {
                    this.gate_contact_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing_rule")) {
                    this.gate_contact_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_od18_length")) {
                    TechEditWizardData.fillRule(varValue, this.gate_od18_length);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_od18_width")) {
                    TechEditWizardData.fillRule(varValue, this.gate_od18_width);
                    continue;
                }
                if (varName.equalsIgnoreCase("od18_diff_overhang")) {
                    TechEditWizardData.fillRule(varValue, this.od18_diff_overhang);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_nt_length")) {
                    TechEditWizardData.fillRule(varValue, this.gate_nt_length);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_nt_width")) {
                    TechEditWizardData.fillRule(varValue, this.gate_nt_width);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_nt_endcap")) {
                    TechEditWizardData.fillRule(varValue, this.poly_nt_endcap);
                    continue;
                }
                if (varName.equalsIgnoreCase("nt_diff_overhang")) {
                    TechEditWizardData.fillRule(varValue, this.nt_diff_overhang);
                    continue;
                }
                if (varName.equalsIgnoreCase("vthl_diff_overhang")) {
                    TechEditWizardData.fillRule(varValue, this.vthl_diff_overhang);
                    continue;
                }
                if (varName.equalsIgnoreCase("vthl_poly_overhang")) {
                    TechEditWizardData.fillRule(varValue, this.vthl_poly_overhang);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size")) {
                    this.contact_size.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size_rule")) {
                    this.contact_size.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing")) {
                    this.contact_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing_rule")) {
                    this.contact_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing")) {
                    this.contact_array_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing_rule")) {
                    this.contact_array_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only")) {
                    this.contact_metal_overhang_inline_only.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only_rule")) {
                    this.contact_metal_overhang_inline_only.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides")) {
                    this.contact_metal_overhang_all_sides.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides_rule")) {
                    this.contact_metal_overhang_all_sides.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang")) {
                    this.contact_poly_overhang.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang_rule")) {
                    this.contact_poly_overhang.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing")) {
                    this.polycon_diff_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing_rule")) {
                    this.polycon_diff_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width")) {
                    this.nplus_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width_rule")) {
                    this.nplus_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff")) {
                    this.nplus_overhang_diff.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff_rule")) {
                    this.nplus_overhang_diff.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_strap")) {
                    this.nplus_overhang_strap.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_strap_rule")) {
                    this.nplus_overhang_strap.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly")) {
                    this.nplus_overhang_poly.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly_rule")) {
                    this.nplus_overhang_poly.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing")) {
                    this.nplus_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing_rule")) {
                    this.nplus_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width")) {
                    this.pplus_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width_rule")) {
                    this.pplus_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff")) {
                    this.pplus_overhang_diff.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff_rule")) {
                    this.pplus_overhang_diff.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_strap")) {
                    this.pplus_overhang_strap.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_strap_rule")) {
                    this.pplus_overhang_strap.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly")) {
                    this.pplus_overhang_poly.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly_rule")) {
                    this.pplus_overhang_poly.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing")) {
                    this.pplus_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing_rule")) {
                    this.pplus_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width")) {
                    this.nwell_width.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width_rule")) {
                    this.nwell_width.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_p")) {
                    this.nwell_overhang_diff_p.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_p")) {
                    this.nwell_overhang_diff_p.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_n")) {
                    this.nwell_overhang_diff_n.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_n")) {
                    this.nwell_overhang_diff_n.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing")) {
                    this.nwell_spacing.value = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing_rule")) {
                    this.nwell_spacing.rule = TechEditWizardData.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width")) {
                    this.fillWizardArray(varValue, this.metal_width, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width_rule")) {
                    this.fillWizardArray(varValue, this.metal_width, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing")) {
                    this.fillWizardArray(varValue, this.metal_spacing, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing_rule")) {
                    this.fillWizardArray(varValue, this.metal_spacing, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("wide_metal_spacing_rules")) {
                    this.fillWizardWideArray(varValue, this.wide_metal_spacing);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_minarea_rules")) {
                    this.fillRulesSeries(varValue, this.metal_minarea);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_enclosed_area_rules")) {
                    this.fillRulesSeries(varValue, this.metal_enclosedarea);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size")) {
                    this.fillWizardArray(varValue, this.via_size, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size_rule")) {
                    this.fillWizardArray(varValue, this.via_size, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing")) {
                    this.fillWizardArray(varValue, this.via_inline_spacing, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_inline_spacing, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline")) {
                    this.fillWizardArray(varValue, this.via_overhang, lineReader.getLineNumber(), false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline_rule")) {
                    this.fillWizardArray(varValue, this.via_overhang, lineReader.getLineNumber(), true);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_contacts_series")) {
                    this.fillSeries(varValue, this.metalContacts, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("contacts_series")) {
                    this.fillSeries(varValue, this.otherContacts, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("transistors_series")) {
                    this.fillSeries(varValue, this.otherTransistors, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("capacitors_series")) {
                    this.fillSeries(varValue, this.capacitors, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("nomulti_contacts_series")) {
                    this.fillSeries(varValue, this.noMultiContacts, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("general_contacts_series")) {
                    this.fillPolygonalContactSeries(varValue, this.generalContacts);
                    continue;
                }
                if (varName.toLowerCase().startsWith("extra_layer")) {
                    this.fillLayerSeries(varValue, this.extraLayers);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_antenna_ratio")) {
                    this.setPolyAntennaRatio(TextUtils.atof(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_antenna_ratio")) {
                    this.metal_antenna_ratio = this.makeDoubleArray(varValue, lineReader.getLineNumber());
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_diff_layer")) {
                    this.diff_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_poly_layer")) {
                    this.poly_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nplus_layer")) {
                    this.nplus_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_pplus_layer")) {
                    this.pplus_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nwell_layer")) {
                    this.nwell_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_contact_layer")) {
                    this.contact_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_metal_layer")) {
                    this.metal_layers = this.setGDSDataArray(varValue, this.num_metal_layers, this.getMetalName());
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_via_layer")) {
                    this.via_layers = this.setGDSDataArray(varValue, this.num_metal_layers - 1, this.getViaName());
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_marking_layer")) {
                    this.marking_layer.setGDSData(TechEditWizardData.getGDSValuesFromString(varValue));
                    continue;
                }
                Object obj = null;
                if (single) {
                    WizardField wf = this.findWizardField(varName);
                    if (wf != null) {
                        TechEditWizardData.fillRule(varValue, wf);
                    }
                    obj = wf;
                } else {
                    WizardRuleFields wfs = this.findWizardRuleFields(varName);
                    if (wfs != null) {
                        TechEditWizardData.fillRules(varValue, wfs);
                    }
                    obj = wfs;
                }
                if (obj != null) continue;
                Job.getUserInterface().showErrorMessage("Unknown keyword '" + varName + "' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                validFile = false;
                break;
            }
            if (!validFile) {
                Job.getUserInterface().showErrorMessage("'" + fileName + "' is not a valid Parameters file. Check content.", "Syntax Error In Technology File");
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
        return true;
    }

    private WizardField findWizardField(String varName) {
        for (WizardField wf : extraVariables) {
            if (!wf.name.equals(varName)) continue;
            return wf;
        }
        WizardField w = new WizardField(varName);
        extraVariables.add(w);
        return w;
    }

    private WizardRuleFields findWizardRuleFields(String varName) {
        for (WizardRuleFields wf : extraDoubleFields) {
            if (!wf.name.equals(varName)) continue;
            return wf;
        }
        WizardRuleFields w = new WizardRuleFields(varName);
        extraDoubleFields.add(w);
        return w;
    }

    private static String stripQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private LayerInfo[] setGDSDataArray(String str, int len, String extra) {
        LayerInfo[] foundArray = new LayerInfo[len];
        for (int i = 0; i < len; ++i) {
            foundArray[i] = new LayerInfo(extra + (i + 1));
        }
        StringTokenizer parse = new StringTokenizer(str, "( \")", false);
        int count2 = 0;
        while (parse.hasMoreTokens()) {
            if (count2 >= len) {
                System.out.println("More GDS values than metal layers in TechEditWizardData");
                break;
            }
            String value2 = parse.nextToken();
            if (value2.equals(",")) continue;
            foundArray[count2++].setGDSData(TechEditWizardData.getGDSValuesFromString(value2));
        }
        return foundArray;
    }

    private double[] makeDoubleArray(String str, int lineNumber) {
        WizardField[] foundArray = new WizardField[this.num_metal_layers];
        for (int i = 0; i < this.num_metal_layers; ++i) {
            foundArray[i] = new WizardField();
        }
        this.fillWizardArray(str, foundArray, lineNumber, false);
        double[] retArray = new double[foundArray.length];
        for (int i = 0; i < foundArray.length; ++i) {
            retArray[i] = foundArray[i].value;
        }
        return retArray;
    }

    private void fillWizardWideArray(String str, List<WideWizardField> wideList) {
        StringTokenizer parse = new StringTokenizer(str, "[]", false);
        int blocks = 0;
        WideWizardField tmp = new WideWizardField();
        while (parse.hasMoreTokens()) {
            StringTokenizer p;
            String value2 = parse.nextToken();
            if (value2.equals(";")) continue;
            if (blocks == 0) {
                p = new StringTokenizer(value2, ", ", false);
                int count2 = 0;
                while (p.hasMoreTokens()) {
                    String v = p.nextToken();
                    switch (count2) {
                        case 0: {
                            tmp.value = Double.parseDouble(v);
                            break;
                        }
                        case 1: {
                            tmp.maxW = Double.parseDouble(v);
                            break;
                        }
                        case 2: {
                            tmp.minLen = Double.parseDouble(v);
                            break;
                        }
                        case 3: {
                            tmp.rule = TechEditWizardData.stripQuotes(v);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ++count2;
                }
                ++blocks;
                continue;
            }
            p = new StringTokenizer(value2, ",", false);
            while (p.hasMoreTokens()) {
                String s = p.nextToken();
                tmp.names.add(s);
            }
        }
        wideList.add(tmp);
    }

    private void fillWizardArray(String str, WizardField[] fieldArray, int lineNumber, boolean getRule) {
        if (!str.startsWith("(")) {
            Job.getUserInterface().showErrorMessage("Array does not start with '(' on '" + str + "', line:" + lineNumber, "Syntax Error In Technology File");
            return;
        }
        StringTokenizer parse = new StringTokenizer(str, "(),\"", false);
        int index = 0;
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken().trim();
            if (value2.equals("")) continue;
            if (index >= fieldArray.length) {
                Job.getUserInterface().showErrorMessage("Out of bound index in array while parsing '" + str + "', line:" + lineNumber, "Syntax Error In Technology File");
                return;
            }
            if (getRule) {
                fieldArray[index++].rule = value2;
                continue;
            }
            double v = TextUtils.atof(value2);
            fieldArray[index++].value = v;
        }
    }

    private static void fillRules(String str, WizardRuleFields rule) {
        TechEditWizardData.fillRule(str, "(,)", rule.xValue, rule.yValue);
    }

    private static void fillRule(String str, WizardField ... rules) {
        TechEditWizardData.fillRule(str, "(,)", rules);
    }

    private static void fillRule(String str, String tokens, WizardField ... rules) {
        StringTokenizer parse = new StringTokenizer(str, tokens, false);
        int count2 = 0;
        int pos = 0;
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            switch (count2) {
                case 0: 
                case 2: {
                    rules[pos].value = Double.parseDouble(value2);
                    break;
                }
                case 1: 
                case 3: {
                    rules[pos].rule = value2 = value2.replaceAll("\"", "");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (++count2 != 2) continue;
            ++pos;
        }
    }

    private void fillLayerSeries(String str, List<LayerInfo> layersList) {
        StringTokenizer parse = new StringTokenizer(str, "()", false);
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (!value2.contains(",")) continue;
            StringTokenizer p = new StringTokenizer(value2, ",", false);
            int itemCount = 0;
            LayerInfo layer = null;
            while (p.hasMoreTokens()) {
                String s = p.nextToken();
                if (s.startsWith(",")) continue;
                switch (itemCount) {
                    case 0: {
                        layer = new LayerInfo(s);
                        layersList.add(layer);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        layer.setLayerInformation(s);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                ++itemCount;
            }
            assert (itemCount > 1 && itemCount < 5);
        }
    }

    private void fillRulesSeries(String str, WizardField ... rules) {
        int index = str.indexOf("(");
        if (!str.startsWith("[") || index == -1) {
            Job.getUserInterface().showErrorMessage("Array does not start with '[' on " + str, "Syntax Error In Technology File");
            return;
        }
        StringTokenizer parse = new StringTokenizer(str.substring(index), "[]", false);
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (value2.equals(";") || value2.startsWith(" ")) continue;
            StringTokenizer p = new StringTokenizer(value2, "()", false);
            int pos = 0;
            while (p.hasMoreTokens()) {
                int itemCount;
                String s = p.nextToken();
                if (s.equals(";") || s.startsWith(" ")) continue;
                StringTokenizer x2 = new StringTokenizer(s, ", \"", false);
                if (pos >= rules.length) assert (pos < rules.length);
                block6: for (itemCount = 0; x2.hasMoreTokens() && itemCount < 2; ++itemCount) {
                    String item = x2.nextToken();
                    switch (itemCount) {
                        case 0: {
                            rules[pos].value = Double.valueOf(item);
                            continue block6;
                        }
                        case 1: {
                            rules[pos++].rule = item;
                        }
                    }
                }
                if (itemCount != 2) assert (itemCount == 2);
            }
        }
    }

    private void fillSeries(String str, Map<String, List<Element>> elementMap, int lineNumber) {
        StringTokenizer parse = new StringTokenizer(str, "[]", false);
        ArrayList<RectLayerNode> nodeList = new ArrayList<RectLayerNode>();
        int steps = 0;
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (value2.equals(";")) continue;
            if (steps == 1) {
                assert (nodeList.size() > 0);
                int index = value2.indexOf("{");
                assert (index != -1);
                String prefix = value2.substring(0, index);
                String v = value2.substring(index);
                StringTokenizer p = new StringTokenizer(v, "{}", false);
                while (p.hasMoreTokens()) {
                    String layer2;
                    String pair2 = p.nextToken();
                    StringTokenizer n = new StringTokenizer(pair2, ", ", false);
                    ArrayList<String> layerNames = new ArrayList<String>();
                    while (n.hasMoreTokens()) {
                        String l = n.nextToken();
                        layerNames.add(l);
                    }
                    if (nodeList.size() != layerNames.size()) {
                        System.out.println("Error in Technology Creation Wizard: no matching number of layers in fillSeries in line " + lineNumber);
                        return;
                    }
                    Element cont = new Element(prefix);
                    for (int i = 0; i < layerNames.size(); ++i) {
                        RectLayerNode node;
                        String name = (String)layerNames.get(i);
                        RectLayerNode tmp = (RectLayerNode)nodeList.get(i);
                        if (tmp instanceof NotCenterRectLayerNode) {
                            NotCenterRectLayerNode tmp1 = (NotCenterRectLayerNode)tmp;
                            node = new NotCenterRectLayerNode(name, tmp.valueX.value, tmp1.valueXR, tmp.valueX.rule, tmp.valueY.value, tmp1.valueYT, tmp.valueY.rule);
                        } else {
                            node = new RectLayerNode(name, tmp.valueX.value, tmp.valueX.rule, tmp.valueY.value, tmp.valueY.rule);
                        }
                        cont.layers.add(node);
                    }
                    String layer1 = (String)layerNames.get(0);
                    if (layer1.compareToIgnoreCase(layer2 = (String)layerNames.get(1)) > 0) {
                        String temp = layer1;
                        layer1 = layer2;
                        layer2 = temp;
                    }
                    this.addItemToElementMap(cont, layer1, layer2, elementMap);
                }
            } else if (steps == 0) {
                StringTokenizer p = new StringTokenizer(value2, "()", false);
                while (p.hasMoreTokens()) {
                    String s = p.nextToken();
                    int itemCount = 0;
                    String key = ", ";
                    int maxVariables = 4;
                    if (s.startsWith("{")) {
                        key = key + "{}";
                        maxVariables = 6;
                    }
                    boolean shortList = maxVariables == 4;
                    StringTokenizer x2 = new StringTokenizer(s, key, false);
                    double overX = 0.0;
                    double overY = 0.0;
                    double overRight = 0.0;
                    double overTop = 0.0;
                    String overXS = null;
                    String overYS = null;
                    ArrayList<String> elems = new ArrayList<String>();
                    while (x2.hasMoreTokens() && itemCount < maxVariables) {
                        elems.add(x2.nextToken());
                    }
                    int numLists = elems.size() / maxVariables;
                    assert (elems.size() % maxVariables == 0);
                    for (int j = 0; j < numLists; ++j) {
                        itemCount = 0;
                        for (int i = 0; i < maxVariables; ++i) {
                            String item = (String)elems.get(j * maxVariables + i);
                            try {
                                switch (itemCount) {
                                    case 0: {
                                        overX = Double.valueOf(item);
                                        break;
                                    }
                                    case 1: {
                                        if (shortList) {
                                            overXS = item;
                                            break;
                                        }
                                        overRight = Double.valueOf(item);
                                        break;
                                    }
                                    case 2: {
                                        if (shortList) {
                                            overY = Double.valueOf(item);
                                            break;
                                        }
                                        overXS = item;
                                        break;
                                    }
                                    case 3: {
                                        if (shortList) {
                                            overYS = item;
                                            break;
                                        }
                                        overY = Double.valueOf(item);
                                        break;
                                    }
                                    case 4: {
                                        assert (!shortList);
                                        overTop = Double.valueOf(item);
                                        break;
                                    }
                                    case 5: {
                                        assert (!shortList);
                                        overYS = item;
                                    }
                                }
                            }
                            catch (Exception e) {
                                System.out.println("Invalid syntax in '" + s + "' while reading fillSeries in line " + lineNumber);
                                return;
                            }
                            ++itemCount;
                        }
                        assert (itemCount <= maxVariables);
                        RectLayerNode node = maxVariables == 6 ? new NotCenterRectLayerNode("", overX, overRight, overXS, overY, overTop, overYS) : new RectLayerNode("", overX, overXS, overY, overYS);
                        nodeList.add(node);
                    }
                }
            } else {
                System.out.println("Error: step not considered");
            }
            ++steps;
        }
    }

    public void addItemToElementMap(Element cont, String layer1, String layer2, Map<String, List<Element>> contactMap) {
        String key = layer1 + "-" + layer2;
        List<Element> l = contactMap.get(key);
        if (l == null) {
            l = new ArrayList<Element>();
            contactMap.put(key, l);
        }
        l.add(cont);
    }

    private void fillPolygonalContactSeries(String str, Map<String, List<Element>> contactMap) {
        StringTokenizer parse = new StringTokenizer(str, "{}", false);
        int count2 = 0;
        double[] points = new double[2];
        ArrayList<PolygonLayerNode> nodeList = new ArrayList<PolygonLayerNode>();
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (value2.equals(";")) continue;
            StringTokenizer par2 = new StringTokenizer(value2, "[]", false);
            while (par2.hasMoreTokens()) {
                String val = par2.nextToken();
                ArrayList<EPoint> pList = new ArrayList<EPoint>();
                if (++count2 % 2 == 1) {
                    StringTokenizer p = new StringTokenizer(val, "()", false);
                    while (p.hasMoreTokens()) {
                        String v = p.nextToken();
                        StringTokenizer g = new StringTokenizer(v, ", ", false);
                        int index = 0;
                        points[1] = Double.MIN_VALUE;
                        points[0] = Double.MIN_VALUE;
                        while (g.hasMoreTokens()) {
                            assert (index < 2);
                            points[index++] = Double.parseDouble(g.nextToken());
                        }
                        assert (index == 2);
                        EPoint point = new EPoint(points[0], points[1]);
                        pList.add(point);
                    }
                    continue;
                }
                StringTokenizer n = new StringTokenizer(val, ", ", false);
                while (n.hasMoreTokens()) {
                    String l = n.nextToken();
                    PolygonLayerNode node = new PolygonLayerNode(l, pList);
                    nodeList.add(node);
                }
            }
        }
    }

    void exportData() {
        String fileName = OpenFile.chooseOutputFile(FileType.TEXT, "Technology Wizard File", "Technology.txt");
        if (fileName == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            this.dumpNumbers(printWriter);
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing XML file '" + fileName + "'");
            return;
        }
    }

    private void dumpNumbers(PrintWriter pw) {
        int i;
        pw.print("#### Electric(tm) VLSI Design System, version ");
        if (User.isIncludeDateAndVersionInOutput()) {
            pw.println(Version.getVersion());
        } else {
            pw.println();
        }
        pw.println("#### ");
        pw.println("#### Technology wizard data file");
        pw.println("####");
        pw.println("#### All dimensions in nanometers.");
        if (IOTool.isUseCopyrightMessage()) {
            String str = IOTool.getCopyrightMessage();
            int start = 0;
            while (start < str.length()) {
                int endPos = str.indexOf(10, start);
                if (endPos < 0) {
                    endPos = str.length();
                }
                String oneLine = str.substring(start, endPos);
                pw.println("#### " + oneLine);
                start = endPos + 1;
            }
        }
        pw.println();
        pw.println("$tech_name = \"" + this.tech_name + "\";");
        pw.println("$tech_description = \"" + this.tech_description + "\";");
        pw.println("$num_metal_layers = " + this.num_metal_layers + ";");
        pw.println("$psubstrate_process = " + this.pSubstrateProcess + ";");
        pw.println("$horizontal_transistors = " + this.horizontalFlag + ";");
        pw.println("$extra_info = " + this.caseFlag + ";");
        pw.println();
        pw.println("## stepsize is minimum granularity that will be used as movement grid");
        pw.println("## set to manufacturing grid or lowest common denominator with design rules");
        pw.println("$stepsize = " + this.stepsize + ";");
        pw.println();
        pw.println("######  DIFFUSION RULES  #####");
        pw.println("$diff_width = " + TextUtils.formatDouble(this.diff_width.value) + ";");
        pw.println("$diff_width_rule = \"" + this.diff_width.rule + "\";");
        pw.println("$diff_poly_overhang = " + TextUtils.formatDouble(this.diff_poly_overhang.value) + ";        # min. diff overhang from gate edge");
        pw.println("$diff_poly_overhang_rule = \"" + this.diff_poly_overhang.rule + "\";        # min. diff overhang from gate edge");
        pw.println("$diff_contact_overhang = " + TextUtils.formatDouble(this.diff_contact_overhang.value) + ";     # min. diff overhang contact");
        pw.println("$diff_contact_overhang_rule = \"" + this.diff_contact_overhang.rule + "\";     # min. diff overhang contact");
        pw.println("$diff_spacing = " + TextUtils.formatDouble(this.diff_spacing.value) + ";");
        pw.println("$diff_spacing_rule = \"" + this.diff_spacing.rule + "\";");
        pw.println();
        pw.println("######  POLY RULES  #####");
        pw.println("$poly_width = " + TextUtils.formatDouble(this.poly_width.value) + ";");
        pw.println("$poly_width_rule = \"" + this.poly_width.rule + "\";");
        pw.println("$poly_endcap = " + TextUtils.formatDouble(this.poly_endcap.value) + ";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_endcap_rule = \"" + this.poly_endcap.rule + "\";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_spacing = " + TextUtils.formatDouble(this.poly_spacing.value) + ";");
        pw.println("$poly_spacing_rule = \"" + this.poly_spacing.rule + "\";");
        pw.println("$poly_diff_spacing = " + TextUtils.formatDouble(this.poly_diff_spacing.value) + ";         # min. spacing between poly and diffusion");
        pw.println("$poly_diff_spacing_rule = \"" + this.poly_diff_spacing.rule + "\";         # min. spacing between poly and diffusion");
        pw.println("$poly_protection_spacing = " + TextUtils.formatDouble(this.poly_protection_spacing.value) + ";         # min. spacing between poly and dummy poly");
        pw.println("$poly_protection_spacing_rule = \"" + this.poly_protection_spacing.rule + "\";         # min. spacing between poly and dummy poly");
        pw.println();
        pw.println("######  GATE RULES  #####");
        pw.println("$gate_length = " + TextUtils.formatDouble(this.gate_length.value) + ";               # min. transistor gate length");
        pw.println("$gate_length_rule = \"" + this.gate_length.rule + "\";               # min. transistor gate length");
        pw.println("$gate_width = " + TextUtils.formatDouble(this.gate_width.value) + ";                # min. transistor gate width");
        pw.println("$gate_width_rule = \"" + this.gate_width.rule + "\";                # min. transistor gate width");
        pw.println("$gate_spacing = " + TextUtils.formatDouble(this.gate_spacing.value) + ";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_spacing_rule = \"" + this.gate_spacing.rule + "\";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_contact_spacing = " + TextUtils.formatDouble(this.gate_contact_spacing.value) + ";      # min. spacing from gate edge to contact inside diffusion");
        pw.println("$gate_contact_spacing_rule = \"" + this.gate_contact_spacing.rule + "\";      # min. spacing from gate edge to contact inside diffusion");
        pw.println();
        pw.println("######  CONTACT RULES  #####");
        pw.println("$contact_size = " + TextUtils.formatDouble(this.contact_size.value) + ";");
        pw.println("$contact_size_rule = \"" + this.contact_size.rule + "\";");
        pw.println("$contact_spacing = " + TextUtils.formatDouble(this.contact_spacing.value) + ";");
        pw.println("$contact_spacing_rule = \"" + this.contact_spacing.rule + "\";");
        pw.println("$contact_array_spacing = " + TextUtils.formatDouble(this.contact_array_spacing.value) + ";");
        pw.println("$contact_array_spacing_rule = \"" + this.contact_array_spacing.rule + "\";");
        pw.println("$contact_metal_overhang_inline_only = " + TextUtils.formatDouble(this.contact_metal_overhang_inline_only.value) + ";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_inline_only_rule = \"" + this.contact_metal_overhang_inline_only.rule + "\";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_all_sides = " + TextUtils.formatDouble(this.contact_metal_overhang_all_sides.value) + ";         # metal overhang when surrounding contact");
        pw.println("$contact_metal_overhang_all_sides_rule = \"" + this.contact_metal_overhang_all_sides.rule + "\";         # metal overhang when surrounding contact");
        pw.println("$contact_poly_overhang = " + TextUtils.formatDouble(this.contact_poly_overhang.value) + ";                    # poly overhang contact, recommended value");
        pw.println("$contact_poly_overhang_rule = \"" + this.contact_poly_overhang.rule + "\";                    # poly overhang contact, recommended value");
        pw.println("$polycon_diff_spacing = " + TextUtils.formatDouble(this.polycon_diff_spacing.value) + ";                    # spacing between poly-metal contact edge and diffusion");
        pw.println("$polycon_diff_spacing_rule = \"" + this.polycon_diff_spacing.rule + "\";                    # spacing between poly-metal contact edge and diffusion");
        pw.println();
        pw.println("######  WELL AND IMPLANT RULES  #####");
        pw.println("$nplus_width = " + TextUtils.formatDouble(this.nplus_width.value) + ";");
        pw.println("$nplus_width_rule = \"" + this.nplus_width.rule + "\";");
        pw.println("$nplus_overhang_diff = " + TextUtils.formatDouble(this.nplus_overhang_diff.value) + ";");
        pw.println("$nplus_overhang_diff_rule = \"" + this.nplus_overhang_diff.rule + "\";");
        pw.println("$nplus_overhang_strap = " + TextUtils.formatDouble(this.nplus_overhang_strap.value) + ";");
        pw.println("$nplus_overhang_strap_rule = \"" + this.nplus_overhang_strap.rule + "\";");
        pw.println("$nplus_overhang_poly = " + TextUtils.formatDouble(this.nplus_overhang_poly.value) + ";");
        pw.println("$nplus_overhang_poly_rule = \"" + this.nplus_overhang_poly.rule + "\";");
        pw.println("$nplus_spacing = " + TextUtils.formatDouble(this.nplus_spacing.value) + ";");
        pw.println("$nplus_spacing_rule = \"" + this.nplus_spacing.rule + "\";");
        pw.println();
        pw.println("$pplus_width = " + TextUtils.formatDouble(this.pplus_width.value) + ";");
        pw.println("$pplus_width_rule = \"" + this.pplus_width.rule + "\";");
        pw.println("$pplus_overhang_diff = " + TextUtils.formatDouble(this.pplus_overhang_diff.value) + ";");
        pw.println("$pplus_overhang_diff_rule = \"" + this.pplus_overhang_diff.rule + "\";");
        pw.println("$pplus_overhang_strap = " + TextUtils.formatDouble(this.pplus_overhang_strap.value) + ";");
        pw.println("$pplus_overhang_strap_rule = \"" + this.pplus_overhang_strap.rule + "\";");
        pw.println("$pplus_overhang_poly = " + TextUtils.formatDouble(this.pplus_overhang_poly.value) + ";");
        pw.println("$pplus_overhang_poly_rule = \"" + this.pplus_overhang_poly.rule + "\";");
        pw.println("$pplus_spacing = " + TextUtils.formatDouble(this.pplus_spacing.value) + ";");
        pw.println("$pplus_spacing_rule = \"" + this.pplus_spacing.rule + "\";");
        pw.println();
        pw.println("$nwell_width = " + TextUtils.formatDouble(this.nwell_width.value) + ";");
        pw.println("$nwell_width_rule = \"" + this.nwell_width.rule + "\";");
        pw.println("$nwell_overhang_diff_p = " + TextUtils.formatDouble(this.nwell_overhang_diff_p.value) + ";");
        pw.println("$nwell_overhang_diff_rule_p = \"" + this.nwell_overhang_diff_p.rule + "\";");
        pw.println("$nwell_overhang_diff_n = " + TextUtils.formatDouble(this.nwell_overhang_diff_n.value) + ";");
        pw.println("$nwell_overhang_diff_rule_n = \"" + this.nwell_overhang_diff_n.rule + "\";");
        pw.println("$nwell_spacing = " + TextUtils.formatDouble(this.nwell_spacing.value) + ";");
        pw.println("$nwell_spacing_rule = \"" + this.nwell_spacing.rule + "\";");
        pw.println();
        pw.println("######  METAL RULES  #####");
        pw.print("@metal_width = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_width[i].value));
        }
        pw.println(");");
        pw.print("@metal_width_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_width[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@metal_spacing = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_spacing[i].value));
        }
        pw.println(");");
        pw.print("@metal_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  VIA RULES  #####");
        pw.print("@via_size = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_size[i].value));
        }
        pw.println(");");
        pw.print("@via_size_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_size[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_inline_spacing[i].value));
        }
        pw.println(");");
        pw.print("@via_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_inline_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("## \"sep2d\" spacing, close proximity via array spacing");
        pw.print("@via_array_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_array_spacing[i].value));
        }
        pw.println(");");
        pw.print("@via_array_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_array_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_overhang_inline = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_overhang[i].value));
        }
        pw.println(");");
        pw.print("@via_overhang_inline_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_overhang[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  ANTENNA RULES  #####");
        pw.println("$poly_antenna_ratio = " + TextUtils.formatDouble(this.poly_antenna_ratio) + ";");
        pw.print("@metal_antenna_ratio = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_antenna_ratio[i]));
        }
        pw.println(");");
        pw.println();
        pw.println("######  GDS-II LAYERS  #####");
        pw.println("$gds_diff_layer = " + this.diff_layer + ";");
        pw.println("$gds_poly_layer = " + this.poly_layer + ";");
        pw.println("$gds_nplus_layer = " + this.nplus_layer + ";");
        pw.println("$gds_pplus_layer = " + this.pplus_layer + ";");
        pw.println("$gds_nwell_layer = " + this.nwell_layer + ";");
        pw.println("$gds_contact_layer = " + this.contact_layer + ";");
        pw.print("@gds_metal_layer = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.metal_layers[i]);
        }
        pw.println(");");
        pw.print("@gds_via_layer = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.via_layers[i]);
        }
        pw.println(");");
        pw.println();
        pw.println("## Device marking layer");
        pw.println("$gds_marking_layer = " + this.marking_layer + ";");
        pw.println();
        pw.println("# End of techfile");
    }

    public void writeXML(boolean checkErrorsInData) {
        String errorMessage;
        if (checkErrorsInData && (errorMessage = this.errorInData()) != null) {
            Job.getUserInterface().showErrorMessage("ERROR: " + errorMessage, "Missing Technology Data");
            return;
        }
        String suggestedName = this.getTechName() + ".xml";
        String fileName = OpenFile.chooseOutputFile(FileType.XML, "Technology XML File", suggestedName);
        if (fileName == null) {
            return;
        }
        try {
            this.dumpXMLFile(fileName);
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Error writing XML file in '" + fileName + "'");
            return;
        }
    }

    private Xml.PrimitiveNodeGroup makeXmlPrimitivePin(Xml.Technology t, String name, double size2, SizeOffset so, List<String> portNames, Xml.NodeLayer ... list2) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list2.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        for (Xml.NodeLayer lb : list2) {
            if (lb == null) continue;
            nodesList.add(lb);
        }
        if (portNames == null) {
            portNames = new ArrayList<String>();
            portNames.add(name);
        }
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, -1, 0.0, 1, 0.0, -1, 0.0, 1, portNames));
        Xml.PrimitiveNodeGroup n = this.makeXmlPrimitive(t.nodeGroups, name + "-Pin", PrimitiveNode.Function.PIN, size2, size2, 0.0, 0.0, so, nodesList, nodePorts, null, true);
        return n;
    }

    private Xml.PrimitiveNodeGroup makeXmlPrimitiveCon(List<Xml.PrimitiveNodeGroup> nodeGroups, String name, PrimitiveNode.Function function, double sizeX, double sizeY, SizeOffset so, List<String> portArcNames, Xml.NodeLayer ... list2) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list2.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        for (Xml.NodeLayer lb : list2) {
            if (lb == null) continue;
            nodesList.add(lb);
        }
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, -1, 0.0, 1, 0.0, -1, 0.0, 1, portArcNames));
        return this.makeXmlPrimitive(nodeGroups, name + "-Con", function, sizeX, sizeY, 0.0, 0.0, so, nodesList, nodePorts, null, false);
    }

    private Xml.PrimitiveNodeGroup makeXmlCapacitor(List<Xml.PrimitiveNodeGroup> nodeGroups, String name, PrimitiveNode.Function function, double sizeX, double sizeY, SizeOffset so, List<String> portNames, List<String> portArcNames, Xml.NodeLayer ... list2) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list2.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        for (Xml.NodeLayer lb : list2) {
            if (lb == null) continue;
            nodesList.add(lb);
        }
        for (String port : portNames) {
            nodePorts.add(this.makeXmlPrimitivePort(port, 0, 180, 0, null, 0.0, -1, 0.0, 1, 0.0, -1, 0.0, 1, portArcNames));
        }
        return this.makeXmlPrimitive(nodeGroups, name + "-Capacitor", function, sizeX, sizeY, 0.0, 0.0, so, nodesList, nodePorts, null, false);
    }

    private Xml.PrimitiveNodeGroup makeXmlPrimitive(List<Xml.PrimitiveNodeGroup> nodeGroups, String name, PrimitiveNode.Function function, double width, double height, double ppLeft, double ppBottom, SizeOffset so, List<Xml.NodeLayer> nodeLayers, List<Xml.PrimitivePort> nodePorts, PrimitiveNode.NodeSizeRule nodeSizeRule, boolean isArcsShrink) {
        Xml.PrimitiveNodeGroup ng = new Xml.PrimitiveNodeGroup();
        ng.isSingleton = true;
        Xml.PrimitiveNode n = new Xml.PrimitiveNode();
        n.name = name;
        n.function = function;
        ng.nodes.add(n);
        ng.shrinkArcs = isArcsShrink;
        EPoint topLeft = EPoint.fromLambda(ppLeft, ppBottom + height);
        EPoint size2 = EPoint.fromLambda(width, height);
        if (!function.isPin() || isArcsShrink) {
            // empty if block
        }
        if (so != null && so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
            so = null;
        }
        ERectangle base = this.calcBaseRectangle(so, nodeLayers, nodeSizeRule);
        ng.baseLX.value = base.getLambdaMinX();
        ng.baseHX.value = base.getLambdaMaxX();
        ng.baseLY.value = base.getLambdaMinY();
        ng.baseHY.value = base.getLambdaMaxY();
        if (nodeLayers != null) {
            ng.nodeLayers.addAll(nodeLayers);
        }
        ng.specialType = 0;
        if (nodeSizeRule != null) {
            ng.nodeSizeRule = new Xml.NodeSizeRule();
            ng.nodeSizeRule.width = nodeSizeRule.getWidth();
            ng.nodeSizeRule.height = nodeSizeRule.getHeight();
            ng.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        ng.ports.addAll(nodePorts);
        nodeGroups.add(ng);
        return ng;
    }

    private ERectangle calcBaseRectangle(SizeOffset so, List<Xml.NodeLayer> nodeLayers, PrimitiveNode.NodeSizeRule nodeSizeRule) {
        long ly;
        long hy;
        long lx;
        long hx;
        if (nodeSizeRule != null) {
            hx = DBMath.lambdaToGrid(0.5 * nodeSizeRule.getWidth());
            lx = -hx;
            hy = DBMath.lambdaToGrid(0.5 * nodeSizeRule.getHeight());
            ly = -hy;
        } else {
            lx = Long.MAX_VALUE;
            hx = Long.MIN_VALUE;
            ly = Long.MAX_VALUE;
            hy = Long.MIN_VALUE;
            for (int i = 0; i < nodeLayers.size(); ++i) {
                long y;
                long x2;
                Xml.NodeLayer nl = nodeLayers.get(i);
                if (nl.representation == 1 || nl.representation == 3) {
                    x2 = DBMath.lambdaToGrid(nl.lx.value);
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    x2 = DBMath.lambdaToGrid(nl.hx.value);
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    y = DBMath.lambdaToGrid(nl.ly.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    y = DBMath.lambdaToGrid(nl.hy.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    continue;
                }
                for (Technology.TechPoint p : nl.techPoints) {
                    x2 = p.getX().getAdder().getGrid();
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    y = p.getY().getAdder().getGrid();
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                }
            }
        }
        if (so != null) {
            lx += so.getLowXGridOffset();
            hx -= so.getHighXGridOffset();
            ly += so.getLowYGridOffset();
            hy -= so.getHighYGridOffset();
        }
        return ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
    }

    private Xml.ArcProto makeXmlArc(Xml.Technology t, String name, ArcProto.Function function, double ant, Xml.ArcLayer ... arcLayers) {
        Xml.ArcProto a = new Xml.ArcProto();
        a.name = name;
        a.function = function;
        a.wipable = true;
        a.extended = true;
        a.fixedAngle = true;
        a.angleIncrement = 90;
        a.antennaRatio = DBMath.round(ant);
        for (Xml.ArcLayer al : arcLayers) {
            if (al == null) continue;
            a.arcLayers.add(al);
        }
        t.arcs.add(a);
        return a;
    }

    private Xml.Layer makeXmlLayer(List<Xml.Layer> layers, Map<Xml.Layer, WizardField> layerMap, String name, Layer.Function function, int extraf, EGraphics graph, WizardField width, boolean pureLayerNode, boolean pureLayerPortArc, String ... portArcNames) {
        Xml.Layer l = this.makeXmlLayer(layers, name, function, extraf, graph, width.value, pureLayerNode, pureLayerPortArc, portArcNames);
        layerMap.put(l, width);
        return l;
    }

    private Xml.Layer makeXmlLayer(List<Xml.Layer> layers, String name, Layer.Function function, int extraf, EGraphics graph, double width, boolean pureLayerNode, boolean pureLayerPortArc, String ... portArcNames) {
        Xml.Layer l = new Xml.Layer();
        l.name = name;
        l.function = function;
        l.extraFunction = extraf;
        graph = graph.withTransparencyMode(EGraphics.J3DTransparencyOption.NONE);
        l.desc = graph = graph.withTransparencyFactor(1.0);
        l.thick3D = 1.0;
        l.height3D = 1.0;
        l.cif = "Not set";
        l.skill = name;
        l.resistance = 1.0;
        l.capacitance = 0.0;
        l.edgeCapacitance = 0.0;
        assert (pureLayerNode || !pureLayerPortArc);
        if (pureLayerNode) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = name + "-Node";
            l.pureLayerNode.style = Poly.Type.FILLED;
            l.pureLayerNode.size.addLambda(this.scaledValue(width));
            l.pureLayerNode.port = "Port_" + name;
            if (pureLayerPortArc) {
                if (portArcNames.length == 0) {
                    l.pureLayerNode.portArcs.add(name);
                } else {
                    for (String s : portArcNames) {
                        l.pureLayerNode.portArcs.add(s);
                    }
                }
            }
        }
        layers.add(l);
        return l;
    }

    private Xml.NodeLayer addXmlNodeLayer(List<Xml.NodeLayer> nodesList, Xml.Technology t, String layerName, double xVal, double yVal) {
        return this.addXmlNodeLayerInternal(nodesList, t, layerName, xVal, yVal, true, true, 0);
    }

    private Xml.NodeLayer addXmlNodeLayerInternal(List<Xml.NodeLayer> nodesList, Xml.Technology t, String layerName, double xVal, double yVal, boolean inLayers, boolean electricalLayers, int port) {
        Xml.Layer layer = t.findLayer(layerName);
        if (layer == null) {
            System.out.println("Error adding layer '" + layerName + "'");
            return null;
        }
        Xml.NodeLayer nl = this.makeXmlNodeLayer(xVal, xVal, yVal, yVal, layer, Poly.Type.FILLED, inLayers, electricalLayers, port);
        nodesList.add(nl);
        return nl;
    }

    private Xml.NodeLayer makeXmlNodeLayer(double lx, double hx, double ly, double hy, Xml.Layer lb, Poly.Type style) {
        return this.makeXmlNodeLayer(lx, hx, ly, hy, lb, style, true, true, 0);
    }

    private Xml.NodeLayer makeXmlNodeLayer(double lx, int lxk, double hx, int hxk, double ly, int lyk, double hy, int hyk, Xml.Layer lb, Poly.Type style, boolean inLayers, boolean electricalLayers, int port) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        if (lb == null) {
            System.out.println("Error: null layer in makeXmlNodeLayer");
        }
        nl.layer = lb.name;
        nl.style = style;
        nl.portNum = port;
        nl.inLayers = inLayers;
        nl.inElectricalLayers = electricalLayers;
        nl.representation = 1;
        nl.lx.k = lxk;
        nl.hx.k = hxk;
        nl.ly.k = lyk;
        nl.hy.k = hyk;
        nl.lx.addLambda(-lx);
        nl.hx.addLambda(hx);
        nl.ly.addLambda(-ly);
        nl.hy.addLambda(hy);
        return nl;
    }

    private Xml.NodeLayer makeXmlNodeLayer(double lx, double hx, double ly, double hy, Xml.Layer lb, Poly.Type style, boolean inLayers, boolean electricalLayers, int port) {
        return this.makeXmlNodeLayer(lx, -1, hx, 1, ly, -1, hy, 1, lb, style, inLayers, electricalLayers, port);
    }

    private Xml.NodeLayer makeXmlMulticut(Xml.Layer lb, double sizeRule, double sepRule, double sepRule2D) {
        return this.makeXmlMulticut(0.0, 0.0, 0.0, 0.0, lb, sizeRule, sepRule, sepRule2D);
    }

    private Xml.NodeLayer makeXmlMulticut(double lx, double hx, double ly, double hy, Xml.Layer lb, double sizeRule, double sepRule, double sepRule2D) {
        return this.makeXmlMulticut(lx, -1, hx, 1, ly, -1, hy, 1, lb, sizeRule, sepRule, sepRule2D);
    }

    private Xml.NodeLayer makeXmlMulticut(double lx, int lxk, double hx, int hxk, double ly, int lyk, double hy, int hyk, Xml.Layer lb, double sizeRule, double sepRule, double sepRule2D) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        nl.layer = lb.name;
        nl.style = Poly.Type.FILLED;
        nl.inElectricalLayers = true;
        nl.inLayers = true;
        nl.representation = 3;
        nl.lx.k = lxk;
        nl.hx.k = hxk;
        nl.ly.k = lyk;
        nl.hy.k = hyk;
        nl.lx.addLambda(-lx);
        nl.hx.addLambda(hx);
        nl.ly.addLambda(-ly);
        nl.hy.addLambda(hy);
        nl.sizex = sizeRule;
        nl.sizey = sizeRule;
        nl.sep1d = sepRule;
        nl.sep2d = sepRule2D;
        return nl;
    }

    private Xml.PrimitivePort makeXmlPrimitivePort(String name, int portAngle, int portRange, int portTopology, EPoint minFullSize, double lx, int slx, double hx, int shx, double ly, int sly, double hy, int shy, List<String> portArcs) {
        Xml.PrimitivePort ppd = new Xml.PrimitivePort();
        double lambdaX = minFullSize != null ? minFullSize.getLambdaX() : 0.0;
        double lambdaY = minFullSize != null ? minFullSize.getLambdaY() : 0.0;
        ppd.name = name;
        ppd.portAngle = portAngle;
        ppd.portRange = portRange;
        ppd.portTopology = portTopology;
        ppd.lx.k = slx;
        ppd.lx.addLambda(DBMath.round(lx + lambdaX * ppd.lx.k));
        ppd.hx.k = shx;
        ppd.hx.addLambda(DBMath.round(hx + lambdaX * ppd.hx.k));
        ppd.ly.k = sly;
        ppd.ly.addLambda(DBMath.round(ly + lambdaY * ppd.ly.k));
        ppd.hy.k = shy;
        ppd.hy.addLambda(DBMath.round(hy + lambdaY * ppd.hy.k));
        if (portArcs != null) {
            for (String s : portArcs) {
                ppd.portArcs.add(s);
            }
        }
        return ppd;
    }

    private Xml.PrimitiveNodeGroup makeContactSeries(List<Xml.PrimitiveNodeGroup> nodeGroups, String composeName, double contSize, Xml.Layer conLayer, double spacing, double arraySpacing, double extLayer1, Xml.Layer layer1, double extLayer2, Xml.Layer layer2) {
        ArrayList<String> portNames = new ArrayList<String>(2);
        portNames.add(layer1.name);
        portNames.add(layer2.name);
        double hlaLong1 = DBMath.round(contSize / 2.0 + extLayer1);
        double hlaLong2 = DBMath.round(contSize / 2.0 + extLayer2);
        return this.makeXmlPrimitiveCon(nodeGroups, composeName, PrimitiveNode.Function.CONTACT, -1.0, -1.0, null, portNames, this.makeXmlNodeLayer(hlaLong1, hlaLong1, hlaLong1, hlaLong1, layer1, Poly.Type.FILLED), this.makeXmlNodeLayer(hlaLong2, hlaLong2, hlaLong2, hlaLong2, layer2, Poly.Type.FILLED), this.makeXmlMulticut(conLayer, contSize, spacing, arraySpacing));
    }

    private static int[] getPatternByCode(int code) {
        int[] pattern = null;
        switch (code) {
            case -1: {
                pattern = nullPattern;
            }
            case 3: {
                pattern = new int[]{65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0};
                break;
            }
            case 4: {
                pattern = new int[]{34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476};
                break;
            }
            case 5: {
                pattern = new int[]{4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845};
                break;
            }
            case 6: {
                pattern = new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369};
                break;
            }
            case 7: {
                pattern = new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0};
                break;
            }
            case 8: {
                pattern = new int[]{0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952};
                break;
            }
            case 9: {
                pattern = new int[]{21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845};
            }
        }
        return pattern;
    }

    private void generateExtraLayers(Xml.Technology t, List<LayerInfo> list2, List<PaletteGroup> paletteList, Map<Xml.Layer, WizardField> layerMap, boolean addPin) {
        for (LayerInfo info : list2) {
            boolean actualPureNode;
            EGraphics graph = null;
            assert (info.graphicsTemplate == null || info.graphicsColor == null);
            if (info.graphicsTemplate != null) {
                for (Xml.Layer l : t.layers) {
                    if (!l.name.equals(info.graphicsTemplate)) continue;
                    graph = l.desc;
                    break;
                }
                if (graph == null) {
                    System.out.println("No template layer " + info.graphicsTemplate + " found");
                }
            } else if (info.graphicsColor != null) {
                boolean displayPatterned = info.graphicsOutline != EGraphics.Outline.NOPAT;
                graph = new EGraphics(displayPatterned, displayPatterned, info.graphicsOutline, 0, info.graphicsColor.getRed(), info.graphicsColor.getGreen(), info.graphicsColor.getBlue(), 1.0, true, info.graphicsPattern != null ? info.graphicsPattern : nullPattern);
            }
            if (graph == null) {
                graph = new EGraphics(false, false, null, 0, 255, 0, 0, 0.4, true, nullPattern);
            }
            boolean actualAddPin = addPin && info.addArc;
            boolean bl = actualPureNode = info.functionExtras != 8192;
            if (actualAddPin && DBMath.areEquals(info.width, 0.0)) {
                System.out.println("Adding pure layer node '" + info.name + "' with zero width");
            }
            WizardField wf = new WizardField(info.width, info.name);
            Xml.Layer layer = this.makeXmlLayer(t.layers, layerMap, info.name, info.function, info.functionExtras, graph, wf, actualPureNode, info.addArc, info.name);
            if (info.cif != null) {
                layer.cif = info.cif;
            }
            this.makeLayerGDS(t, layer, String.valueOf(info));
            if (info.addArc) {
                info.grp = new PaletteGroup();
                ArcProto.Function fun = ArcProto.Function.findByPrintName(info.function.toString());
                if (fun == null) {
                    System.out.println("It didn't find equivalent arc function for layer '" + layer.name + ", function='" + (Object)((Object)info.function) + "'. Assigining unknown function");
                    fun = ArcProto.Function.UNKNOWN;
                }
                info.grp.addArc(this.makeXmlArc(t, info.name, fun, 0.0, this.makeXmlArcLayer(layer, wf)));
                double hla = this.scaledValue(info.width / 2.0);
                info.grp.addPinOrResistor(this.makeXmlPrimitivePin(t, info.name, hla, null, null, this.makeXmlNodeLayer(hla, hla, hla, hla, layer, Poly.Type.CROSSED)), null);
                paletteList.add(info.grp);
            }
            if (info.height > -1.0) {
                layer.height3D = info.height;
            }
            if (!(info.thickness > -1.0)) continue;
            layer.thick3D = info.thickness;
        }
    }

    public void dumpXMLFile(String fileName) throws IOException {
        int i;
        String name;
        int i2;
        int metalNum;
        int i3;
        Xml.Technology t = new Xml.Technology();
        t.techName = this.getTechName();
        t.shortTechName = this.getTechName();
        t.description = this.getTechDescription();
        t.maxNumMetals = t.defaultNumMetals = this.getNumMetalLayers();
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getStepSize();
        t.scaleRelevant = true;
        t.resolutionValue = this.getResolution();
        t.defaultFoundry = "NONE";
        t.minResistance = 1.0;
        t.minCapacitance = 0.1;
        t.menuPalette = new Xml.MenuPalette();
        Xml.Foundry f2 = new Xml.Foundry();
        f2.name = Foundry.Type.NONE.getName();
        t.foundries.add(f2);
        Color[] metal_colour = new Color[]{new Color(0, 150, 255), new Color(148, 0, 211), new Color(255, 215, 0), new Color(132, 112, 255), new Color(255, 160, 122), new Color(34, 139, 34), new Color(178, 34, 34), new Color(34, 34, 178), new Color(153, 153, 153), new Color(102, 102, 102)};
        Color poly_colour = new Color(255, 155, 192);
        Color diff_colour = new Color(107, 226, 96);
        Color via_colour = new Color(205, 205, 205);
        Color[] colorMap = new Color[]{poly_colour, diff_colour, metal_colour[0], metal_colour[1], metal_colour[2]};
        for (int i4 = 0; i4 < colorMap.length; ++i4) {
            Color transparentColor = colorMap[i4];
            t.transparentLayers.add(transparentColor);
        }
        ArrayList<Xml.Layer> metalLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> dummyMetalLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> exclusionMetalLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> viaLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> dummyViaLayers = new ArrayList<Xml.Layer>();
        LinkedHashMap<Xml.Layer, WizardField> layerMap = new LinkedHashMap<Xml.Layer, WizardField>();
        int[] dexclPattern = new int[]{4112, 8224, 16448, 32896, 16448, 8224, 4112, 2056, 4112, 8224, 16448, 32896, 16448, 8224, 4112, 2056};
        for (i3 = 0; i3 < this.num_metal_layers; ++i3) {
            metalNum = i3 + 1;
            double opacity = (double)(75 - metalNum * 5) / 100.0;
            int metLayHigh = i3 / 10;
            int metLayDig = i3 % 10;
            int r = metal_colour[metLayDig].getRed() * (10 - metLayHigh) / 10;
            int g = metal_colour[metLayDig].getGreen() * (10 - metLayHigh) / 10;
            int b = metal_colour[metLayDig].getBlue() * (10 - metLayHigh) / 10;
            int tcol = 0;
            int[] pattern = null;
            switch (metLayDig) {
                case 0: {
                    tcol = 3;
                    break;
                }
                case 1: {
                    tcol = 4;
                    break;
                }
                case 2: {
                    tcol = 5;
                    break;
                }
                default: {
                    pattern = TechEditWizardData.getPatternByCode(metLayDig);
                }
            }
            boolean onDisplay = true;
            boolean onPrinter = true;
            if (pattern == null) {
                pattern = nullPattern;
                onDisplay = false;
                onPrinter = false;
            }
            EGraphics graph = new EGraphics(onDisplay, onPrinter, null, tcol, r, g, b, opacity, true, pattern);
            Layer.Function fun = Layer.Function.getMetal(metalNum);
            if (fun == null) {
                throw new IOException("invalid number of metals");
            }
            String metalName = this.getMetalName() + metalNum;
            Xml.Layer layer = this.makeXmlLayer(t.layers, layerMap, metalName, fun, 0, graph, this.metal_width[i3], true, true, new String[0]);
            metalLayers.add(layer);
            if (!this.withExtraDummyLayers()) continue;
            graph = new EGraphics(true, true, null, tcol, r, g, b, opacity, false, nullPattern);
            layer = this.makeXmlLayer(t.layers, this.getDName() + metalName, Layer.Function.getDummyMetal(i3), 0, graph, 5.0 * this.metal_width[i3].value, true, false, new String[0]);
            dummyMetalLayers.add(layer);
            graph = new EGraphics(true, true, null, tcol, r, g, b, opacity, true, dexclPattern);
            layer = this.makeXmlLayer(t.layers, this.getExclName(metalName), Layer.Function.getDummyExclMetal(i3), 0, graph, 2.0 * this.metal_width[i3].value, true, false, new String[0]);
            exclusionMetalLayers.add(layer);
        }
        for (i3 = 0; i3 < this.num_metal_layers - 1; ++i3) {
            metalNum = i3 + 1;
            int r = via_colour.getRed();
            int g = via_colour.getGreen();
            int b = via_colour.getBlue();
            double opacity = 0.7;
            EGraphics graph = new EGraphics(false, false, null, 0, r, g, b, opacity, true, nullPattern);
            Layer.Function fun = Layer.Function.getContact(metalNum + 1);
            String viaName = this.getViaName() + metalNum;
            if (fun == null) {
                throw new IOException("invalid number of vias");
            }
            viaLayers.add(this.makeXmlLayer(t.layers, layerMap, viaName, fun, 16384, graph, this.via_size[i3], true, false, new String[0]));
            if (!this.withExtraDummyLayers()) continue;
            graph = new EGraphics(true, true, null, 0, r, g, b, opacity, false, nullPattern);
            Xml.Layer layer = this.makeXmlLayer(t.layers, "DMY-" + viaName, Layer.Function.getDummyMetal(i3), 0, graph, this.via_size[i3].value, true, false, new String[0]);
            dummyViaLayers.add(layer);
        }
        ArrayList<PaletteGroup> allGroups = new ArrayList<PaletteGroup>();
        if (!this.isBasicCase()) {
            this.addStandardLayers(t, layerMap, nullPattern, dexclPattern);
        }
        if (this.withExtraDummyLayers()) {
            EGraphics graph = new EGraphics(true, true, null, 2, 0, 0, 0, 1.0, true, dexclPattern);
            Xml.Layer exclusionDiffPLayer = this.makeXmlLayer(t.layers, "DEXCL-P-" + this.diff_layer.name, Layer.Function.DEXCLDIFF, 0, graph, 2.0 * this.diff_width.value, true, false, new String[0]);
            Xml.Layer exclusionDiffNLayer = this.makeXmlLayer(t.layers, "DEXCL-N-" + this.diff_layer.name, Layer.Function.DEXCLDIFF, 0, graph, 2.0 * this.diff_width.value, true, false, new String[0]);
            this.makeLayerGDS(t, exclusionDiffPLayer, "150/20");
            this.makeLayerGDS(t, exclusionDiffNLayer, "150/20");
        }
        EGraphics graph = new EGraphics(false, false, null, 0, 255, 0, 0, 0.4, true, nullPattern);
        Xml.Layer deviceMarkLayer = this.makeXmlLayer(t.layers, layerMap, this.marking_layer.name, Layer.Function.CONTROL, 0, graph, this.nplus_width, true, false, new String[0]);
        ArrayList<PaletteGroup> extraPaletteList = new ArrayList<PaletteGroup>();
        this.generateExtraLayers(t, this.extraLayers, extraPaletteList, layerMap, true);
        ArrayList<PaletteGroup> textPaletteList = new ArrayList<PaletteGroup>();
        this.generateExtraLayers(t, this.textLayers, textPaletteList, layerMap, false);
        PaletteGroup[] metalPalette = new PaletteGroup[this.num_metal_layers];
        for (int i5 = 1; i5 <= this.num_metal_layers; ++i5) {
            PaletteGroup group;
            double ant = (int)Math.round(this.metal_antenna_ratio[i5 - 1]) | 0xC8;
            metalPalette[i5 - 1] = group = new PaletteGroup();
            group.addArc(this.makeXmlArc(t, this.getMetalName() + i5, ArcProto.Function.getContact(i5), ant, this.makeXmlArcLayer((Xml.Layer)metalLayers.get(i5 - 1), this.metal_width[i5 - 1])));
        }
        ArrayList<PaletteGroup> polysGroup = new ArrayList<PaletteGroup>();
        if (!this.isBasicCase()) {
            this.addStandardElements(t, layerMap, metalLayers, allGroups, polysGroup);
        }
        for (i2 = 0; i2 < this.num_metal_layers; ++i2) {
            double hla = this.scaledValue(this.metal_width[i2].value / 2.0);
            Xml.Layer lt = (Xml.Layer)metalLayers.get(i2);
            PaletteGroup group = metalPalette[i2];
            group.addPinOrResistor(this.makeXmlPrimitivePin(t, lt.name, hla, null, null, this.makeXmlNodeLayer(hla, hla, hla, hla, lt, Poly.Type.CROSSED)), null);
        }
        if (this.withDefaultSquareMetals()) {
            for (i2 = 1; i2 < this.num_metal_layers; ++i2) {
                Xml.Layer lb = (Xml.Layer)metalLayers.get(i2 - 1);
                Xml.Layer lt = (Xml.Layer)metalLayers.get(i2);
                PaletteGroup group = metalPalette[i2 - 1];
                Xml.Layer via = (Xml.Layer)viaLayers.get(i2 - 1);
                double viaSize = this.scaledValue(this.via_size[i2 - 1].value);
                double viaSpacing = this.scaledValue(this.via_inline_spacing[i2 - 1].value);
                double viaArraySpacing = this.scaledValue(this.via_array_spacing[i2 - 1].value);
                name = lb.name + "-" + lt.name;
                double longDist = this.scaledValue(this.via_overhang[i2 - 1].value);
                group.addElement(this.makeContactSeries(t.nodeGroups, name, viaSize, via, viaSpacing, viaArraySpacing, longDist, lt, longDist, lb), null);
            }
        }
        ArrayList<String> portNames = new ArrayList<String>();
        for (Map.Entry<String, List<Element>> e : this.metalContacts.entrySet()) {
            for (Element c : e.getValue()) {
                assert (c.layers.size() == 2);
                RectLayerNode verticalLayer = (RectLayerNode)c.layers.get(0);
                RectLayerNode horizontalLayer = (RectLayerNode)c.layers.get(1);
                int i6 = Integer.valueOf(verticalLayer.layer);
                int j = Integer.valueOf(horizontalLayer.layer);
                Xml.Layer ly = (Xml.Layer)metalLayers.get(i6 - 1);
                Xml.Layer lx = (Xml.Layer)metalLayers.get(j - 1);
                name = j > i6 ? ly.name + "-" + lx.name : lx.name + "-" + ly.name;
                int via = j > i6 ? i6 : j;
                double metalContSize = this.scaledValue(this.via_size[via - 1].value);
                double spacing = this.scaledValue(this.via_inline_spacing[via - 1].value);
                double arraySpacing = this.scaledValue(this.via_array_spacing[via - 1].value);
                Xml.Layer metalConLayer = (Xml.Layer)viaLayers.get(via - 1);
                double h1x = this.scaledValue(this.via_size[via - 1].value / 2.0 + verticalLayer.valueX.value);
                double h1y = this.scaledValue(this.via_size[via - 1].value / 2.0 + verticalLayer.valueY.value);
                double h2x = this.scaledValue(this.via_size[via - 1].value / 2.0 + horizontalLayer.valueX.value);
                double h2y = this.scaledValue(this.via_size[via - 1].value / 2.0 + horizontalLayer.valueY.value);
                double longX = this.scaledValue(Math.abs(verticalLayer.valueX.value - horizontalLayer.valueX.value));
                double longY = this.scaledValue(Math.abs(verticalLayer.valueY.value - horizontalLayer.valueY.value));
                portNames.clear();
                portNames.add(lx.name);
                portNames.add(ly.name);
                String p = c.prefix == null || c.prefix.equals("") ? "" : c.prefix + "-";
                metalPalette[via - 1].addElement(this.makeXmlPrimitiveCon(t.nodeGroups, p + name, PrimitiveNode.Function.CONTACT, -1.0, -1.0, new SizeOffset(longX, longX, longY, longY), portNames, this.makeXmlNodeLayer(h1x, h1x, h1y, h1y, ly, Poly.Type.FILLED), this.makeXmlNodeLayer(h2x, h2x, h2y, h2y, lx, Poly.Type.FILLED), this.makeXmlMulticut(metalConLayer, metalContSize, spacing, arraySpacing)), c.prefix);
            }
        }
        this.addGenericContacts(t, this.noMultiContacts, extraPaletteList, polysGroup);
        allGroups.addAll(polysGroup);
        for (PaletteGroup g : metalPalette) {
            allGroups.add(g);
        }
        allGroups.addAll(extraPaletteList);
        for (PaletteGroup o : allGroups) {
            t.menuPalette.menuBoxes.add(o.arcs);
            t.menuPalette.menuBoxes.add(o.pins);
            t.menuPalette.menuBoxes.add(o.elements);
        }
        this.makeLayerGDS(t, deviceMarkLayer, String.valueOf(this.marking_layer));
        for (i = 0; i < this.num_metal_layers; ++i) {
            Xml.Layer met = (Xml.Layer)metalLayers.get(i);
            this.makeLayerGDS(t, met, String.valueOf(this.metal_layers[i]));
            if (this.withExtraDummyLayers()) {
                this.makeLayerGDS(t, (Xml.Layer)dummyMetalLayers.get(i), this.metal_layers[i].value + "/1");
                this.makeLayerGDS(t, (Xml.Layer)exclusionMetalLayers.get(i), "150/" + (i + 1));
            }
            if (i > this.num_metal_layers - 2) continue;
            Xml.Layer via = (Xml.Layer)viaLayers.get(i);
            this.makeLayerGDS(t, via, String.valueOf(this.via_layers[i]));
            if (!this.withExtraDummyLayers()) continue;
            this.makeLayerGDS(t, (Xml.Layer)dummyViaLayers.get(i), String.valueOf(this.via_layers[i]) + "/1");
        }
        for (i = 0; i < this.num_metal_layers; ++i) {
            Xml.Layer met = (Xml.Layer)metalLayers.get(i);
            this.makeLayerRuleMinRule(t, met, DRCTemplate.DRCRuleType.MINWID, this.metal_width[i]);
            this.makeLayerRuleMinRule(t, met, DRCTemplate.DRCRuleType.MINAREA, this.metal_minarea[i]);
            this.makeLayerRuleMinRule(t, met, DRCTemplate.DRCRuleType.MINENCLOSEDAREA, this.metal_enclosedarea[i]);
            this.makeLayersRule(t, met, DRCTemplate.DRCRuleType.SPACING, this.metal_spacing[i].rule, this.metal_spacing[i].value);
            if (i >= this.num_metal_layers - 1) continue;
            Xml.Layer via = (Xml.Layer)viaLayers.get(i);
            this.makeLayerRuleMinRule(t, via, DRCTemplate.DRCRuleType.MINWID, this.via_size[i]);
            this.makeLayersRule(t, via, DRCTemplate.DRCRuleType.SPACING, this.via_inline_spacing[i].rule, this.via_inline_spacing[i].value);
        }
        for (WideWizardField w : this.wide_metal_spacing) {
            for (String layerName : w.names) {
                Xml.Layer layer = t.findLayer(layerName);
                assert (layer != null);
                this.makeLayersWideRule(t, layer, DRCTemplate.DRCRuleType.SPACING, w.rule, w.value, w.maxW, w.minLen);
            }
        }
        for (LayerInfo layer : this.extraLayers) {
            Xml.Layer l = t.findLayer(layer.name);
            if (layer.minimum != null) {
                this.makeLayerRuleMinRule(t, l, DRCTemplate.DRCRuleType.MINWID, layer.minimum);
            }
            if (layer.spacing == null) continue;
            this.makeLayersRule(t, l, DRCTemplate.DRCRuleType.SPACING, layer.spacing.rule, layer.spacing.value);
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(new String("Pure"));
        t.menuPalette.menuBoxes.add(l);
        l = new ArrayList();
        l.add(new String("Misc."));
        t.menuPalette.menuBoxes.add(l);
        l = new ArrayList();
        l.add(new String("Cell"));
        t.menuPalette.menuBoxes.add(l);
        int val = t.menuPalette.menuBoxes.size() / 60;
        int rest = t.menuPalette.menuBoxes.size() % 60;
        if (rest != 0) {
            ++val;
        }
        t.menuPalette.numColumns = 3 * val;
        Collections.sort(t.nodeGroups, primitiveNodeGroupSort);
        for (Xml.PrimitiveNodeGroup nodeGroup : t.nodeGroups) {
            Collections.sort(nodeGroup.nodeLayers, nodeLayerSort);
        }
        boolean includeDateAndVersion = User.isIncludeDateAndVersionInOutput();
        String copyrightMessage = IOTool.isUseCopyrightMessage() ? IOTool.getCopyrightMessage() : null;
        t.writeXml(fileName, includeDateAndVersion, copyrightMessage);
    }

    private PrimitiveNode.Function getWellContactFunction(int i) {
        if (i == 0) {
            return this.pSubstrateProcess ? PrimitiveNode.Function.SUBSTRATE : PrimitiveNode.Function.WELL;
        }
        return this.pSubstrateProcess ? PrimitiveNode.Function.WELL : PrimitiveNode.Function.SUBSTRATE;
    }

    private void prepareTransistor(double gateWidth, double gateLength, double polyEndcap, double diffPolyOverhang, double gateContactSpacing, double contactSize, Xml.Layer activeLayer, Xml.Layer polyLayer, Xml.Layer polyGateLayer, List<Xml.NodeLayer> nodesList, List<Xml.PrimitivePort> nodePorts) {
        double impx = this.scaledValue(gateWidth / 2.0);
        double impy = this.scaledValue((gateLength + diffPolyOverhang * 2.0) / 2.0);
        double diffY = this.scaledValue(gateLength / 2.0 + gateContactSpacing + contactSize / 2.0);
        double diffX = 0.0;
        double xSign = 1.0;
        double ySign = -1.0;
        nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, impy, activeLayer, Poly.Type.FILLED, true, false, -1));
        nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, 0.0, activeLayer, Poly.Type.FILLED, false, true, 3));
        nodesList.add(this.makeXmlNodeLayer(impx, impx, 0.0, impy, activeLayer, Poly.Type.FILLED, false, true, 1));
        ArrayList<String> portNames = new ArrayList<String>();
        portNames.add(activeLayer.name);
        Xml.PrimitivePort diffTopPort = this.makeXmlPrimitivePort("diff-top", 90, 90, 1, null, diffX, -1, diffX, 1, diffY, 1, diffY, 1, portNames);
        Xml.PrimitivePort diffBottomPort = this.makeXmlPrimitivePort("diff-bottom", 270, 90, 2, null, xSign * diffX, -1, xSign * diffX, 1, ySign * diffY, -1, ySign * diffY, -1, portNames);
        double gatey = this.scaledValue(gateLength / 2.0);
        double gatex = impx;
        double endPolyx = this.scaledValue((gateWidth + polyEndcap * 2.0) / 2.0);
        double endPolyy = gatey;
        double endLeftOrRight = -impx;
        double endTopOrBotton = endPolyy;
        double polyX = endPolyx;
        double polyY = 0.0;
        nodesList.add(this.makeXmlNodeLayer(gatex, gatex, gatey, gatey, polyGateLayer, Poly.Type.FILLED, false, true, -1));
        nodesList.add(this.makeXmlNodeLayer(endPolyx, endLeftOrRight, endPolyy, endTopOrBotton, polyLayer, Poly.Type.FILLED, false, true, 0));
        nodesList.add(this.makeXmlNodeLayer(endLeftOrRight, endPolyx, endTopOrBotton, endPolyy, polyLayer, Poly.Type.FILLED, false, true, 2));
        nodesList.add(this.makeXmlNodeLayer(endPolyx, endPolyx, endPolyy, endPolyy, polyLayer, Poly.Type.FILLED, true, false, -1));
        portNames.clear();
        portNames.add(polyLayer.name);
        Xml.PrimitivePort polyLeftPort = this.makeXmlPrimitivePort("poly-left", 180, 90, 0, null, ySign * polyX, -1, ySign * polyX, -1, xSign * polyY, -1, xSign * polyY, 1, portNames);
        Xml.PrimitivePort polyRightPort = this.makeXmlPrimitivePort("poly-right", 0, 180, 0, null, polyX, 1, polyX, 1, polyY, -1, polyY, 1, portNames);
        nodePorts.clear();
        nodePorts.add(polyLeftPort);
        nodePorts.add(diffTopPort);
        nodePorts.add(polyRightPort);
        nodePorts.add(diffBottomPort);
    }

    private Xml.ArcLayer makeXmlArcLayer(Xml.Layer layer, WizardField ... flds) {
        Xml.ArcLayer al = new Xml.ArcLayer();
        al.layer = layer.name;
        al.style = Poly.Type.FILLED;
        for (int i = 0; i < flds.length; ++i) {
            al.extend.addLambda(this.scaledValue(flds[i].value / 2.0));
        }
        return al;
    }

    private void makeLayerGDS(Xml.Technology t, Xml.Layer l, String gdsVal) {
        for (Xml.Foundry f2 : t.foundries) {
            f2.layerGds.put(l.name, gdsVal);
        }
    }

    private void makeLayerRuleMinRule(Xml.Technology t, Xml.Layer l, DRCTemplate.DRCRuleType type, WizardField fld) {
        if (fld.value == 0.0) {
            return;
        }
        for (Xml.Foundry f2 : t.foundries) {
            f2.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), type, l.name, null, new double[]{this.scaledValue(fld.value)}, null, null));
        }
    }

    private void makeLayersWideRule(Xml.Technology t, Xml.Layer l, DRCTemplate.DRCRuleType ruleType, String ruleName, double ruleValue, double maxW, double minLen) {
        for (Xml.Foundry f2 : t.foundries) {
            f2.rules.add(new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), ruleType, maxW, minLen, l.name, l.name, new double[]{this.scaledValue(ruleValue)}, -1));
        }
    }

    private void makeLayersRule(Xml.Technology t, Xml.Layer l, DRCTemplate.DRCRuleType ruleType, String ruleName, double ruleValue) {
        for (Xml.Foundry f2 : t.foundries) {
            f2.rules.add(new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), ruleType, l.name, l.name, new double[]{this.scaledValue(ruleValue)}, null, null));
        }
    }

    private void makeLayersRuleSpacing(Xml.Technology t, Xml.Layer l1, Xml.Layer l2, String ruleName, double ruleValue) {
        double value2 = this.scaledValue(ruleValue);
        for (Xml.Foundry f2 : t.foundries) {
            f2.rules.add(new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SPACING, l1.name, l2.name, new double[]{value2, value2}, null, null));
        }
    }

    private void makeLayersRuleSurround(Xml.Technology t, Xml.Layer l1, Xml.Layer l2, String ruleName, double ruleValue) {
        double value2 = this.scaledValue(ruleValue);
        for (Xml.Foundry f2 : t.foundries) {
            f2.rules.add(new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SURROUND, l1.name, l2.name, new double[]{value2, value2}, null, null));
        }
    }

    private double scaledValue(double val) {
        return DBMath.round(val / (double)this.stepsize);
    }

    private void createSecondPolyElements(Xml.Technology t, Map<Xml.Layer, WizardField> layerMap, List<PaletteGroup> polysGroup) {
        int[] nullPattern = new int[]{44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952, 44975, 34952, 64250, 34952};
        EGraphics graph = new EGraphics(true, true, null, 0, 255, 190, 6, 1.0, true, nullPattern);
        Xml.Layer poly2Layer = this.makeXmlLayer(t.layers, layerMap, this.poly2_layer.name, Layer.Function.POLY2, 0, graph, this.poly_width, true, true, new String[0]);
        PaletteGroup poly2Group = new PaletteGroup();
        double ant = (int)Math.round(this.poly_antenna_ratio) | 0xC8;
        poly2Group.addArc(this.makeXmlArc(t, poly2Layer.name, ArcProto.Function.getPoly(2), ant, this.makeXmlArcLayer(poly2Layer, this.poly_width)));
        polysGroup.add(poly2Group);
        double hla = this.scaledValue(this.poly_width.value / 2.0);
        poly2Group.addPinOrResistor(this.makeXmlPrimitivePin(t, poly2Layer.name, hla, null, null, this.makeXmlNodeLayer(hla, hla, hla, hla, poly2Layer, Poly.Type.CROSSED)), null);
    }

    private void createAnalogElements(Xml.Technology t, List<Xml.Layer> metalLayers, List<PaletteGroup> polysGroup) {
        Xml.Layer selectLayer;
        PrimitiveNode.Function func;
        WizardField selectWF;
        double polyNoScaled;
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>();
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        Xml.Layer poly2Layer = t.findLayer(this.poly2_layer.name);
        assert (poly2Layer != null);
        Xml.Layer hiRestLayer = t.findLayer("Hi-Res");
        Xml.Layer polyConLayer = t.findLayer(this.poly_layer.name + "-Cut");
        PaletteGroup g = polysGroup.get(1);
        for (Map.Entry<String, List<Element>> e : this.capacitors.entrySet()) {
            this.addContactsOrCapacitors(t, e.getValue(), metalLayers, null, null, g, true);
        }
        WizardField polyRL = this.findWizardField("hi_poly_resistor_length");
        WizardField poly2Overhang = this.findWizardField("contact_poly2_overhang");
        WizardField hiRestOverhang = this.findWizardField("hi-res_overhang");
        this.addMetalElements(t, polyConLayer, this.contact_array_spacing.value, polyRL, poly2Overhang, nodesList, nodePorts);
        double soxNoScaled = polyNoScaled = 2.0 * poly2Overhang.value + this.contact_size.value;
        double polyL = this.scaledValue(polyRL.value / 2.0 + polyNoScaled);
        double polyWNoScaled = this.scaledValue(this.contact_size.value / 2.0 + poly2Overhang.value);
        double polyW = this.scaledValue(polyWNoScaled);
        nodesList.add(this.makeXmlNodeLayer(polyL, polyL, polyW, polyW, poly2Layer, Poly.Type.FILLED, true, true, 0));
        double hiresL = this.scaledValue(polyRL.value / 2.0 + hiRestOverhang.value);
        double hiresW = this.scaledValue(polyWNoScaled + hiRestOverhang.value);
        nodesList.add(this.makeXmlNodeLayer(hiresL, hiresL, hiresW, hiresW, hiRestLayer, Poly.Type.FILLED, true, true, 0));
        double sox = this.scaledValue(soxNoScaled);
        double soy = this.scaledValue(hiRestOverhang.value);
        Xml.PrimitiveNodeGroup n = this.makeXmlPrimitive(t.nodeGroups, "Hi-Res-Poly2-Resistor", PrimitiveNode.Function.RESHIRESPOLY2, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
        g.addElement(n, "Hi-RPoly2");
        WizardField activeRL = this.findWizardField("active_resistor_length");
        String[] diffNames = new String[]{"P", "N"};
        Xml.Layer activeConLayer = t.findLayer(this.diff_layer.name + "-Cut");
        for (int i = 0; i < 2; ++i) {
            Xml.Layer wellLayer;
            Xml.Layer selectLayer2;
            Xml.Layer activeLayer = t.findLayer(diffNames[i] + "-" + this.diff_layer.name);
            nodesList.clear();
            nodePorts.clear();
            if (i == 0) {
                selectLayer2 = t.findLayer(this.pplus_layer.name);
                selectWF = this.pplus_overhang_diff;
                wellLayer = t.findLayer(this.nwell_layer.name);
                func = PrimitiveNode.Function.RESPACTIVE;
            } else {
                selectLayer2 = t.findLayer(this.nplus_layer.name);
                selectWF = this.nplus_overhang_diff;
                wellLayer = t.findLayer("P-Well");
                func = PrimitiveNode.Function.RESNACTIVE;
            }
            double activeNoScaled = 2.0 * this.diff_contact_overhang.value + this.contact_size.value;
            double activeL = this.scaledValue(activeRL.value / 2.0 + activeNoScaled);
            double activeWNoScaled = this.contact_size.value / 2.0 + this.diff_contact_overhang.value;
            double activeW = this.scaledValue(activeWNoScaled);
            nodesList.add(this.makeXmlNodeLayer(activeL, activeL, activeW, activeW, activeLayer, Poly.Type.FILLED, true, true, 0));
            double selectOverhang = this.scaledValue(selectWF.value);
            double selectL = selectOverhang + activeL;
            double selectW = selectOverhang + activeW;
            nodesList.add(this.makeXmlNodeLayer(selectL, selectL, selectW, selectW, selectLayer2, Poly.Type.FILLED, true, true, 0));
            Xml.NodeLayer wellNodeLayer = null;
            if (!this.getPSubstratelProcess()) {
                double wellOverhang = this.scaledValue(this.nwell_overhang_diff_p.value - selectWF.value);
                double wellL = wellOverhang + selectL;
                double wellW = wellOverhang + selectW;
                wellNodeLayer = this.makeXmlNodeLayer(wellL, wellL, wellW, wellW, wellLayer, Poly.Type.FILLED, true, true, 0);
                nodesList.add(wellNodeLayer);
            }
            this.addMetalElements(t, activeConLayer, this.contact_array_spacing.value, activeRL, this.diff_contact_overhang, nodesList, nodePorts);
            sox = this.scaledValue(this.nwell_overhang_diff_p.value + activeNoScaled);
            soy = this.scaledValue(this.nwell_overhang_diff_p.value);
            n = this.makeXmlPrimitive(t.nodeGroups, diffNames[i] + "-Active-Resistor", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            g.addElement(n, diffNames[i] + "-RActive");
        }
        WizardField wellRL = this.findWizardField("well_resistor_length");
        for (int i = 0; i < 2; ++i) {
            PrimitiveNode.Function func2;
            Xml.Layer wellLayer;
            WizardField selectWF2;
            Xml.Layer activeLayer = t.findLayer(diffNames[i] + "-" + this.diff_layer.name);
            nodesList.clear();
            nodePorts.clear();
            if (i == 0) {
                selectLayer = t.findLayer(this.pplus_layer.name);
                selectWF2 = this.pplus_overhang_diff;
                wellLayer = t.findLayer("P-Well");
                func2 = PrimitiveNode.Function.RESPWELL;
            } else {
                selectLayer = t.findLayer(this.nplus_layer.name);
                selectWF2 = this.nplus_overhang_diff;
                wellLayer = t.findLayer(this.nwell_layer.name);
                func2 = PrimitiveNode.Function.RESNWELL;
            }
            double activeNoScaled = 2.0 * this.diff_contact_overhang.value + this.contact_size.value;
            double activeDistance = this.scaledValue(wellRL.value / 2.0);
            double activeX = this.scaledValue(2.0 * this.diff_contact_overhang.value + this.contact_size.value);
            double activeL = this.scaledValue(wellRL.value / 2.0 + activeNoScaled);
            double activeWNoScaled = this.contact_size.value / 2.0 + this.diff_contact_overhang.value;
            double activeW = this.scaledValue(activeWNoScaled);
            nodesList.add(this.makeXmlNodeLayer(activeDistance + activeX, -1, -activeDistance, -1, activeW, -1, activeW, 1, activeLayer, Poly.Type.FILLED, true, true, 0));
            nodesList.add(this.makeXmlNodeLayer(-activeDistance, 1, activeDistance + activeX, 1, activeW, -1, activeW, 1, activeLayer, Poly.Type.FILLED, true, true, 1));
            double selectOverhang = this.scaledValue(selectWF2.value);
            double selectL = selectOverhang + activeL;
            double selectW = selectOverhang + activeW;
            double selectDistance = activeDistance - this.scaledValue(selectWF2.value);
            double selectX = activeX + 2.0 * selectWF2.value;
            nodesList.add(this.makeXmlNodeLayer(selectDistance + selectX, -1, -selectDistance, -1, selectW, -1, selectW, 1, selectLayer, Poly.Type.FILLED, true, true, 0));
            nodesList.add(this.makeXmlNodeLayer(-selectDistance, 1, selectDistance + selectX, 1, selectW, -1, selectW, 1, selectLayer, Poly.Type.FILLED, true, true, 1));
            Xml.NodeLayer wellNodeLayer = null;
            if (!this.getPSubstratelProcess()) {
                double wellOverhang = this.scaledValue(this.nwell_overhang_diff_n.value - selectWF2.value);
                double wellL = wellOverhang + selectL;
                double wellW = wellOverhang + selectW;
                wellNodeLayer = this.makeXmlNodeLayer(wellL, wellL, wellW, wellW, wellLayer, Poly.Type.FILLED, true, true, 0);
                nodesList.add(wellNodeLayer);
            }
            this.addMetalElements(t, activeConLayer, this.contact_array_spacing.value, wellRL, this.diff_contact_overhang, nodesList, nodePorts);
            sox = this.scaledValue(this.nwell_overhang_diff_n.value) + activeX + selectOverhang;
            soy = 0.0;
            n = this.makeXmlPrimitive(t.nodeGroups, diffNames[i] + "-Well-Resistor", func2, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            g.addElement(n, diffNames[i] + "-RWell");
        }
        polyRL = this.findWizardField("poly_resistor_length");
        Xml.Layer polyLayer = t.findLayer(this.poly_layer.name);
        for (int i = 0; i < 2; ++i) {
            nodesList.clear();
            nodePorts.clear();
            if (i == 0) {
                selectLayer = t.findLayer(this.pplus_layer.name);
                selectWF = this.pplus_overhang_diff;
                func = PrimitiveNode.Function.RESPPOLY;
            } else {
                selectLayer = t.findLayer(this.nplus_layer.name);
                selectWF = this.nplus_overhang_diff;
                func = PrimitiveNode.Function.RESNPOLY;
            }
            polyNoScaled = 2.0 * this.contact_poly_overhang.value + this.contact_size.value;
            polyL = this.scaledValue(polyRL.value / 2.0 + polyNoScaled);
            polyWNoScaled = this.contact_size.value / 2.0 + this.diff_contact_overhang.value;
            polyW = this.scaledValue(polyWNoScaled);
            nodesList.add(this.makeXmlNodeLayer(polyL, polyL, polyW, polyW, polyLayer, Poly.Type.FILLED, true, true, 0));
            double selectOverhang = this.scaledValue(selectWF.value);
            double selectL = selectOverhang + polyL;
            double selectW = selectOverhang + polyW;
            nodesList.add(this.makeXmlNodeLayer(selectL, selectL, selectW, selectW, selectLayer, Poly.Type.FILLED, true, true, 0));
            this.addMetalElements(t, polyConLayer, this.contact_array_spacing.value, polyRL, this.contact_poly_overhang, nodesList, nodePorts);
            sox = this.scaledValue(selectWF.value + polyNoScaled);
            soy = this.scaledValue(selectWF.value);
            n = this.makeXmlPrimitive(t.nodeGroups, diffNames[i] + "-Poly-Resistor", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            g.addElement(n, diffNames[i] + "-RPoly");
        }
        WizardField silicide_overhang = this.findWizardField("silicide_overhang");
        for (int i = 0; i < 2; ++i) {
            WizardField selectWF3;
            Xml.Layer selectLayer3;
            if (i == 0) {
                selectLayer3 = t.findLayer(this.pplus_layer.name);
                selectWF3 = this.pplus_overhang_diff;
                func = PrimitiveNode.Function.RESPNSPOLY;
            } else {
                selectLayer3 = t.findLayer(this.nplus_layer.name);
                selectWF3 = this.nplus_overhang_diff;
                func = PrimitiveNode.Function.RESNNSPOLY;
            }
            nodesList.clear();
            nodePorts.clear();
            polyNoScaled = this.contact_poly_overhang.value + silicide_overhang.value + this.contact_size.value;
            polyL = this.scaledValue(polyRL.value / 2.0 + polyNoScaled);
            polyWNoScaled = this.contact_size.value / 2.0 + this.diff_contact_overhang.value;
            polyW = this.scaledValue(polyWNoScaled);
            nodesList.add(this.makeXmlNodeLayer(polyL, polyL, polyW, polyW, polyLayer, Poly.Type.FILLED, true, true, 0));
            double selectOverhang = this.scaledValue(selectWF3.value);
            double selectL = selectOverhang + polyL;
            double selectW = selectOverhang + polyW;
            nodesList.add(this.makeXmlNodeLayer(selectL, selectL, selectW, selectW, selectLayer3, Poly.Type.FILLED, true, true, 0));
            WizardField len = polyRL;
            if (silicide_overhang.value > this.contact_poly_overhang.value) {
                len = new WizardField(polyRL.value + 2.0 * (silicide_overhang.value - this.contact_poly_overhang.value), "modified polyRL");
            }
            Xml.Layer silicideLayer = t.findLayer(this.marking_layer.name);
            double silicideOverhang = this.scaledValue(silicide_overhang.value);
            double silicideL = this.scaledValue(polyRL.value / 2.0);
            double silicideW = silicideOverhang + selectW;
            nodesList.add(this.makeXmlNodeLayer(silicideL, silicideL, silicideW, silicideW, silicideLayer, Poly.Type.FILLED, true, true, 0));
            this.addMetalElements(t, polyConLayer, this.contact_array_spacing.value, len, this.contact_poly_overhang, nodesList, nodePorts);
            sox = this.scaledValue(selectWF3.value + polyNoScaled);
            soy = this.scaledValue(silicide_overhang.value + selectWF3.value);
            n = this.makeXmlPrimitive(t.nodeGroups, diffNames[i] + "-No-Silicide-Poly-Resistor", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            g.addElement(n, diffNames[i] + "-RNSPoly");
        }
    }

    private void addMetalElements(Xml.Technology t, Xml.Layer conLayer, double spacing, WizardField width, WizardField overhang, List<Xml.NodeLayer> nodesList, List<Xml.PrimitivePort> nodePorts) {
        Xml.Layer m1Layer = t.findLayer(this.getMetalName() + "1");
        ArrayList<String> portNames = new ArrayList<String>();
        portNames.add(m1Layer.name);
        double m1Y = this.scaledValue(this.contact_metal_overhang_all_sides.value + this.contact_size.value / 2.0);
        double m1X = this.scaledValue(2.0 * this.contact_metal_overhang_all_sides.value + this.contact_size.value);
        double m1Distance = this.scaledValue(width.value / 2.0 + overhang.value - this.contact_metal_overhang_all_sides.value);
        nodesList.add(this.makeXmlNodeLayer(m1Distance + m1X, -1, -m1Distance, -1, m1Y, -1, m1Y, 1, m1Layer, Poly.Type.FILLED, true, true, 0));
        nodesList.add(this.makeXmlNodeLayer(-m1Distance, 1, m1Distance + m1X, 1, m1Y, -1, m1Y, 1, m1Layer, Poly.Type.FILLED, true, true, 1));
        double contSize = this.scaledValue(this.contact_size.value);
        double cutSizeHalf = this.scaledValue(this.contact_size.value / 2.0);
        double cutStart = this.scaledValue(width.value / 2.0 + overhang.value);
        Xml.PrimitivePort port = this.makeXmlPrimitivePort("left", 0, 180, 0, null, -(cutStart + contSize), -1, -cutStart, -1, -cutSizeHalf, -1, cutSizeHalf, 1, portNames);
        nodePorts.add(port);
        port = this.makeXmlPrimitivePort("right", 0, 180, 1, null, cutStart, 1, cutStart + contSize, 1, -cutSizeHalf, -1, cutSizeHalf, 1, portNames);
        nodePorts.add(port);
        double cutEnd = this.scaledValue(width.value / 2.0 + overhang.value);
        double cutEndY = 0.0;
        nodesList.add(this.makeXmlMulticut(cutEnd + contSize, -1, -cutEnd, -1, cutEndY, -1, cutEndY, 1, conLayer, contSize, spacing, spacing));
        nodesList.add(this.makeXmlMulticut(-cutEnd, 1, cutEnd + contSize, 1, cutEndY, -1, cutEndY, 1, conLayer, contSize, spacing, spacing));
    }

    private void addStandardLayers(Xml.Technology t, Map<Xml.Layer, WizardField> layerMap, int[] nullPattern, int[] dexclPattern) {
        Color contact_colour = new Color(100, 100, 100);
        Color nplus_colour = new Color(224, 238, 224);
        Color pplus_colour = new Color(224, 224, 120);
        Color nwell_colour = new Color(140, 140, 140);
        EGraphics graph = new EGraphics(false, false, null, 1, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer polyLayer = this.makeXmlLayer(t.layers, layerMap, this.poly_layer.name, Layer.Function.POLY1, 0, graph, this.poly_width, true, true, new String[0]);
        Xml.Layer polyGateLayer = this.makeXmlLayer(t.layers, layerMap, this.poly_layer.name + "Gate", Layer.Function.GATE, 0, graph, this.poly_width, true, false, new String[0]);
        if (this.withExtraDummyLayers()) {
            graph = new EGraphics(true, true, null, 1, 0, 0, 0, 1.0, true, dexclPattern);
            Xml.Layer exclusionPolyLayer = this.makeXmlLayer(t.layers, "DEXCL-" + this.poly_layer.name, Layer.Function.DEXCLPOLY1, 0, graph, 2.0 * this.poly_width.value, true, false, new String[0]);
            this.makeLayerGDS(t, exclusionPolyLayer, "150/21");
        }
        graph = new EGraphics(false, false, null, 0, contact_colour.getRed(), contact_colour.getGreen(), contact_colour.getBlue(), 0.5, true, nullPattern);
        Xml.Layer polyConLayer = this.makeXmlLayer(t.layers, layerMap, "Poly-Cut", Layer.Function.CONTACT1, 32768, graph, this.contact_size, true, false, new String[0]);
        Xml.Layer diffConLayer = this.makeXmlLayer(t.layers, layerMap, this.diff_layer.name + "-Cut", Layer.Function.CONTACT1, 65536, graph, this.contact_size, true, false, new String[0]);
        graph = new EGraphics(false, false, null, 2, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer diffNLayer = this.makeXmlLayer(t.layers, layerMap, "N-" + this.diff_layer.name, Layer.Function.DIFFN, 0, graph, this.diff_width, true, true, "N-" + this.diff_layer.name, "N-Well", "S-N-Well");
        Xml.Layer diffPLayer = this.makeXmlLayer(t.layers, layerMap, "P-" + this.diff_layer.name, Layer.Function.DIFFP, 0, graph, this.diff_width, true, true, "P-" + this.diff_layer.name, "P-Well", "S-P-Well");
        int[] patternSlash = new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056};
        int[] patternBackSlash = new int[]{514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028};
        int[] patternDots = new int[]{514, 0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0};
        int[] patternDotsShift = new int[]{0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0, 514, 0, 8224, 0, 514};
        graph = new EGraphics(true, true, null, 0, nplus_colour.getRed(), nplus_colour.getGreen(), nplus_colour.getBlue(), 1.0, true, patternSlash);
        Xml.Layer nplusLayer = this.makeXmlLayer(t.layers, layerMap, this.nplus_layer.name, Layer.Function.IMPLANTN, 0, graph, this.nplus_width, true, false, new String[0]);
        graph = new EGraphics(true, true, null, 0, pplus_colour.getRed(), pplus_colour.getGreen(), pplus_colour.getBlue(), 1.0, true, patternDots);
        Xml.Layer pplusLayer = this.makeXmlLayer(t.layers, layerMap, this.pplus_layer.name, Layer.Function.IMPLANTP, 0, graph, this.pplus_width, true, false, new String[0]);
        graph = new EGraphics(true, true, null, 0, nwell_colour.getRed(), nwell_colour.getGreen(), nwell_colour.getBlue(), 1.0, true, patternDotsShift);
        Xml.Layer nwellLayer = this.makeXmlLayer(t.layers, layerMap, this.nwell_layer.name, Layer.Function.WELLN, 0, graph, this.nwell_width, true, false, new String[0]);
        graph = new EGraphics(true, true, null, 0, nwell_colour.getRed(), nwell_colour.getGreen(), nwell_colour.getBlue(), 1.0, true, patternBackSlash);
        Xml.Layer pwellLayer = this.makeXmlLayer(t.layers, layerMap, "P-Well", Layer.Function.WELLP, 0, graph, this.nwell_width, true, false, new String[0]);
    }

    private void addStandardElements(Xml.Technology t, Map<Xml.Layer, WizardField> layerMap, List<Xml.Layer> metalLayers, List<PaletteGroup> allGroups, List<PaletteGroup> polysGroup) {
        Xml.Layer[] polys;
        Xml.Layer[] wells;
        double ant = (int)Math.round(this.poly_antenna_ratio) | 0xC8;
        PaletteGroup polyGroup = new PaletteGroup();
        polysGroup.add(polyGroup);
        ArrayList<String> portNames = new ArrayList<String>();
        Xml.Layer polyLayer = t.findLayer(this.poly_layer.name);
        Xml.Layer polyGateLayer = t.findLayer(this.poly_layer.name + "Gate");
        Xml.Layer polyConLayer = t.findLayer("Poly-Cut");
        Xml.Layer diffConLayer = t.findLayer(this.diff_layer.name + "-Cut");
        Xml.Layer nwellLayer = t.findLayer(this.nwell_layer.name);
        Xml.Layer pwellLayer = t.findLayer("P-Well");
        Xml.Layer nplusLayer = t.findLayer(this.nplus_layer.name);
        Xml.Layer pplusLayer = t.findLayer(this.pplus_layer.name);
        Xml.Layer diffNLayer = t.findLayer("N-" + this.diff_layer.name);
        Xml.Layer diffPLayer = t.findLayer("P-" + this.diff_layer.name);
        polyGroup.addArc(this.makeXmlArc(t, polyLayer.name, ArcProto.Function.getPoly(1), ant, this.makeXmlArcLayer(polyLayer, this.poly_width)));
        double hla = this.scaledValue(this.poly_width.value / 2.0);
        polyGroup.addPinOrResistor(this.makeXmlPrimitivePin(t, polyLayer.name, hla, null, null, this.makeXmlNodeLayer(hla, hla, hla, hla, polyLayer, Poly.Type.CROSSED)), null);
        if (this.getSecondPolyFlag()) {
            this.createSecondPolyElements(t, layerMap, polysGroup);
        }
        if (this.getAnalogFlag()) {
            this.createAnalogElements(t, metalLayers, polysGroup);
        }
        Xml.Layer m1Layer = metalLayers.get(0);
        portNames.clear();
        portNames.add(polyLayer.name);
        portNames.add(m1Layer.name);
        hla = this.scaledValue(this.contact_size.value / 2.0 + this.contact_poly_overhang.value);
        double contSize = this.scaledValue(this.contact_size.value);
        double contSpacing = this.scaledValue(this.contact_spacing.value);
        double contArraySpacing = this.scaledValue(this.contact_array_spacing.value);
        double metal1Over = this.scaledValue(this.contact_size.value / 2.0 + this.contact_metal_overhang_all_sides.value);
        if (!this.isComplexCase()) {
            if (this.via_overhang.length > 0) {
                polyGroup.addElement(this.makeContactSeries(t.nodeGroups, polyLayer.name, contSize, polyConLayer, contSpacing, contArraySpacing, this.scaledValue(this.contact_poly_overhang.value), polyLayer, this.scaledValue(this.via_overhang[0].value), m1Layer), null);
            } else {
                System.out.println("Not via 0 layer");
            }
        }
        PaletteGroup[] diffPalette = new PaletteGroup[]{new PaletteGroup(), new PaletteGroup()};
        PaletteGroup[] wellPalette = new PaletteGroup[]{new PaletteGroup(), new PaletteGroup()};
        hla = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value);
        double nsel = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.nplus_overhang_diff.value);
        double psel = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.pplus_overhang_diff.value);
        double nwell = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.nwell_overhang_diff_p.value);
        double nso = this.scaledValue(this.nwell_overhang_diff_p.value);
        double pso = !this.pSubstrateProcess ? nso : this.scaledValue(this.nplus_overhang_diff.value);
        String[] diffNames = new String[]{"P", "N"};
        double[] sos = new double[]{nso, pso};
        double[] sels = new double[]{psel, nsel};
        Xml.Layer[] diffLayers = new Xml.Layer[]{diffPLayer, diffNLayer};
        Xml.Layer[] plusLayers = new Xml.Layer[]{pplusLayer, nplusLayer};
        for (Map.Entry<String, List<Element>> e : this.otherContacts.entrySet()) {
            this.addContactsOrCapacitors(t, e.getValue(), metalLayers, diffPalette, wellPalette, polyGroup, false);
        }
        for (int i = 0; i < 2; ++i) {
            WizardField arcVal;
            Xml.ArcLayer arcL;
            ArcProto.Function arcF;
            Xml.NodeLayer wellNode;
            Xml.NodeLayer wellNodePin;
            portNames.clear();
            portNames.add(diffLayers[i].name);
            portNames.add(m1Layer.name);
            String composeName = diffNames[i] + "-" + this.diff_layer.name;
            if (i == 0) {
                wellNodePin = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.CROSSED);
                wellNode = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED);
                arcF = ArcProto.Function.DIFFP;
                arcL = this.makeXmlArcLayer(nwellLayer, this.diff_width, this.nwell_overhang_diff_p);
                arcVal = this.pplus_overhang_diff;
            } else {
                wellNodePin = !this.pSubstrateProcess ? this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.CROSSED) : null;
                wellNode = !this.pSubstrateProcess ? this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.FILLED) : null;
                arcF = ArcProto.Function.DIFFN;
                arcL = !this.pSubstrateProcess ? this.makeXmlArcLayer(pwellLayer, this.diff_width, this.nwell_overhang_diff_p) : null;
                arcVal = this.nplus_overhang_diff;
            }
            PaletteGroup diffG = diffPalette[i];
            diffG.addArc(this.makeXmlArc(t, composeName, arcF, 0.0, this.makeXmlArcLayer(diffLayers[i], this.diff_width), this.makeXmlArcLayer(plusLayers[i], this.diff_width, arcVal), arcL));
            diffG.addPinOrResistor(this.makeXmlPrimitivePin(t, composeName, hla, new SizeOffset(sos[i], sos[i], sos[i], sos[i]), null, this.makeXmlNodeLayer(hla, hla, hla, hla, diffLayers[i], Poly.Type.CROSSED), this.makeXmlNodeLayer(sels[i], sels[i], sels[i], sels[i], plusLayers[i], Poly.Type.CROSSED), wellNodePin), null);
            diffG.addElement(this.makeXmlPrimitiveCon(t.nodeGroups, "F-" + composeName, PrimitiveNode.Function.CONTACT, hla, hla, new SizeOffset(sos[i], sos[i], sos[i], sos[i]), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED), this.makeXmlNodeLayer(hla, hla, hla, hla, diffLayers[i], Poly.Type.FILLED), this.makeXmlNodeLayer(sels[i], sels[i], sels[i], sels[i], plusLayers[i], Poly.Type.FILLED), wellNode, this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing)), "Full-" + diffNames[i]);
        }
        nwell = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.nwell_overhang_diff_n.value);
        nso = this.scaledValue(this.nwell_overhang_diff_n.value);
        pso = !this.pSubstrateProcess ? nso : this.scaledValue(this.pplus_overhang_strap.value);
        double[] wellSos = new double[]{pso, nso};
        Xml.Layer[] wellLayers = new Xml.Layer[]{pwellLayer, nwellLayer};
        double nselW = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.nplus_overhang_strap.value);
        double pselW = this.scaledValue(this.contact_size.value / 2.0 + this.diff_contact_overhang.value + this.pplus_overhang_strap.value);
        double[] wellSels = new double[]{pselW, nselW};
        for (int i = 0; i < 2; ++i) {
            WizardField arcVal;
            Xml.ArcLayer arcL;
            String composeName = diffNames[i] + "-Well";
            Xml.NodeLayer wellNodeLayer = null;
            Xml.NodeLayer wellNodePinLayer = null;
            PaletteGroup g = wellPalette[i];
            PrimitiveNode.Function func = this.getWellContactFunction(i);
            portNames.clear();
            if (i == 0) {
                if (!this.pSubstrateProcess) {
                    wellNodePinLayer = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.CROSSED);
                    wellNodeLayer = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.FILLED);
                }
                portNames.add(pwellLayer.name);
                arcL = !this.pSubstrateProcess ? this.makeXmlArcLayer(pwellLayer, this.diff_width, this.nwell_overhang_diff_p) : null;
                arcVal = this.pplus_overhang_diff;
            } else {
                portNames.add(nwellLayer.name);
                wellNodePinLayer = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.CROSSED);
                wellNodeLayer = this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED);
                arcL = this.makeXmlArcLayer(nwellLayer, this.diff_width, this.nwell_overhang_diff_p);
                arcVal = this.nplus_overhang_diff;
            }
            portNames.add(m1Layer.name);
            g.addArc(this.makeXmlArc(t, composeName, ArcProto.Function.WELL, 0.0, this.makeXmlArcLayer(diffLayers[i], this.diff_width), this.makeXmlArcLayer(plusLayers[i], this.diff_width, arcVal), arcL));
            g.addArc(this.makeXmlArc(t, "S-" + composeName, ArcProto.Function.WELL, 0.0, this.makeXmlArcLayer(wellLayers[i], this.diff_width, this.nwell_overhang_diff_p)));
            ArrayList<String> arcNames = new ArrayList<String>();
            arcNames.add(composeName);
            arcNames.add("S-" + composeName);
            g.addPinOrResistor(this.makeXmlPrimitivePin(t, composeName, hla, new SizeOffset(wellSos[i], wellSos[i], wellSos[i], wellSos[i]), arcNames, this.makeXmlNodeLayer(hla, hla, hla, hla, diffLayers[i], Poly.Type.CROSSED), this.makeXmlNodeLayer(sels[i], sels[i], sels[i], sels[i], plusLayers[i], Poly.Type.CROSSED), wellNodePinLayer), null);
            g.addElement(this.makeXmlPrimitiveCon(t.nodeGroups, "F-" + composeName, func, hla, hla, new SizeOffset(wellSos[i], wellSos[i], wellSos[i], wellSos[i]), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED), this.makeXmlNodeLayer(hla, hla, hla, hla, diffLayers[i], Poly.Type.FILLED), this.makeXmlNodeLayer(wellSels[i], wellSels[i], wellSels[i], wellSels[i], plusLayers[i], Poly.Type.FILLED), wellNodeLayer, this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing)), "Full-" + diffNames[i] + "W");
        }
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>();
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        EPoint minFullSize = null;
        PaletteGroup[] transPalette = new PaletteGroup[2];
        for (int i = 0; i < 2; ++i) {
            PrimitiveNode.Function wrFunc;
            Xml.Layer selectLayer;
            Xml.Layer activeLayer;
            String name;
            PaletteGroup paletteGroup;
            double selecty = 0.0;
            double selectx = 0.0;
            Xml.Layer wellLayer = null;
            double sox = 0.0;
            double soy = 0.0;
            double impx = this.scaledValue(this.gate_width.value / 2.0);
            double impy = this.scaledValue((this.gate_length.value + this.diff_poly_overhang.value * 2.0) / 2.0);
            double nwell_overhangX = 0.0;
            double nwell_overhangY = 0.0;
            transPalette[i] = paletteGroup = new PaletteGroup();
            double protectDist = this.scaledValue(this.poly_protection_spacing.value);
            double extraSelX = 0.0;
            double extraSelY = 0.0;
            PrimitiveNode.Function func = null;
            PrimitiveNode.Function prFunc = null;
            if (i == 0) {
                name = "P";
                nwell_overhangY = nwell_overhangX = this.nwell_overhang_diff_n.value;
                wellLayer = nwellLayer;
                activeLayer = diffPLayer;
                selectLayer = pplusLayer;
                extraSelX = this.pplus_overhang_poly.value;
                extraSelY = this.pplus_overhang_diff.value;
                func = PrimitiveNode.Function.TRAPMOS;
                prFunc = PrimitiveNode.Function.RESPPOLY;
                wrFunc = PrimitiveNode.Function.RESPWELL;
            } else {
                name = "N";
                activeLayer = diffNLayer;
                selectLayer = nplusLayer;
                extraSelX = this.nplus_overhang_poly.value;
                extraSelY = this.nplus_overhang_diff.value;
                func = PrimitiveNode.Function.TRANMOS;
                prFunc = PrimitiveNode.Function.RESNPOLY;
                wrFunc = PrimitiveNode.Function.RESNWELL;
                if (!this.pSubstrateProcess) {
                    nwell_overhangY = nwell_overhangX = this.nwell_overhang_diff_p.value;
                    wellLayer = pwellLayer;
                } else {
                    nwell_overhangX = this.poly_endcap.value + extraSelX;
                    nwell_overhangY = extraSelY;
                }
            }
            selectx = this.scaledValue(this.gate_width.value / 2.0 + this.poly_endcap.value + extraSelX);
            selecty = this.scaledValue(this.gate_length.value / 2.0 + this.diff_poly_overhang.value + extraSelY);
            double wellx = this.scaledValue(this.gate_width.value / 2.0 + nwell_overhangX);
            double welly = this.scaledValue(this.gate_length.value / 2.0 + this.diff_poly_overhang.value + nwell_overhangY);
            sox = this.scaledValue(nwell_overhangX);
            soy = this.scaledValue(this.diff_poly_overhang.value + nwell_overhangY);
            if (DBMath.isLessThan(wellx, selectx)) {
                sox = this.scaledValue(this.poly_endcap.value + extraSelX);
                wellx = selectx;
            }
            if (DBMath.isLessThan(welly, selecty)) {
                soy = this.scaledValue(this.diff_poly_overhang.value + extraSelY);
                welly = selecty;
            }
            nodesList.clear();
            nodePorts.clear();
            portNames.clear();
            double gatey = this.scaledValue(this.gate_length.value / 2.0);
            double gatex = impx;
            double endPolyx = this.scaledValue((this.gate_width.value + this.poly_endcap.value * 2.0) / 2.0);
            double endPolyy = gatey;
            double endLeftOrRight = -impx;
            double endTopOrBotton = endPolyy;
            double diffX = 0.0;
            double diffY = this.scaledValue(this.gate_length.value / 2.0 + this.gate_contact_spacing.value + this.contact_size.value / 2.0);
            double xSign = 1.0;
            double ySign = -1.0;
            double polyX = endPolyx;
            double polyY = 0.0;
            if (!this.horizontalFlag) {
                double tmp = impx;
                impx = impy;
                impy = tmp;
                tmp = wellx;
                wellx = welly;
                welly = tmp;
                tmp = sox;
                sox = soy;
                soy = tmp;
                tmp = selectx;
                selectx = selecty;
                selecty = tmp;
                tmp = gatex;
                gatex = gatey;
                gatey = tmp;
                tmp = endPolyx;
                endPolyx = endPolyy;
                endPolyy = tmp;
                tmp = diffX;
                diffX = diffY;
                diffY = tmp;
                tmp = polyX;
                polyX = polyY;
                polyY = tmp;
                tmp = xSign;
                xSign = ySign;
                ySign = tmp;
                endLeftOrRight = endPolyx;
                endTopOrBotton = -impx;
            }
            Xml.NodeLayer xTranWellLayer = null;
            if (wellLayer != null) {
                xTranWellLayer = this.makeXmlNodeLayer(wellx, wellx, welly, welly, wellLayer, Poly.Type.FILLED);
                nodesList.add(xTranWellLayer);
            }
            nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, impy, activeLayer, Poly.Type.FILLED, true, false, -1));
            nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, 0.0, activeLayer, Poly.Type.FILLED, false, true, 3));
            nodesList.add(this.makeXmlNodeLayer(impx, impx, 0.0, impy, activeLayer, Poly.Type.FILLED, false, true, 1));
            portNames.clear();
            portNames.add(activeLayer.name);
            Xml.PrimitivePort diffTopPort = this.makeXmlPrimitivePort("diff-top", 90, 90, 1, minFullSize, diffX, -1, diffX, 1, diffY, 1, diffY, 1, portNames);
            Xml.PrimitivePort diffBottomPort = this.makeXmlPrimitivePort("diff-bottom", 270, 90, 2, minFullSize, xSign * diffX, -1, xSign * diffX, 1, ySign * diffY, -1, ySign * diffY, -1, portNames);
            nodesList.add(this.makeXmlNodeLayer(gatex, gatex, gatey, gatey, polyGateLayer, Poly.Type.FILLED, false, true, -1));
            nodesList.add(this.makeXmlNodeLayer(endPolyx, endLeftOrRight, endPolyy, endTopOrBotton, polyLayer, Poly.Type.FILLED, false, true, 0));
            nodesList.add(this.makeXmlNodeLayer(endLeftOrRight, endPolyx, endTopOrBotton, endPolyy, polyLayer, Poly.Type.FILLED, false, true, 2));
            nodesList.add(this.makeXmlNodeLayer(endPolyx, endPolyx, endPolyy, endPolyy, polyLayer, Poly.Type.FILLED, true, false, -1));
            portNames.clear();
            portNames.add(polyLayer.name);
            Xml.PrimitivePort polyLeftPort = this.makeXmlPrimitivePort("poly-left", 180, 90, 0, minFullSize, ySign * polyX, -1, ySign * polyX, -1, xSign * polyY, -1, xSign * polyY, 1, portNames);
            Xml.PrimitivePort polyRightPort = this.makeXmlPrimitivePort("poly-right", 0, 180, 0, minFullSize, polyX, 1, polyX, 1, polyY, -1, polyY, 1, portNames);
            Xml.NodeLayer xTranSelLayer = this.makeXmlNodeLayer(selectx, selectx, selecty, selecty, selectLayer, Poly.Type.FILLED);
            nodesList.add(xTranSelLayer);
            nodePorts.add(polyLeftPort);
            nodePorts.add(diffTopPort);
            nodePorts.add(polyRightPort);
            nodePorts.add(diffBottomPort);
            Xml.PrimitiveNodeGroup n = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, name);
            if (!this.withExtraTransistors()) continue;
            nodesList.remove(xTranSelLayer);
            double shortSelectX = this.scaledValue(this.gate_width.value / 2.0 + this.poly_endcap.value);
            xTranSelLayer = this.makeXmlNodeLayer(shortSelectX, shortSelectX, selecty, selecty, selectLayer, Poly.Type.FILLED);
            nodesList.add(xTranSelLayer);
            double shortSox = sox;
            shortSox = this.scaledValue(this.poly_endcap.value);
            if (wellLayer != null) {
                nodesList.remove(xTranWellLayer);
                xTranWellLayer = this.makeXmlNodeLayer(shortSelectX, shortSelectX, welly, welly, wellLayer, Poly.Type.FILLED);
                nodesList.add(xTranWellLayer);
            }
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(shortSox, shortSox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, name + "-S");
            double vthlx = this.scaledValue(this.gate_width.value / 2.0 + this.vthl_diff_overhang.value);
            double vthly = this.scaledValue(this.gate_length.value / 2.0 + this.vthl_poly_overhang.value);
            String tmp = "VTH-" + name;
            Xml.NodeLayer nl = this.addXmlNodeLayer(nodesList, t, tmp, vthlx, vthly);
            n = this.makeXmlPrimitive(t.nodeGroups, tmp + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(shortSox, shortSox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, tmp + "-S");
            nodesList.remove(nl);
            tmp = "VTL-" + name;
            nl = this.addXmlNodeLayer(nodesList, t, tmp, vthlx, vthly);
            n = this.makeXmlPrimitive(t.nodeGroups, tmp + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(shortSox, shortSox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, tmp + "-S");
            nodesList.remove(xTranSelLayer);
            double endOfProtectionY = this.gate_length.value + this.poly_protection_spacing.value;
            double selectExtraY = this.scaledValue(this.gate_length.value / 2.0 + endOfProtectionY + extraSelX);
            xTranSelLayer = this.makeXmlNodeLayer(selectx, selectx, selectExtraY, selectExtraY, selectLayer, Poly.Type.FILLED);
            nodesList.add(xTranSelLayer);
            if (DBMath.isLessThan(welly, selectExtraY)) {
                welly = selectExtraY;
                soy = this.scaledValue(endOfProtectionY + extraSelX);
            }
            if (wellLayer != null) {
                nodesList.remove(xTranWellLayer);
                xTranWellLayer = this.makeXmlNodeLayer(wellx, wellx, welly, welly, wellLayer, Poly.Type.FILLED);
                nodesList.add(xTranWellLayer);
            }
            if (!this.horizontalFlag) {
                System.out.println("Not working with !horizontal");
                assert (false);
            }
            portNames.clear();
            portNames.add(polyLayer.name);
            Xml.NodeLayer bOrL = this.makeXmlNodeLayer(gatex, gatex, DBMath.round(protectDist + 3.0 * endPolyy), -DBMath.round(endPolyy + protectDist), polyLayer, Poly.Type.FILLED, true, false, -1);
            nodesList.add(bOrL);
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor-B", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, name + "-B");
            Xml.NodeLayer tOrR = this.makeXmlNodeLayer(gatex, gatex, -DBMath.round(endPolyy + protectDist), DBMath.round(protectDist + 3.0 * endPolyy), polyLayer, Poly.Type.FILLED, true, false, -1);
            nodesList.add(tOrR);
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor-TB", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, name + "-TB");
            nodesList.remove(bOrL);
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor-T", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, name + "-T");
            double od18x = this.scaledValue(this.gate_od18_width.value / 2.0 + this.od18_diff_overhang[0].value);
            double od18y = this.scaledValue(this.gate_od18_length.value / 2.0 + this.diff_poly_overhang.value + this.od18_diff_overhang[1].value);
            nodePorts.clear();
            nodesList.clear();
            this.prepareTransistor(this.gate_od18_width.value, this.gate_od18_length.value, this.poly_endcap.value, this.diff_poly_overhang.value, this.gate_contact_spacing.value, this.contact_size.value, activeLayer, polyLayer, polyGateLayer, nodesList, nodePorts);
            this.addXmlNodeLayer(nodesList, t, "OD_18", od18x, od18y);
            shortSelectX = this.scaledValue(this.gate_od18_width.value / 2.0 + this.poly_endcap.value);
            selecty = this.scaledValue(this.gate_od18_length.value / 2.0 + this.diff_poly_overhang.value + extraSelY);
            xTranSelLayer = this.makeXmlNodeLayer(shortSelectX, shortSelectX, selecty, selecty, selectLayer, Poly.Type.FILLED);
            nodesList.add(xTranSelLayer);
            if (wellLayer != null) {
                xTranWellLayer = this.makeXmlNodeLayer(od18x, od18x, od18y, od18y, wellLayer, Poly.Type.FILLED);
                nodesList.add(xTranWellLayer);
            }
            sox = this.scaledValue(this.od18_diff_overhang[0].value);
            soy = this.scaledValue(this.diff_poly_overhang.value + this.od18_diff_overhang[1].value);
            n = this.makeXmlPrimitive(t.nodeGroups, "OD18-" + name + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, "18-" + name + "-S");
            WizardField gateOD18ud1Len = this.findWizardField("gate_od18ud15_length");
            nodePorts.clear();
            nodesList.clear();
            this.prepareTransistor(this.gate_od18_width.value, gateOD18ud1Len.value, this.poly_endcap.value, this.diff_poly_overhang.value, this.gate_contact_spacing.value, this.contact_size.value, activeLayer, polyLayer, polyGateLayer, nodesList, nodePorts);
            od18y = this.scaledValue(gateOD18ud1Len.value / 2.0 + this.diff_poly_overhang.value + this.od18_diff_overhang[1].value);
            this.addXmlNodeLayer(nodesList, t, "OD_18", od18x, od18y);
            WizardRuleFields od18ud15DifOverhang = this.findWizardRuleFields("od18u15_diff_overhang");
            double od18du15x = this.scaledValue(this.gate_od18_width.value / 2.0 + od18ud15DifOverhang.xValue.value);
            double od18du15y = this.scaledValue(gateOD18ud1Len.value / 2.0 + this.diff_poly_overhang.value + od18ud15DifOverhang.yValue.value);
            this.addXmlNodeLayer(nodesList, t, "OD_18ud15", od18du15x, od18du15y);
            shortSelectX = this.scaledValue(this.gate_od18_width.value / 2.0 + this.poly_endcap.value);
            selecty = this.scaledValue(gateOD18ud1Len.value / 2.0 + this.diff_poly_overhang.value + extraSelY);
            xTranSelLayer = this.makeXmlNodeLayer(shortSelectX, shortSelectX, selecty, selecty, selectLayer, Poly.Type.FILLED);
            nodesList.add(xTranSelLayer);
            double wellX = od18x;
            double wellY = od18y;
            double biggerX = this.od18_diff_overhang[0].value;
            double biggerY = this.od18_diff_overhang[1].value;
            if (DBMath.isGreaterThan(od18ud15DifOverhang.xValue.value, this.od18_diff_overhang[0].value)) {
                wellX = od18du15x;
                biggerX = od18ud15DifOverhang.xValue.value;
            }
            if (DBMath.isGreaterThan(od18ud15DifOverhang.yValue.value, this.od18_diff_overhang[1].value)) {
                wellY = od18du15y;
                biggerY = od18ud15DifOverhang.yValue.value;
            }
            if (wellLayer != null) {
                xTranWellLayer = this.makeXmlNodeLayer(wellX, wellX, wellY, wellY, wellLayer, Poly.Type.FILLED);
                nodesList.add(xTranWellLayer);
            }
            sox = this.scaledValue(biggerX);
            soy = this.scaledValue(this.diff_poly_overhang.value + biggerY);
            n = this.makeXmlPrimitive(t.nodeGroups, "OD18ud15-" + name + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addElement(n, "18ud15-" + name + "-S");
            if (i == 1) {
                double ntx = this.scaledValue(this.gate_nt_width.value / 2.0 + this.nt_diff_overhang.value);
                double nty = this.scaledValue(this.gate_nt_length.value / 2.0 + this.diff_poly_overhang.value + this.nt_diff_overhang.value);
                nodePorts.clear();
                nodesList.clear();
                this.prepareTransistor(this.gate_nt_width.value, this.gate_nt_length.value, this.poly_nt_endcap.value, this.diff_poly_overhang.value, this.gate_contact_spacing.value, this.contact_size.value, activeLayer, polyLayer, polyGateLayer, nodesList, nodePorts);
                this.addXmlNodeLayer(nodesList, t, "NT-N", ntx, nty);
                shortSelectX = this.scaledValue(this.gate_nt_width.value / 2.0 + this.poly_nt_endcap.value);
                selecty = this.scaledValue(this.gate_nt_length.value / 2.0 + this.diff_poly_overhang.value + extraSelY);
                xTranSelLayer = this.makeXmlNodeLayer(shortSelectX, shortSelectX, selecty, selecty, selectLayer, Poly.Type.FILLED);
                nodesList.add(xTranSelLayer);
                if (wellLayer != null) {
                    xTranWellLayer = this.makeXmlNodeLayer(ntx, ntx, nty, nty, wellLayer, Poly.Type.FILLED);
                    nodesList.add(xTranWellLayer);
                }
                sox = this.scaledValue(this.poly_nt_endcap.value);
                soy = this.scaledValue(this.diff_poly_overhang.value + this.nt_diff_overhang.value);
                n = this.makeXmlPrimitive(t.nodeGroups, "NT-" + name + "-Transistor-S", func, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
                paletteGroup.addElement(n, "NT-" + name + "-S");
            }
            nodesList.clear();
            nodePorts.clear();
            WizardField polyRL = this.findWizardField("poly_resistor_length");
            WizardField polyRW = this.findWizardField("poly_resistor_width");
            WizardField rpoS = this.findWizardField("rpo_contact_spacing");
            WizardField rpoODPolyEx = this.findWizardField("rpo_odpoly_overhang");
            WizardField rhOverhang = this.findWizardField("rh_odpoly_overhang");
            double resistorSpacing = this.contact_array_spacing.value;
            double soxNoScaled = rpoS.value + this.contact_poly_overhang.value + resistorSpacing + 2.0 * this.contact_size.value;
            double halfTotalL = this.scaledValue(polyRL.value / 2.0 + soxNoScaled);
            double halfTotalW = this.scaledValue(polyRW.value / 2.0);
            nodesList.add(this.makeXmlNodeLayer(halfTotalL, halfTotalL, halfTotalW, halfTotalW, polyLayer, Poly.Type.FILLED, true, true, -1));
            double rpoY = this.scaledValue(polyRW.value / 2.0 + rpoODPolyEx.value);
            double rpoX = this.scaledValue(polyRL.value / 2.0);
            Xml.Layer rpoLayer = t.findLayer("RPO");
            this.addXmlNodeLayerInternal(nodesList, t, "RPO", rpoX, rpoY, true, true, -1);
            double cutDistance = this.scaledValue(rpoS.value + polyRL.value / 2.0);
            double m1Distance = cutDistance - this.scaledValue(this.contact_poly_overhang.value);
            double m1Y = this.scaledValue(polyRW.value / 2.0);
            double m1W = this.scaledValue(2.0 * this.contact_poly_overhang.value + resistorSpacing + 2.0 * this.contact_size.value);
            double cutSizeHalf = this.scaledValue(this.contact_size.value / 2.0);
            double cutEnd = cutDistance + contSize;
            double cutSpacing = this.scaledValue(resistorSpacing);
            double cutEnd2 = cutEnd + contSize + cutSpacing;
            portNames.clear();
            portNames.add(m1Layer.name);
            Xml.PrimitivePort port = this.makeXmlPrimitivePort("left-rpo", 0, 180, 0, minFullSize, -(cutEnd + cutSpacing), -1, -cutEnd, -1, -cutSizeHalf, -1, cutSizeHalf, 1, portNames);
            nodePorts.add(port);
            port = this.makeXmlPrimitivePort("right-rpo", 0, 180, 1, minFullSize, cutEnd, 1, cutEnd + cutSpacing, 1, -cutSizeHalf, -1, cutSizeHalf, 1, portNames);
            nodePorts.add(port);
            nodesList.add(this.makeXmlNodeLayer(m1Distance + m1W, -1, -m1Distance, -1, m1Y, -1, m1Y, 1, m1Layer, Poly.Type.FILLED, true, true, 0));
            nodesList.add(this.makeXmlNodeLayer(-m1Distance, 1, m1Distance + m1W, 1, m1Y, -1, m1Y, 1, m1Layer, Poly.Type.FILLED, true, true, 1));
            double selectY = this.scaledValue(polyRW.value / 2.0 + rhOverhang.value);
            double selectX = this.scaledValue(polyRL.value / 2.0 + soxNoScaled + extraSelX);
            nodesList.add(this.makeXmlNodeLayer(selectX, selectX, selectY, selectY, selectLayer, Poly.Type.FILLED, true, true, -1));
            this.addXmlNodeLayerInternal(nodesList, t, "RH", selectX, selectY, true, true, -1);
            this.addXmlNodeLayerInternal(nodesList, t, "RPDMY", selectX, selectY, true, true, -1);
            nodesList.add(this.makeXmlMulticut(cutEnd2, -1, -cutDistance, -1, cutSizeHalf, -1, cutSizeHalf, 1, polyConLayer, contSize, contArraySpacing, contArraySpacing));
            nodesList.add(this.makeXmlMulticut(-cutDistance, 1, cutEnd2, 1, cutSizeHalf, -1, cutSizeHalf, 1, polyConLayer, contSize, contArraySpacing, contArraySpacing));
            sox = this.scaledValue(soxNoScaled + extraSelX);
            soy = this.scaledValue(rpoODPolyEx.value);
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Poly-RPO-Resistor", prFunc, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addPinOrResistor(n, name + "-RPoly");
            nodesList.clear();
            nodePorts.clear();
            WizardField wellRL = this.findWizardField("well_resistor_length");
            WizardField wellRW = this.findWizardField("well_resistor_width");
            WizardField rpoSelO = this.findWizardField("rpo_select_overlap");
            WizardField rpoCoS = this.findWizardField("rpo_co_space_in_nwrod");
            WizardField coNwrodO = this.findWizardField("co_nwrod_overhang");
            WizardField odNwrodO = this.findWizardField("od_nwrod_overhang");
            WizardField rpoNwrodS = this.findWizardField("rpo_nwrod_space");
            double cutEndNoScaled = rpoSelO.value + rpoCoS.value;
            double cutSpacingNoScaled = resistorSpacing + 2.0 * this.contact_size.value;
            double wellFromnwdmyWidth = cutEndNoScaled + cutSpacingNoScaled + coNwrodO.value;
            double activeXNoScaled = wellFromnwdmyWidth + odNwrodO.value;
            soxNoScaled = activeXNoScaled + rpoODPolyEx.value;
            double soyNoScaled = odNwrodO.value + rpoODPolyEx.value;
            halfTotalL = this.scaledValue(wellRL.value / 2.0 + soxNoScaled);
            halfTotalW = this.scaledValue(wellRW.value / 2.0 + soyNoScaled);
            double activeWX = this.scaledValue(wellRL.value / 2.0 + activeXNoScaled);
            double activeWY = this.scaledValue(wellRW.value / 2.0 + odNwrodO.value);
            nodesList.add(this.makeXmlNodeLayer(activeWX, activeWX, activeWY, activeWY, activeLayer, Poly.Type.FILLED, true, true, -1));
            double halfW = this.scaledValue(wellRW.value / 2.0);
            double halfWellLNoScaled = wellRL.value / 2.0 + wellFromnwdmyWidth;
            double halfWellL = this.scaledValue(halfWellLNoScaled);
            if (i == 1) {
                nodesList.add(this.makeXmlNodeLayer(halfWellL, halfWellL, halfW, halfW, nwellLayer, Poly.Type.FILLED, true, true, -1));
            }
            double halfL = this.scaledValue(wellRL.value / 2.0);
            this.addXmlNodeLayerInternal(nodesList, t, "NWDMY-LVS", halfL, halfTotalW, true, true, -1);
            cutEnd = this.scaledValue(wellRL.value / 2.0 + cutEndNoScaled);
            cutSpacing = this.scaledValue(cutSpacingNoScaled);
            m1Distance = this.scaledValue(wellRL.value / 2.0 + rpoSelO.value);
            nodesList.add(this.makeXmlNodeLayer(halfWellL, -1, -m1Distance, -1, halfW, -1, halfW, 1, m1Layer, Poly.Type.FILLED, true, true, 0));
            nodesList.add(this.makeXmlNodeLayer(-m1Distance, 1, halfWellL, 1, halfW, -1, halfW, 1, m1Layer, Poly.Type.FILLED, true, true, 1));
            double deltaFromActve = rpoNwrodS.value + rpoSelO.value;
            selectY = this.scaledValue(wellRW.value / 2.0 + deltaFromActve);
            selectX = this.scaledValue(halfWellLNoScaled + deltaFromActve);
            nodesList.add(this.makeXmlNodeLayer(selectX, -1, -halfL, -1, selectY, -1, selectY, 1, selectLayer, Poly.Type.FILLED, true, true, 0));
            nodesList.add(this.makeXmlNodeLayer(-halfL, -1, selectX, 1, selectY, -1, selectY, 1, selectLayer, Poly.Type.FILLED, true, true, 0));
            port = this.makeXmlPrimitivePort("left-rpo", 0, 180, 0, minFullSize, -(cutEnd + cutSpacing), -1, -cutEnd, -1, -halfW, -1, halfW, 1, portNames);
            nodePorts.add(port);
            port = this.makeXmlPrimitivePort("right-rpo", 0, 180, 1, minFullSize, cutEnd, 1, cutEnd + cutSpacing, 1, -halfW, -1, halfW, 1, portNames);
            nodePorts.add(port);
            double holeStartX = this.scaledValue(halfWellLNoScaled + rpoNwrodS.value);
            double holeStartY = this.scaledValue(wellRW.value / 2.0 + rpoNwrodS.value);
            if (rpoLayer != null) {
                nodesList.add(this.makeXmlNodeLayer(halfTotalL, -1, -holeStartX, -1, halfTotalW, -1, halfTotalW, 1, rpoLayer, Poly.Type.FILLED, true, true, -1));
                nodesList.add(this.makeXmlNodeLayer(-holeStartX, -1, halfTotalL, -1, halfTotalW, -1, halfTotalW, 1, rpoLayer, Poly.Type.FILLED, true, true, -1));
                nodesList.add(this.makeXmlNodeLayer(holeStartX, -1, holeStartX, 1, halfTotalW, -1, -holeStartY, -1, rpoLayer, Poly.Type.FILLED, true, true, -1));
                nodesList.add(this.makeXmlNodeLayer(holeStartX, -1, holeStartX, 1, -holeStartY, -1, halfTotalW, 1, rpoLayer, Poly.Type.FILLED, true, true, -1));
                nodesList.add(this.makeXmlNodeLayer(m1Distance, m1Distance, holeStartY, holeStartY, rpoLayer, Poly.Type.FILLED, true, true, -1));
            } else {
                System.out.println("Error: layer rpo doesn't exist");
            }
            cutEnd2 = cutEnd + cutSpacing;
            double cutEndY = this.scaledValue(wellRW.value / 2.0 - coNwrodO.value);
            nodesList.add(this.makeXmlMulticut(cutEnd2, -1, -cutEnd, -1, cutEndY, -1, cutEndY, 1, diffConLayer, contSize, contArraySpacing, contArraySpacing));
            nodesList.add(this.makeXmlMulticut(-cutEnd, 1, cutEnd2, 1, cutEndY, -1, cutEndY, 1, diffConLayer, contSize, contArraySpacing, contArraySpacing));
            sox = this.scaledValue(soxNoScaled);
            soy = this.scaledValue(soyNoScaled);
            n = this.makeXmlPrimitive(t.nodeGroups, name + "-Well-RPO-Resistor", wrFunc, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
            paletteGroup.addPinOrResistor(n, name + "-RWell");
        }
        for (Map.Entry<String, List<Element>> e : this.otherTransistors.entrySet()) {
            List<Element> elemList = e.getValue();
            System.out.println("Building transistors group " + e.getKey());
            for (Element el : elemList) {
                nodesList.clear();
                nodePorts.clear();
                double sox = 0.0;
                double soy = 0.0;
                double maxX = Double.NEGATIVE_INFINITY;
                double maxY = Double.NEGATIVE_INFINITY;
                Xml.PrimitivePort leftP = null;
                Xml.PrimitivePort rightP = null;
                Xml.PrimitivePort topP = null;
                Xml.PrimitivePort bottomP = null;
                boolean foundDiff = false;
                double diffWidth = 0.0;
                for (LayerNode layerNode : el.layers) {
                    RectLayerNode rn = (RectLayerNode)layerNode;
                    Xml.Layer xmlLayer = t.findLayer(rn.layer);
                    if (xmlLayer == null) {
                        System.out.println("Error: layer '" + rn.layer + "' is not defined");
                        return;
                    }
                    if (rn instanceof NotCenterRectLayerNode) {
                        NotCenterRectLayerNode nc = (NotCenterRectLayerNode)rn;
                        double left = nc.valueX.value;
                        double right = nc.valueXR;
                        double bottom = nc.valueY.value;
                        double top = nc.valueYT;
                        int factorB = -1;
                        int factorT = 1;
                        if (bottom < 0.0 && top < 0.0) {
                            factorT = -1;
                            bottom = Math.abs(bottom);
                        } else if (top > 0.0 && bottom > 0.0) {
                            factorB = 1;
                            bottom = -Math.abs(bottom);
                        }
                        nodesList.add(this.makeXmlNodeLayer(left, -1, right, 1, bottom, factorB, top, factorT, t.findLayer(rn.layer), Poly.Type.FILLED, true, false, -1));
                        continue;
                    }
                    boolean isPolyLayer = rn.layer.contains("Poly");
                    boolean isDiffLayer = rn.layer.contains("Diff");
                    double w = rn.valueX.value / 2.0;
                    double h = rn.valueY.value / 2.0;
                    if (h > maxY) {
                        maxY = h;
                    }
                    if (w > maxX) {
                        maxX = w;
                    }
                    if (isPolyLayer) {
                        assert (foundDiff);
                        nodesList.add(this.makeXmlNodeLayer(w, -1, -diffWidth, -1, h, -1, h, 1, t.findLayer(rn.layer), Poly.Type.FILLED, true, true, 0));
                        nodesList.add(this.makeXmlNodeLayer(-diffWidth, 1, w, 1, h, -1, h, 1, t.findLayer(rn.layer), Poly.Type.FILLED, true, true, 2));
                        nodesList.add(this.makeXmlNodeLayer(diffWidth, -1, diffWidth, 1, h, -1, h, 1, t.findLayer("PolyGate"), Poly.Type.FILLED, true, true, -1));
                    } else if (isDiffLayer) {
                        foundDiff = true;
                        diffWidth = Math.abs(w);
                        nodesList.add(this.makeXmlNodeLayer(w, -1, w, 1, h, -1, 0.0, 1, t.findLayer(rn.layer), Poly.Type.FILLED, true, true, 3));
                        nodesList.add(this.makeXmlNodeLayer(w, -1, w, 1, 0.0, -1, h, 1, t.findLayer(rn.layer), Poly.Type.FILLED, true, true, 1));
                    }
                    nodesList.add(this.makeXmlNodeLayer(w, -1, w, 1, h, -1, h, 1, t.findLayer(rn.layer), Poly.Type.FILLED, true, false, -1));
                    if (t.findArc(rn.layer) == null) continue;
                    portNames.clear();
                    portNames.add(rn.layer);
                    if (isPolyLayer) {
                        soy = h;
                        double absW = Math.abs(w);
                        leftP = this.makeXmlPrimitivePort(rn.layer + "-left", 180, 90, 0, minFullSize, -absW, -1, -absW, -1, 0.0, -1, 0.0, 1, portNames);
                        rightP = this.makeXmlPrimitivePort(rn.layer + "-right", 0, 180, 0, minFullSize, absW, 1, absW, 1, 0.0, -1, 0.0, 1, portNames);
                        continue;
                    }
                    if (!isDiffLayer) continue;
                    sox = w;
                    double absH = Math.abs(h / 2.0);
                    topP = this.makeXmlPrimitivePort(rn.layer + "-top", 90, 90, 1, minFullSize, 0.0, -1, 0.0, 1, absH, 1, absH, 1, portNames);
                    bottomP = this.makeXmlPrimitivePort(rn.layer + "-bottom", 270, 90, 2, minFullSize, 0.0, -1, 0.0, 1, -absH, -1, -absH, -1, portNames);
                }
                nodePorts.add(leftP);
                nodePorts.add(topP);
                nodePorts.add(rightP);
                nodePorts.add(bottomP);
                String name = "G" + el.prefix;
                sox = maxX - sox;
                soy = maxY - soy;
                Xml.PrimitiveNodeGroup primitiveNodeGroup = this.makeXmlPrimitive(t.nodeGroups, name + "-Transistor", PrimitiveNode.Function.TRANMOS, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
                transPalette[0].addElement(primitiveNodeGroup, name);
            }
        }
        allGroups.add(transPalette[0]);
        allGroups.add(transPalette[1]);
        allGroups.add(diffPalette[0]);
        allGroups.add(diffPalette[1]);
        allGroups.add(wellPalette[0]);
        allGroups.add(wellPalette[1]);
        this.makeLayerGDS(t, diffPLayer, String.valueOf(this.diff_layer));
        this.makeLayerGDS(t, diffNLayer, String.valueOf(this.diff_layer));
        this.makeLayerGDS(t, pplusLayer, String.valueOf(this.pplus_layer));
        this.makeLayerGDS(t, nplusLayer, String.valueOf(this.nplus_layer));
        this.makeLayerGDS(t, nwellLayer, String.valueOf(this.nwell_layer));
        this.makeLayerGDS(t, polyConLayer, String.valueOf(this.contact_layer));
        this.makeLayerGDS(t, diffConLayer, String.valueOf(this.contact_layer));
        this.makeLayerGDS(t, polyLayer, String.valueOf(this.poly_layer));
        this.makeLayerGDS(t, polyGateLayer, String.valueOf(this.poly_layer));
        for (Xml.Layer l : diffLayers) {
            this.makeLayerRuleMinRule(t, l, DRCTemplate.DRCRuleType.MINWID, this.diff_width);
            this.makeLayersRule(t, l, DRCTemplate.DRCRuleType.SPACING, this.diff_spacing.rule, this.diff_spacing.value);
        }
        WizardField[] plus_diff = new WizardField[]{this.pplus_overhang_diff, this.nplus_overhang_diff};
        WizardField[] plus_width = new WizardField[]{this.pplus_width, this.nplus_width};
        WizardField[] plus_spacing = new WizardField[]{this.pplus_spacing, this.nplus_spacing};
        for (int i = 0; i < plusLayers.length; ++i) {
            this.makeLayerRuleMinRule(t, plusLayers[i], DRCTemplate.DRCRuleType.MINWID, plus_width[i]);
            this.makeLayersRuleSurround(t, plusLayers[i], diffLayers[i], plus_diff[i].rule, plus_diff[i].value);
            this.makeLayersRule(t, plusLayers[i], DRCTemplate.DRCRuleType.SPACING, plus_spacing[i].rule, plus_spacing[i].value);
        }
        for (Xml.Layer w : wells = new Xml.Layer[]{pwellLayer, nwellLayer}) {
            this.makeLayerRuleMinRule(t, w, DRCTemplate.DRCRuleType.MINWID, this.nwell_width);
            this.makeLayersRuleSurround(t, w, diffPLayer, this.nwell_overhang_diff_p.rule, this.nwell_overhang_diff_p.value);
            this.makeLayersRuleSurround(t, w, diffNLayer, this.nwell_overhang_diff_n.rule, this.nwell_overhang_diff_n.value);
            this.makeLayersRule(t, w, DRCTemplate.DRCRuleType.SPACING, this.nwell_spacing.rule, this.nwell_spacing.value);
        }
        for (Xml.Layer w : polys = new Xml.Layer[]{polyLayer, polyGateLayer}) {
            this.makeLayerRuleMinRule(t, w, DRCTemplate.DRCRuleType.MINWID, this.poly_width);
            this.makeLayersRule(t, w, DRCTemplate.DRCRuleType.SPACING, this.poly_spacing.rule, this.poly_spacing.value);
        }
        this.makeLayersRuleSpacing(t, diffConLayer, polyGateLayer, this.gate_contact_spacing.rule, this.gate_contact_spacing.value);
        this.makeLayersRuleSpacing(t, polyConLayer, polyGateLayer, this.gate_contact_spacing.rule, this.gate_contact_spacing.value);
    }

    private void addContactsOrCapacitors(Xml.Technology t, List<Element> contacts, List<Xml.Layer> metalLayers, PaletteGroup[] diffPalette, PaletteGroup[] wellPalette, PaletteGroup polyGroup, boolean capacitor) {
        ArrayList<String> portArcNames = new ArrayList<String>(0);
        ArrayList<String> portNames = new ArrayList<String>(2);
        portNames.add("a");
        portNames.add("b");
        String name = null;
        Xml.Layer polyLayer = t.findLayer(this.poly_layer.name);
        Xml.Layer polyConLayer = t.findLayer("Poly-Cut");
        Xml.Layer diffConLayer = t.findLayer(this.diff_layer.name + "-Cut");
        Xml.Layer nwellLayer = t.findLayer(this.nwell_layer.name);
        Xml.Layer pwellLayer = t.findLayer("P-Well");
        Xml.Layer diffNLayer = t.findLayer("N-" + this.diff_layer.name);
        Xml.Layer diffPLayer = t.findLayer("P-" + this.diff_layer.name);
        Xml.Layer[] diffLayers = new Xml.Layer[]{diffPLayer, diffNLayer};
        Xml.Layer pol2yLayer = t.findLayer(this.poly2_layer.name);
        double contSize = this.scaledValue(this.contact_size.value);
        double contSpacing = this.scaledValue(this.contact_spacing.value);
        double contArraySpacing = this.scaledValue(this.contact_array_spacing.value);
        for (Element c : contacts) {
            Xml.Layer ly = null;
            Xml.Layer lx = null;
            Xml.Layer conLay = diffConLayer;
            PaletteGroup g = null;
            RectLayerNode metalLayer = (RectLayerNode)c.layers.get(0);
            RectLayerNode otherLayer = (RectLayerNode)c.layers.get(1);
            String extraName = "";
            if (!TextUtils.isANumber(metalLayer.layer)) {
                assert (TextUtils.isANumber(otherLayer.layer));
                metalLayer = (RectLayerNode)c.layers.get(1);
                otherLayer = (RectLayerNode)c.layers.get(0);
            }
            int m1 = Integer.valueOf(metalLayer.layer);
            ly = metalLayers.get(m1 - 1);
            String layerName = otherLayer.layer;
            if (layerName.equals(diffLayers[0].name)) {
                lx = diffLayers[0];
                g = diffPalette[0];
                extraName = "P";
            } else if (layerName.equals(diffLayers[1].name)) {
                lx = diffLayers[1];
                g = diffPalette[1];
                extraName = "N";
            } else if (layerName.equals(polyLayer.name)) {
                lx = polyLayer;
                conLay = polyConLayer;
                g = polyGroup;
            } else if (this.getSecondPolyFlag() && layerName.equals(pol2yLayer.name)) {
                lx = pol2yLayer;
                conLay = polyConLayer;
                g = polyGroup;
            } else assert (false);
            double h1x = this.scaledValue(this.contact_size.value / 2.0 + metalLayer.valueX.value);
            double h1y = this.scaledValue(this.contact_size.value / 2.0 + metalLayer.valueY.value);
            double h2x = this.scaledValue(this.contact_size.value / 2.0 + otherLayer.valueX.value);
            double h2y = this.scaledValue(this.contact_size.value / 2.0 + otherLayer.valueY.value);
            double longX = Math.abs(metalLayer.valueX.value - otherLayer.valueX.value);
            double longY = Math.abs(metalLayer.valueY.value - otherLayer.valueY.value);
            PrimitiveNode.Function func = !capacitor ? PrimitiveNode.Function.CONTACT : PrimitiveNode.Function.CAPAC;
            Xml.NodeLayer[] nodes = new Xml.NodeLayer[c.layers.size() + 1];
            int count2 = 0;
            nodes[count2++] = this.makeXmlMulticut(conLay, contSize, contSpacing, contArraySpacing);
            nodes[count2++] = this.makeXmlNodeLayer(h1x, h1x, h1y, h1y, ly, Poly.Type.FILLED);
            nodes[count2++] = this.makeXmlNodeLayer(h2x, h2x, h2y, h2y, lx, Poly.Type.FILLED);
            Xml.Layer otherLayerPort = lx;
            for (int i = 2; i < c.layers.size(); ++i) {
                RectLayerNode node = (RectLayerNode)c.layers.get(i);
                Xml.Layer lz = t.findLayer(node.layer);
                if (lz == pwellLayer && lx == diffLayers[0] || lz == nwellLayer && lx == diffLayers[1]) {
                    otherLayerPort = lz;
                    if (lz == pwellLayer) {
                        g = wellPalette[0];
                        func = this.getWellContactFunction(0);
                        extraName = "PW";
                    } else {
                        g = wellPalette[1];
                        func = this.getWellContactFunction(1);
                        extraName = "NW";
                    }
                }
                if (this.pSubstrateProcess && lz == pwellLayer) continue;
                double h3x = this.scaledValue(this.contact_size.value / 2.0 + node.valueX.value);
                double h3y = this.scaledValue(this.contact_size.value / 2.0 + node.valueY.value);
                nodes[count2++] = this.makeXmlNodeLayer(h3x, h3x, h3y, h3y, lz, Poly.Type.FILLED);
                double longXLocal = Math.abs(node.valueX.value - otherLayer.valueX.value);
                double longYLocal = Math.abs(node.valueY.value - otherLayer.valueY.value);
                if (DBMath.isGreaterThan(longXLocal, longX)) {
                    longX = longXLocal;
                }
                if (!DBMath.isGreaterThan(longYLocal, longY)) continue;
                longY = longYLocal;
            }
            longX = this.scaledValue(longX);
            longY = this.scaledValue(longY);
            portArcNames.clear();
            portArcNames.add(otherLayerPort.name);
            portArcNames.add(ly.name);
            name = ly.name + "-" + otherLayerPort.name;
            String p = c.prefix == null || c.prefix.equals("") ? "" : c.prefix + "-";
            Xml.PrimitiveNodeGroup png = !capacitor ? this.makeXmlPrimitiveCon(t.nodeGroups, p + name, func, -1.0, -1.0, new SizeOffset(longX, longX, longY, longY), portArcNames, nodes) : this.makeXmlCapacitor(t.nodeGroups, p + name, func, -1.0, -1.0, new SizeOffset(longX, longX, longY, longY), portNames, portArcNames, nodes);
            g.addElement(png, p + extraName);
        }
    }

    private void addGenericContacts(Xml.Technology t, Map<String, List<Element>> contacts, List<PaletteGroup> extraPaletteList, List<PaletteGroup> polysGroup) {
        ArrayList<String> portNames = new ArrayList<String>(0);
        Xml.Layer polyLayer = t.findLayer(this.poly_layer.name);
        for (Map.Entry<String, List<Element>> e : contacts.entrySet()) {
            for (Element c : e.getValue()) {
                assert (c.layers.size() == 3);
                RectLayerNode aLayer = (RectLayerNode)c.layers.get(0);
                RectLayerNode bLayer = (RectLayerNode)c.layers.get(1);
                RectLayerNode cutLayer = (RectLayerNode)c.layers.get(2);
                PaletteGroup grp = null;
                Boolean polyGroup = false;
                for (LayerNode l : c.layers) {
                    RectLayerNode n = (RectLayerNode)l;
                    for (LayerInfo info : this.extraLayers) {
                        if (info.name.equals(n.layer)) {
                            grp = info.grp;
                            break;
                        }
                        if (grp == null) continue;
                        break;
                    }
                    if (grp != null) break;
                    if (!n.layer.equals(polyLayer.name)) continue;
                    polyGroup = true;
                }
                if (grp == null) {
                    if (polyGroup.booleanValue()) {
                        grp = polysGroup.get(0);
                    } else {
                        grp = new PaletteGroup();
                        extraPaletteList.add(grp);
                    }
                }
                Xml.Layer la = t.findLayer(aLayer.layer);
                Xml.Layer lb = t.findLayer(bLayer.layer);
                String name = la.name + "-" + lb.name;
                double metalContSizeX = this.scaledValue(cutLayer.valueX.value / 2.0);
                double metalContSizeY = this.scaledValue(cutLayer.valueY.value / 2.0);
                Xml.Layer metalConLayer = t.findLayer(cutLayer.layer);
                double h1x = this.scaledValue(cutLayer.valueX.value / 2.0 + aLayer.valueX.value);
                double h1y = this.scaledValue(cutLayer.valueY.value / 2.0 + aLayer.valueY.value);
                double h2x = this.scaledValue(cutLayer.valueX.value / 2.0 + bLayer.valueX.value);
                double h2y = this.scaledValue(cutLayer.valueY.value / 2.0 + bLayer.valueY.value);
                double longX = this.scaledValue(Math.abs(aLayer.valueX.value - bLayer.valueX.value));
                double longY = this.scaledValue(Math.abs(aLayer.valueY.value - bLayer.valueY.value));
                portNames.clear();
                portNames.add(lb.name);
                portNames.add(la.name);
                if (allArcs.get(la.name) == null) {
                    System.out.println("Error: Arc '" + la.name + "' does not exist");
                }
                if (allArcs.get(lb.name) == null) {
                    System.out.println("Error: Arc '" + lb.name + "' does not exist");
                }
                String p = c.prefix == null || c.prefix.equals("") ? "" : c.prefix + "-";
                grp.addElement(this.makeXmlPrimitiveCon(t.nodeGroups, p + name, PrimitiveNode.Function.CONTACT, -1.0, -1.0, new SizeOffset(longX, longX, longY, longY), portNames, this.makeXmlNodeLayer(h1x, h1x, h1y, h1y, la, Poly.Type.FILLED), this.makeXmlNodeLayer(h2x, h2x, h2y, h2y, lb, Poly.Type.FILLED), this.makeXmlNodeLayer(metalContSizeX, metalContSizeX, metalContSizeY, metalContSizeY, metalConLayer, Poly.Type.FILLED)), c.prefix);
            }
        }
    }

    static {
        extraVariables = new ArrayList<WizardField>();
        extraDoubleFields = new ArrayList<WizardRuleFields>();
        primitiveNodeGroupSort = new PrimitiveNodeGroupSort();
        nodeLayerSort = new NodeLayerSort();
    }

    public static class NodeLayerSort
    implements Comparator<Xml.NodeLayer> {
        @Override
        public int compare(Xml.NodeLayer l1, Xml.NodeLayer l2) {
            return l1.layer.compareTo(l2.layer);
        }
    }

    public static class PrimitiveNodeGroupSort
    implements Comparator<Xml.PrimitiveNodeGroup> {
        @Override
        public int compare(Xml.PrimitiveNodeGroup l1, Xml.PrimitiveNodeGroup l2) {
            Xml.PrimitiveNode n1 = l1.nodes.get(0);
            Xml.PrimitiveNode n2 = l2.nodes.get(0);
            return n1.name.compareTo(n2.name);
        }
    }

    public static class LayerInfo {
        String name;
        int value;
        int type;
        int pin;
        int pinType;
        int text;
        int textType;
        String cif;
        String graphicsTemplate;
        Color graphicsColor;
        EGraphics.Outline graphicsOutline;
        int[] graphicsPattern;
        double width = 0.0;
        double height = -1.0;
        double thickness = -1.0;
        boolean addArc = false;
        WizardField spacing;
        WizardField minimum;
        Layer.Function function = Layer.Function.ART;
        int functionExtras = 0;
        PaletteGroup grp;

        public LayerInfo(String n) {
            this.name = n;
        }

        public LayerInfo(String n, int v) {
            this(n);
            this.value = v;
        }

        String getValueWithType() {
            if (this.value == 0) {
                return "";
            }
            return this.type != 0 ? this.value + "/" + this.type : this.value + "";
        }

        String getPinWithType() {
            if (this.pin == 0) {
                return "";
            }
            return this.pinType != 0 ? this.pin + "/" + this.pinType : this.pin + "";
        }

        String getTextWithType() {
            if (this.text == 0) {
                return "";
            }
            return this.textType != 0 ? this.text + "/" + this.textType : this.text + "";
        }

        public void setArc(boolean withArc) {
            this.addArc = withArc;
        }

        public void setGDSData(int[] vals) {
            assert (vals.length == 6);
            this.value = vals[0];
            this.type = vals[1];
            this.pin = vals[2];
            this.pinType = vals[3];
            this.text = vals[4];
            this.textType = vals[5];
        }

        public Layer.Function setLayerFunction(String funcName) {
            Layer.Function func = Layer.Function.UNKNOWN;
            int f2 = 0;
            String fucN = funcName.toUpperCase();
            if (funcName.startsWith("VIA")) {
                String nums = funcName.substring(3);
                int lay = Integer.parseInt(nums);
                func = Layer.Function.getContact(lay);
            } else if (funcName.startsWith("METAL")) {
                String nums = funcName.substring(5);
                int lay = Integer.parseInt(nums);
                func = Layer.Function.getMetal(lay);
            } else if (funcName.startsWith("POLYCONT") || funcName.equals("CO")) {
                func = Layer.Function.CONTACT1;
            } else if (funcName.startsWith("PW")) {
                func = Layer.Function.WELLP;
            } else if (funcName.startsWith("NW")) {
                func = Layer.Function.WELLN;
            } else if (funcName.startsWith("OD")) {
                func = Layer.Function.DIFF;
            } else if (funcName.startsWith("PDIFF")) {
                func = Layer.Function.DIFFP;
            } else if (funcName.startsWith("NDIFF")) {
                func = Layer.Function.DIFFN;
            } else if (funcName.equals("PO")) {
                func = Layer.Function.POLY1;
            } else if (funcName.equals("NP")) {
                func = Layer.Function.IMPLANTN;
            } else if (funcName.equals("PP")) {
                func = Layer.Function.IMPLANTP;
            } else if (funcName.equals("VTH_P") || funcName.equals("VTL_P")) {
                func = Layer.Function.IMPLANTP;
                f2 = 0x200000;
            } else if (funcName.equals("VTH_N") || funcName.equals("VTL_N")) {
                func = Layer.Function.IMPLANTN;
                f2 = 0x200000;
            } else if (funcName.equals("PRBOUND")) {
                func = Layer.Function.CONTROL;
            } else if (funcName.equals("RPO")) {
                func = Layer.Function.ART;
            } else if (funcName.equals("TEXT")) {
                func = Layer.Function.ART;
                f2 = 8192;
            } else {
                System.out.println("Case not considered in Layer:setLayerFunction: '" + funcName + "'");
            }
            this.function = func;
            this.functionExtras = f2;
            return func;
        }

        public void setWidth(double w) {
            this.width = w;
        }

        public void setColor(String name) {
            String n = TechEditWizardData.stripQuotes(name);
            this.graphicsColor = fromColor.getColor(n);
        }

        public void setStyle(EGraphics.Outline style) {
            this.graphicsOutline = style;
        }

        public void setPattern(int patCode) {
            this.graphicsPattern = TechEditWizardData.getPatternByCode(patCode);
        }

        void validateIndex(int index, String s) {
            boolean validIndex;
            boolean bl = validIndex = index != -1;
            if (!validIndex) {
                System.out.println("Invalid layer information in '" + s + "'");
                if (Job.getDebug()) assert (validIndex);
            }
        }

        void setLayerInformation(String s) {
            StringTokenizer p = new StringTokenizer(s, ":", false);
            while (p.hasMoreTokens()) {
                String str = p.nextToken();
                str = str.trim();
                int index = str.indexOf("=");
                if (str.startsWith("G")) {
                    this.setGDSData(TechEditWizardData.getGDSValuesFromString(str.substring(index + 1)));
                    continue;
                }
                if (str.startsWith("W")) {
                    this.validateIndex(index, s);
                    this.width = Double.parseDouble(str.substring(index + 1));
                    continue;
                }
                if (str.startsWith("T")) {
                    this.validateIndex(index, s);
                    this.thickness = Double.parseDouble(str.substring(index + 1));
                    continue;
                }
                if (str.startsWith("H")) {
                    this.validateIndex(index, s);
                    this.height = Double.parseDouble(str.substring(index + 1));
                    continue;
                }
                if (str.startsWith("S")) {
                    this.validateIndex(index, s);
                    this.spacing = new WizardField();
                    TechEditWizardData.fillRule(str.substring(index + 1), "{/}", new WizardField[]{this.spacing});
                    continue;
                }
                if (str.startsWith("M")) {
                    this.validateIndex(index, s);
                    this.minimum = new WizardField();
                    TechEditWizardData.fillRule(str.substring(index + 1), "{/}", new WizardField[]{this.minimum});
                    continue;
                }
                if (str.startsWith("A")) {
                    assert (str.length() == 1 && str.toLowerCase().equals("a"));
                    this.addArc = true;
                    continue;
                }
                if (str.startsWith("F")) {
                    this.validateIndex(index, s);
                    this.function = Layer.Function.valueOf(str.substring(index + 1));
                    continue;
                }
                if (str.startsWith("CIF")) {
                    this.validateIndex(index, s);
                    this.cif = str.substring(index + 1);
                    continue;
                }
                if (str.startsWith("C")) {
                    this.validateIndex(index, s);
                    this.setGraphicsTemplate(str.substring(index + 1));
                    continue;
                }
                System.out.println("Case not implemented");
                assert (false);
            }
        }

        void setGraphicsTemplate(String s) {
            if (s.startsWith("[")) {
                StringTokenizer p = new StringTokenizer(s, ". []", false);
                int[] colors = new int[3];
                String outlineOrPattern = null;
                int itemCount = 0;
                while (p.hasMoreTokens()) {
                    String str = p.nextToken();
                    if (itemCount < 3) {
                        colors[itemCount++] = Integer.parseInt(str);
                    } else {
                        outlineOrPattern = str;
                    }
                    assert (itemCount < 4);
                }
                EGraphics.Outline outline = EGraphics.Outline.findOutline(EGraphics.Outline.NOPAT.name());
                int[] pattern = new int[16];
                this.graphicsColor = new Color(colors[0], colors[1], colors[2]);
                if (outlineOrPattern != null) {
                    EGraphics.Outline out = EGraphics.Outline.findOutline(outlineOrPattern);
                    if (out != null) {
                        outline = out;
                    } else {
                        if (!outlineOrPattern.startsWith("{")) {
                            System.out.println("Systax error in line '" + outlineOrPattern + "'");
                            if (Job.getDebug()) assert (outlineOrPattern.startsWith("{"));
                        }
                        StringTokenizer pat = new StringTokenizer(outlineOrPattern, "/ {}", false);
                        int count2 = 0;
                        while (pat.hasMoreTokens()) {
                            String str = pat.nextToken();
                            int num = Integer.parseInt(str);
                            assert (count2 < 16);
                            pattern[count2++] = num;
                        }
                        if (count2 != 16) assert (count2 == 16);
                    }
                }
                this.graphicsOutline = outline;
                this.graphicsPattern = pattern;
            } else {
                this.graphicsTemplate = s;
            }
        }

        public String toString() {
            String val = this.getValueWithType();
            if (this.pin != 0) {
                val = val + "," + this.getPinWithType() + "p";
            }
            if (this.text != 0) {
                val = val + "," + this.getTextWithType() + "t";
            }
            return val;
        }
    }

    private class ColorProperties {
        private final Map<String, Color> colourMap;

        public ColorProperties(Class<?> classWithColorFields) {
            this.colourMap = Collections.unmodifiableMap(this.populateColourMap(classWithColorFields));
        }

        public Map<String, Color> getAllColours() {
            return this.colourMap;
        }

        public Color getColor(String key) {
            return this.colourMap.get(key);
        }

        private Map<String, Color> populateColourMap(Class<?> classWithColorFields) {
            HashMap<String, Color> colourMap = new HashMap<String, Color>();
            for (Field f2 : classWithColorFields.getFields()) {
                if (!this.isPublicStaticFinalColor(f2)) continue;
                try {
                    colourMap.put(f2.getName(), (Color)f2.get(null));
                }
                catch (IllegalArgumentException e) {
                    assert (false) : f2;
                }
                catch (IllegalAccessException e) {
                    assert (false) : f2;
                }
            }
            return colourMap;
        }

        private boolean isPublicStaticFinalColor(Field f2) {
            int modifiers = f2.getModifiers();
            return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && this.isColor(f2.getType());
        }

        private boolean isColor(Class<?> c) {
            if (c == null) {
                return false;
            }
            if (c.equals(Color.class)) {
                return true;
            }
            return this.isColor(c.getSuperclass());
        }
    }

    private static class PaletteGroup {
        List<Xml.ArcProto> arcs;
        List<Xml.MenuNodeInst> pins;
        List<Xml.MenuNodeInst> elements;

        private PaletteGroup() {
        }

        void addArc(Xml.ArcProto arc) {
            if (this.arcs == null) {
                this.arcs = new ArrayList<Xml.ArcProto>();
            }
            this.arcs.add(arc);
            if (allArcs.get(arc.name) == null) {
                allArcs.put(arc.name, arc);
            }
        }

        private void add(List<Xml.MenuNodeInst> list2, Xml.PrimitiveNodeGroup element, String shortName) {
            assert (element.isSingleton);
            Xml.PrimitiveNode pn = element.nodes.get(0);
            Xml.MenuNodeInst n = new Xml.MenuNodeInst();
            n.protoName = pn.name;
            n.function = pn.function;
            if (shortName != null) {
                n.text = shortName;
            }
            list2.add(n);
        }

        void addPinOrResistor(Xml.PrimitiveNodeGroup pin, String shortName) {
            if (this.pins == null) {
                this.pins = new ArrayList<Xml.MenuNodeInst>();
            }
            this.add(this.pins, pin, shortName);
        }

        void addElement(Xml.PrimitiveNodeGroup element, String shortName) {
            if (this.elements == null) {
                this.elements = new ArrayList<Xml.MenuNodeInst>();
            }
            this.add(this.elements, element, shortName);
        }
    }

    public static class Element {
        String prefix;
        List<LayerNode> layers;

        public Element(String p) {
            this.prefix = p;
            this.layers = new ArrayList<LayerNode>();
        }

        public List<LayerNode> getLayers() {
            return this.layers;
        }
    }

    public static class NotCenterRectLayerNode
    extends RectLayerNode {
        double valueXR;
        double valueYT;

        public NotCenterRectLayerNode(String l, double valX, double valXR, String nameX, double valY, double valYR, String nameY) {
            super(l, valX, nameX, valY, nameY);
            this.valueXR = valXR;
            this.valueYT = valYR;
        }
    }

    public static class RectLayerNode
    extends LayerNode {
        WizardField valueX;
        WizardField valueY;

        public RectLayerNode(String l, double valX, String nameX, double valY, String nameY) {
            super(l);
            this.valueX = new WizardField(valX, nameX);
            this.valueY = new WizardField(valY, nameY);
        }
    }

    private static class PolygonLayerNode
    extends LayerNode {
        List<EPoint> pList;

        PolygonLayerNode(String l, List<EPoint> list2) {
            super(l);
            this.pList = list2;
        }
    }

    private static class LayerNode {
        String layer;

        LayerNode(String l) {
            this.layer = l;
        }
    }
}

