/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class EditingPreferences
extends PrefPackage {
    public static final boolean USE_THREAD_LOCAL = false;
    private static final String KEY_EXTEND_X = "DefaultExtendX";
    private static final String KEY_EXTEND_Y = "DefaultExtendY";
    private static final String KEY_EXTEND = "DefaultExtend";
    private static final String KEY_PIN = "Pin";
    private static final String KEY_RIGID = "DefaultRigid";
    private static final String KEY_FIXED_ANGLE = "DefaultFixedAngle";
    private static final String KEY_SLIDABLE = "DefaultSlidable";
    private static final String KEY_EXTENDED = "DefaultExtended";
    private static final String KEY_DIRECTIONAL = "DefaultDirectional";
    private static final String KEY_ANGLE = "DefaultAngle";
    private static final String KEY_ALIGNMENT = "AlignmentToGridVector";
    private static final EDimension[] DEFAULT_ALIGNMENTS = new EDimension[]{new EDimension(20.0, 20.0), new EDimension(10.0, 10.0), new EDimension(5.0, 5.0), new EDimension(1.0, 1.0), new EDimension(0.5, 0.5)};
    private static final int DEFAULT_ALIGNMENT_INDEX = 3;
    private static final String TEXT_DESCRIPTOR_NODE = "database/variable";
    private static final String KEY_TEXT_DESCRIPTOR = "TextDescriptorFor";
    private static final String KEY_TEXT_DESCRIPTOR_COLOR = "TextDescriptorColorFor";
    private static final String KEY_TEXT_DESCRIPTOR_FONT = "TextDescriptorFontFor";
    private final transient TechPool techPool;
    private final HashMap<PrimitiveNodeId, ImmutableNodeInst> defaultNodes;
    private HashMap<ArcProtoId, ImmutableArcInst> defaultArcs;
    private HashMap<ArcProtoId, Integer> defaultArcAngleIncrements;
    private HashMap<ArcProtoId, PrimitiveNodeId> defaultArcPins;
    private EDimension[] alignments;
    private int alignmentIndex;
    private String workingDirectory;
    private Map<Object, String> fileGroupDirectories;
    private TextDescriptor[] textDescriptors;
    @PrefPackage.BooleanPref(node="tool/user", key="PlaceCellCenter", factory=true)
    private boolean placeCellCenter;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartVerticalPlacementExport", factory=0)
    private int smartVerticalPlacementExport;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartHorizontalPlacementExport", factory=0)
    private int smartHorizontalPlacementExport;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartVerticalPlacementArc", factory=0)
    private int smartVerticalPlacementArc;
    @PrefPackage.IntegerPref(node="tool/user", key="SmartHorizontalPlacementArc", factory=0)
    private int smartHorizontalPlacementArc;
    @PrefPackage.BooleanPref(node="tool/user", key="FatWires", factory=true)
    private boolean fatWires;
    @PrefPackage.DoublePref(node="tool/user", key="IconGenLeadLength", factory=2.0)
    private double iconGenLeadLength;
    @PrefPackage.DoublePref(node="tool/user", key="IconGenLeadSpacing", factory=2.0)
    private double iconGenLeadSpacing;
    @PrefPackage.BooleanPref(node="tool/user", key="IconGenDrawLeads", factory=true)
    private boolean iconGenDrawLeads;
    @PrefPackage.BooleanPref(node="tool/user", key="IconsAlwaysDrawn", factory=false)
    private boolean iconsAlwaysDrawn;
    @PrefPackage.BooleanPref(node="tool/user", key="IconGenDrawBody", factory=true)
    private boolean iconGenDrawBody;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenExportPlacement", factory=0)
    private int iconGenExportPlacement;
    @PrefPackage.BooleanPref(node="tool/user", key="IconGenExportPlacementExact", factory=true)
    private boolean iconGenExportPlacementExact;
    @PrefPackage.BooleanPref(node="tool/user", key="IconGenReverseExportOrder", factory=false)
    private boolean iconGenReverseExportOrder;
    @PrefPackage.DoublePref(node="tool/user", key="IconGenBodyTextSize", factory=2.0)
    private double iconGenBodyTextSize;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenExportLocation", factory=1)
    private int iconGenExportLocation;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenExportStyle", factory=0)
    private int iconGenExportStyle;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenExportTech", factory=1)
    private int iconGenExportTech;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenInstanceLocation", factory=0)
    private int iconGenInstanceLocation;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenInputRot", factory=0)
    private int iconGenInputRot;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenOutputRot", factory=0)
    private int iconGenOutputRot;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenBidirRot", factory=0)
    private int iconGenBidirRot;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenPowerRot", factory=0)
    private int iconGenPowerRot;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenGroundRot", factory=0)
    private int iconGenGroundRot;
    @PrefPackage.IntegerPref(node="tool/user", key="IconGenClockRot", factory=0)
    private int iconGenClockRot;

    public EditingPreferences(boolean factory, TechPool techPool) {
        super(factory);
        this.techPool = techPool;
        this.defaultNodes = new HashMap();
        this.defaultArcs = new HashMap();
        this.defaultArcAngleIncrements = new HashMap();
        this.defaultArcPins = new HashMap();
        AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
        this.textDescriptors = new TextDescriptor[textTypes.length * 2];
        if (factory) {
            this.alignments = DEFAULT_ALIGNMENTS;
            this.alignmentIndex = 3;
            for (int i = 0; i < textTypes.length; ++i) {
                AbstractTextDescriptor.TextType t = textTypes[i];
                this.textDescriptors[i * 2 + 0] = t.getFactoryTextDescriptor().withDisplay(false);
                this.textDescriptors[i * 2 + 1] = t.getFactoryTextDescriptor();
            }
            return;
        }
        Preferences prefRoot = EditingPreferences.getPrefRoot();
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        Preferences textDescriptorPrefs = prefRoot.node(TEXT_DESCRIPTOR_NODE);
        for (Technology tech : techPool.values()) {
            ImmutableElectricObject factoryInst;
            Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                PrimitiveNodeId pnId = pn.getId();
                factoryInst = pn.getFactoryDefaultInst();
                EPoint factorySize = ((ImmutableNodeInst)factoryInst).size;
                String keyExtendX = this.getKey(KEY_EXTEND_X, pnId);
                double factoryExtendX = factorySize.getLambdaX() * 0.5;
                double extendX = techPrefs.getDouble(keyExtendX, factoryExtendX);
                String keyExtendY = this.getKey(KEY_EXTEND_Y, pnId);
                double factoryExtendY = factorySize.getLambdaY() * 0.5;
                double extendY = techPrefs.getDouble(keyExtendY, factoryExtendY);
                if (extendX == factoryExtendX && extendY == factoryExtendY) continue;
                EPoint size2 = EPoint.fromLambda(extendX * 2.0, extendY * 2.0);
                this.defaultNodes.put(pnId, ((ImmutableNodeInst)factoryInst).withSize(size2));
            }
            it = tech.getArcs();
            while (it.hasNext()) {
                PrimitiveNode pin;
                String keyPin;
                String arcPinName;
                int factoryAngleIncrement;
                String keyAngle;
                int angleIncrement;
                ArcProto ap = (ArcProto)it.next();
                ArcProtoId apId = ap.getId();
                factoryInst = ap.getFactoryDefaultInst();
                int flags = ((ImmutableArcInst)factoryInst).flags;
                String keyExtend = this.getKey(KEY_EXTEND, apId);
                double factoryExtend = ((ImmutableArcInst)factoryInst).getLambdaExtendOverMin();
                double extend = techPrefs.getDouble(keyExtend, factoryExtend);
                String keyRigid = this.getKey(KEY_RIGID, apId);
                boolean factoryRigid = ((ImmutableArcInst)factoryInst).isRigid();
                boolean rigid = userPrefs.getBoolean(keyRigid, factoryRigid);
                flags = ImmutableArcInst.RIGID.set(flags, rigid);
                String keyFixedAngle = this.getKey(KEY_FIXED_ANGLE, apId);
                boolean factoryFixedAngle = ((ImmutableArcInst)factoryInst).isFixedAngle();
                boolean fixedAngle = userPrefs.getBoolean(keyFixedAngle, factoryFixedAngle);
                flags = ImmutableArcInst.FIXED_ANGLE.set(flags, fixedAngle);
                String keySlidable = this.getKey(KEY_SLIDABLE, apId);
                boolean factorySlidable = ((ImmutableArcInst)factoryInst).isSlidable();
                boolean slidable = userPrefs.getBoolean(keySlidable, factorySlidable);
                flags = ImmutableArcInst.SLIDABLE.set(flags, slidable);
                String keyExtended = this.getKey(KEY_EXTENDED, apId);
                boolean factoryExtended = ((ImmutableArcInst)factoryInst).isTailExtended();
                assert (factoryExtended == ((ImmutableArcInst)factoryInst).isHeadExtended());
                boolean extended = userPrefs.getBoolean(keyExtended, factoryExtended);
                flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, extended);
                flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, extended);
                String keyDirectional = this.getKey(KEY_DIRECTIONAL, apId);
                boolean factoryDirectional = ((ImmutableArcInst)factoryInst).isHeadArrowed();
                assert (factoryDirectional == ((ImmutableArcInst)factoryInst).isBodyArrowed());
                boolean directional = userPrefs.getBoolean(keyDirectional, factoryDirectional);
                flags = ImmutableArcInst.HEAD_ARROWED.set(flags, directional);
                flags = ImmutableArcInst.BODY_ARROWED.set(flags, directional);
                ImmutableArcInst a = ((ImmutableArcInst)factoryInst).withGridExtendOverMin(DBMath.lambdaToGrid(extend)).withFlags(flags);
                if (a != factoryInst) {
                    this.defaultArcs.put(apId, a);
                }
                if ((angleIncrement = userPrefs.getInt(keyAngle = this.getKey(KEY_ANGLE, apId), factoryAngleIncrement = ap.getFactoryAngleIncrement())) != factoryAngleIncrement) {
                    this.defaultArcAngleIncrements.put(apId, angleIncrement);
                }
                if ((arcPinName = techPrefs.get(keyPin = this.getKey(KEY_PIN, apId), "")).length() <= 0 || (pin = tech.findNodeProto(arcPinName)) == null) continue;
                this.defaultArcPins.put(apId, pin.getId());
            }
        }
        String alignmentStr = userPrefs.get(KEY_ALIGNMENT, null);
        if (alignmentStr != null) {
            this.alignments = EditingPreferences.correctAlignmentGridVector(EditingPreferences.transformStringIntoArray(alignmentStr));
            this.alignmentIndex = Math.max(0, Math.min(this.alignments.length - 1, EditingPreferences.getDefaultAlignmentIndex(alignmentStr)));
        } else {
            this.alignments = DEFAULT_ALIGNMENTS;
            this.alignmentIndex = 3;
        }
        this.workingDirectory = User.getWorkingDirectory();
        this.fileGroupDirectories = new HashMap<Object, String>();
        if (factory) {
            for (Object obj : FileType.getFileTypeGroups()) {
                this.fileGroupDirectories.put(obj, FileType.getFactoryGroupPath(obj));
            }
        } else {
            for (Object obj : FileType.getFileTypeGroups()) {
                this.fileGroupDirectories.put(obj, FileType.getGroupPath(obj));
            }
        }
        for (int i = 0; i < textTypes.length; ++i) {
            AbstractTextDescriptor.ActiveFont af;
            AbstractTextDescriptor.TextType t = textTypes[i];
            TextDescriptor factoryTd = t.getFactoryTextDescriptor();
            long factoryBits = EditingPreferences.swap(factoryTd.lowLevelGet());
            long bits2 = textDescriptorPrefs.getLong(t.getKey(KEY_TEXT_DESCRIPTOR), factoryBits);
            int color = textDescriptorPrefs.getInt(t.getKey(KEY_TEXT_DESCRIPTOR_COLOR), 0);
            String fontName = textDescriptorPrefs.get(t.getKey(KEY_TEXT_DESCRIPTOR_FONT), "");
            MutableTextDescriptor mtd = new MutableTextDescriptor(EditingPreferences.swap(bits2), color, true);
            int face = 0;
            if (fontName.length() > 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName)) != null) {
                face = af.getIndex();
            }
            mtd.setFace(face);
            this.textDescriptors[i * 2 + 1] = TextDescriptor.newTextDescriptor(mtd);
            mtd.setDisplay(false);
            this.textDescriptors[i * 2 + 0] = TextDescriptor.newTextDescriptor(mtd);
        }
    }

    @Override
    protected void putPrefs(Preferences prefRoot, boolean removeDefaults) {
        this.putPrefs(prefRoot, removeDefaults, null);
    }

    public void putPrefs(Preferences prefRoot, boolean removeDefaults, EditingPreferences oldEp) {
        super.putPrefs(prefRoot, removeDefaults);
        if (oldEp != null && oldEp.techPool != this.techPool) {
            oldEp = null;
        }
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        Preferences textDescriptorPrefs = prefRoot.node(TEXT_DESCRIPTOR_NODE);
        for (Technology tech : this.techPool.values()) {
            ImmutableElectricObject factoryInst;
            Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                PrimitiveNodeId pnId = pn.getId();
                ImmutableNodeInst n = this.defaultNodes.get(pnId);
                if (oldEp != null && n == oldEp.defaultNodes.get(pnId)) continue;
                factoryInst = pn.getFactoryDefaultInst();
                if (n == null) {
                    n = factoryInst;
                }
                String keyX = this.getKey(KEY_EXTEND_X, pnId);
                if (removeDefaults && n.size.getGridX() == ((ImmutableNodeInst)factoryInst).size.getGridX()) {
                    techPrefs.remove(keyX);
                } else {
                    techPrefs.putDouble(keyX, n.size.getLambdaX() * 0.5);
                }
                String keyY = this.getKey(KEY_EXTEND_Y, pnId);
                if (removeDefaults && n.size.getGridY() == ((ImmutableNodeInst)factoryInst).size.getGridY()) {
                    techPrefs.remove(keyY);
                    continue;
                }
                techPrefs.putDouble(keyY, n.size.getLambdaY() * 0.5);
            }
            it = tech.getArcs();
            while (it.hasNext()) {
                String pinName;
                ArcProto ap = (ArcProto)it.next();
                ArcProtoId apId = ap.getId();
                ImmutableElectricObject a = this.defaultArcs.get(apId);
                if (oldEp == null || a != oldEp.defaultArcs.get(apId)) {
                    factoryInst = ap.getFactoryDefaultInst();
                    if (a == null) {
                        a = factoryInst;
                    }
                    String keyExtend = this.getKey(KEY_EXTEND, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).getGridExtendOverMin() == ((ImmutableArcInst)factoryInst).getGridExtendOverMin()) {
                        techPrefs.remove(keyExtend);
                    } else {
                        techPrefs.putDouble(keyExtend, ((ImmutableArcInst)a).getLambdaExtendOverMin());
                    }
                    String keyRigid = this.getKey(KEY_RIGID, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isRigid() == ((ImmutableArcInst)factoryInst).isRigid()) {
                        userPrefs.remove(keyRigid);
                    } else {
                        userPrefs.putBoolean(keyRigid, ((ImmutableArcInst)a).isRigid());
                    }
                    String keyFixedAngle = this.getKey(KEY_FIXED_ANGLE, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isFixedAngle() == ((ImmutableArcInst)factoryInst).isFixedAngle()) {
                        userPrefs.remove(keyFixedAngle);
                    } else {
                        userPrefs.putBoolean(keyFixedAngle, ((ImmutableArcInst)a).isFixedAngle());
                    }
                    String keySlidable = this.getKey(KEY_SLIDABLE, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isSlidable() == ((ImmutableArcInst)factoryInst).isSlidable()) {
                        userPrefs.remove(keySlidable);
                    } else {
                        userPrefs.putBoolean(keySlidable, ((ImmutableArcInst)a).isSlidable());
                    }
                    String keyExtended = this.getKey(KEY_EXTENDED, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isTailExtended() == ((ImmutableArcInst)factoryInst).isTailExtended()) {
                        userPrefs.remove(keyExtended);
                    } else {
                        userPrefs.putBoolean(keyExtended, ((ImmutableArcInst)a).isTailExtended());
                    }
                    String keyDirectional = this.getKey(KEY_DIRECTIONAL, apId);
                    if (removeDefaults && ((ImmutableArcInst)a).isHeadArrowed() == ((ImmutableArcInst)factoryInst).isHeadArrowed()) {
                        userPrefs.remove(keyDirectional);
                    } else {
                        userPrefs.putBoolean(keyDirectional, ((ImmutableArcInst)a).isHeadArrowed());
                    }
                }
                Integer angleIncrementObj = this.defaultArcAngleIncrements.get(apId);
                if (oldEp == null || angleIncrementObj != oldEp.defaultArcAngleIncrements.get(apId)) {
                    int factoryAngleIncrement = ap.getFactoryAngleIncrement();
                    int angleIncrement = angleIncrementObj != null ? angleIncrementObj : factoryAngleIncrement;
                    String keyAngle = this.getKey(KEY_ANGLE, apId);
                    if (removeDefaults && angleIncrement == factoryAngleIncrement) {
                        userPrefs.remove(keyAngle);
                    } else {
                        userPrefs.putInt(keyAngle, angleIncrement);
                    }
                }
                PrimitiveNodeId pinId = this.defaultArcPins.get(apId);
                if (oldEp != null && pinId == oldEp.defaultArcPins.get(apId)) continue;
                String keyPin = this.getKey(KEY_PIN, apId);
                String string2 = pinName = pinId != null ? pinId.name : "";
                if (removeDefaults && pinName.length() == 0) {
                    techPrefs.remove(keyPin);
                    continue;
                }
                techPrefs.put(keyPin, pinName);
            }
        }
        if (oldEp == null || this.alignments != oldEp.alignments || this.alignmentIndex != oldEp.alignmentIndex) {
            if (removeDefaults && Arrays.equals(this.alignments, DEFAULT_ALIGNMENTS) && this.alignmentIndex == 3) {
                userPrefs.remove(KEY_ALIGNMENT);
            } else {
                userPrefs.put(KEY_ALIGNMENT, EditingPreferences.transformArrayIntoString(this.alignments, this.alignmentIndex));
            }
        }
        if (oldEp == null || this.textDescriptors != oldEp.textDescriptors) {
            AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
            for (int i = 0; i < textTypes.length; ++i) {
                String fontName;
                long bits2;
                AbstractTextDescriptor.TextType t = textTypes[i];
                TextDescriptor td = this.textDescriptors[i * 2 + 1];
                String keyTextDescriptor = t.getKey(KEY_TEXT_DESCRIPTOR);
                String keyTextDescriptorColor = t.getKey(KEY_TEXT_DESCRIPTOR_COLOR);
                String keyTextDescriptorFont = t.getKey(KEY_TEXT_DESCRIPTOR_FONT);
                long factoryBits = t.getFactoryTextDescriptor().lowLevelGet();
                if (td.getFace() == 0) {
                    bits2 = td.lowLevelGet();
                    fontName = "";
                } else {
                    fontName = AbstractTextDescriptor.ActiveFont.findActiveFont(td.getFace()).getName();
                    MutableTextDescriptor mtd = new MutableTextDescriptor(td);
                    mtd.setFace(0);
                    bits2 = mtd.lowLevelGet();
                }
                if (removeDefaults && bits2 == factoryBits) {
                    textDescriptorPrefs.remove(keyTextDescriptor);
                } else {
                    textDescriptorPrefs.putLong(keyTextDescriptor, EditingPreferences.swap(bits2));
                }
                if (removeDefaults && td.getColorIndex() == 0) {
                    textDescriptorPrefs.remove(keyTextDescriptorColor);
                } else {
                    textDescriptorPrefs.putInt(keyTextDescriptorColor, td.getColorIndex());
                }
                if (removeDefaults && fontName.length() == 0) {
                    textDescriptorPrefs.remove(keyTextDescriptorFont);
                    continue;
                }
                textDescriptorPrefs.put(keyTextDescriptorFont, fontName);
            }
        }
    }

    public EditingPreferences withNodeSize(PrimitiveNodeId pnId, EPoint size2) {
        PrimitiveNode pn = this.techPool.getPrimitiveNode(pnId);
        if (pn == null) {
            return this;
        }
        ImmutableNodeInst n = pn.getDefaultInst(this);
        assert (n.protoId == pnId);
        if (n.size.equals(size2)) {
            return this;
        }
        HashMap<PrimitiveNodeId, ImmutableNodeInst> newDefaultNodes = new HashMap<PrimitiveNodeId, ImmutableNodeInst>(this.defaultNodes);
        if (size2.equals(pn.getFactoryDefaultInst().size)) {
            newDefaultNodes.remove(pnId);
        } else {
            newDefaultNodes.put(pnId, n.withSize(size2));
        }
        return this.withField("defaultNodes", newDefaultNodes);
    }

    public EditingPreferences withPlaceCellCenter(boolean placeCellCenter) {
        if (placeCellCenter == this.isPlaceCellCenter()) {
            return this;
        }
        return this.withField("placeCellCenter", placeCellCenter);
    }

    public EditingPreferences withDefaultNodesReset() {
        if (this.defaultNodes.isEmpty()) {
            return this;
        }
        return this.withField("defaultNodes", new HashMap());
    }

    public EditingPreferences withNodesReset() {
        return this.withDefaultNodesReset().withPlaceCellCenter(true);
    }

    public EditingPreferences withArcFlags(ArcProtoId apId, int flags) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        ImmutableArcInst a = ap.getDefaultInst(this);
        if (flags == a.flags) {
            return this;
        }
        HashMap<ArcProtoId, ImmutableArcInst> newDefaultArcs = new HashMap<ArcProtoId, ImmutableArcInst>(this.defaultArcs);
        ImmutableArcInst factoryA = ap.getFactoryDefaultInst();
        if (flags == factoryA.flags) {
            newDefaultArcs.remove(apId);
        } else {
            newDefaultArcs.put(apId, a.withFlags(flags));
        }
        return this.withField("defaultArcs", newDefaultArcs);
    }

    public EditingPreferences withArcGridExtend(ArcProtoId apId, long gridExtend) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        ImmutableArcInst a = ap.getDefaultInst(this);
        if (gridExtend == a.getGridExtendOverMin()) {
            return this;
        }
        HashMap<ArcProtoId, ImmutableArcInst> newDefaultArcs = new HashMap<ArcProtoId, ImmutableArcInst>(this.defaultArcs);
        ImmutableArcInst factoryA = ap.getFactoryDefaultInst();
        if (gridExtend == factoryA.getGridExtendOverMin()) {
            newDefaultArcs.remove(apId);
        } else {
            newDefaultArcs.put(apId, a.withGridExtendOverMin(gridExtend));
        }
        return this.withField("defaultArcs", newDefaultArcs);
    }

    public EditingPreferences withArcAngleIncrement(ArcProtoId apId, int angleIncrement) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        if (angleIncrement == ap.getAngleIncrement(this)) {
            return this;
        }
        HashMap<ArcProtoId, Integer> newDefaultArcAngleIncrements = new HashMap<ArcProtoId, Integer>(this.defaultArcAngleIncrements);
        int factoryAngleIncrement = ap.getFactoryAngleIncrement();
        if (angleIncrement == factoryAngleIncrement) {
            newDefaultArcAngleIncrements.remove(apId);
        } else {
            newDefaultArcAngleIncrements.put(apId, angleIncrement);
        }
        return this.withField("defaultArcAngleIncrements", newDefaultArcAngleIncrements);
    }

    public EditingPreferences withArcPin(ArcProtoId apId, PrimitiveNodeId arcPinId) {
        ArcProto ap = this.techPool.getArcProto(apId);
        if (ap == null) {
            return this;
        }
        if (arcPinId == ap.findOverridablePinProto(this).getId()) {
            return this;
        }
        HashMap<ArcProtoId, PrimitiveNodeId> newDefaultArcPins = new HashMap<ArcProtoId, PrimitiveNodeId>(this.defaultArcPins);
        PrimitiveNodeId factoryArcPinId = ap.findPinProto().getId();
        if (arcPinId == factoryArcPinId) {
            newDefaultArcPins.remove(apId);
        } else {
            newDefaultArcPins.put(apId, arcPinId);
        }
        return this.withField("defaultArcPins", newDefaultArcPins);
    }

    public EditingPreferences withArcsReset() {
        return this.withDefaultArcsReset().withDefaultAngleIncrementsReset().withDefaultArcPinsReset();
    }

    private EditingPreferences withDefaultArcsReset() {
        if (this.defaultArcs.isEmpty()) {
            return this;
        }
        return this.withField("defaultArcs", new HashMap());
    }

    private EditingPreferences withDefaultAngleIncrementsReset() {
        if (this.defaultArcAngleIncrements.isEmpty()) {
            return this;
        }
        return this.withField("defaultArcAngleIncrements", new HashMap());
    }

    private EditingPreferences withDefaultArcPinsReset() {
        if (this.defaultArcPins.isEmpty()) {
            return this;
        }
        return this.withField("defaultArcPins", new HashMap());
    }

    public ImmutableNodeInst getDefaultNode(PrimitiveNodeId pnId) {
        return this.defaultNodes.get(pnId);
    }

    public ImmutableArcInst getDefaultArc(ArcProtoId apId) {
        return this.defaultArcs.get(apId);
    }

    public Integer getDefaultAngleIncrement(ArcProtoId apId) {
        return this.defaultArcAngleIncrements.get(apId);
    }

    public PrimitiveNodeId getDefaultArcPinId(ArcProtoId apId) {
        return this.defaultArcPins.get(apId);
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getGroupDirectory(FileType type) {
        return this.fileGroupDirectories.get(type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EditingPreferences) {
            EditingPreferences that = (EditingPreferences)o;
            return this.techPool == that.techPool && this.defaultNodes.equals(that.defaultNodes) && this.isPlaceCellCenter() == that.isPlaceCellCenter() && this.defaultArcs.equals(that.defaultArcs) && this.defaultArcAngleIncrements.equals(that.defaultArcAngleIncrements) && this.defaultArcPins.equals(that.defaultArcPins) && Arrays.equals(this.alignments, that.alignments) && this.alignmentIndex == that.alignmentIndex && Arrays.equals(this.textDescriptors, that.textDescriptors) && this.isFatWires() == that.isFatWires() && this.getIconGenLeadLength() == that.getIconGenLeadLength() && this.getIconGenLeadSpacing() == that.getIconGenLeadSpacing() && this.isIconGenDrawLeads() == that.isIconGenDrawLeads() && this.isIconsAlwaysDrawn() == that.isIconsAlwaysDrawn() && this.isIconGenDrawBody() == that.isIconGenDrawBody() && this.getIconGenExportPlacement() == that.getIconGenExportPlacement() && this.isIconGenExportPlacementExact() == that.isIconGenExportPlacementExact() && this.isIconGenReverseExportOrder() == that.isIconGenReverseExportOrder() && this.getIconGenBodyTextSize() == that.getIconGenBodyTextSize() && this.getIconGenExportLocation() == that.getIconGenExportLocation() && this.getIconGenExportStyle() == that.getIconGenExportStyle() && this.getIconGenExportTech() == that.getIconGenExportTech() && this.getIconGenInstanceLocation() == that.getIconGenInstanceLocation() && this.getIconGenInputRot() == that.getIconGenInputRot() && this.getIconGenOutputRot() == that.getIconGenOutputRot() && this.getIconGenBidirRot() == that.getIconGenBidirRot() && this.getIconGenPowerRot() == that.getIconGenPowerRot() && this.getIconGenClockRot() == that.getIconGenClockRot();
        }
        return false;
    }

    public EDimension getAlignmentToGrid() {
        return this.alignments[this.alignmentIndex];
    }

    public int getAlignmentToGridIndex() {
        return this.alignmentIndex;
    }

    public EDimension[] getAlignmentToGridVector() {
        return (EDimension[])this.alignments.clone();
    }

    public EditingPreferences withAlignment(EDimension[] dist, int current) {
        dist = EditingPreferences.correctAlignmentGridVector((EDimension[])dist.clone());
        current = Math.max(0, Math.min(dist.length - 1, current));
        return this.withAlignments(dist).withAlignmentIndex(current);
    }

    public EditingPreferences withAlignmentReset() {
        return this.withAlignments(DEFAULT_ALIGNMENTS).withAlignmentIndex(3);
    }

    private EditingPreferences withAlignments(EDimension[] alignments) {
        if (Arrays.equals(alignments, this.alignments)) {
            return this;
        }
        return this.withField("alignments", alignments);
    }

    private EditingPreferences withAlignmentIndex(int alignmentIndex) {
        if (alignmentIndex == this.alignmentIndex) {
            return this;
        }
        return this.withField("alignmentIndex", new Integer(alignmentIndex));
    }

    public TextDescriptor getNodeTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.NODE, true);
    }

    public TextDescriptor getArcTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.ARC, true);
    }

    public TextDescriptor getExportTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.EXPORT, true);
    }

    public TextDescriptor getPortInstTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.PORT, true);
    }

    public TextDescriptor getAnnotationTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.ANNOTATION, true);
    }

    public TextDescriptor getInstanceTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.INSTANCE, true);
    }

    public TextDescriptor getCellTextDescriptor() {
        return this.getTextDescriptor(AbstractTextDescriptor.TextType.CELL, true);
    }

    public TextDescriptor getTextDescriptor(AbstractTextDescriptor.TextType textType, boolean display) {
        return this.textDescriptors[textType.ordinal() * 2 + (display ? 1 : 0)];
    }

    public EditingPreferences withTextDescriptor(AbstractTextDescriptor.TextType textType, TextDescriptor td) {
        if ((td = td.withDisplay(true)) == this.textDescriptors[textType.ordinal() * 2 + 1]) {
            return this;
        }
        TextDescriptor[] newTextDescriptors = (TextDescriptor[])this.textDescriptors.clone();
        newTextDescriptors[textType.ordinal() * 2 + 1] = td;
        newTextDescriptors[textType.ordinal() * 2 + 0] = td.withDisplay(false);
        return this.withField("textDescriptors", newTextDescriptors);
    }

    public EditingPreferences withTextDescriptorsReset() {
        EditingPreferences ep = this;
        AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
        for (int i = 0; i < textTypes.length; ++i) {
            AbstractTextDescriptor.TextType t = textTypes[i];
            ep = ep.withTextDescriptor(t, t.getFactoryTextDescriptor());
        }
        return ep;
    }

    public EditingPreferences withSmartVerticalPlacementExport(int smartVerticalPlacementExport) {
        if (smartVerticalPlacementExport == this.getSmartVerticalPlacementExport()) {
            return this;
        }
        return this.withField("smartVerticalPlacementExport", smartVerticalPlacementExport);
    }

    public EditingPreferences withSmartHorizontalPlacementExport(int smartHorizontalPlacementExport) {
        if (smartHorizontalPlacementExport == this.getSmartHorizontalPlacementExport()) {
            return this;
        }
        return this.withField("smartHorizontalPlacementExport", smartHorizontalPlacementExport);
    }

    public EditingPreferences withSmartVerticalPlacementArc(int smartVerticalPlacementArc) {
        if (smartVerticalPlacementArc == this.getSmartVerticalPlacementArc()) {
            return this;
        }
        return this.withField("smartVerticalPlacementArc", smartVerticalPlacementArc);
    }

    public EditingPreferences withSmartHorizontalPlacementArc(int smartHorizontalPlacementArc) {
        if (smartHorizontalPlacementArc == this.getSmartHorizontalPlacementArc()) {
            return this;
        }
        return this.withField("smartHorizontalPlacementArc", smartHorizontalPlacementArc);
    }

    public EditingPreferences withFatWires(boolean fatWires) {
        if (fatWires == this.isFatWires()) {
            return this;
        }
        return this.withField("fatWires", fatWires);
    }

    public EditingPreferences withPlacementReset() {
        return this.withSmartHorizontalPlacementArc(0).withSmartVerticalPlacementArc(0).withSmartHorizontalPlacementExport(0).withSmartVerticalPlacementExport(0);
    }

    public EditingPreferences withFatWiresReset() {
        return this.withFatWires(true);
    }

    public EditingPreferences withIconGenLeadLength(double iconGenLeadLength) {
        if (iconGenLeadLength == this.getIconGenLeadLength()) {
            return this;
        }
        return this.withField("iconGenLeadLength", new Double(iconGenLeadLength));
    }

    public EditingPreferences withIconGenLeadSpacing(double iconGenLeadSpacing) {
        if (iconGenLeadSpacing == this.getIconGenLeadSpacing()) {
            return this;
        }
        return this.withField("iconGenLeadSpacing", new Double(iconGenLeadSpacing));
    }

    public EditingPreferences withIconGenDrawLeads(boolean iconGenDrawLeads) {
        if (iconGenDrawLeads == this.isIconGenDrawLeads()) {
            return this;
        }
        return this.withField("iconGenDrawLeads", iconGenDrawLeads);
    }

    public EditingPreferences withIconsAlwaysDrawn(boolean iconsAlwaysDrawn) {
        if (iconsAlwaysDrawn == this.isIconsAlwaysDrawn()) {
            return this;
        }
        return this.withField("iconsAlwaysDrawn", iconsAlwaysDrawn);
    }

    public EditingPreferences withIconGenDrawBody(boolean iconGenDrawBody) {
        if (iconGenDrawBody == this.isIconGenDrawBody()) {
            return this;
        }
        return this.withField("iconGenDrawBody", iconGenDrawBody);
    }

    public EditingPreferences withIconGenExportPlacement(int iconGenExportPlacement) {
        if (iconGenExportPlacement == this.getIconGenExportPlacement()) {
            return this;
        }
        return this.withField("iconGenExportPlacement", new Integer(iconGenExportPlacement));
    }

    public EditingPreferences withIconGenExportPlacementExact(boolean iconGenExportPlacementExact) {
        if (iconGenExportPlacementExact == this.isIconGenExportPlacementExact()) {
            return this;
        }
        return this.withField("iconGenExportPlacementExact", iconGenExportPlacementExact);
    }

    public EditingPreferences withIconGenReverseExportOrder(boolean iconGenReverseExportOrder) {
        if (iconGenReverseExportOrder == this.isIconGenReverseExportOrder()) {
            return this;
        }
        return this.withField("iconGenReverseExportOrder", iconGenReverseExportOrder);
    }

    public EditingPreferences withIconGenBodyTextSize(double iconGenBodyTextSize) {
        if (iconGenBodyTextSize == this.getIconGenBodyTextSize()) {
            return this;
        }
        return this.withField("iconGenBodyTextSize", new Double(iconGenBodyTextSize));
    }

    public EditingPreferences withIconGenExportLocation(int iconGenExportLocation) {
        if (iconGenExportLocation == this.getIconGenExportLocation()) {
            return this;
        }
        return this.withField("iconGenExportLocation", new Integer(iconGenExportLocation));
    }

    public EditingPreferences withIconGenExportStyle(int iconGenExportStyle) {
        if (iconGenExportStyle == this.getIconGenExportStyle()) {
            return this;
        }
        return this.withField("iconGenExportStyle", new Integer(iconGenExportStyle));
    }

    public EditingPreferences withIconGenExportTech(int iconGenExportTech) {
        if (iconGenExportTech == this.getIconGenExportTech()) {
            return this;
        }
        return this.withField("iconGenExportTech", new Integer(iconGenExportTech));
    }

    public EditingPreferences withIconGenInstanceLocation(int iconGenInstanceLocation) {
        if (iconGenInstanceLocation == this.getIconGenInstanceLocation()) {
            return this;
        }
        return this.withField("iconGenInstanceLocation", new Integer(iconGenInstanceLocation));
    }

    public EditingPreferences withIconGenInputRot(int iconGenInputRot) {
        if (iconGenInputRot == this.getIconGenInputRot()) {
            return this;
        }
        return this.withField("iconGenInputRot", new Integer(iconGenInputRot));
    }

    public EditingPreferences withIconGenOutputRot(int iconGenOutputRot) {
        if (iconGenOutputRot == this.getIconGenOutputRot()) {
            return this;
        }
        return this.withField("iconGenOutputRot", new Integer(iconGenOutputRot));
    }

    public EditingPreferences withIconGenBidirRot(int iconGenBidirRot) {
        if (iconGenBidirRot == this.getIconGenBidirRot()) {
            return this;
        }
        return this.withField("iconGenBidirRot", new Integer(iconGenBidirRot));
    }

    public EditingPreferences withIconGenPowerRot(int iconGenPowerRot) {
        if (iconGenPowerRot == this.getIconGenPowerRot()) {
            return this;
        }
        return this.withField("iconGenPowerRot", new Integer(iconGenPowerRot));
    }

    public EditingPreferences withIconGenGroundRot(int iconGenGroundRot) {
        if (iconGenGroundRot == this.getIconGenGroundRot()) {
            return this;
        }
        return this.withField("iconGenGroundRot", new Integer(iconGenGroundRot));
    }

    public EditingPreferences withIconGenClockRot(int iconGenClockRot) {
        if (iconGenClockRot == this.getIconGenClockRot()) {
            return this;
        }
        return this.withField("iconGenClockRot", new Integer(iconGenClockRot));
    }

    public EditingPreferences withIconGenReset() {
        return this.withIconGenLeadLength(2.0).withIconGenLeadSpacing(2.0).withIconGenDrawLeads(true).withIconsAlwaysDrawn(false).withIconGenDrawBody(true).withIconGenExportPlacement(0).withIconGenExportPlacementExact(true).withIconGenReverseExportOrder(false).withIconGenBodyTextSize(2.0).withIconGenExportLocation(1).withIconGenExportStyle(0).withIconGenExportTech(1).withIconGenInstanceLocation(0).withIconGenInputRot(0).withIconGenOutputRot(0).withIconGenBidirRot(0).withIconGenPowerRot(0).withIconGenGroundRot(0).withIconGenClockRot(0);
    }

    @Override
    protected EditingPreferences withField(String fieldName, Object value2) {
        return (EditingPreferences)super.withField(fieldName, value2);
    }

    private static EDimension[] correctAlignmentGridVector(EDimension[] retVal) {
        if (retVal.length < 5) {
            EDimension[] newRetVal = new EDimension[5];
            int shift = 5 - retVal.length;
            for (int i = retVal.length - 1; i >= 0; --i) {
                newRetVal[i + shift] = retVal[i];
            }
            while (shift > 0) {
                newRetVal[--shift] = new EDimension(newRetVal[shift + 1].getWidth() * 2.0, newRetVal[shift + 1].getHeight() * 2.0);
            }
            retVal = newRetVal;
        }
        return retVal;
    }

    private static EDimension[] transformStringIntoArray(String vector) {
        StringTokenizer parse = new StringTokenizer(vector, "( )", false);
        ArrayList<EDimension> valuesFound = new ArrayList<EDimension>();
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (value2.startsWith("*")) {
                value2 = value2.substring(1);
            }
            int slashPos = value2.indexOf(47);
            String xPart = value2;
            String yPart = value2;
            if (slashPos >= 0) {
                xPart = value2.substring(0, slashPos);
                yPart = value2.substring(slashPos + 1);
            }
            try {
                EDimension dim = new EDimension(Math.abs(Double.parseDouble(xPart)), Math.abs(Double.parseDouble(yPart)));
                valuesFound.add(dim);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EDimension[] values2 = new EDimension[valuesFound.size()];
        for (int i = 0; i < valuesFound.size(); ++i) {
            values2[i] = (EDimension)valuesFound.get(i);
        }
        return values2;
    }

    private static int getDefaultAlignmentIndex(String vector) {
        int curVal = 0;
        StringTokenizer parse = new StringTokenizer(vector, "( )", false);
        while (parse.hasMoreTokens()) {
            String value2 = parse.nextToken();
            if (value2.startsWith("*")) {
                return curVal;
            }
            if (TextUtils.atof(value2) < 0.0) {
                return curVal;
            }
            ++curVal;
        }
        return 0;
    }

    private static String transformArrayIntoString(EDimension[] s, int current) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i == 0) {
                sb.append('(');
            } else {
                sb.append(' ');
            }
            if (i == current) {
                sb.append('*');
            }
            sb.append(s[i].getWidth());
            if (s[i].getWidth() == s[i].getHeight()) continue;
            sb.append('/');
            sb.append(s[i].getHeight());
        }
        sb.append(')');
        String dir = sb.toString();
        return dir;
    }

    public boolean isPlaceCellCenter() {
        return this.placeCellCenter;
    }

    public int getSmartVerticalPlacementExport() {
        return this.smartVerticalPlacementExport;
    }

    public int getSmartHorizontalPlacementExport() {
        return this.smartHorizontalPlacementExport;
    }

    public int getSmartVerticalPlacementArc() {
        return this.smartVerticalPlacementArc;
    }

    public int getSmartHorizontalPlacementArc() {
        return this.smartHorizontalPlacementArc;
    }

    public boolean isFatWires() {
        return this.fatWires;
    }

    public double getIconGenLeadLength() {
        return this.iconGenLeadLength;
    }

    public double getIconGenLeadSpacing() {
        return this.iconGenLeadSpacing;
    }

    public boolean isIconGenDrawLeads() {
        return this.iconGenDrawLeads;
    }

    public boolean isIconsAlwaysDrawn() {
        return this.iconsAlwaysDrawn;
    }

    public boolean isIconGenDrawBody() {
        return this.iconGenDrawBody;
    }

    public int getIconGenExportPlacement() {
        return this.iconGenExportPlacement;
    }

    public boolean isIconGenExportPlacementExact() {
        return this.iconGenExportPlacementExact;
    }

    public boolean isIconGenReverseExportOrder() {
        return this.iconGenReverseExportOrder;
    }

    public double getIconGenBodyTextSize() {
        return this.iconGenBodyTextSize;
    }

    public int getIconGenExportLocation() {
        return this.iconGenExportLocation;
    }

    public int getIconGenExportStyle() {
        return this.iconGenExportStyle;
    }

    public int getIconGenExportTech() {
        return this.iconGenExportTech;
    }

    public int getIconGenInstanceLocation() {
        return this.iconGenInstanceLocation;
    }

    public int getIconGenInputRot() {
        return this.iconGenInputRot;
    }

    public int getIconGenOutputRot() {
        return this.iconGenOutputRot;
    }

    public int getIconGenBidirRot() {
        return this.iconGenBidirRot;
    }

    public int getIconGenPowerRot() {
        return this.iconGenPowerRot;
    }

    public int getIconGenGroundRot() {
        return this.iconGenGroundRot;
    }

    public int getIconGenClockRot() {
        return this.iconGenClockRot;
    }

    private static long swap(long value2) {
        int v0 = (int)value2;
        return value2 >>> 32 | (long)v0 << 32;
    }

    public int hashCode() {
        return this.defaultNodes.size() + this.defaultArcs.size();
    }

    public static EditingPreferences getThreadEditingPreferences() {
        return Job.getUserInterface().lowLevelGetEditingPreferences();
    }
}

