/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.tool.user.UserInterfaceMain;
import java.io.File;
import java.io.FilenameFilter;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FileType
implements Serializable {
    private static final ArrayList<FileType> allTypes = new ArrayList();
    public static final FileType ANY = FileType.makeFileType("All", new String[0], "All Files");
    public static final FileType ALS = FileType.makeFileType("ALS", new String[]{"als"}, "ALS Simulation Deck (als)", FileTypeGroup.BUILTINSIMGRP);
    public static final FileType ALSVECTOR = FileType.makeFileType("ALS Vectors", new String[]{"vec"}, "ALS Vector Deck (vec)", FileTypeGroup.BUILTINSIMGRP);
    public static final FileType APPLICON860 = FileType.makeFileType("Applicon 860", new String[]{"apl"}, "Applicon 860 Deck (apl)");
    public static final FileType BOOKSHELF = FileType.makeFileType("Bookshelf Format", new String[]{"aux"}, "Bookshelf Aux File (aux)");
    public static final FileType CALIBREDRV = FileType.makeFileType("CALIBREDRV", new String[]{"tcl"}, "CALIBREDRV Deck (tcl)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType CDL = FileType.makeFileType("CDL", new String[]{"cdl"}, "CDL Deck (cdl)", FileTypeGroup.SPICESIMGRP);
    public static final FileType CIF = FileType.makeFileType("CIF", new String[]{"cif"}, "CIF File (cif)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType COSMOS = FileType.makeFileType("COSMOS", new String[]{"sim"}, "COSMOS File (sim)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType DAIS = FileType.makeFileType("Dais", new String[]{""}, "Dais Workspace (ends in _ws)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType DB = FileType.makeFileType("DB", new String[]{"db"}, "Calibre DRC Error File (db)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType DEF = FileType.makeFileType("DEF", new String[]{"def"}, "DEF File (def)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType DELIB = FileType.makeFileType("DELIB", new String[]{"delib"}, "Directory Library File (delib)", FileTypeGroup.DATABASEGRP);
    public static final FileType DFTM = FileType.makeFileType("DFTM", new String[]{"dftm"}, "Data flow/Transactional Memory Netlist (dftm)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType DSPF = FileType.makeFileType("DSPF", new String[]{"dspf"}, "Detailed Standard Parasitic File (dspf)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType DXF = FileType.makeFileType("DXF", new String[]{"dxf"}, "DXF File (dxf)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType EAGLE = FileType.makeFileType("Eagle", new String[]{"txt"}, "Eagle File (txt)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType ECAD = FileType.makeFileType("ECAD", new String[]{"enl"}, "ECAD File (enl)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType EDIF = FileType.makeFileType("EDIF", new String[]{"edif"}, "EDIF File (edif)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType ELIB = FileType.makeFileType("ELIB", new String[]{"elib"}, "Library File (elib)", FileTypeGroup.DATABASEGRP);
    public static final FileType EPS = FileType.makeFileType("Encapsulated PostScript", new String[]{"eps"}, "Encapsulated PostScript (eps)");
    public static final FileType EPIC = FileType.makeFileType("EPIC output", new String[]{"out"}, "EPIC simulation output (out)", FileTypeGroup.SPICESIMGRP);
    public static final FileType ERR = FileType.makeFileType("ERR", new String[]{"err"}, "Assura DRC Error File (err)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType ESIM = FileType.makeFileType("ESIM", new String[]{"sim"}, "ESIM File (sim)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType FASTHENRY = FileType.makeFileType("FastHenry", new String[]{"inp"}, "FastHenry File (inp)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType FPGA = FileType.makeFileType("FPGA", new String[]{"fpga"}, "FPGA Architecture File (fpga)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType GDS = FileType.makeFileType("GDS", new String[]{"gds"}, "GDS File (gds)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType GDSMAP = FileType.makeFileType("GDS Map", new String[]{"map"}, "GDS Layer Map File (map)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType GERBER = FileType.makeFileType("Gerber", new String[]{"gbr"}, "Gerber File (gbr)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType HSPICEOUT = FileType.makeFileTypeNumeric("HSpice Output", new String[]{"tr"}, "HSpice Output File (tr0,1,2...)", FileTypeGroup.SPICESIMGRP);
    public static final FileType HPGL = FileType.makeFileType("HPGL", new String[]{"hpgl2"}, "HPGL File (hpgl2)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType HTML = FileType.makeFileType("HTML", new String[]{"html"}, "HTML File (html)");
    public static final FileType I = FileType.makeFileType("I", new String[]{"i"}, "Estimated Currents File (i)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType IRSIM = FileType.makeFileType("IRSIM", new String[]{"sim"}, "IRSIM Deck (sim)", FileTypeGroup.BUILTINSIMGRP);
    public static final FileType IRSIMPARAM = FileType.makeFileType("IRSIM Parameters", new String[]{"prm"}, "IRSIM Parameter Deck (prm)", FileTypeGroup.BUILTINSIMGRP);
    public static final FileType IRSIMVECTOR = FileType.makeFileType("IRSIM Vectors", new String[]{"cmd"}, "IRSIM Vector Deck (cmd)", FileTypeGroup.BUILTINSIMGRP);
    public static final FileType JAVA = FileType.makeFileType("Java", new String[]{"java", "bsh"}, "Java Script File (java, bsh)");
    public static final FileType JAR = FileType.makeFileType("Jar", new String[]{"jar"}, "Java binary archive (jar)", FileTypeGroup.JARGRP);
    public static final FileType JELIB = FileType.makeFileType("JELIB", new String[]{"jelib"}, "Library File (jelib)", FileTypeGroup.DATABASEGRP);
    public static final FileType J3D = FileType.makeFileType("J3D", new String[]{"j3d"}, "Java3D Demo File (j3d}");
    public static final FileType JYTHON = FileType.makeFileType("Jython", new String[]{"jy", "py"}, "Jython Script File (jy, py)");
    public static final FileType L = FileType.makeFileType("L", new String[]{"L"}, "L File (L)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType LEF = FileType.makeFileType("LEF", new String[]{"lef"}, "LEF File (lef)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType LIBFILE = FileType.makeFileType("LIBFILE", new String[]{"jelib", "elib", "txt"}, "Library File", FileTypeGroup.DATABASEGRP);
    public static final FileType LIB = FileType.makeFileType("LIB", new String[]{"lib"}, "Liberty File (lib)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType MAXWELL = FileType.makeFileType("Maxwell", new String[]{"mac"}, "Maxwell Deck (mac)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType MOSSIM = FileType.makeFileType("MOSSIM", new String[]{"ntk"}, "MOSSIM Deck (ntk)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType MOV = FileType.makeFileType("Movie", new String[]{"mov"}, "Movie File (mov)");
    public static final FileType PADARR = FileType.makeFileType("Pad Array", new String[]{"arr"}, "Pad Generator Array File (arr)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType PADS = FileType.makeFileType("Pads", new String[]{"asc"}, "Pads File (asc)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType PAL = FileType.makeFileType("PAL", new String[]{"pal"}, "PAL File (pal)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType POSTSCRIPT = FileType.makeFileType("PostScript", new String[]{"ps"}, "PostScript (ps)");
    public static final FileType PNG = FileType.makeFileType("PNG", new String[]{"png"}, "PNG (png)");
    public static final FileType PREFS = FileType.makeFileType("Preferences", new String[]{"xml"}, "Preferences (xml)");
    public static final FileType PROJECT = FileType.makeFileType("Project Management", new String[]{"proj"}, "Project Management (proj)");
    public static final FileType PSPICEOUT = FileType.makeFileType("PSpice Output", new String[]{"txt"}, "PSpice/Spice3 Text Output File (txt)", FileTypeGroup.SPICESIMGRP);
    public static final FileType RAWSPICEOUT = FileType.makeFileType("RawSpice Output", new String[]{"raw"}, "Spice Raw Output File (raw)", FileTypeGroup.SPICESIMGRP);
    public static final FileType RAWSSPICEOUT = FileType.makeFileType("Raw SmartSpice Output", new String[]{"raw"}, "SmartSPICE Raw Output File (raw)", FileTypeGroup.SPICESIMGRP);
    public static final FileType RAWLTSPICEOUT = FileType.makeFileType("Raw LTSpice Output", new String[]{"raw"}, "LTSPICE Raw Output File (raw)", FileTypeGroup.SPICESIMGRP);
    public static final FileType READABLEDUMP = FileType.makeFileType("ReadableDump", new String[]{"txt"}, "Readable Dump Library File (txt)", FileTypeGroup.DATABASEGRP);
    public static final FileType RSIM = FileType.makeFileType("RSIM", new String[]{"sim"}, "RSIM File (sim)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType SILOS = FileType.makeFileType("Silos", new String[]{"sil"}, "Silos Deck (sil)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType SKILL = FileType.makeFileType("Skill", new String[]{"il"}, "Skill Deck (il)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType SKILLEXPORTSONLY = FileType.makeFileType("SkillExports Only", new String[]{"il"}, "Skill Deck (il)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType SPICE = FileType.makeFileType("Spice", new String[]{"spi", "sp"}, "Spice Deck (spi, sp)", FileTypeGroup.SPICESIMGRP);
    public static final FileType SPICEOUT = FileType.makeFileType("Spice Output", new String[]{"spo"}, "Spice/GNUCap Output File (spo)", FileTypeGroup.SPICESIMGRP);
    public static final FileType STL = FileType.makeFileType("STL", new String[]{"stl"}, "STL File (stl)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType SUE = FileType.makeFileType("Sue", new String[]{"sue"}, "Sue File (sue)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType SVG = FileType.makeFileType("SVG", new String[]{"svg"}, "Scalable Vector Graphics (svg)");
    public static final FileType TEGAS = FileType.makeFileType("Tegas", new String[]{"tdl"}, "Tegas File (tdl)", FileTypeGroup.OTHERSIMGRP);
    public static final FileType TELESIS = FileType.makeFileType("Telesis", new String[]{"txt"}, "Telesis File (txt)", FileTypeGroup.EXPORTIMPORTGRP);
    public static final FileType TEXT = FileType.makeFileType("Text", new String[]{"txt"}, "Text File (txt)");
    public static final FileType VERILOG = FileType.makeFileType("Verilog", new String[]{"v", "vL"}, "Verilog Deck (v)", FileTypeGroup.VERILOGSIMGRP);
    public static final FileType VERILOGA = FileType.makeFileType("VerilogA", new String[]{"va", "vLA"}, "VerilogA Deck (va)", FileTypeGroup.VERILOGSIMGRP);
    public static final FileType VERILOGOUT = FileType.makeFileType("Verilog Output", new String[]{"dump"}, "Verilog VCD Dump (vcd)", FileTypeGroup.VERILOGSIMGRP);
    public static final FileType XML = FileType.makeFileType("XML", new String[]{"xml"}, "XML File (xml)");
    public static final FileType DEFAULTLIB = JELIB;
    public static final FileType[] libraryTypes = new FileType[]{JELIB, ELIB, DELIB};
    private static String[] libraryTypesExt;
    private static String libraryTypesExtReadable;
    public static final FileType LIBRARYFORMATS;
    private String name;
    private String[] extensions;
    private String desc;
    private boolean allowNumbers;
    private transient FileFilterSwing ffs;
    private transient FileFilterAWT ffa;
    private FileTypeGroup group;

    public static FileTypeGroup[] getFileTypeGroups() {
        return (FileTypeGroup[])FileTypeGroup.class.getEnumConstants();
    }

    public static String getDatabaseGroupPath() {
        return JELIB.getGroupPath();
    }

    private FileType() {
    }

    public void setGroupPath(String path) {
        if (this.group == null || path == null) {
            return;
        }
        EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
        ep = ep.withGroupDirectory(this.group, path);
        UserInterfaceMain.setEditingPreferences(ep);
    }

    public String getGroupPath() {
        return this.getGroupPath(EditingPreferences.getInstance());
    }

    public String getGroupPath(EditingPreferences ep) {
        if (this.group == null) {
            return null;
        }
        String dir = ep.getGroupDirectory(this.group);
        return dir.isEmpty() ? ep.getWorkingDirectory() : dir;
    }

    private static FileType makeFileType(String name, String[] extensions, String desc, FileTypeGroup g) {
        FileType f2 = FileType.makeFileType(name, extensions, desc);
        f2.group = g;
        return f2;
    }

    private static FileType makeFileType(String name, String[] extensions, String desc) {
        FileType ft = new FileType();
        ft.name = name;
        ft.extensions = extensions;
        ft.desc = desc;
        ft.ffs = null;
        ft.ffa = null;
        ft.allowNumbers = false;
        ft.group = null;
        allTypes.add(ft);
        return ft;
    }

    private static FileType makeFileTypeNumeric(String name, String[] extensions, String desc, FileTypeGroup g) {
        FileType ft = FileType.makeFileType(name, extensions, desc);
        ft.allowNumbers = true;
        ft.group = g;
        return ft;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getFirstExtension() {
        String[] exts = this.getExtensions();
        if (exts == null || exts.length == 0) {
            return "";
        }
        return exts[0];
    }

    public String[] getExtensions() {
        if (this.allowNumbers) {
            String[] newExtensions = new String[this.extensions.length];
            for (int i = 0; i < this.extensions.length; ++i) {
                newExtensions[i] = this.extensions[i] + "0";
            }
            return newExtensions;
        }
        return this.extensions;
    }

    public static boolean matchExtension(String ext) {
        String extLow = ext.toLowerCase();
        for (FileType t : allTypes) {
            String[] exts;
            for (String s : exts = t.getExtensions()) {
                if (!s.toLowerCase().contains(extLow)) continue;
                return true;
            }
        }
        return false;
    }

    public FileFilterSwing getFileFilterSwing() {
        if (this.ffs == null) {
            this.ffs = new FileFilterSwing(this.extensions, this.desc, this.allowNumbers);
        }
        return this.ffs;
    }

    public FileFilterAWT getFileFilterAWT() {
        if (this.ffa == null) {
            this.ffa = new FileFilterAWT(this.extensions, this.desc, this.allowNumbers);
        }
        return this.ffa;
    }

    private Object readResolve() throws ObjectStreamException {
        for (FileType ft : allTypes) {
            if (!this.name.equals(ft.name)) continue;
            return ft;
        }
        return this;
    }

    public String toString() {
        return this.name;
    }

    public static FileType getType(FileFilter filter2) {
        for (FileType type : allTypes) {
            if (type.ffs != filter2) continue;
            return type;
        }
        return null;
    }

    public static FileType getType(FilenameFilter filter2) {
        for (FileType type : allTypes) {
            if (type.ffa != filter2) continue;
            return type;
        }
        return null;
    }

    public static FileType findType(String typeName) {
        String n = typeName.toLowerCase();
        for (FileType type : allTypes) {
            if (!type.name.toLowerCase().equals(n)) continue;
            return type;
        }
        return null;
    }

    public static FileType findTypeByExtension(String extName) {
        String n = extName.toLowerCase();
        for (FileType type : allTypes) {
            for (String ex : type.extensions) {
                if (!ex.toLowerCase().equals(n)) continue;
                return type;
            }
        }
        return null;
    }

    private static boolean matches(String fileName, String[] extensions, boolean allowNumbers) {
        if (extensions.length == 0) {
            return true;
        }
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return false;
        }
        String thisExtension = fileName.substring(i + 1);
        if (thisExtension == null) {
            return false;
        }
        for (String extension : extensions) {
            if (extension.equalsIgnoreCase(thisExtension)) {
                return true;
            }
            if (!allowNumbers || thisExtension.length() <= extension.length() || !thisExtension.startsWith(extension)) continue;
            boolean allDigits = true;
            for (int k = extension.length(); k < thisExtension.length(); ++k) {
                if (Character.isDigit(thisExtension.charAt(k))) continue;
                allDigits = false;
            }
            if (!allDigits) continue;
            return true;
        }
        return false;
    }

    public static FileType getLibraryFormat(String fileName, FileType defaultType) {
        if (fileName != null) {
            if (fileName.endsWith(File.separator)) {
                fileName = fileName.substring(0, fileName.length() - File.separator.length());
            }
            for (FileType type : libraryTypes) {
                if (!fileName.endsWith("." + type.getFirstExtension())) continue;
                return type;
            }
        }
        return defaultType;
    }

    static {
        ArrayList<String> exts = new ArrayList<String>();
        for (FileType type : libraryTypes) {
            String[] typeExts;
            for (String typeExt : typeExts = type.getExtensions()) {
                exts.add(typeExt);
            }
        }
        libraryTypesExt = new String[exts.size()];
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < exts.size(); ++i) {
            FileType.libraryTypesExt[i] = (String)exts.get(i);
            buf.append((String)exts.get(i));
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.replace(buf.length() - 2, buf.length(), ")");
        }
        libraryTypesExtReadable = buf.toString();
        LIBRARYFORMATS = FileType.makeFileType("LibraryFormats", libraryTypesExt, "Library Formats " + libraryTypesExtReadable, FileTypeGroup.DATABASEGRP);
    }

    private static class FileFilterAWT
    implements FilenameFilter {
        private String[] extensions;
        private String desc;
        private boolean allowNumbers;

        public FileFilterAWT(String[] extensions, String desc, boolean allowNumbers) {
            this.extensions = extensions;
            this.desc = desc;
            this.allowNumbers = allowNumbers;
        }

        @Override
        public boolean accept(File f2, String fileName) {
            return FileType.matches(fileName, this.extensions, this.allowNumbers);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    private static class FileFilterSwing
    extends FileFilter {
        private String[] extensions;
        private String desc;
        private boolean allowNumbers;

        public FileFilterSwing(String[] extensions, String desc, boolean allowNumbers) {
            this.extensions = extensions;
            this.desc = desc;
            this.allowNumbers = allowNumbers;
        }

        @Override
        public boolean accept(File f2) {
            if (f2 == null) {
                return false;
            }
            if (f2.isDirectory()) {
                return true;
            }
            String fileName = f2.getName();
            return FileType.matches(fileName, this.extensions, this.allowNumbers);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static enum FileTypeGroup {
        DATABASEGRP("Database"),
        OTHERSIMGRP("Others Simulation"),
        SPICESIMGRP("SPICE Simulation"),
        BUILTINSIMGRP("Built-In Simulation"),
        VERILOGSIMGRP("Verilog Simulation"),
        EXPORTIMPORTGRP("Export-Import"),
        JARGRP("Electric Build");

        String groupName;

        private FileTypeGroup(String grpName) {
            this.groupName = grpName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String toString() {
            return this.groupName;
        }
    }
}

