/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AddLibraryJob
extends Job {
    private Set<Library> libList;
    private ProjectDB pdb;
    private int backupScheme;

    public static void addThisLibrary() {
        AddLibraryJob.addLibrary(Library.getCurrent());
    }

    public static void addLibrary(Library lib) {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        boolean response = Job.getUserInterface().confirmMessage("Are you sure you want to enter this library into the repository?");
        if (!response) {
            return;
        }
        HashSet<Library> yesList = new HashSet<Library>();
        yesList.add(lib);
        HashSet<Library> noList = new HashSet<Library>();
        AddLibraryJob.includeDependentLibraries(lib, yesList, noList, false);
        new AddLibraryJob(yesList);
    }

    public static void addAllLibraries() {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        boolean response = Job.getUserInterface().confirmMessage("Are you sure you want to enter libraries into the repository?");
        if (!response) {
            return;
        }
        HashSet<Library> libList = new HashSet<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || Project.isLibraryManaged(lib)) continue;
            libList.add(lib);
        }
        new AddLibraryJob(libList);
    }

    private AddLibraryJob(Set<Library> libList) {
        super("Add Library", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.libList = libList;
        this.pdb = Project.projectDB;
        this.backupScheme = IOTool.getBackupRedundancy();
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        for (Library aLib : this.libList) {
            ProjectLibrary pl = this.pdb.findProjectLibrary(aLib);
            if (!pl.isEmpty()) continue;
            this.addLibraryNow(aLib, pl);
        }
        this.fieldVariableChanged("pdb");
        return true;
    }

    @Override
    public void terminateOK() {
        Project.projectDB = this.pdb;
        WindowFrame.wantToRedoLibraryTree();
        Job.getUserInterface().showInformationMessage("Libraries have been checked-into the repository and marked appropriately.", "Libraries Added");
    }

    private static void includeDependentLibraries(Library lib, Set<Library> yesList, Set<Library> noList, boolean yesToAll) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            Iterator<NodeInst> nIt = cell.getNodes();
            while (nIt.hasNext()) {
                Cell subCell;
                Library oLib;
                NodeInst ni = nIt.next();
                if (!ni.isCellInstance() || (oLib = (subCell = (Cell)ni.getProto()).getLibrary()) == lib || yesList.contains(oLib) || noList.contains(oLib) || Project.isLibraryManaged(oLib)) continue;
                int ret = 0;
                if (!yesToAll) {
                    String[] options = new String[]{"Yes", "No", "Yes to All"};
                    ret = Job.getUserInterface().askForChoice("Do you also want to add dependent library " + oLib.getName() + " to the repository?", "Add Dependent Library To Repository", options, "Yes");
                }
                if (ret == 1) {
                    noList.add(oLib);
                    continue;
                }
                if (ret == 2) {
                    yesToAll = true;
                }
                yesList.add(oLib);
                AddLibraryJob.includeDependentLibraries(oLib, yesList, noList, yesToAll);
            }
        }
    }

    private void addLibraryNow(Library lib, ProjectLibrary pl) throws JobException {
        EditingPreferences ep = this.getEditingPreferences();
        String libraryname = lib.getName();
        pl.setProjectDirectory(Project.getRepositoryLocation() + File.separator + libraryname);
        File dir = new File(pl.getProjectDirectory());
        if (dir.exists()) {
            throw new JobException("Repository directory '" + pl.getProjectDirectory() + "' already exists");
        }
        if (!dir.mkdir()) {
            throw new JobException("Could not create repository directory '" + pl.getProjectDirectory() + "'");
        }
        System.out.println("Making repository directory '" + pl.getProjectDirectory() + "'...");
        Project.setChangeStatus(true);
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            ProjectCell pc = new ProjectCell(cell, pl);
            pc.setLastOwner(Project.getCurrentUserName());
            pc.setComment("Initial checkin");
            if (cell.getNewestVersion() != cell) {
                if (cell.getNumUsagesIn() == 0) continue;
                System.out.println("Warning: including old version of " + cell);
                pc.setLatestVersion(false);
            }
            pl.linkProjectCellToCell(pc, cell);
            if (Project.writeCell(cell, pc, this.backupScheme, ep)) {
                System.out.println("Error writing cell file");
                continue;
            }
            System.out.println("Entering " + cell);
            Project.markLocked(cell, true, ep);
        }
        String projfile = pl.getProjectDirectory() + File.separator + "project.proj";
        lib.newVar(Project.PROJPATHKEY, (Object)projfile, ep);
        try {
            PrintStream buffWriter = new PrintStream(new FileOutputStream(projfile));
            Iterator<ProjectCell> it2 = pl.getProjectCells();
            while (it2.hasNext()) {
                ProjectCell pc = it2.next();
                buffWriter.println("::" + pc.getCellName() + ":" + pc.getVersion() + "-" + pc.getView().getFullName() + "." + pc.getLibExtension() + ":" + pc.getOwner() + ":" + pc.getLastOwner() + ":" + pc.getComment());
            }
            buffWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error creating " + projfile);
        }
        Project.setChangeStatus(false);
    }
}

