/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.machine;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStar;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar2.machine.AStarMachine;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar2.storage.AStarClosedListReferencing;
import com.sun.electric.tool.routing.experimentalAStar2.storage.AStarOpenListCheapList;
import java.util.List;

public class AStarRegionMachine
implements AStarMachine<AStarRegionNode>,
AStarMapVisitorBase<AStarRegionNode> {
    private ObjectPool<AStarRegionNode> nodePool;
    private AStarOpenListCheapList<AStarRegionNode> openList;
    private AStarClosedListReferencing<AStarRegionNode> closedList;
    private AStarMapBase<AStarRegionNode> map = null;
    private AStarGoalBase<AStarRegionNode> goal = null;

    public AStarRegionMachine(ObjectPool<AStarRegionNode> nodePool) {
        this.nodePool = nodePool;
        this.openList = new AStarOpenListCheapList();
        this.closedList = new AStarClosedListReferencing();
    }

    @Override
    public List<AStarRegionNode> findPath(int startX, int startY, int startZ, int goalX, int goalY, int goalZ) {
        if (this.map == null) {
            throw new IllegalStateException("The searched map must be specified before path search can be done.");
        }
        if (this.goal == null) {
            throw new IllegalStateException("The goal object must be specified before path search can be done.");
        }
        AStarRegionNode startRegion = this.map.nodeAt(startX, startY, startZ);
        AStarRegionNode goalRegion = this.map.nodeAt(goalX, goalY, goalZ);
        assert (startRegion != null);
        assert (goalRegion != null);
        this.goal.setGoalNode(goalRegion);
        int goalDistance = this.goal.distanceToGoal(startX, startY, startZ);
        goalRegion.initialize(null, goalDistance, 0, goalDistance, goalX, goalY, goalZ);
        startRegion.initialize(null, 0, goalDistance, goalDistance, startX, startY, startZ);
        this.openList.addNodeToOpenList(startRegion);
        return AStar.findPath(this.openList, this.closedList, this.map, this.goal, this.nodePool, this);
    }

    @Override
    public void setUpSearchSpace(AStarMapBase<AStarRegionNode> newMap, AStarGoalBase<AStarRegionNode> newGoal) {
        if (newMap == null) {
            throw new IllegalArgumentException("The map to search may not be null.");
        }
        if (newGoal == null) {
            throw new IllegalArgumentException("The goal object may not be null.");
        }
        this.map = newMap;
        this.openList.setMap(this.map);
        this.closedList.setMap(this.map);
        this.goal = newGoal;
        this.goal.setNodeStorage(this.openList);
    }

    @Override
    public void visitNeighbour(AStarRegionNode origin, int x2, int y, int z) {
        if (origin.getX() == x2 && (!origin.isTerminalRegion() && origin.getVerticalCapacity() == 0 || !this.map.nodeAt(x2, y, z).isTerminalRegion() && this.map.nodeAt(x2, y, z).getVerticalCapacity() == 0)) {
            return;
        }
        if (origin.getY() == y && (!origin.isTerminalRegion() && origin.getHorizontalCapacity() == 0 || !this.map.nodeAt(x2, y, z).isTerminalRegion() && this.map.nodeAt(x2, y, z).getHorizontalCapacity() == 0)) {
            return;
        }
        int costFromStart = origin.getCostFromStart() + this.goal.getNodeCost(origin, x2, y, z);
        int costToGoal = this.goal.distanceToGoal(x2, y, z);
        int totalCost = costFromStart + costToGoal;
        AStarRegionNode foundNode = this.openList.findOpenNode(x2, y, z);
        AStarNode portal = null;
        boolean foundCheaperPath = false;
        if (foundNode != null) {
            if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                foundCheaperPath = true;
                this.openList.removeNodeFromOpenList(foundNode);
            }
        } else {
            foundNode = this.closedList.findClosedNode(x2, y, z);
            if (foundNode != null) {
                if (totalCost < foundNode.getTotalCost() && (portal = this.findPortal(origin, foundNode)) != null) {
                    foundCheaperPath = true;
                    this.closedList.removeNodeFromClosedList(foundNode);
                }
            } else {
                foundNode = this.map.nodeAt(x2, y, z);
                portal = this.findPortal(origin, foundNode);
                if (portal != null) {
                    foundCheaperPath = true;
                }
            }
        }
        if (foundCheaperPath) {
            foundNode.initialize(origin, costFromStart, costToGoal, totalCost, x2, y, z);
            foundNode.setEntryPoint(portal);
            this.openList.addNodeToOpenList(foundNode);
        }
    }

    public AStarNode findPortal(AStarRegionNode originRegion, AStarRegionNode targetRegion) {
        AStarNode result2;
        block15: {
            int fy;
            int oy;
            block17: {
                block16: {
                    int fx;
                    int ox;
                    block14: {
                        result2 = null;
                        if (originRegion.getZ() != targetRegion.getZ()) {
                            if (targetRegion.isTileBlocked(originRegion.getEntryPoint().getX(), originRegion.getEntryPoint().getY())) {
                                return null;
                            }
                            return originRegion.getEntryPoint();
                        }
                        ox = originRegion.getX();
                        fx = targetRegion.getX();
                        oy = originRegion.getY();
                        fy = targetRegion.getY();
                        if (ox != fx - 1) break block14;
                        int targetX = 0;
                        int originX = originRegion.width - 1;
                        int y = originRegion.getEntryPoint().getY();
                        int count2 = 0;
                        while (y + count2 < originRegion.height || y - count2 >= 0) {
                            if (y + count2 < originRegion.height && originRegion.isPortalWithPath(originX, y + count2, false) && targetRegion.isPortalWithPath(targetX, y + count2, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y + count2, 0);
                            }
                            if (y - count2 >= 0 && originRegion.isPortalWithPath(originX, y - count2, false) && targetRegion.isPortalWithPath(targetX, y - count2, false)) {
                                return targetRegion.getMap(false).nodeAt(targetX, y - count2, 0);
                            }
                            ++count2;
                        }
                        break block15;
                    }
                    if (ox != fx + 1) break block16;
                    int targetX = originRegion.width - 1;
                    int originX = 0;
                    int y = originRegion.getEntryPoint().getY();
                    int count3 = 0;
                    while (y + count3 < originRegion.height || y - count3 >= 0) {
                        if (y + count3 < originRegion.height && originRegion.isPortalWithPath(originX, y + count3, false) && targetRegion.isPortalWithPath(targetX, y + count3, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y + count3, 0);
                        }
                        if (y - count3 >= 0 && originRegion.isPortalWithPath(originX, y - count3, false) && targetRegion.isPortalWithPath(targetX, y - count3, false)) {
                            return targetRegion.getMap(false).nodeAt(targetX, y - count3, 0);
                        }
                        ++count3;
                    }
                    break block15;
                }
                if (oy != fy + 1) break block17;
                int targetY = originRegion.height - 1;
                int originY = 0;
                int x2 = originRegion.getEntryPoint().getX();
                int count4 = 0;
                while (x2 + count4 < originRegion.width || x2 - count4 >= 0) {
                    if (x2 + count4 < originRegion.width && originRegion.isPortalWithPath(x2 + count4, originY, true) && targetRegion.isPortalWithPath(x2 + count4, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x2 + count4, targetY, 0);
                    }
                    if (x2 - count4 >= 0 && originRegion.isPortalWithPath(x2 - count4, originY, true) && targetRegion.isPortalWithPath(x2 - count4, targetY, true)) {
                        return targetRegion.getMap(false).nodeAt(x2 - count4, targetY, 0);
                    }
                    ++count4;
                }
                break block15;
            }
            if (oy != fy - 1) break block15;
            int targetY = 0;
            int originY = originRegion.height - 1;
            int x3 = originRegion.getEntryPoint().getX();
            int count5 = 0;
            while (x3 + count5 < originRegion.width || x3 - count5 >= 0) {
                if (x3 + count5 < originRegion.width && originRegion.isPortalWithPath(x3 + count5, originY, true) && targetRegion.isPortalWithPath(x3 + count5, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x3 + count5, targetY, 0);
                }
                if (x3 - count5 >= 0 && originRegion.isPortalWithPath(x3 - count5, originY, true) && targetRegion.isPortalWithPath(x3 - count5, targetY, true)) {
                    return targetRegion.getMap(false).nodeAt(x3 - count5, targetY, 0);
                }
                ++count5;
            }
        }
        return result2;
    }
}

