/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class OpenFile {
    public static String chooseInputFile(FileType type, String title, EditingPreferences ep) {
        if (ep == null) {
            ep = EditingPreferences.getInstance();
        }
        return OpenFile.chooseInputFile(type, title, false, ep.getWorkingDirectory(), true, ep);
    }

    public static String chooseDirectory(String title) {
        return OpenFile.chooseInputFile(null, title, true, User.getWorkingDirectory(), true, EditingPreferences.getInstance());
    }

    public static String chooseInputFile(FileType type, String title, boolean wantDirectory) {
        return OpenFile.chooseInputFile(type, title, wantDirectory, User.getWorkingDirectory(), true, EditingPreferences.getInstance());
    }

    public static String chooseInputFile(FileType type, String title, boolean wantDirectory, String initialDir, boolean setSelectedDirAsWorkingDir, EditingPreferences ep) {
        String path;
        if (title == null) {
            title = type != null ? (wantDirectory ? "Choose Directory with " + type.getDescription() + " files" : "Open " + type.getDescription()) : (wantDirectory ? "Choose Directory" : "Open file");
        }
        String string2 = path = type != null && ep != null ? type.getGroupPath(ep) : null;
        if (path != null) {
            initialDir = path;
        }
        OpenFileSwing dialog = new OpenFileSwing();
        dialog.saveDialog = false;
        dialog.setSelectedDirAsWorkingDir = setSelectedDirAsWorkingDir;
        dialog.fileType = type;
        dialog.setDialogTitle(title);
        File dir = new File(initialDir);
        if (!dir.exists() || !dir.isDirectory()) {
            dir = new File(User.getWorkingDirectory());
        }
        dialog.setCurrentDirectory(dir);
        if (type != null) {
            if (type == FileType.ELIB || type == FileType.JELIB || type == FileType.DELIB || type == FileType.LIBFILE || type == FileType.LIBRARYFORMATS) {
                LibDirs.LibDirFileSystemView view = LibDirs.newLibDirFileSystemView(dialog.getFileSystemView());
                dialog.setFileSystemView(view);
                dialog.setFileView(new LibDirs.LibDirFileView(view));
            }
            dialog.setFileFilter(type.getFileFilterSwing());
        }
        if (wantDirectory) {
            dialog.setFileSelectionMode(1);
        }
        JFrame chooseFrame = new JFrame();
        chooseFrame.setIconImage(TopLevel.getFrameIcon().getImage());
        int returnVal = dialog.showOpenDialog(chooseFrame);
        if (returnVal == 0) {
            File file = dialog.getSelectedFile();
            return file.getPath();
        }
        return null;
    }

    public static String chooseOutputFile(FileType type, String title, String defaultFile) {
        FileType[] types = type == null ? null : new FileType[]{type};
        return OpenFile.chooseOutputFile(types, title, defaultFile);
    }

    public static String chooseOutputFile(FileType[] types, String title, String defaultFile) {
        if (title == null) {
            title = types != null ? "Write " + types[0].getDescription() : "Write file";
        }
        if (types == null) {
            types = new FileType[]{FileType.ANY};
        }
        String initialDir = User.getWorkingDirectory();
        String path = types[0].getGroupPath();
        if (path != null) {
            initialDir = path;
        }
        OpenFileSwing dialog = new OpenFileSwing();
        dialog.saveDialog = true;
        dialog.setDialogTitle(title);
        for (int i = 0; i < types.length; ++i) {
            dialog.addChoosableFileFilter(types[i].getFileFilterSwing());
        }
        dialog.setCurrentDirectory(new File(initialDir));
        if (defaultFile != null) {
            dialog.setFileFilter(FileMenu.getLibraryFormat(defaultFile, types[0]).getFileFilterSwing());
            dialog.setSelectedFile(new File(defaultFile));
        }
        JFrame chooseFrame = new JFrame();
        chooseFrame.setIconImage(TopLevel.getFrameIcon().getImage());
        int returnVal = dialog.showSaveDialog(chooseFrame);
        if (returnVal == 0) {
            File file = dialog.getSelectedFile();
            String fileName = file.getPath();
            FileType selectedType = FileType.getType(dialog.getFileFilter());
            if (selectedType != null) {
                boolean validExtension;
                String dir = TextUtils.getFilePath(TextUtils.makeURLToFile(fileName));
                selectedType.setGroupPath(dir);
                String[] exts = selectedType.getExtensions();
                boolean bl = validExtension = exts != null && exts.length > 0;
                if (validExtension) {
                    String extension = exts[0];
                    int dotPos = fileName.lastIndexOf(46);
                    if (dotPos < 0) {
                        fileName = fileName + "." + extension;
                    } else if (!fileName.substring(dotPos + 1).startsWith(extension)) {
                        fileName = fileName + "." + extension;
                    }
                }
            }
            return fileName;
        }
        return null;
    }

    public static FileType getOpenFileType(String libName, FileType def) {
        File libFile = new File(libName);
        if ((libName = libFile.getName()).endsWith(File.separator)) {
            libName = libName.substring(0, libName.length() - 1);
        }
        if (libName.endsWith(".elib")) {
            return FileType.ELIB;
        }
        if (libName.endsWith(".jelib")) {
            return FileType.JELIB;
        }
        if (libName.endsWith(".delib")) {
            return FileType.DELIB;
        }
        if (libName.endsWith(".txt")) {
            return FileType.READABLEDUMP;
        }
        return def;
    }

    public static class OpenFileSwing
    extends JFileChooser {
        private boolean saveDialog;
        private boolean setSelectedDirAsWorkingDir;
        File lastDELIBVisit = null;
        private FileType fileType;

        private OpenFileSwing() {
        }

        @Override
        public void approveSelection() {
            File f2 = this.getSelectedFile();
            if (this.saveDialog) {
                int result2;
                String actualGivenExtension;
                String filename = f2.getName();
                FileType selectedType = FileType.getType(this.getFileFilter());
                String extension = TextUtils.getExtension(filename);
                FileType givenExtension = FileType.findTypeByExtension(extension);
                String string2 = actualGivenExtension = givenExtension != null ? givenExtension.getFirstExtension() : extension;
                if (givenExtension != selectedType && !extension.toLowerCase().equals(actualGivenExtension.toLowerCase())) {
                    f2 = new File(f2.getAbsolutePath() + "." + selectedType.getFirstExtension());
                }
                if (f2.exists() && (result2 = JOptionPane.showConfirmDialog(this, "The file " + f2.getName() + " already exists, would you like to overwrite it?", "Overwrite?", 0, 2)) != 0) {
                    return;
                }
            } else {
                FileSystemView view = this.getFileSystemView();
                if (view instanceof LibDirs.LibDirFileSystemView && !f2.exists()) {
                    Iterator<String> it = LibDirs.getLibDirs();
                    while (it.hasNext()) {
                        File newFile;
                        String dirName = it.next();
                        File dir = new File(dirName);
                        if (!dir.exists() || !dir.isDirectory() || !(newFile = new File(dir, f2.getName())).exists()) continue;
                        f2 = newFile;
                        break;
                    }
                }
            }
            this.setSelectedFile(f2);
            if (this.setSelectedDirAsWorkingDir) {
                User.setWorkingDirectory(this.getCurrentDirectory().getPath());
            }
            if (this.fileType != null) {
                this.fileType.setGroupPath(this.getCurrentDirectory().getPath());
            }
            super.approveSelection();
        }

        @Override
        public boolean isTraversable(File f2) {
            this.lastDELIBVisit = null;
            if (f2 == null) {
                return false;
            }
            if (f2.getName().toLowerCase().endsWith("." + FileType.DELIB.getFirstExtension())) {
                this.lastDELIBVisit = f2;
                return false;
            }
            return super.isTraversable(f2);
        }

        @Override
        public boolean isDirectorySelectionEnabled() {
            File file = this.getSelectedFile();
            if (file == null && this.lastDELIBVisit != null) {
                file = this.lastDELIBVisit;
            }
            if (file != null && super.getFileSelectionMode() != 1 && file.getName().toLowerCase().endsWith("." + FileType.DELIB.getFirstExtension())) {
                return true;
            }
            return super.isDirectorySelectionEnabled();
        }

        @Override
        public void setSelectedFile(File file) {
            super.setSelectedFile(file);
        }
    }
}

