/* CPU data header for m32c.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996-2016 Free Software Foundation, Inc.

This file is part of the GNU Binutils and/or GDB, the GNU debugger.

   This file is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.

*/

#ifndef M32C_CPU_H
#define M32C_CPU_H

#define CGEN_ARCH m32c

/* Given symbol S, return m32c_cgen_<S>.  */
#define CGEN_SYM(s) m32c##_cgen_##s


/* Selected cpu families.  */
#define HAVE_CPU_M16CBF
#define HAVE_CPU_M32CBF

#define CGEN_INSN_LSB0_P 0

/* Minimum size of any insn (in bytes).  */
#define CGEN_MIN_INSN_SIZE 1

/* Maximum size of any insn (in bytes).  */
#define CGEN_MAX_INSN_SIZE 10

#define CGEN_INT_INSN_P 0

/* Maximum number of syntax elements in an instruction.  */
#define CGEN_ACTUAL_MAX_SYNTAX_ELEMENTS 21

/* CGEN_MNEMONIC_OPERANDS is defined if mnemonics have operands.
   e.g. In "b,a foo" the ",a" is an operand.  If mnemonics have operands
   we can't hash on everything up to the space.  */
#define CGEN_MNEMONIC_OPERANDS

/* Maximum number of fields in an instruction.  */
#define CGEN_ACTUAL_MAX_IFMT_OPERANDS 13

/* Attributes.  */

/* Enum declaration for machine type selection.  */
typedef enum mach_attr {
  MACH_BASE, MACH_M16C, MACH_M32C, MACH_MAX
} MACH_ATTR;

/* Enum declaration for instruction set selection.  */
typedef enum isa_attr {
  ISA_M16C, ISA_M32C, ISA_MAX
} ISA_ATTR;

/* Enum declaration for .  */
typedef enum rl_type_attr {
  RL_TYPE_NONE, RL_TYPE_JUMP, RL_TYPE_1ADDR, RL_TYPE_2ADDR
} RL_TYPE_ATTR;

/* Number of architecture variants.  */
#define MAX_ISAS  ((int) ISA_MAX)
#define MAX_MACHS ((int) MACH_MAX)

/* Ifield support.  */

/* Ifield attribute indices.  */

/* Enum declaration for cgen_ifld attrs.  */
typedef enum cgen_ifld_attr {
  CGEN_IFLD_VIRTUAL, CGEN_IFLD_PCREL_ADDR, CGEN_IFLD_ABS_ADDR, CGEN_IFLD_RESERVED
 , CGEN_IFLD_SIGN_OPT, CGEN_IFLD_SIGNED, CGEN_IFLD_END_BOOLS, CGEN_IFLD_START_NBOOLS = 31
 , CGEN_IFLD_MACH, CGEN_IFLD_ISA, CGEN_IFLD_RL_TYPE, CGEN_IFLD_END_NBOOLS
} CGEN_IFLD_ATTR;

/* Number of non-boolean elements in cgen_ifld_attr.  */
#define CGEN_IFLD_NBOOL_ATTRS (CGEN_IFLD_END_NBOOLS - CGEN_IFLD_START_NBOOLS - 1)

/* cgen_ifld attribute accessor macros.  */
#define CGEN_ATTR_CGEN_IFLD_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_IFLD_MACH-CGEN_IFLD_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_IFLD_ISA_VALUE(attrs) ((attrs)->nonbool[CGEN_IFLD_ISA-CGEN_IFLD_START_NBOOLS-1].bitset)
#define CGEN_ATTR_CGEN_IFLD_RL_TYPE_VALUE(attrs) ((attrs)->nonbool[CGEN_IFLD_RL_TYPE-CGEN_IFLD_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_IFLD_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_IFLD_PCREL_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_PCREL_ADDR)) != 0)
#define CGEN_ATTR_CGEN_IFLD_ABS_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_ABS_ADDR)) != 0)
#define CGEN_ATTR_CGEN_IFLD_RESERVED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_RESERVED)) != 0)
#define CGEN_ATTR_CGEN_IFLD_SIGN_OPT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_SIGN_OPT)) != 0)
#define CGEN_ATTR_CGEN_IFLD_SIGNED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_SIGNED)) != 0)

/* Enum declaration for m32c ifield types.  */
typedef enum ifield_type {
  M32C_F_NIL, M32C_F_ANYOF, M32C_F_0_1, M32C_F_0_2
 , M32C_F_0_3, M32C_F_0_4, M32C_F_1_3, M32C_F_2_2
 , M32C_F_3_4, M32C_F_3_1, M32C_F_4_1, M32C_F_4_3
 , M32C_F_4_4, M32C_F_4_6, M32C_F_5_1, M32C_F_5_3
 , M32C_F_6_2, M32C_F_7_1, M32C_F_8_1, M32C_F_8_2
 , M32C_F_8_3, M32C_F_8_4, M32C_F_8_8, M32C_F_9_3
 , M32C_F_9_1, M32C_F_10_1, M32C_F_10_2, M32C_F_10_3
 , M32C_F_11_1, M32C_F_12_1, M32C_F_12_2, M32C_F_12_3
 , M32C_F_12_4, M32C_F_12_6, M32C_F_13_3, M32C_F_14_1
 , M32C_F_14_2, M32C_F_15_1, M32C_F_16_1, M32C_F_16_2
 , M32C_F_16_4, M32C_F_16_8, M32C_F_18_1, M32C_F_18_2
 , M32C_F_18_3, M32C_F_20_1, M32C_F_20_3, M32C_F_20_2
 , M32C_F_20_4, M32C_F_21_3, M32C_F_24_2, M32C_F_24_8
 , M32C_F_32_16, M32C_F_SRC16_RN, M32C_F_SRC16_AN, M32C_F_SRC32_AN_UNPREFIXED
 , M32C_F_SRC32_AN_PREFIXED, M32C_F_SRC32_RN_UNPREFIXED_QI, M32C_F_SRC32_RN_PREFIXED_QI, M32C_F_SRC32_RN_UNPREFIXED_HI
 , M32C_F_SRC32_RN_PREFIXED_HI, M32C_F_SRC32_RN_UNPREFIXED_SI, M32C_F_SRC32_RN_PREFIXED_SI, M32C_F_DST32_RN_EXT_UNPREFIXED
 , M32C_F_DST16_RN, M32C_F_DST16_RN_EXT, M32C_F_DST16_RN_QI_S, M32C_F_DST16_AN
 , M32C_F_DST16_AN_S, M32C_F_DST32_AN_UNPREFIXED, M32C_F_DST32_AN_PREFIXED, M32C_F_DST32_RN_UNPREFIXED_QI
 , M32C_F_DST32_RN_PREFIXED_QI, M32C_F_DST32_RN_UNPREFIXED_HI, M32C_F_DST32_RN_PREFIXED_HI, M32C_F_DST32_RN_UNPREFIXED_SI
 , M32C_F_DST32_RN_PREFIXED_SI, M32C_F_DST16_1_S, M32C_F_IMM_8_S4, M32C_F_IMM_12_S4
 , M32C_F_IMM_13_U3, M32C_F_IMM_20_S4, M32C_F_IMM1_S, M32C_F_IMM3_S
 , M32C_F_DSP_8_U6, M32C_F_DSP_8_U8, M32C_F_DSP_8_S8, M32C_F_DSP_10_U6
 , M32C_F_DSP_16_U8, M32C_F_DSP_16_S8, M32C_F_DSP_24_U8, M32C_F_DSP_24_S8
 , M32C_F_DSP_32_U8, M32C_F_DSP_32_S8, M32C_F_DSP_40_U8, M32C_F_DSP_40_S8
 , M32C_F_DSP_48_U8, M32C_F_DSP_48_S8, M32C_F_DSP_56_U8, M32C_F_DSP_56_S8
 , M32C_F_DSP_64_U8, M32C_F_DSP_64_S8, M32C_F_DSP_8_U16, M32C_F_DSP_8_S16
 , M32C_F_DSP_16_U16, M32C_F_DSP_16_S16, M32C_F_DSP_24_U16, M32C_F_DSP_24_S16
 , M32C_F_DSP_32_U16, M32C_F_DSP_32_S16, M32C_F_DSP_40_U16, M32C_F_DSP_40_S16
 , M32C_F_DSP_48_U16, M32C_F_DSP_48_S16, M32C_F_DSP_64_U16, M32C_F_DSP_8_S24
 , M32C_F_DSP_8_U24, M32C_F_DSP_16_U24, M32C_F_DSP_24_U24, M32C_F_DSP_32_U24
 , M32C_F_DSP_40_U20, M32C_F_DSP_40_U24, M32C_F_DSP_40_S32, M32C_F_DSP_48_U20
 , M32C_F_DSP_48_U24, M32C_F_DSP_16_S32, M32C_F_DSP_24_S32, M32C_F_DSP_32_S32
 , M32C_F_DSP_48_U32, M32C_F_DSP_48_S32, M32C_F_DSP_56_S16, M32C_F_DSP_64_S16
 , M32C_F_BITNO16_S, M32C_F_BITNO32_PREFIXED, M32C_F_BITNO32_UNPREFIXED, M32C_F_BITBASE16_U11_S
 , M32C_F_BITBASE32_16_U11_UNPREFIXED, M32C_F_BITBASE32_16_S11_UNPREFIXED, M32C_F_BITBASE32_16_U19_UNPREFIXED, M32C_F_BITBASE32_16_S19_UNPREFIXED
 , M32C_F_BITBASE32_16_U27_UNPREFIXED, M32C_F_BITBASE32_24_U11_PREFIXED, M32C_F_BITBASE32_24_S11_PREFIXED, M32C_F_BITBASE32_24_U19_PREFIXED
 , M32C_F_BITBASE32_24_S19_PREFIXED, M32C_F_BITBASE32_24_U27_PREFIXED, M32C_F_LAB_5_3, M32C_F_LAB32_JMP_S
 , M32C_F_LAB_8_8, M32C_F_LAB_8_16, M32C_F_LAB_8_24, M32C_F_LAB_16_8
 , M32C_F_LAB_24_8, M32C_F_LAB_32_8, M32C_F_LAB_40_8, M32C_F_COND16
 , M32C_F_COND16J_5, M32C_F_COND32, M32C_F_COND32J, M32C_F_MAX
} IFIELD_TYPE;

#define MAX_IFLD ((int) M32C_F_MAX)

/* Hardware attribute indices.  */

/* Enum declaration for cgen_hw attrs.  */
typedef enum cgen_hw_attr {
  CGEN_HW_VIRTUAL, CGEN_HW_CACHE_ADDR, CGEN_HW_PC, CGEN_HW_PROFILE
 , CGEN_HW_END_BOOLS, CGEN_HW_START_NBOOLS = 31, CGEN_HW_MACH, CGEN_HW_ISA
 , CGEN_HW_RL_TYPE, CGEN_HW_END_NBOOLS
} CGEN_HW_ATTR;

/* Number of non-boolean elements in cgen_hw_attr.  */
#define CGEN_HW_NBOOL_ATTRS (CGEN_HW_END_NBOOLS - CGEN_HW_START_NBOOLS - 1)

/* cgen_hw attribute accessor macros.  */
#define CGEN_ATTR_CGEN_HW_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_HW_MACH-CGEN_HW_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_HW_ISA_VALUE(attrs) ((attrs)->nonbool[CGEN_HW_ISA-CGEN_HW_START_NBOOLS-1].bitset)
#define CGEN_ATTR_CGEN_HW_RL_TYPE_VALUE(attrs) ((attrs)->nonbool[CGEN_HW_RL_TYPE-CGEN_HW_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_HW_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_HW_CACHE_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_CACHE_ADDR)) != 0)
#define CGEN_ATTR_CGEN_HW_PC_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_PC)) != 0)
#define CGEN_ATTR_CGEN_HW_PROFILE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_PROFILE)) != 0)

/* Enum declaration for m32c hardware types.  */
typedef enum cgen_hw_type {
  HW_H_MEMORY, HW_H_SINT, HW_H_UINT, HW_H_ADDR
 , HW_H_IADDR, HW_H_PC, HW_H_GR, HW_H_GR_QI
 , HW_H_GR_HI, HW_H_GR_SI, HW_H_GR_EXT_QI, HW_H_GR_EXT_HI
 , HW_H_R0L, HW_H_R0H, HW_H_R1L, HW_H_R1H
 , HW_H_R0, HW_H_R1, HW_H_R2, HW_H_R3
 , HW_H_R0L_R0H, HW_H_R2R0, HW_H_R3R1, HW_H_R1R2R0
 , HW_H_AR, HW_H_AR_QI, HW_H_AR_HI, HW_H_AR_SI
 , HW_H_A0, HW_H_A1, HW_H_SB, HW_H_FB
 , HW_H_SP, HW_H_SBIT, HW_H_ZBIT, HW_H_OBIT
 , HW_H_CBIT, HW_H_UBIT, HW_H_IBIT, HW_H_BBIT
 , HW_H_DBIT, HW_H_DCT0, HW_H_DCT1, HW_H_SVF
 , HW_H_DRC0, HW_H_DRC1, HW_H_DMD0, HW_H_DMD1
 , HW_H_INTB, HW_H_SVP, HW_H_VCT, HW_H_ISP
 , HW_H_DMA0, HW_H_DMA1, HW_H_DRA0, HW_H_DRA1
 , HW_H_DSA0, HW_H_DSA1, HW_H_COND16, HW_H_COND16C
 , HW_H_COND16J, HW_H_COND16J_5, HW_H_COND32, HW_H_CR1_32
 , HW_H_CR2_32, HW_H_CR3_32, HW_H_CR_16, HW_H_FLAGS
 , HW_H_SHIMM, HW_H_BIT_INDEX, HW_H_SRC_INDEX, HW_H_DST_INDEX
 , HW_H_SRC_INDIRECT, HW_H_DST_INDIRECT, HW_H_NONE, HW_MAX
} CGEN_HW_TYPE;

#define MAX_HW ((int) HW_MAX)

/* Operand attribute indices.  */

/* Enum declaration for cgen_operand attrs.  */
typedef enum cgen_operand_attr {
  CGEN_OPERAND_VIRTUAL, CGEN_OPERAND_PCREL_ADDR, CGEN_OPERAND_ABS_ADDR, CGEN_OPERAND_SIGN_OPT
 , CGEN_OPERAND_SIGNED, CGEN_OPERAND_NEGATIVE, CGEN_OPERAND_RELAX, CGEN_OPERAND_SEM_ONLY
 , CGEN_OPERAND_END_BOOLS, CGEN_OPERAND_START_NBOOLS = 31, CGEN_OPERAND_MACH, CGEN_OPERAND_ISA
 , CGEN_OPERAND_RL_TYPE, CGEN_OPERAND_END_NBOOLS
} CGEN_OPERAND_ATTR;

/* Number of non-boolean elements in cgen_operand_attr.  */
#define CGEN_OPERAND_NBOOL_ATTRS (CGEN_OPERAND_END_NBOOLS - CGEN_OPERAND_START_NBOOLS - 1)

/* cgen_operand attribute accessor macros.  */
#define CGEN_ATTR_CGEN_OPERAND_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_OPERAND_MACH-CGEN_OPERAND_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_OPERAND_ISA_VALUE(attrs) ((attrs)->nonbool[CGEN_OPERAND_ISA-CGEN_OPERAND_START_NBOOLS-1].bitset)
#define CGEN_ATTR_CGEN_OPERAND_RL_TYPE_VALUE(attrs) ((attrs)->nonbool[CGEN_OPERAND_RL_TYPE-CGEN_OPERAND_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_OPERAND_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_PCREL_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_PCREL_ADDR)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_ABS_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_ABS_ADDR)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SIGN_OPT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SIGN_OPT)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SIGNED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SIGNED)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_NEGATIVE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_NEGATIVE)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_RELAX_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_RELAX)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SEM_ONLY_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SEM_ONLY)) != 0)

/* Enum declaration for m32c operand types.  */
typedef enum cgen_operand_type {
  M32C_OPERAND_PC, M32C_OPERAND_SRC16RNQI, M32C_OPERAND_SRC16RNHI, M32C_OPERAND_SRC32RNUNPREFIXEDQI
 , M32C_OPERAND_SRC32RNUNPREFIXEDHI, M32C_OPERAND_SRC32RNUNPREFIXEDSI, M32C_OPERAND_SRC32RNPREFIXEDQI, M32C_OPERAND_SRC32RNPREFIXEDHI
 , M32C_OPERAND_SRC32RNPREFIXEDSI, M32C_OPERAND_SRC16AN, M32C_OPERAND_SRC16ANQI, M32C_OPERAND_SRC16ANHI
 , M32C_OPERAND_SRC32ANUNPREFIXED, M32C_OPERAND_SRC32ANUNPREFIXEDQI, M32C_OPERAND_SRC32ANUNPREFIXEDHI, M32C_OPERAND_SRC32ANUNPREFIXEDSI
 , M32C_OPERAND_SRC32ANPREFIXED, M32C_OPERAND_SRC32ANPREFIXEDQI, M32C_OPERAND_SRC32ANPREFIXEDHI, M32C_OPERAND_SRC32ANPREFIXEDSI
 , M32C_OPERAND_DST16RNQI, M32C_OPERAND_DST16RNHI, M32C_OPERAND_DST16RNSI, M32C_OPERAND_DST16RNEXTQI
 , M32C_OPERAND_DST32R0QI_S, M32C_OPERAND_DST32R0HI_S, M32C_OPERAND_DST32RNUNPREFIXEDQI, M32C_OPERAND_DST32RNUNPREFIXEDHI
 , M32C_OPERAND_DST32RNUNPREFIXEDSI, M32C_OPERAND_DST32RNEXTUNPREFIXEDQI, M32C_OPERAND_DST32RNEXTUNPREFIXEDHI, M32C_OPERAND_DST32RNPREFIXEDQI
 , M32C_OPERAND_DST32RNPREFIXEDHI, M32C_OPERAND_DST32RNPREFIXEDSI, M32C_OPERAND_DST16RNQI_S, M32C_OPERAND_DST16ANQI_S
 , M32C_OPERAND_BIT16RN, M32C_OPERAND_BIT32RNPREFIXED, M32C_OPERAND_BIT32RNUNPREFIXED, M32C_OPERAND_R0
 , M32C_OPERAND_R1, M32C_OPERAND_R2, M32C_OPERAND_R3, M32C_OPERAND_R0L
 , M32C_OPERAND_R0H, M32C_OPERAND_R2R0, M32C_OPERAND_R3R1, M32C_OPERAND_R1R2R0
 , M32C_OPERAND_DST16AN, M32C_OPERAND_DST16ANQI, M32C_OPERAND_DST16ANHI, M32C_OPERAND_DST16ANSI
 , M32C_OPERAND_DST16AN_S, M32C_OPERAND_DST32ANUNPREFIXED, M32C_OPERAND_DST32ANUNPREFIXEDQI, M32C_OPERAND_DST32ANUNPREFIXEDHI
 , M32C_OPERAND_DST32ANUNPREFIXEDSI, M32C_OPERAND_DST32ANEXTUNPREFIXED, M32C_OPERAND_DST32ANPREFIXED, M32C_OPERAND_DST32ANPREFIXEDQI
 , M32C_OPERAND_DST32ANPREFIXEDHI, M32C_OPERAND_DST32ANPREFIXEDSI, M32C_OPERAND_BIT16AN, M32C_OPERAND_BIT32ANPREFIXED
 , M32C_OPERAND_BIT32ANUNPREFIXED, M32C_OPERAND_A0, M32C_OPERAND_A1, M32C_OPERAND_SB
 , M32C_OPERAND_FB, M32C_OPERAND_SP, M32C_OPERAND_SRCDST16_R0L_R0H_S_NORMAL, M32C_OPERAND_REGSETPOP
 , M32C_OPERAND_REGSETPUSH, M32C_OPERAND_RN16_PUSH_S, M32C_OPERAND_AN16_PUSH_S, M32C_OPERAND_DSP_8_U6
 , M32C_OPERAND_DSP_8_U8, M32C_OPERAND_DSP_8_U16, M32C_OPERAND_DSP_8_S8, M32C_OPERAND_DSP_8_S24
 , M32C_OPERAND_DSP_8_U24, M32C_OPERAND_DSP_10_U6, M32C_OPERAND_DSP_16_U8, M32C_OPERAND_DSP_16_U16
 , M32C_OPERAND_DSP_16_U20, M32C_OPERAND_DSP_16_U24, M32C_OPERAND_DSP_16_S8, M32C_OPERAND_DSP_16_S16
 , M32C_OPERAND_DSP_24_U8, M32C_OPERAND_DSP_24_U16, M32C_OPERAND_DSP_24_U20, M32C_OPERAND_DSP_24_U24
 , M32C_OPERAND_DSP_24_S8, M32C_OPERAND_DSP_24_S16, M32C_OPERAND_DSP_32_U8, M32C_OPERAND_DSP_32_U16
 , M32C_OPERAND_DSP_32_U24, M32C_OPERAND_DSP_32_U20, M32C_OPERAND_DSP_32_S8, M32C_OPERAND_DSP_32_S16
 , M32C_OPERAND_DSP_40_U8, M32C_OPERAND_DSP_40_S8, M32C_OPERAND_DSP_40_U16, M32C_OPERAND_DSP_40_S16
 , M32C_OPERAND_DSP_40_U20, M32C_OPERAND_DSP_40_U24, M32C_OPERAND_DSP_48_U8, M32C_OPERAND_DSP_48_S8
 , M32C_OPERAND_DSP_48_U16, M32C_OPERAND_DSP_48_S16, M32C_OPERAND_DSP_48_U20, M32C_OPERAND_DSP_48_U24
 , M32C_OPERAND_IMM_8_S4, M32C_OPERAND_IMM_8_S4N, M32C_OPERAND_IMM_SH_8_S4, M32C_OPERAND_IMM_8_QI
 , M32C_OPERAND_IMM_8_HI, M32C_OPERAND_IMM_12_S4, M32C_OPERAND_IMM_12_S4N, M32C_OPERAND_IMM_SH_12_S4
 , M32C_OPERAND_IMM_13_U3, M32C_OPERAND_IMM_20_S4, M32C_OPERAND_IMM_SH_20_S4, M32C_OPERAND_IMM_16_QI
 , M32C_OPERAND_IMM_16_HI, M32C_OPERAND_IMM_16_SI, M32C_OPERAND_IMM_24_QI, M32C_OPERAND_IMM_24_HI
 , M32C_OPERAND_IMM_24_SI, M32C_OPERAND_IMM_32_QI, M32C_OPERAND_IMM_32_SI, M32C_OPERAND_IMM_32_HI
 , M32C_OPERAND_IMM_40_QI, M32C_OPERAND_IMM_40_HI, M32C_OPERAND_IMM_40_SI, M32C_OPERAND_IMM_48_QI
 , M32C_OPERAND_IMM_48_HI, M32C_OPERAND_IMM_48_SI, M32C_OPERAND_IMM_56_QI, M32C_OPERAND_IMM_56_HI
 , M32C_OPERAND_IMM_64_HI, M32C_OPERAND_IMM1_S, M32C_OPERAND_IMM3_S, M32C_OPERAND_BIT3_S
 , M32C_OPERAND_BITNO16R, M32C_OPERAND_BITNO32PREFIXED, M32C_OPERAND_BITNO32UNPREFIXED, M32C_OPERAND_BITBASE16_16_U8
 , M32C_OPERAND_BITBASE16_16_S8, M32C_OPERAND_BITBASE16_16_U16, M32C_OPERAND_BITBASE16_8_U11_S, M32C_OPERAND_BITBASE32_16_U11_UNPREFIXED
 , M32C_OPERAND_BITBASE32_16_S11_UNPREFIXED, M32C_OPERAND_BITBASE32_16_U19_UNPREFIXED, M32C_OPERAND_BITBASE32_16_S19_UNPREFIXED, M32C_OPERAND_BITBASE32_16_U27_UNPREFIXED
 , M32C_OPERAND_BITBASE32_24_U11_PREFIXED, M32C_OPERAND_BITBASE32_24_S11_PREFIXED, M32C_OPERAND_BITBASE32_24_U19_PREFIXED, M32C_OPERAND_BITBASE32_24_S19_PREFIXED
 , M32C_OPERAND_BITBASE32_24_U27_PREFIXED, M32C_OPERAND_LAB_5_3, M32C_OPERAND_LAB32_JMP_S, M32C_OPERAND_LAB_8_8
 , M32C_OPERAND_LAB_8_16, M32C_OPERAND_LAB_8_24, M32C_OPERAND_LAB_16_8, M32C_OPERAND_LAB_24_8
 , M32C_OPERAND_LAB_32_8, M32C_OPERAND_LAB_40_8, M32C_OPERAND_SBIT, M32C_OPERAND_OBIT
 , M32C_OPERAND_ZBIT, M32C_OPERAND_CBIT, M32C_OPERAND_UBIT, M32C_OPERAND_IBIT
 , M32C_OPERAND_BBIT, M32C_OPERAND_DBIT, M32C_OPERAND_COND16_16, M32C_OPERAND_COND16_24
 , M32C_OPERAND_COND16_32, M32C_OPERAND_COND32_16, M32C_OPERAND_COND32_24, M32C_OPERAND_COND32_32
 , M32C_OPERAND_COND32_40, M32C_OPERAND_COND16C, M32C_OPERAND_COND16J, M32C_OPERAND_COND16J5
 , M32C_OPERAND_COND32, M32C_OPERAND_COND32J, M32C_OPERAND_SCCOND32, M32C_OPERAND_FLAGS16
 , M32C_OPERAND_FLAGS32, M32C_OPERAND_CR16, M32C_OPERAND_CR1_UNPREFIXED_32, M32C_OPERAND_CR1_PREFIXED_32
 , M32C_OPERAND_CR2_32, M32C_OPERAND_CR3_UNPREFIXED_32, M32C_OPERAND_CR3_PREFIXED_32, M32C_OPERAND_Z
 , M32C_OPERAND_S, M32C_OPERAND_Q, M32C_OPERAND_G, M32C_OPERAND_X
 , M32C_OPERAND_SIZE, M32C_OPERAND_BITINDEX, M32C_OPERAND_SRCINDEX, M32C_OPERAND_DSTINDEX
 , M32C_OPERAND_NOREMAINDER, M32C_OPERAND_SRC16_RN_DIRECT_QI, M32C_OPERAND_SRC16_RN_DIRECT_HI, M32C_OPERAND_SRC32_RN_DIRECT_UNPREFIXED_QI
 , M32C_OPERAND_SRC32_RN_DIRECT_PREFIXED_QI, M32C_OPERAND_SRC32_RN_DIRECT_UNPREFIXED_HI, M32C_OPERAND_SRC32_RN_DIRECT_PREFIXED_HI, M32C_OPERAND_SRC32_RN_DIRECT_UNPREFIXED_SI
 , M32C_OPERAND_SRC32_RN_DIRECT_PREFIXED_SI, M32C_OPERAND_SRC16_AN_DIRECT_QI, M32C_OPERAND_SRC16_AN_DIRECT_HI, M32C_OPERAND_SRC32_AN_DIRECT_UNPREFIXED_QI
 , M32C_OPERAND_SRC32_AN_DIRECT_UNPREFIXED_HI, M32C_OPERAND_SRC32_AN_DIRECT_UNPREFIXED_SI, M32C_OPERAND_SRC32_AN_DIRECT_PREFIXED_QI, M32C_OPERAND_SRC32_AN_DIRECT_PREFIXED_HI
 , M32C_OPERAND_SRC32_AN_DIRECT_PREFIXED_SI, M32C_OPERAND_SRC16_AN_INDIRECT_QI, M32C_OPERAND_SRC16_AN_INDIRECT_HI, M32C_OPERAND_SRC32_AN_INDIRECT_UNPREFIXED_QI
 , M32C_OPERAND_SRC32_AN_INDIRECT_UNPREFIXED_HI, M32C_OPERAND_SRC32_AN_INDIRECT_UNPREFIXED_SI, M32C_OPERAND_SRC32_AN_INDIRECT_PREFIXED_QI, M32C_OPERAND_SRC32_AN_INDIRECT_PREFIXED_HI
 , M32C_OPERAND_SRC32_AN_INDIRECT_PREFIXED_SI, M32C_OPERAND_SRC16_16_8_SB_RELATIVE_QI, M32C_OPERAND_SRC16_16_16_SB_RELATIVE_QI, M32C_OPERAND_SRC16_16_8_FB_RELATIVE_QI
 , M32C_OPERAND_SRC16_16_8_AN_RELATIVE_QI, M32C_OPERAND_SRC16_16_16_AN_RELATIVE_QI, M32C_OPERAND_SRC16_16_20_AN_RELATIVE_QI, M32C_OPERAND_SRC16_16_8_SB_RELATIVE_HI
 , M32C_OPERAND_SRC16_16_16_SB_RELATIVE_HI, M32C_OPERAND_SRC16_16_8_FB_RELATIVE_HI, M32C_OPERAND_SRC16_16_8_AN_RELATIVE_HI, M32C_OPERAND_SRC16_16_16_AN_RELATIVE_HI
 , M32C_OPERAND_SRC16_16_20_AN_RELATIVE_HI, M32C_OPERAND_SRC32_16_8_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_16_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_8_FB_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_SRC32_16_16_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_8_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_16_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_24_AN_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_SRC32_16_8_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_16_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_8_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_16_FB_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_SRC32_16_8_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_16_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_24_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_8_SB_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_SRC32_16_16_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_8_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_16_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_8_AN_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_SRC32_16_16_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_24_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_SRC32_24_8_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_SRC32_24_16_SB_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_SRC32_24_8_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_SRC32_24_16_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_SRC32_24_8_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_SRC32_24_16_AN_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_SRC32_24_24_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_SRC32_24_8_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_SRC32_24_16_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_SRC32_24_8_FB_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_SRC32_24_16_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_SRC32_24_8_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_SRC32_24_16_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_SRC32_24_24_AN_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_SRC32_24_8_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC32_24_16_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC32_24_8_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC32_24_16_FB_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_SRC32_24_8_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC32_24_16_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC32_24_24_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_SRC16_16_16_ABSOLUTE_QI
 , M32C_OPERAND_SRC16_16_16_ABSOLUTE_HI, M32C_OPERAND_SRC32_16_16_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_24_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_16_ABSOLUTE_UNPREFIXED_HI
 , M32C_OPERAND_SRC32_16_24_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_16_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_24_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_SRC32_24_16_ABSOLUTE_PREFIXED_QI
 , M32C_OPERAND_SRC32_24_24_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_SRC32_24_16_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_SRC32_24_24_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_SRC32_24_16_ABSOLUTE_PREFIXED_SI
 , M32C_OPERAND_SRC32_24_24_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_SRC16_2_S_8_SB_RELATIVE_QI, M32C_OPERAND_SRC16_2_S_8_FB_RELATIVE_QI, M32C_OPERAND_SRC16_2_S_16_ABSOLUTE_QI
 , M32C_OPERAND_SRC32_2_S_8_SB_RELATIVE_QI, M32C_OPERAND_SRC32_2_S_8_FB_RELATIVE_QI, M32C_OPERAND_SRC32_2_S_16_ABSOLUTE_QI, M32C_OPERAND_SRC32_2_S_8_SB_RELATIVE_HI
 , M32C_OPERAND_SRC32_2_S_8_FB_RELATIVE_HI, M32C_OPERAND_SRC32_2_S_16_ABSOLUTE_HI, M32C_OPERAND_DST16_RN_DIRECT_QI, M32C_OPERAND_DST16_RN_DIRECT_HI
 , M32C_OPERAND_DST16_RN_DIRECT_SI, M32C_OPERAND_DST16_RN_DIRECT_EXT_QI, M32C_OPERAND_DST32_RN_DIRECT_UNPREFIXED_QI, M32C_OPERAND_DST32_RN_DIRECT_PREFIXED_QI
 , M32C_OPERAND_DST32_RN_DIRECT_UNPREFIXED_HI, M32C_OPERAND_DST32_RN_DIRECT_PREFIXED_HI, M32C_OPERAND_DST32_RN_DIRECT_UNPREFIXED_SI, M32C_OPERAND_DST32_RN_DIRECT_PREFIXED_SI
 , M32C_OPERAND_DST32_RN_DIRECT_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_RN_DIRECT_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_R3_DIRECT_UNPREFIXED_HI, M32C_OPERAND_DST16_AN_DIRECT_QI
 , M32C_OPERAND_DST16_AN_DIRECT_HI, M32C_OPERAND_DST16_AN_DIRECT_SI, M32C_OPERAND_DST32_AN_DIRECT_UNPREFIXED_QI, M32C_OPERAND_DST32_AN_DIRECT_PREFIXED_QI
 , M32C_OPERAND_DST32_AN_DIRECT_UNPREFIXED_HI, M32C_OPERAND_DST32_AN_DIRECT_PREFIXED_HI, M32C_OPERAND_DST32_AN_DIRECT_UNPREFIXED_SI, M32C_OPERAND_DST32_AN_DIRECT_PREFIXED_SI
 , M32C_OPERAND_DST16_AN_INDIRECT_QI, M32C_OPERAND_DST16_AN_INDIRECT_HI, M32C_OPERAND_DST16_AN_INDIRECT_SI, M32C_OPERAND_DST16_AN_INDIRECT_EXT_QI
 , M32C_OPERAND_DST32_AN_INDIRECT_UNPREFIXED_QI, M32C_OPERAND_DST32_AN_INDIRECT_PREFIXED_QI, M32C_OPERAND_DST32_AN_INDIRECT_UNPREFIXED_HI, M32C_OPERAND_DST32_AN_INDIRECT_PREFIXED_HI
 , M32C_OPERAND_DST32_AN_INDIRECT_UNPREFIXED_SI, M32C_OPERAND_DST32_AN_INDIRECT_PREFIXED_SI, M32C_OPERAND_DST32_AN_INDIRECT_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_AN_INDIRECT_EXTUNPREFIXED_HI
 , M32C_OPERAND_DST16_16_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_16_16_SB_RELATIVE_QI, M32C_OPERAND_DST16_16_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_16_8_AN_RELATIVE_QI
 , M32C_OPERAND_DST16_16_16_AN_RELATIVE_QI, M32C_OPERAND_DST16_16_20_AN_RELATIVE_QI, M32C_OPERAND_DST16_24_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_24_16_SB_RELATIVE_QI
 , M32C_OPERAND_DST16_24_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_24_8_AN_RELATIVE_QI, M32C_OPERAND_DST16_24_16_AN_RELATIVE_QI, M32C_OPERAND_DST16_24_20_AN_RELATIVE_QI
 , M32C_OPERAND_DST16_32_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_32_16_SB_RELATIVE_QI, M32C_OPERAND_DST16_32_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_32_8_AN_RELATIVE_QI
 , M32C_OPERAND_DST16_32_16_AN_RELATIVE_QI, M32C_OPERAND_DST16_32_20_AN_RELATIVE_QI, M32C_OPERAND_DST16_40_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_40_16_SB_RELATIVE_QI
 , M32C_OPERAND_DST16_40_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_40_8_AN_RELATIVE_QI, M32C_OPERAND_DST16_40_16_AN_RELATIVE_QI, M32C_OPERAND_DST16_40_20_AN_RELATIVE_QI
 , M32C_OPERAND_DST16_48_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_48_16_SB_RELATIVE_QI, M32C_OPERAND_DST16_48_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_48_8_AN_RELATIVE_QI
 , M32C_OPERAND_DST16_48_16_AN_RELATIVE_QI, M32C_OPERAND_DST16_48_20_AN_RELATIVE_QI, M32C_OPERAND_DST16_16_8_SB_RELATIVE_HI, M32C_OPERAND_DST16_16_16_SB_RELATIVE_HI
 , M32C_OPERAND_DST16_16_8_FB_RELATIVE_HI, M32C_OPERAND_DST16_16_8_AN_RELATIVE_HI, M32C_OPERAND_DST16_16_16_AN_RELATIVE_HI, M32C_OPERAND_DST16_16_20_AN_RELATIVE_HI
 , M32C_OPERAND_DST16_24_8_SB_RELATIVE_HI, M32C_OPERAND_DST16_24_16_SB_RELATIVE_HI, M32C_OPERAND_DST16_24_8_FB_RELATIVE_HI, M32C_OPERAND_DST16_24_8_AN_RELATIVE_HI
 , M32C_OPERAND_DST16_24_16_AN_RELATIVE_HI, M32C_OPERAND_DST16_24_20_AN_RELATIVE_HI, M32C_OPERAND_DST16_32_8_SB_RELATIVE_HI, M32C_OPERAND_DST16_32_16_SB_RELATIVE_HI
 , M32C_OPERAND_DST16_32_8_FB_RELATIVE_HI, M32C_OPERAND_DST16_32_8_AN_RELATIVE_HI, M32C_OPERAND_DST16_32_16_AN_RELATIVE_HI, M32C_OPERAND_DST16_32_20_AN_RELATIVE_HI
 , M32C_OPERAND_DST16_40_8_SB_RELATIVE_HI, M32C_OPERAND_DST16_40_16_SB_RELATIVE_HI, M32C_OPERAND_DST16_40_8_FB_RELATIVE_HI, M32C_OPERAND_DST16_40_8_AN_RELATIVE_HI
 , M32C_OPERAND_DST16_40_16_AN_RELATIVE_HI, M32C_OPERAND_DST16_40_20_AN_RELATIVE_HI, M32C_OPERAND_DST16_48_8_SB_RELATIVE_HI, M32C_OPERAND_DST16_48_16_SB_RELATIVE_HI
 , M32C_OPERAND_DST16_48_8_FB_RELATIVE_HI, M32C_OPERAND_DST16_48_8_AN_RELATIVE_HI, M32C_OPERAND_DST16_48_16_AN_RELATIVE_HI, M32C_OPERAND_DST16_48_20_AN_RELATIVE_HI
 , M32C_OPERAND_DST16_16_8_SB_RELATIVE_SI, M32C_OPERAND_DST16_16_16_SB_RELATIVE_SI, M32C_OPERAND_DST16_16_8_FB_RELATIVE_SI, M32C_OPERAND_DST16_16_8_AN_RELATIVE_SI
 , M32C_OPERAND_DST16_16_16_AN_RELATIVE_SI, M32C_OPERAND_DST16_16_20_AN_RELATIVE_SI, M32C_OPERAND_DST16_24_8_SB_RELATIVE_SI, M32C_OPERAND_DST16_24_16_SB_RELATIVE_SI
 , M32C_OPERAND_DST16_24_8_FB_RELATIVE_SI, M32C_OPERAND_DST16_24_8_AN_RELATIVE_SI, M32C_OPERAND_DST16_24_16_AN_RELATIVE_SI, M32C_OPERAND_DST16_24_20_AN_RELATIVE_SI
 , M32C_OPERAND_DST16_32_8_SB_RELATIVE_SI, M32C_OPERAND_DST16_32_16_SB_RELATIVE_SI, M32C_OPERAND_DST16_32_8_FB_RELATIVE_SI, M32C_OPERAND_DST16_32_8_AN_RELATIVE_SI
 , M32C_OPERAND_DST16_32_16_AN_RELATIVE_SI, M32C_OPERAND_DST16_32_20_AN_RELATIVE_SI, M32C_OPERAND_DST16_40_8_SB_RELATIVE_SI, M32C_OPERAND_DST16_40_16_SB_RELATIVE_SI
 , M32C_OPERAND_DST16_40_8_FB_RELATIVE_SI, M32C_OPERAND_DST16_40_8_AN_RELATIVE_SI, M32C_OPERAND_DST16_40_16_AN_RELATIVE_SI, M32C_OPERAND_DST16_40_20_AN_RELATIVE_SI
 , M32C_OPERAND_DST16_48_8_SB_RELATIVE_SI, M32C_OPERAND_DST16_48_16_SB_RELATIVE_SI, M32C_OPERAND_DST16_48_8_FB_RELATIVE_SI, M32C_OPERAND_DST16_48_8_AN_RELATIVE_SI
 , M32C_OPERAND_DST16_48_16_AN_RELATIVE_SI, M32C_OPERAND_DST16_48_20_AN_RELATIVE_SI, M32C_OPERAND_DST16_16_8_SB_RELATIVE_EXT_QI, M32C_OPERAND_DST16_16_16_SB_RELATIVE_EXT_QI
 , M32C_OPERAND_DST16_16_8_FB_RELATIVE_EXT_QI, M32C_OPERAND_DST16_16_8_AN_RELATIVE_EXT_QI, M32C_OPERAND_DST16_16_16_AN_RELATIVE_EXT_QI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_16_16_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_8_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_8_AN_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_16_16_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_24_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_16_SB_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_24_8_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_16_AN_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_24_24_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_8_FB_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_32_16_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_24_AN_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_40_8_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_16_FB_RELATIVE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_40_8_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_16_16_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_8_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_8_AN_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_16_16_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_24_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_16_SB_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_24_8_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_16_AN_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_24_24_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_8_FB_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_32_16_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_24_AN_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_40_8_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_16_FB_RELATIVE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_40_8_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_16_16_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_16_8_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_16_8_AN_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_16_16_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_16_24_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_16_SB_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_24_8_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_16_AN_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_24_24_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_8_FB_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_32_16_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_24_AN_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_40_8_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_16_FB_RELATIVE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_40_8_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_24_16_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_24_8_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_24_16_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_24_24_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_32_8_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_32_16_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_32_24_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_8_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_40_16_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_8_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_48_8_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_48_16_SB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_48_8_FB_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_48_16_FB_RELATIVE_PREFIXED_QI
 , M32C_OPERAND_DST32_48_8_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_48_16_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_48_24_AN_RELATIVE_PREFIXED_QI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_24_16_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_24_8_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_24_16_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_24_24_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_32_8_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_32_16_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_32_24_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_8_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_40_16_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_8_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_48_8_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_48_16_SB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_48_8_FB_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_48_16_FB_RELATIVE_PREFIXED_HI
 , M32C_OPERAND_DST32_48_8_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_48_16_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_48_24_AN_RELATIVE_PREFIXED_HI, M32C_OPERAND_DST32_24_8_SB_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_24_16_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_24_8_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_24_16_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_24_8_AN_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_24_16_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_24_24_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_32_8_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_32_16_SB_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_32_8_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_32_16_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_32_8_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_32_16_AN_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_32_24_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_8_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_16_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_8_FB_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_40_16_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_8_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_16_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_40_24_AN_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_48_8_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_48_16_SB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_48_8_FB_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_48_16_FB_RELATIVE_PREFIXED_SI
 , M32C_OPERAND_DST32_48_8_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_48_16_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_48_24_AN_RELATIVE_PREFIXED_SI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_EXTUNPREFIXED_QI
 , M32C_OPERAND_DST32_16_16_SB_RELATIVE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_8_FB_RELATIVE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_8_AN_RELATIVE_EXTUNPREFIXED_QI
 , M32C_OPERAND_DST32_16_16_AN_RELATIVE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_24_AN_RELATIVE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_16_16_SB_RELATIVE_EXTUNPREFIXED_HI
 , M32C_OPERAND_DST32_16_8_FB_RELATIVE_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_16_8_AN_RELATIVE_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_16_16_AN_RELATIVE_EXTUNPREFIXED_HI
 , M32C_OPERAND_DST32_16_24_AN_RELATIVE_EXTUNPREFIXED_HI, M32C_OPERAND_DST16_16_16_ABSOLUTE_QI, M32C_OPERAND_DST16_24_16_ABSOLUTE_QI, M32C_OPERAND_DST16_32_16_ABSOLUTE_QI
 , M32C_OPERAND_DST16_40_16_ABSOLUTE_QI, M32C_OPERAND_DST16_48_16_ABSOLUTE_QI, M32C_OPERAND_DST16_16_16_ABSOLUTE_HI, M32C_OPERAND_DST16_24_16_ABSOLUTE_HI
 , M32C_OPERAND_DST16_32_16_ABSOLUTE_HI, M32C_OPERAND_DST16_40_16_ABSOLUTE_HI, M32C_OPERAND_DST16_48_16_ABSOLUTE_HI, M32C_OPERAND_DST16_16_16_ABSOLUTE_SI
 , M32C_OPERAND_DST16_24_16_ABSOLUTE_SI, M32C_OPERAND_DST16_32_16_ABSOLUTE_SI, M32C_OPERAND_DST16_40_16_ABSOLUTE_SI, M32C_OPERAND_DST16_48_16_ABSOLUTE_SI
 , M32C_OPERAND_DST16_16_16_ABSOLUTE_EXT_QI, M32C_OPERAND_DST32_16_16_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_24_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_24_16_ABSOLUTE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_24_24_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_16_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_32_24_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_40_16_ABSOLUTE_UNPREFIXED_QI
 , M32C_OPERAND_DST32_40_24_ABSOLUTE_UNPREFIXED_QI, M32C_OPERAND_DST32_16_16_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_24_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_24_16_ABSOLUTE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_24_24_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_16_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_32_24_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_40_16_ABSOLUTE_UNPREFIXED_HI
 , M32C_OPERAND_DST32_40_24_ABSOLUTE_UNPREFIXED_HI, M32C_OPERAND_DST32_16_16_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_16_24_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_16_ABSOLUTE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_24_24_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_16_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_32_24_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_40_16_ABSOLUTE_UNPREFIXED_SI
 , M32C_OPERAND_DST32_40_24_ABSOLUTE_UNPREFIXED_SI, M32C_OPERAND_DST32_24_16_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_24_24_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_32_16_ABSOLUTE_PREFIXED_QI
 , M32C_OPERAND_DST32_32_24_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_40_16_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_40_24_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_48_16_ABSOLUTE_PREFIXED_QI
 , M32C_OPERAND_DST32_48_24_ABSOLUTE_PREFIXED_QI, M32C_OPERAND_DST32_24_16_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_24_24_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_32_16_ABSOLUTE_PREFIXED_HI
 , M32C_OPERAND_DST32_32_24_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_40_16_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_40_24_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_48_16_ABSOLUTE_PREFIXED_HI
 , M32C_OPERAND_DST32_48_24_ABSOLUTE_PREFIXED_HI, M32C_OPERAND_DST32_24_16_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_24_24_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_32_16_ABSOLUTE_PREFIXED_SI
 , M32C_OPERAND_DST32_32_24_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_40_16_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_40_24_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_48_16_ABSOLUTE_PREFIXED_SI
 , M32C_OPERAND_DST32_48_24_ABSOLUTE_PREFIXED_SI, M32C_OPERAND_DST32_16_16_ABSOLUTE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_24_ABSOLUTE_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_16_ABSOLUTE_EXTUNPREFIXED_HI
 , M32C_OPERAND_DST32_16_24_ABSOLUTE_EXTUNPREFIXED_HI, M32C_OPERAND_BIT16_RN_DIRECT, M32C_OPERAND_BIT32_RN_DIRECT_UNPREFIXED, M32C_OPERAND_BIT32_RN_DIRECT_PREFIXED
 , M32C_OPERAND_BIT16_AN_DIRECT, M32C_OPERAND_BIT32_AN_DIRECT_UNPREFIXED, M32C_OPERAND_BIT32_AN_DIRECT_PREFIXED, M32C_OPERAND_BIT16_AN_INDIRECT
 , M32C_OPERAND_BIT32_AN_INDIRECT_UNPREFIXED, M32C_OPERAND_BIT32_AN_INDIRECT_PREFIXED, M32C_OPERAND_BIT16_16_8_SB_RELATIVE, M32C_OPERAND_BIT16_16_16_SB_RELATIVE
 , M32C_OPERAND_BIT16_16_8_FB_RELATIVE, M32C_OPERAND_BIT16_16_8_AN_RELATIVE, M32C_OPERAND_BIT16_16_16_AN_RELATIVE, M32C_OPERAND_BIT32_16_11_SB_RELATIVE_UNPREFIXED
 , M32C_OPERAND_BIT32_16_19_SB_RELATIVE_UNPREFIXED, M32C_OPERAND_BIT32_16_11_FB_RELATIVE_UNPREFIXED, M32C_OPERAND_BIT32_16_19_FB_RELATIVE_UNPREFIXED, M32C_OPERAND_BIT32_16_11_AN_RELATIVE_UNPREFIXED
 , M32C_OPERAND_BIT32_16_19_AN_RELATIVE_UNPREFIXED, M32C_OPERAND_BIT32_16_27_AN_RELATIVE_UNPREFIXED, M32C_OPERAND_BIT32_24_11_SB_RELATIVE_PREFIXED, M32C_OPERAND_BIT32_24_19_SB_RELATIVE_PREFIXED
 , M32C_OPERAND_BIT32_24_11_FB_RELATIVE_PREFIXED, M32C_OPERAND_BIT32_24_19_FB_RELATIVE_PREFIXED, M32C_OPERAND_BIT32_24_11_AN_RELATIVE_PREFIXED, M32C_OPERAND_BIT32_24_19_AN_RELATIVE_PREFIXED
 , M32C_OPERAND_BIT32_24_27_AN_RELATIVE_PREFIXED, M32C_OPERAND_BIT16_11_SB_RELATIVE_S, M32C_OPERAND_RN16_PUSH_S_DERIVED, M32C_OPERAND_AN16_PUSH_S_DERIVED
 , M32C_OPERAND_BIT16_16_16_ABSOLUTE, M32C_OPERAND_BIT32_16_19_ABSOLUTE_UNPREFIXED, M32C_OPERAND_BIT32_16_27_ABSOLUTE_UNPREFIXED, M32C_OPERAND_BIT32_24_19_ABSOLUTE_PREFIXED
 , M32C_OPERAND_BIT32_24_27_ABSOLUTE_PREFIXED, M32C_OPERAND_DST16_3_S_R0L_DIRECT_QI, M32C_OPERAND_DST16_3_S_R0H_DIRECT_QI, M32C_OPERAND_DST16_3_S_8_8_SB_RELATIVE_QI
 , M32C_OPERAND_DST16_3_S_8_8_FB_RELATIVE_QI, M32C_OPERAND_DST16_3_S_8_16_ABSOLUTE_QI, M32C_OPERAND_DST16_3_S_16_8_SB_RELATIVE_QI, M32C_OPERAND_DST16_3_S_16_8_FB_RELATIVE_QI
 , M32C_OPERAND_DST16_3_S_16_16_ABSOLUTE_QI, M32C_OPERAND_SRCDST16_R0L_R0H_S_DERIVED, M32C_OPERAND_DST32_2_S_R0L_DIRECT_QI, M32C_OPERAND_DST32_2_S_R0_DIRECT_HI
 , M32C_OPERAND_DST32_1_S_A0_DIRECT_HI, M32C_OPERAND_DST32_1_S_A1_DIRECT_HI, M32C_OPERAND_DST32_2_S_8_SB_RELATIVE_QI, M32C_OPERAND_DST32_2_S_8_FB_RELATIVE_QI
 , M32C_OPERAND_DST32_2_S_16_ABSOLUTE_QI, M32C_OPERAND_DST32_2_S_8_SB_RELATIVE_HI, M32C_OPERAND_DST32_2_S_8_FB_RELATIVE_HI, M32C_OPERAND_DST32_2_S_16_ABSOLUTE_HI
 , M32C_OPERAND_DST32_2_S_8_SB_RELATIVE_SI, M32C_OPERAND_DST32_2_S_8_FB_RELATIVE_SI, M32C_OPERAND_DST32_2_S_16_ABSOLUTE_SI, M32C_OPERAND_SRC16_BASIC_QI
 , M32C_OPERAND_SRC16_BASIC_HI, M32C_OPERAND_SRC32_BASIC_UNPREFIXED_QI, M32C_OPERAND_SRC32_BASIC_PREFIXED_QI, M32C_OPERAND_SRC32_BASIC_UNPREFIXED_HI
 , M32C_OPERAND_SRC32_BASIC_PREFIXED_HI, M32C_OPERAND_SRC32_BASIC_UNPREFIXED_SI, M32C_OPERAND_SRC32_BASIC_PREFIXED_SI, M32C_OPERAND_SRC32_BASIC_EXTPREFIXED_QI
 , M32C_OPERAND_SRC16_16_8_QI, M32C_OPERAND_SRC16_16_16_QI, M32C_OPERAND_SRC16_16_8_HI, M32C_OPERAND_SRC16_16_16_HI
 , M32C_OPERAND_SRC32_16_8_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_16_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_24_UNPREFIXED_QI, M32C_OPERAND_SRC32_16_8_UNPREFIXED_HI
 , M32C_OPERAND_SRC32_16_16_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_24_UNPREFIXED_HI, M32C_OPERAND_SRC32_16_8_UNPREFIXED_SI, M32C_OPERAND_SRC32_16_16_UNPREFIXED_SI
 , M32C_OPERAND_SRC32_16_24_UNPREFIXED_SI, M32C_OPERAND_SRC32_24_8_PREFIXED_QI, M32C_OPERAND_SRC32_24_16_PREFIXED_QI, M32C_OPERAND_SRC32_24_24_PREFIXED_QI
 , M32C_OPERAND_SRC32_24_8_PREFIXED_HI, M32C_OPERAND_SRC32_24_16_PREFIXED_HI, M32C_OPERAND_SRC32_24_24_PREFIXED_HI, M32C_OPERAND_SRC32_24_8_PREFIXED_SI
 , M32C_OPERAND_SRC32_24_16_PREFIXED_SI, M32C_OPERAND_SRC32_24_24_PREFIXED_SI, M32C_OPERAND_DST16_BASIC_QI, M32C_OPERAND_DST16_BASIC_HI
 , M32C_OPERAND_DST16_BASIC_SI, M32C_OPERAND_DST32_BASIC_UNPREFIXED_QI, M32C_OPERAND_DST32_BASIC_PREFIXED_QI, M32C_OPERAND_DST32_BASIC_UNPREFIXED_HI
 , M32C_OPERAND_DST32_BASIC_PREFIXED_HI, M32C_OPERAND_DST32_BASIC_UNPREFIXED_SI, M32C_OPERAND_DST32_BASIC_PREFIXED_SI, M32C_OPERAND_DST16_16_QI
 , M32C_OPERAND_DST16_16_8_QI, M32C_OPERAND_DST16_16_16_QI, M32C_OPERAND_DST16_16_16SA_QI, M32C_OPERAND_DST16_16_20AR_QI
 , M32C_OPERAND_DST16_16_HI, M32C_OPERAND_DST16_16_8_HI, M32C_OPERAND_DST16_16_16_HI, M32C_OPERAND_DST16_16_16SA_HI
 , M32C_OPERAND_DST16_16_20AR_HI, M32C_OPERAND_DST16_16_SI, M32C_OPERAND_DST16_16_8_SI, M32C_OPERAND_DST16_16_16_SI
 , M32C_OPERAND_DST16_16_16SA_SI, M32C_OPERAND_DST16_16_20AR_SI, M32C_OPERAND_DST16_16_EXT_QI, M32C_OPERAND_DST16_AN_INDIRECT_MOVA_HI
 , M32C_OPERAND_DST16_16_8_AN_RELATIVE_MOVA_HI, M32C_OPERAND_DST16_16_16_AN_RELATIVE_MOVA_HI, M32C_OPERAND_DST16_16_8_SB_RELATIVE_MOVA_HI, M32C_OPERAND_DST16_16_16_SB_RELATIVE_MOVA_HI
 , M32C_OPERAND_DST16_16_8_FB_RELATIVE_MOVA_HI, M32C_OPERAND_DST16_16_16_ABSOLUTE_MOVA_HI, M32C_OPERAND_DST16_16_MOVA_HI, M32C_OPERAND_DST32_AN_INDIRECT_UNPREFIXED_MOVA_SI
 , M32C_OPERAND_DST32_16_8_AN_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_16_AN_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_24_AN_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_8_SB_RELATIVE_UNPREFIXED_MOVA_SI
 , M32C_OPERAND_DST32_16_16_SB_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_8_FB_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_16_FB_RELATIVE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_16_ABSOLUTE_UNPREFIXED_MOVA_SI
 , M32C_OPERAND_DST32_16_24_ABSOLUTE_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_UNPREFIXED_MOVA_SI, M32C_OPERAND_DST32_16_UNPREFIXED_QI, M32C_OPERAND_DST32_16_8_UNPREFIXED_QI
 , M32C_OPERAND_DST32_16_16_UNPREFIXED_QI, M32C_OPERAND_DST32_16_16SA_UNPREFIXED_QI, M32C_OPERAND_DST32_16_24_UNPREFIXED_QI, M32C_OPERAND_DST32_16_UNPREFIXED_HI
 , M32C_OPERAND_DST32_16_8_UNPREFIXED_HI, M32C_OPERAND_DST32_16_16_UNPREFIXED_HI, M32C_OPERAND_DST32_16_16SA_UNPREFIXED_HI, M32C_OPERAND_DST32_16_24_UNPREFIXED_HI
 , M32C_OPERAND_DST32_16_UNPREFIXED_SI, M32C_OPERAND_DST32_16_8_UNPREFIXED_SI, M32C_OPERAND_DST32_16_16_UNPREFIXED_SI, M32C_OPERAND_DST32_16_16SA_UNPREFIXED_SI
 , M32C_OPERAND_DST32_16_24_UNPREFIXED_SI, M32C_OPERAND_DST32_16_EXTUNPREFIXED_QI, M32C_OPERAND_DST32_16_EXTUNPREFIXED_HI, M32C_OPERAND_DST32_16_UNPREFIXED_MULEX_HI
 , M32C_OPERAND_DST16_24_QI, M32C_OPERAND_DST16_24_HI, M32C_OPERAND_DST32_24_UNPREFIXED_QI, M32C_OPERAND_DST32_24_PREFIXED_QI
 , M32C_OPERAND_DST32_24_8_PREFIXED_QI, M32C_OPERAND_DST32_24_16_PREFIXED_QI, M32C_OPERAND_DST32_24_24_PREFIXED_QI, M32C_OPERAND_DST32_24_UNPREFIXED_HI
 , M32C_OPERAND_DST32_24_PREFIXED_HI, M32C_OPERAND_DST32_24_8_PREFIXED_HI, M32C_OPERAND_DST32_24_16_PREFIXED_HI, M32C_OPERAND_DST32_24_24_PREFIXED_HI
 , M32C_OPERAND_DST32_24_UNPREFIXED_SI, M32C_OPERAND_DST32_24_PREFIXED_SI, M32C_OPERAND_DST32_24_8_PREFIXED_SI, M32C_OPERAND_DST32_24_16_PREFIXED_SI
 , M32C_OPERAND_DST32_24_24_PREFIXED_SI, M32C_OPERAND_DST16_32_QI, M32C_OPERAND_DST16_32_HI, M32C_OPERAND_DST32_32_UNPREFIXED_QI
 , M32C_OPERAND_DST32_32_PREFIXED_QI, M32C_OPERAND_DST32_32_UNPREFIXED_HI, M32C_OPERAND_DST32_32_PREFIXED_HI, M32C_OPERAND_DST32_32_UNPREFIXED_SI
 , M32C_OPERAND_DST32_32_PREFIXED_SI, M32C_OPERAND_DST32_40_UNPREFIXED_QI, M32C_OPERAND_DST32_40_PREFIXED_QI, M32C_OPERAND_DST32_40_UNPREFIXED_HI
 , M32C_OPERAND_DST32_40_PREFIXED_HI, M32C_OPERAND_DST32_40_UNPREFIXED_SI, M32C_OPERAND_DST32_40_PREFIXED_SI, M32C_OPERAND_DST32_48_PREFIXED_QI
 , M32C_OPERAND_DST32_48_PREFIXED_HI, M32C_OPERAND_DST32_48_PREFIXED_SI, M32C_OPERAND_BIT16_16, M32C_OPERAND_BIT16_16_BASIC
 , M32C_OPERAND_BIT16_16_8, M32C_OPERAND_BIT16_16_16, M32C_OPERAND_BIT32_16_UNPREFIXED, M32C_OPERAND_BIT32_24_PREFIXED
 , M32C_OPERAND_BIT32_BASIC_UNPREFIXED, M32C_OPERAND_BIT32_16_8_UNPREFIXED, M32C_OPERAND_BIT32_16_16_UNPREFIXED, M32C_OPERAND_BIT32_16_24_UNPREFIXED
 , M32C_OPERAND_SRC16_2_S, M32C_OPERAND_SRC32_2_S_QI, M32C_OPERAND_SRC32_2_S_HI, M32C_OPERAND_DST16_3_S_8
 , M32C_OPERAND_DST16_3_S_16, M32C_OPERAND_SRCDST16_R0L_R0H_S, M32C_OPERAND_DST32_2_S_BASIC_QI, M32C_OPERAND_DST32_2_S_BASIC_HI
 , M32C_OPERAND_DST32_2_S_8_QI, M32C_OPERAND_DST32_2_S_16_QI, M32C_OPERAND_DST32_2_S_8_HI, M32C_OPERAND_DST32_2_S_16_HI
 , M32C_OPERAND_DST32_2_S_8_SI, M32C_OPERAND_DST32_2_S_16_SI, M32C_OPERAND_DST32_AN_S, M32C_OPERAND_BIT16_11_S
 , M32C_OPERAND_RN16_PUSH_S_ANYOF, M32C_OPERAND_AN16_PUSH_S_ANYOF, M32C_OPERAND_MAX
} CGEN_OPERAND_TYPE;

/* Number of operands types.  */
#define MAX_OPERANDS 902

/* Maximum number of operands referenced by any insn.  */
#define MAX_OPERAND_INSTANCES 8

/* Insn attribute indices.  */

/* Enum declaration for cgen_insn attrs.  */
typedef enum cgen_insn_attr {
  CGEN_INSN_ALIAS, CGEN_INSN_VIRTUAL, CGEN_INSN_UNCOND_CTI, CGEN_INSN_COND_CTI
 , CGEN_INSN_SKIP_CTI, CGEN_INSN_DELAY_SLOT, CGEN_INSN_RELAXABLE, CGEN_INSN_RELAXED
 , CGEN_INSN_NO_DIS, CGEN_INSN_PBB, CGEN_INSN_END_BOOLS, CGEN_INSN_START_NBOOLS = 31
 , CGEN_INSN_MACH, CGEN_INSN_ISA, CGEN_INSN_RL_TYPE, CGEN_INSN_END_NBOOLS
} CGEN_INSN_ATTR;

/* Number of non-boolean elements in cgen_insn_attr.  */
#define CGEN_INSN_NBOOL_ATTRS (CGEN_INSN_END_NBOOLS - CGEN_INSN_START_NBOOLS - 1)

/* cgen_insn attribute accessor macros.  */
#define CGEN_ATTR_CGEN_INSN_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_INSN_MACH-CGEN_INSN_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_INSN_ISA_VALUE(attrs) ((attrs)->nonbool[CGEN_INSN_ISA-CGEN_INSN_START_NBOOLS-1].bitset)
#define CGEN_ATTR_CGEN_INSN_RL_TYPE_VALUE(attrs) ((attrs)->nonbool[CGEN_INSN_RL_TYPE-CGEN_INSN_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_INSN_ALIAS_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_ALIAS)) != 0)
#define CGEN_ATTR_CGEN_INSN_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_INSN_UNCOND_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_UNCOND_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_COND_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_COND_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_SKIP_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_SKIP_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_DELAY_SLOT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_DELAY_SLOT)) != 0)
#define CGEN_ATTR_CGEN_INSN_RELAXABLE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_RELAXABLE)) != 0)
#define CGEN_ATTR_CGEN_INSN_RELAXED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_RELAXED)) != 0)
#define CGEN_ATTR_CGEN_INSN_NO_DIS_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_NO_DIS)) != 0)
#define CGEN_ATTR_CGEN_INSN_PBB_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_PBB)) != 0)

/* cgen.h uses things we just defined.  */
#include "opcode/cgen.h"

extern const struct cgen_ifld m32c_cgen_ifld_table[];

/* Attributes.  */
extern const CGEN_ATTR_TABLE m32c_cgen_hardware_attr_table[];
extern const CGEN_ATTR_TABLE m32c_cgen_ifield_attr_table[];
extern const CGEN_ATTR_TABLE m32c_cgen_operand_attr_table[];
extern const CGEN_ATTR_TABLE m32c_cgen_insn_attr_table[];

/* Hardware decls.  */

extern CGEN_KEYWORD m32c_cgen_opval_h_gr;
extern CGEN_KEYWORD m32c_cgen_opval_h_gr_QI;
extern CGEN_KEYWORD m32c_cgen_opval_h_gr_HI;
extern CGEN_KEYWORD m32c_cgen_opval_h_gr_SI;
extern CGEN_KEYWORD m32c_cgen_opval_h_gr_ext_QI;
extern CGEN_KEYWORD m32c_cgen_opval_h_gr_ext_HI;
extern CGEN_KEYWORD m32c_cgen_opval_h_r0l;
extern CGEN_KEYWORD m32c_cgen_opval_h_r0h;
extern CGEN_KEYWORD m32c_cgen_opval_h_r1l;
extern CGEN_KEYWORD m32c_cgen_opval_h_r1h;
extern CGEN_KEYWORD m32c_cgen_opval_h_r0;
extern CGEN_KEYWORD m32c_cgen_opval_h_r1;
extern CGEN_KEYWORD m32c_cgen_opval_h_r2;
extern CGEN_KEYWORD m32c_cgen_opval_h_r3;
extern CGEN_KEYWORD m32c_cgen_opval_h_r0l_r0h;
extern CGEN_KEYWORD m32c_cgen_opval_h_r2r0;
extern CGEN_KEYWORD m32c_cgen_opval_h_r3r1;
extern CGEN_KEYWORD m32c_cgen_opval_h_r1r2r0;
extern CGEN_KEYWORD m32c_cgen_opval_h_ar;
extern CGEN_KEYWORD m32c_cgen_opval_h_ar_QI;
extern CGEN_KEYWORD m32c_cgen_opval_h_ar_HI;
extern CGEN_KEYWORD m32c_cgen_opval_h_ar_SI;
extern CGEN_KEYWORD m32c_cgen_opval_h_a0;
extern CGEN_KEYWORD m32c_cgen_opval_h_a1;
extern CGEN_KEYWORD m32c_cgen_opval_h_cond16;
extern CGEN_KEYWORD m32c_cgen_opval_h_cond16c;
extern CGEN_KEYWORD m32c_cgen_opval_h_cond16j;
extern CGEN_KEYWORD m32c_cgen_opval_h_cond16j_5;
extern CGEN_KEYWORD m32c_cgen_opval_h_cond32;
extern CGEN_KEYWORD m32c_cgen_opval_h_cr1_32;
extern CGEN_KEYWORD m32c_cgen_opval_h_cr2_32;
extern CGEN_KEYWORD m32c_cgen_opval_h_cr3_32;
extern CGEN_KEYWORD m32c_cgen_opval_h_cr_16;
extern CGEN_KEYWORD m32c_cgen_opval_h_flags;
extern CGEN_KEYWORD m32c_cgen_opval_h_shimm;

extern const CGEN_HW_ENTRY m32c_cgen_hw_table[];



#endif /* M32C_CPU_H */
