/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 1999-2003, 2009, 2010, 2012-2014 Free Software
Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 1700MHz Cortex-A15 with Neon (in spite of file position) */
/* FFT tuning limit = 25000000 */
/* Generated by tuneup.c, 2014-03-12, gcc 4.6 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          3
#define MOD_1U_TO_MOD_1_1_THRESHOLD          3
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         9
#define MOD_1_2_TO_MOD_1_4_THRESHOLD     MP_SIZE_T_MAX
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      8
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           15

#define MUL_TOOM22_THRESHOLD                23
#define MUL_TOOM33_THRESHOLD                90
#define MUL_TOOM44_THRESHOLD               262
#define MUL_TOOM6H_THRESHOLD               351
#define MUL_TOOM8H_THRESHOLD               557

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      90
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     160
#define MUL_TOOM42_TO_TOOM53_THRESHOLD      89
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     169
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     130

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 43
#define SQR_TOOM3_THRESHOLD                138
#define SQR_TOOM4_THRESHOLD                363
#define SQR_TOOM6_THRESHOLD                517
#define SQR_TOOM8_THRESHOLD                725

#define MULMID_TOOM42_THRESHOLD             52

#define MULMOD_BNM1_THRESHOLD               17
#define SQRMOD_BNM1_THRESHOLD               23

#define MUL_FFT_MODF_THRESHOLD             550  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    550, 5}, {     25, 6}, {     27, 7}, {     15, 6}, \
    {     31, 7}, {     19, 6}, {     39, 7}, {     25, 6}, \
    {     51, 7}, {     27, 8}, {     15, 7}, {     33, 8}, \
    {     19, 7}, {     41, 8}, {     23, 7}, {     51, 8}, \
    {     27, 9}, {     15, 8}, {     31, 7}, {     63, 8}, \
    {     39, 9}, {     23, 8}, {     51,10}, {     15, 9}, \
    {     31, 8}, {     67, 9}, {     39, 8}, {     79, 9}, \
    {     47, 8}, {     99, 9}, {     55,10}, {     31, 9}, \
    {     79,10}, {     47, 9}, {    103,11}, {     31,10}, \
    {     63, 9}, {    135,10}, {     79, 9}, {    159,10}, \
    {     95, 9}, {    191,10}, {    111,11}, {     63,10}, \
    {    159,11}, {     95,10}, {    191, 9}, {    383,10}, \
    {    207,12}, {     63,11}, {    127,10}, {    255, 9}, \
    {    511,10}, {    271, 9}, {    543,11}, {    159,10}, \
    {    319, 9}, {    639,10}, {    335, 9}, {    671,10}, \
    {    351,11}, {    191,10}, {    383, 9}, {    767,10}, \
    {    399, 9}, {    799,10}, {    415,11}, {    223,12}, \
    {    127,11}, {    255,10}, {    543,11}, {    287,10}, \
    {    607,11}, {    319,10}, {    671,11}, {    351,12}, \
    {    191,11}, {    383,10}, {    799,11}, {    415,10}, \
    {    831,13}, {    127,12}, {    255,11}, {    543,10}, \
    {   1087,11}, {    607,12}, {    319,11}, {    671,10}, \
    {   1343,11}, {    735,12}, {    383,11}, {    799,10}, \
    {   1599,11}, {    831,12}, {    447,11}, {    895,13}, \
    {    255,12}, {    511,11}, {   1023,12}, {    575,11}, \
    {   1151,12}, {    639,11}, {   1279,12}, {    703,13}, \
    {    383,12}, {    767,11}, {   1599,12}, {    831,11}, \
    {   1663,12}, {    895,13}, {    511,12}, {   1087,13}, \
    {    639,12}, {   1407,13}, {    767,12}, {   1599,13}, \
    {    895,14}, {    511,13}, {   1023,12}, {   2111,13}, \
    {   1151,12}, {   2431,13}, {   1279,14}, {    767,13}, \
    {   1535,12}, {   3071,15}, {    511,14}, {   1023,13}, \
    {   2175,14}, {   1279,13}, {   2559,12}, {   5119,13}, \
    {   2815,12}, {   5631,13}, {   2943,14}, {  16384,15}, \
    {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 137
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             525  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    525, 5}, {     25, 6}, {     27, 7}, {     15, 6}, \
    {     32, 7}, {     17, 6}, {     35, 7}, {     19, 6}, \
    {     39, 7}, {     25, 6}, {     51, 7}, {     27, 8}, \
    {     15, 7}, {     35, 8}, {     19, 7}, {     41, 8}, \
    {     23, 7}, {     51, 8}, {     27, 7}, {     55, 9}, \
    {     15, 8}, {     31, 7}, {     63, 8}, {     39, 9}, \
    {     23, 8}, {     55,10}, {     15, 9}, {     31, 8}, \
    {     67, 9}, {     39, 8}, {     79, 9}, {     47, 8}, \
    {     95, 9}, {     55,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {     95,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    159,10}, {     95, 9}, \
    {    191,10}, {    111,11}, {     63,10}, {    143, 9}, \
    {    287,10}, {    159,11}, {     95,10}, {    191, 9}, \
    {    383,12}, {     63,11}, {    127,10}, {    255, 9}, \
    {    511,10}, {    271, 9}, {    543,10}, {    287,11}, \
    {    159,10}, {    335, 9}, {    671,10}, {    351,11}, \
    {    191,10}, {    383, 9}, {    767,10}, {    399, 9}, \
    {    799,10}, {    415,11}, {    223,12}, {    127,11}, \
    {    255,10}, {    543,11}, {    287,10}, {    607,11}, \
    {    319,10}, {    671,11}, {    351,12}, {    191,11}, \
    {    383,10}, {    799,11}, {    415,10}, {    831,13}, \
    {    127,12}, {    255,11}, {    543,10}, {   1087,11}, \
    {    607,12}, {    319,11}, {    671,10}, {   1343,11}, \
    {    735,12}, {    383,11}, {    799,10}, {   1599,11}, \
    {    831,12}, {    447,11}, {    895,12}, {    511,11}, \
    {   1023,12}, {    575,11}, {   1151,12}, {    639,11}, \
    {   1343,12}, {    703,13}, {    383,12}, {    767,11}, \
    {   1599,12}, {    831,11}, {   1663,12}, {    895,13}, \
    {    511,12}, {   1087,13}, {    639,12}, {   1407,13}, \
    {    767,12}, {   1727,13}, {    895,14}, {    511,13}, \
    {   1023,12}, {   2047,13}, {   1151,12}, {   2431,13}, \
    {   1279,14}, {    767,13}, {   1535,12}, {   3071,15}, \
    {    511,14}, {   1023,13}, {   2047,12}, {   4095,13}, \
    {   2175,14}, {   1279,13}, {   2559,12}, {   5119,13}, \
    {   2687,14}, {  16384,15}, {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 139
#define SQR_FFT_THRESHOLD                 4736

#define MULLO_BASECASE_THRESHOLD             9
#define MULLO_DC_THRESHOLD                  39
#define MULLO_MUL_N_THRESHOLD            11278

#define DC_DIV_QR_THRESHOLD                 54
#define DC_DIVAPPR_Q_THRESHOLD             296
#define DC_BDIV_QR_THRESHOLD                52
#define DC_BDIV_Q_THRESHOLD                300

#define INV_MULMOD_BNM1_THRESHOLD           44
#define INV_NEWTON_THRESHOLD               294
#define INV_APPR_THRESHOLD                 294

#define BINV_NEWTON_THRESHOLD              375
#define REDC_1_TO_REDC_2_THRESHOLD         102
#define REDC_2_TO_REDC_N_THRESHOLD           0  /* always */

#define MU_DIV_QR_THRESHOLD               1718
#define MU_DIVAPPR_Q_THRESHOLD            1718
#define MUPI_DIV_QR_THRESHOLD              108
#define MU_BDIV_QR_THRESHOLD              1528
#define MU_BDIV_Q_THRESHOLD               1718

#define POWM_SEC_TABLE  3,32,70,416,1464

#define MATRIX22_STRASSEN_THRESHOLD         22
#define HGCD_THRESHOLD                     152
#define HGCD_APPR_THRESHOLD                230
#define HGCD_REDUCE_THRESHOLD             3259
#define GCD_DC_THRESHOLD                   702
#define GCDEXT_DC_THRESHOLD                538
#define JACOBI_BASE_METHOD                   4

#define GET_STR_DC_THRESHOLD                18
#define GET_STR_PRECOMPUTE_THRESHOLD        32
#define SET_STR_DC_THRESHOLD               119
#define SET_STR_PRECOMPUTE_THRESHOLD      1063

#define FAC_DSC_THRESHOLD                  262
#define FAC_ODD_THRESHOLD                   26
