//
//   Copyright (C) 2005, 2006 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef SDL_GLUE_H
#define SDL_GLUE_H

#include "gnash.h"
#include "rect.h"

namespace gnash
{

class SdlGlue
{
  public:
    virtual ~SdlGlue() { }
    virtual bool init(int argc, char **argv[]) = 0;

    virtual bool prepDrawingArea(int width, int height, uint32_t sdl_flags) = 0;
    virtual render_handler* createRenderHandler(int depth) = 0;
    virtual void render() = 0;
    virtual void setInvalidatedRegion(const rect& bounds) {}
    virtual void resize(int width, int height) {}
    
  protected:
    int _bpp;
};

} // namespace gnash

#endif // SDL_GLUE_H
