// Sound_as.hx:  ActionScript 3 "Sound" class, for Gnash.
//
// Generated by gen-as3.sh on: 20090503 by "rob". Remove this
// after any hand editing loosing changes.
//
//   Copyright (C) 2009, 2010 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// This test case must be processed by CPP before compiling to include the
//  DejaGnu.hx header file for the testing framework support.

//NOTE: this is a test suite only for flash versions > 9. For ealier
//versions of flash, please use the internal test with ming.

#if flash9
import flash.media.ID3Info;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.media.SoundChannel;
import flash.display.MovieClip;
#end
#if !flash9
import flash.Sound;
import flash.MovieClip;
#end
import flash.Lib;
import Type;
import Std;
import DejaGnu;

// Class must be named with the PP prefix, as that's the name the
// file passed to haxe will have after the preprocessing step
class Sound_as {
    static function main() {
        #if flash9
		var x1:Sound = new Sound();
        // Make sure we actually get a valid class        
        if (x1 != null) {
            DejaGnu.pass("Sound class exists");
        } else {
            DejaGnu.fail("Sound lass doesn't exist");
        }
// Tests to see if all the properties exist. All these do is test for
// existance of a property, and don't test the functionality at all. This
// is primarily useful only to test completeness of the API implementation.
	if (Type.typeof(x1.bytesLoaded) == ValueType.TInt) {
	    DejaGnu.pass("Sound::bytesLoaded property exists");
	} else {
	    DejaGnu.fail("Sound::bytesLoaded property doesn't exist");
	}
	
	if (Type.typeof(x1.bytesTotal) == ValueType.TInt) {
	    DejaGnu.pass("Sound::bytesTotal property exists");
	} else {
	    DejaGnu.fail("Sound::bytesTotal property doesn't exist");
	}
	if (Std.is(x1.id3, ID3Info)) {
	    DejaGnu.pass("Sound::id3 property exists");
	} else {
	    DejaGnu.fail("Sound::id3 property doesn't exist");
	}
	if (Type.typeof(x1.isBuffering) == ValueType.TBool) {
	    DejaGnu.pass("Sound::isBuffering property exists");
	} else {
	    DejaGnu.fail("Sound::isBuffering property doesn't exist");
	}
	if (Type.typeof(x1.length) == ValueType.TInt) {
	    DejaGnu.pass("Sound::length property exists");
	} else {
	    DejaGnu.fail("Sound::length property doesn't exist");
	}
	if (Std.is(Std.string(x1.url), String)) {
	    DejaGnu.pass("Sound::url property exists");
	} else {
	    DejaGnu.fail("Sound::url property doesn't exist");
	}

// Tests to see if all the methods exist. All these do is test for
// existance of a method, and don't test the functionality at all. This
// is primarily useful only to test completeness of the API implementation.

	if (Type.typeof(x1.close) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::close() method exists");
	} else {
	    DejaGnu.fail("Sound::close() method doesn't exist");
	}
	if (Type.typeof(x1.load) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::load() method exists");
	} else {
	    DejaGnu.fail("Sound::load() method doesn't exist");
	}
 	if (Type.typeof(x1.play) == ValueType.TFunction) {
 	    DejaGnu.pass("Sound::play() method exists");
 	} else {
 	    DejaGnu.fail("Sound::play() method doesn't exist");
 	}

	#end
	#if !flash9
		
		var x2:Sound = new Sound();
	//check properties
	DejaGnu.note("duration is returning this type: " + Type.typeof(x2.duration));
	
	//check methods
	if (Type.typeof(x2.attachSound) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::attachSound() method exists");
	} else {
	    DejaGnu.fail("Sound::attachSound() method doesn't exist");
	}
	if (Type.typeof(x2.getBytesLoaded) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::getBytesLoaded() method exists");
	} else {
	    DejaGnu.fail("Sound::getBytesLoaded() method doesn't exist");
	}
	if (Type.typeof(x2.getBytesTotal) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::getBytesTotal() method exists");
	} else {
	    DejaGnu.fail("Sound::getBytesTotal() method doesn't exist");
	}
	if (Type.typeof(x2.getPan) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::getPan() method exists");
	} else {
	    DejaGnu.fail("Sound::getPan() method doesn't exist");
	}
	if (Type.typeof(x2.getTransform) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::getTransform() method exists");
	} else {
	    DejaGnu.fail("Sound::getTransform() method doesn't exist");
	}
	if (Type.typeof(x2.getVolume) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::getVolume() method exists");
	} else {
	    DejaGnu.fail("Sound::getVolume() method doesn't exist");
	}
	if (Type.typeof(x2.loadSound) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::loadSound() method exists");
	} else {
	    DejaGnu.fail("Sound::loadSound() method doesn't exist");
	}
	if (Type.typeof(x2.setPan) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::setPan() method exists");
	} else {
	    DejaGnu.fail("Sound::setPan() method doesn't exist");
	}
	if (Type.typeof(x2.setTransform) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::setTransform() method exists");
	} else {
	    DejaGnu.fail("Sound::setTransform() method doesn't exist");
	}
	if (Type.typeof(x2.setVolume) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::setVolume() method exists");
	} else {
	    DejaGnu.fail("Sound::setVolume() method doesn't exist");
	}
	if (Type.typeof(x2.start) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::start() method exists");
	} else {
	    DejaGnu.fail("Sound::start() method doesn't exist");
	}
	if (Type.typeof(x2.stop) == ValueType.TFunction) {
	    DejaGnu.pass("Sound::stop() method exists");
	} else {
	    DejaGnu.fail("Sound::stop() method doesn't exist");
	}
	
	//testing constructor and check return of inspectors
	var s1:Sound = new Sound();
	if (Std.is(s1, Sound)) {
		DejaGnu.pass("sound() constructor returns the correct object type");
	} else {
		DejaGnu.fail("sound() constructor is not returning a object of type Sound");
	}
	
	if ((s1.getVolume() == 100) && (Type.typeof(s1.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct default level (100)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct default level (should be 100)");
	}
	
	//set new volume level and check that it has changed
	s1.setVolume(95);
	if ((s1.getVolume() == 95) && (Type.typeof(s1.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct new level (95)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct new level (should now be 95)");
	}
	//check more functions return vals here
	if (Std.is(s1.checkPolicyFile, Bool)) {
		DejaGnu.pass("Sound::checkPolicyFile is properly returning a boolean.");
	} else {
		DejaGnu.xfail("Sound::checkPolicyFile is not returning a boolean as expected.");
	}
	
	//use construcor taking a movieclip and check return of all inspectors
		var s2:Sound = new Sound(flash.Lib._root);
	if (Std.is(s2, Sound)) {
		DejaGnu.pass("sound() constructor returns the correct object type with a movieclip object");
	} else {
		DejaGnu.fail("sound() constructor is not returning a object of type Sound when instantiated with movieclip object");
	}
	if ((s2.getVolume() == 100) && (Type.typeof(s2.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct default level (100)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct default level (should be 100)");
	}
	if (Std.is(s2.checkPolicyFile, Bool)) {
		DejaGnu.pass("Sound::checkPolicyFile is properly returning a boolean.");
	} else {
		DejaGnu.xfail("Sound::checkPolicyFile is not returning a boolean as expected.");
	}
	//test constructor with bad argument
	var s3:Sound = new Sound(33);
	
	if (Std.is(s2, Sound)) {
		DejaGnu.pass("sound() constructor returns the correct object type with a bad argument");
	} else {
		DejaGnu.fail("sound() constructor is not returning a object of type Sound when instantiated with bad argument");
	}
	
	//test association of Sound to characters
	var s1a:Sound = new Sound();
	var s1b:Sound = new Sound();
	if ((s1a.getVolume() == 95) && (Type.typeof(s1a.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct level (95)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct new level (should be 95)");
	}
	s1b.setVolume(76);
	if ((s1b.getVolume() == 76) && (Type.typeof(s1b.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct new level (76)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct new level (should now be 76)");
	}
	
	//test association of Sound to characters with bad constructor args
	var s1c:Sound = new Sound(54);
	var s1d:Sound = new Sound(54);
	s1c.setVolume(54);
	var s1e:Sound = new Sound(null);
	if ((s1e.getVolume() == 76) && (Type.typeof(s1e.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct new level (76)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct new level (should now be 76)");
	}
	
	//Test constructor with invalid argument (of type Object)
	var o = {property : 0}; //this is a dummy object
	var s1g:Sound = new Sound(o);
	var s1h:Sound = new Sound(o);
	s1g.setVolume(54);
	
	var s2:Sound = new Sound(flash.Lib._root);
	var s3:Sound = new Sound(flash.Lib._root);
	if ((s2.getVolume() == 100) && (Type.typeof(s2.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct default level (100)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct default level (should be 100)");
	}
	if ((s3.getVolume() == 100) && (Type.typeof(s3.getVolume()) == ValueType.TInt)) {
		DejaGnu.pass("Sound::getVolume has the correct default level (100)");
	} else {
		DejaGnu.fail("Sound::getVolume doesn't have the correct default level (should be 100)");
	}
	#end
        // Call this after finishing all tests. It prints out the totals.
        DejaGnu.done();
    }
}
