/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (set-opt.c)
 *
 *  It has been AutoGen-ed
 *  From the definitions    stdin
 *  and the template file   str2enum
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name ``Bruce Korb'' nor the name of any other
 *    contributor may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * str2enum IS PROVIDED BY Bruce Korb ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bruce Korb OR ANY OTHER CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "set-opt.h"
#include <ctype.h>
#include <string.h>
/* ANSI-C code produced by gperf version 3.1 */
/* Command-line: gperf set-opt.gp  */
/* Computed positions: -k'1' */



# if 0 /* gperf build options: */
// %struct-type
// %language=ANSI-C
// %includes
// %global-table
// %omit-struct-type
// %readonly-tables
// %compare-strncmp
//
// %define slot-name               set_name
// %define hash-function-name      set_opt_hash
// %define lookup-function-name    find_set_opt_name
// %define word-array-name         set_opt_table
// %define initializer-suffix      ,SET_COUNT_CMD
//
# endif

#include "set-opt.h"
typedef struct {
    char const *    set_name;
    set_opt_enum_t set_id;
} set_opt_map_t;
#include <string.h>

/* maximum key range = 16, duplicates = 0 */

static unsigned int
set_opt_hash (register const char *str, register size_t len)
{
  static const unsigned char asso_values[] =
    {
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 15,
      22, 22, 22, 22, 22, 22, 22, 22,  5, 22,
       0, 22, 22, 22, 10,  0, 22,  0, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
      22, 22, 22, 22, 22, 22
    };
  return len + asso_values[(unsigned char)str[0]];
}

static const set_opt_map_t set_opt_table[] =
  {
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"shared",     SET_CMD_SHARED},
    {"",SET_COUNT_CMD},
    {"specials",   SET_CMD_SPECIALS},
    {"no-pbkdf2",  SET_CMD_NO_PBKDF2},
    {"use-pbkdf2", SET_CMD_USE_PBKDF2},
    {"length",     SET_CMD_LENGTH},
    {"",SET_COUNT_CMD},
    {"login-id",   SET_CMD_LOGIN_ID},
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"rehash",     SET_CMD_REHASH},
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"",SET_COUNT_CMD}, {"",SET_COUNT_CMD},
    {"cclass",     SET_CMD_CCLASS}
  };

static inline const set_opt_map_t *
find_set_opt_name (register const char *str, register size_t len)
{
  if (len <= 10 && len >= 6)
    {
      register unsigned int key = (int)set_opt_hash (str, len);

      if (key <= 21)
        {
          register const char *s = set_opt_table[key].set_name;

          if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
            return &set_opt_table[key];
        }
    }
  return 0;
}

/**
 * Convert a command (keyword) to a set_opt_enum_t enumeration value.
 * The length of the command is computed by calling \a strspn()
 * on the input argument.
 *
 * @param[in] str   a string that should start with a known key word.
 * @returns the enumeration value.
 * If not found, that value is SET_INVALID_CMD.
 */
set_opt_enum_t
find_set_opt_cmd(char const * str)
{
    set_opt_map_t const * map;
    static char const accept[] =
        "-2abcdefghiklnoprstu";
    unsigned int clen = strspn(str, accept);

    if (isalnum((unsigned char)str[clen]))
        return SET_INVALID_CMD;
    map = find_set_opt_name(str, (unsigned int)clen);
    return (map == NULL) ? SET_INVALID_CMD : map->set_id;
}

/**
 * Convert an set_opt_enum_t value into a string.
 *
 * @param[in] id  the enumeration value
 * @returns the associated string, or "* UNDEFINED *" if \a id
 * is out of range.
 */
char const *
set_opt_name(set_opt_enum_t id)
{
    static char const undef[] = "* UNDEFINED *";
    static char const * const nm_table[] = {
        [SET_CMD_CCLASS    ] = "cclass",
        [SET_CMD_LENGTH    ] = "length",
        [SET_CMD_LOGIN_ID  ] = "login-id",
        [SET_CMD_NO_PBKDF2 ] = "no-pbkdf2",
        [SET_CMD_REHASH    ] = "rehash",
        [SET_CMD_SHARED    ] = "shared",
        [SET_CMD_SPECIALS  ] = "specials",
        [SET_CMD_USE_PBKDF2] = "use-pbkdf2" };
    char const * res = undef;
    if (id < SET_COUNT_CMD) {
        res = nm_table[id];
        if (res == NULL)
            res = undef;
    }
    return res;
}

/* end of set-opt.c */
