/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (opts.c)
 *
 *  It has been AutoGen-ed
 *  From the definitions    opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:2:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the gnu-pw-mgr author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The gnu-pw-mgr program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2013-2018 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  gnu-pw-mgr is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  gnu-pw-mgr is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __doxygen__
#define OPTION_CODE_COMPILE 1
#include "opts.h"
#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;
#define zCopyright      (gnu_pw_mgr_opt_strs+0)
#define zLicenseDescrip (gnu_pw_mgr_opt_strs+259)


#ifndef NULL
#  define NULL 0
#endif

/**
 *  static const strings for gnu-pw-mgr options
 */
static char const gnu_pw_mgr_opt_strs[4000] =
/*     0 */ "gnu-pw-mgr 2.7.4\n"
            "Copyright (C) 2013-2018 Bruce Korb, all rights reserved.\n"
            "This is free software. It is licensed for use, modification and\n"
            "redistribution under the terms of the GNU General Public License,\n"
            "version 3 or later <http://gnu.org/licenses/gpl.html>\n\0"
/*   259 */ "gnu-pw-mgr is free software: you can redistribute it and/or modify it under\n"
            "the terms of the GNU General Public License as published by the Free\n"
            "Software Foundation, either version 3 of the License, or (at your option)\n"
            "any later version.\n\n"
            "gnu-pw-mgr is distributed in the hope that it will be useful, but WITHOUT\n"
            "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n"
            "FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for\n"
            "more details.\n\n"
            "You should have received a copy of the GNU General Public License along\n"
            "with this program.  If not, see <http://www.gnu.org/licenses/>.\n\0"
/*   868 */ "Options for adding and removing seeds in the configuration file.:\0"
/*   934 */ "define a seed for a series of passwords\0"
/*   974 */ "SEED\0"
/*   979 */ "seed\0"
/*   984 */ "seed tag\0"
/*   993 */ "TAG\0"
/*   997 */ "tag\0"
/*  1001 */ "seed text\0"
/*  1011 */ "TEXT\0"
/*  1016 */ "text\0"
/*  1021 */ "shared tag\0"
/*  1032 */ "SHARED\0"
/*  1039 */ "no-shared\0"
/*  1049 */ "no\0"
/*  1052 */ "set default character classes\0"
/*  1082 */ "DEFAULT_CCLASS\0"
/*  1097 */ "no-default-cclass\0"
/*  1115 */ "Options for specifying password attributes.:\0"
/*  1160 */ "a reminder of your login id\0"
/*  1188 */ "LOGIN_ID\0"
/*  1197 */ "login-id\0"
/*  1206 */ "sets password length\0"
/*  1227 */ "LENGTH\0"
/*  1234 */ "length\0"
/*  1241 */ "password character class\0"
/*  1266 */ "CCLASS\0"
/*  1273 */ "cclass\0"
/*  1280 */ "Change the password rehash count\0"
/*  1313 */ "REHASH\0"
/*  1320 */ "rehash\0"
/*  1327 */ "rehash password with PKCS#5 PBKDF2\0"
/*  1362 */ "PBKDF2\0"
/*  1369 */ "no-pbkdf2\0"
/*  1379 */ "use-pbkdf2\0"
/*  1390 */ "set alternate special characters\0"
/*  1423 */ "SPECIALS\0"
/*  1432 */ "specials\0"
/*  1441 */ "/+-\0"
/*  1445 */ "Options for management and output format.:\0"
/*  1488 */ "omit printing the password headers\0"
/*  1523 */ "NO_HEADER\0"
/*  1533 */ "no-header\0"
/*  1543 */ "select only certain bytes of a password\0"
/*  1583 */ "SELECT_CHARS\0"
/*  1596 */ "select-chars\0"
/*  1609 */ "confirmation question answers (see man page)\0"
/*  1654 */ "CONFIRM\0"
/*  1662 */ "confirm\0"
/*  1670 */ "out-of-date confirmation question answers (deprecated)\0"
/*  1725 */ "OLD_CONFIRM\0"
/*  1737 */ "old-confirm\0"
/*  1749 */ "Show status of a password id\0"
/*  1778 */ "STATUS\0"
/*  1785 */ "status\0"
/*  1792 */ "Remove a password id entry\0"
/*  1819 */ "DELETE\0"
/*  1826 */ "delete\0"
/*  1833 */ "a reminder of domains used for password id\0"
/*  1876 */ "DOMAIN\0"
/*  1883 */ "domain\0"
/*  1890 */ "specify configuration file\0"
/*  1917 */ "CONFIG_FILE\0"
/*  1929 */ "config-file\0"
/*  1941 */ "Options supported by the AutoOpts option library.:\0"
/*  1992 */ "display extended usage information and exit\0"
/*  2036 */ "help\0"
/*  2041 */ "extended usage information passed thru pager\0"
/*  2086 */ "more-help\0"
/*  2096 */ "output version information and exit\0"
/*  2132 */ "version\0"
/*  2140 */ "load options from a config file\0"
/*  2172 */ "LOAD_OPTS\0"
/*  2182 */ "no-load-opts\0"
/*  2195 */ "GNU_PW_MGR\0"
/*  2206 */ "gnu-pw-mgr - derive a password from an id - Ver. 2.7.4\n"
            "Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [ <pw-id> ]\n\0"
/*  2331 */ "bkorb@gnu.org\0"
/*  2345 */ "\n"
            "The password id should contain a fairly consistent permutation of the URL\n"
            "you are logging in to.  \"Fairly\" because you may wish to vary your\n"
            "financial institutions differently than your newspaper, or you may need\n"
            "multiple credentials for the same domain.  Either way, a password id is\n"
            "formed by surrounding the domain name with unlikely prefixes, suffixes and\n"
            "punctuations.\n\n"
            "Only the passwords for one password id are ever printed.  If the command\n"
            "line contains multiple operands (arguments after the options), then they\n"
            "are assembled into one password id with space characters separating the\n"
            "original operands.  One password is printed for each seed stored in the\n"
            "password configuration file.\n\n"
            "One password is printed for every configured seed value with a matching\n"
            "'--shared' option state.  Seed values are added by specifying just the\n"
            "'--tag' and '--text' options, with or without the '--shared' option.  When\n"
            "passwords are printed, the tag is also printed in plain text.\n\n"
            "Passwords are changed by specifying the '-r' or '--rehash' option with a\n"
            "new numeric value.  The day this happens will be noted in the password\n"
            "configuration file and printed in the password header.\n\n"
            "Password ids are never stored anywhere.\n\n"
            "Please be sure to read the \"Warnings\" section in the full documentation.\n\n"
            "NOTE: the '--load-opts' option is supported by the option processing\n"
            "library.  This program actually prohibits its usage.  The password\n"
            "configuration database is normally found in a standard location.  It may be\n"
            "overridden at invocation time by the '--config-file' option.  Using\n"
            "'--load-opts' on the command line will lead to a conflict error.\n\0"
/*  3983 */ "gnu-pw-mgr 2.7.4";

/**
 *  seed-options option description:
 */
/** seed-options option separation text */
#define SEED_OPTIONS_DESC      (gnu_pw_mgr_opt_strs+868)
#define SEED_OPTIONS_FLAGS     (OPTST_DOCUMENT | OPTST_NO_INIT)

/**
 *  seed option description:
 */
/** Descriptive text for the seed option */
#define SEED_DESC      (gnu_pw_mgr_opt_strs+934)
/** Upper-cased name for the seed option */
#define SEED_NAME      (gnu_pw_mgr_opt_strs+974)
/** Name string for the seed option */
#define SEED_name      (gnu_pw_mgr_opt_strs+979)
/** Compiled in flag settings for the seed option */
#define SEED_FLAGS     (OPTST_DISABLED | OPTST_NO_COMMAND \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_HIERARCHY))

/**
 *  tag option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the tag option */
#define TAG_DESC      (gnu_pw_mgr_opt_strs+984)
/** Upper-cased name for the tag option */
#define TAG_NAME      (gnu_pw_mgr_opt_strs+993)
/** Name string for the tag option */
#define TAG_name      (gnu_pw_mgr_opt_strs+997)
/** Other options that appear in conjunction with the tag option */
static int const aTagCantList[] = {
    INDEX_OPT_LOGIN_ID,
    INDEX_OPT_LENGTH,
    INDEX_OPT_CCLASS,
    INDEX_OPT_REHASH,
    INDEX_OPT_SPECIALS,
    INDEX_OPT_NO_HEADER,
    INDEX_OPT_SELECT_CHARS,
    INDEX_OPT_CONFIRM,
    INDEX_OPT_STATUS,
    INDEX_OPT_DELETE, NO_EQUIVALENT };
/** Compiled in flag settings for the tag option */
#define TAG_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  text option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the text option */
#define TEXT_DESC      (gnu_pw_mgr_opt_strs+1001)
/** Upper-cased name for the text option */
#define TEXT_NAME      (gnu_pw_mgr_opt_strs+1011)
/** Name string for the text option */
#define TEXT_name      (gnu_pw_mgr_opt_strs+1016)
/** Other options that are required by the text option */
static int const aTextMustList[] = {
    INDEX_OPT_TAG, NO_EQUIVALENT };
/** Compiled in flag settings for the text option */
#define TEXT_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  shared option description:
 */
/** Descriptive text for the shared option */
#define SHARED_DESC      (gnu_pw_mgr_opt_strs+1021)
/** Upper-cased name for the shared option */
#define SHARED_NAME      (gnu_pw_mgr_opt_strs+1032)
/** disablement name for the shared option */
#define NOT_SHARED_name  (gnu_pw_mgr_opt_strs+1039)
/** disablement prefix for the shared option */
#define NOT_SHARED_PFX   (gnu_pw_mgr_opt_strs+1049)
/** Name string for the shared option */
#define SHARED_name      (NOT_SHARED_name + 3)
/** Compiled in flag settings for the shared option */
#define SHARED_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  default-cclass option description:
 */
/** Descriptive text for the default-cclass option */
#define DEFAULT_CCLASS_DESC      (gnu_pw_mgr_opt_strs+1052)
/** Upper-cased name for the default-cclass option */
#define DEFAULT_CCLASS_NAME      (gnu_pw_mgr_opt_strs+1082)
/** disablement name for the default-cclass option */
#define NOT_DEFAULT_CCLASS_name  (gnu_pw_mgr_opt_strs+1097)
/** disablement prefix for the default-cclass option */
#define NOT_DEFAULT_CCLASS_PFX   (gnu_pw_mgr_opt_strs+1049)
/** Name string for the default-cclass option */
#define DEFAULT_CCLASS_name      (NOT_DEFAULT_CCLASS_name + 3)
/** Compiled in flag settings for the default-cclass option */
#define DEFAULT_CCLASS_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  password-options option description:
 */
/** password-options option separation text */
#define PASSWORD_OPTIONS_DESC      (gnu_pw_mgr_opt_strs+1115)
#define PASSWORD_OPTIONS_FLAGS     (OPTST_DOCUMENT | OPTST_NO_INIT)

/**
 *  login-id option description:
 */
/** Descriptive text for the login-id option */
#define LOGIN_ID_DESC      (gnu_pw_mgr_opt_strs+1160)
/** Upper-cased name for the login-id option */
#define LOGIN_ID_NAME      (gnu_pw_mgr_opt_strs+1188)
/** Name string for the login-id option */
#define LOGIN_ID_name      (gnu_pw_mgr_opt_strs+1197)
/** Compiled in flag settings for the login-id option */
#define LOGIN_ID_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  length option description:
 */
/** Descriptive text for the length option */
#define LENGTH_DESC      (gnu_pw_mgr_opt_strs+1206)
/** Upper-cased name for the length option */
#define LENGTH_NAME      (gnu_pw_mgr_opt_strs+1227)
/** Name string for the length option */
#define LENGTH_name      (gnu_pw_mgr_opt_strs+1234)
/** The compiled in default value for the length option argument */
#define LENGTH_DFT_ARG   ((char const*)16)
/** Compiled in flag settings for the length option */
#define LENGTH_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  cclass option description:
 */
/** Descriptive text for the cclass option */
#define CCLASS_DESC      (gnu_pw_mgr_opt_strs+1241)
/** Upper-cased name for the cclass option */
#define CCLASS_NAME      (gnu_pw_mgr_opt_strs+1266)
/** Name string for the cclass option */
#define CCLASS_name      (gnu_pw_mgr_opt_strs+1273)
/** The compiled in default value for the cclass option argument */
#define CCLASS_DFT_ARG   (NULL)
#define CclassCookieBits             VOIDP(CCLASS_ALPHA|CCLASS_DIGIT)
/** Compiled in flag settings for the cclass option */
#define CCLASS_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_MEMBERSHIP))

/**
 *  rehash option description:
 */
/** Descriptive text for the rehash option */
#define REHASH_DESC      (gnu_pw_mgr_opt_strs+1280)
/** Upper-cased name for the rehash option */
#define REHASH_NAME      (gnu_pw_mgr_opt_strs+1313)
/** Name string for the rehash option */
#define REHASH_name      (gnu_pw_mgr_opt_strs+1320)
/** Compiled in flag settings for the rehash option */
#define REHASH_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  pbkdf2 option description:
 */
/** Descriptive text for the pbkdf2 option */
#define PBKDF2_DESC      (gnu_pw_mgr_opt_strs+1327)
/** Upper-cased name for the pbkdf2 option */
#define PBKDF2_NAME      (gnu_pw_mgr_opt_strs+1362)
/** disablement name for the pbkdf2 option */
#define NOT_PBKDF2_name  (gnu_pw_mgr_opt_strs+1369)
/** disablement prefix for the pbkdf2 option */
#define NOT_PBKDF2_PFX   (gnu_pw_mgr_opt_strs+1049)
/** Name string for the pbkdf2 option */
#define PBKDF2_name      (gnu_pw_mgr_opt_strs+1379)
/** The compiled in default value for the pbkdf2 option argument */
#define PBKDF2_DFT_ARG   ((char const*)10007)
/** Compiled in flag settings for the pbkdf2 option */
#define PBKDF2_FLAGS     (OPTST_INITENABLED | OPTST_NO_INIT | OPTST_NO_COMMAND \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  specials option description:
 */
/** Descriptive text for the specials option */
#define SPECIALS_DESC      (gnu_pw_mgr_opt_strs+1390)
/** Upper-cased name for the specials option */
#define SPECIALS_NAME      (gnu_pw_mgr_opt_strs+1423)
/** Name string for the specials option */
#define SPECIALS_name      (gnu_pw_mgr_opt_strs+1432)
/** The compiled in default value for the specials option argument */
#define SPECIALS_DFT_ARG   (gnu_pw_mgr_opt_strs+1441)
/** Compiled in flag settings for the specials option */
#define SPECIALS_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  formatting-options option description:
 */
/** formatting-options option separation text */
#define FORMATTING_OPTIONS_DESC      (gnu_pw_mgr_opt_strs+1445)
#define FORMATTING_OPTIONS_FLAGS     (OPTST_DOCUMENT | OPTST_NO_INIT)

/**
 *  no-header option description:
 */
/** Descriptive text for the no-header option */
#define NO_HEADER_DESC      (gnu_pw_mgr_opt_strs+1488)
/** Upper-cased name for the no-header option */
#define NO_HEADER_NAME      (gnu_pw_mgr_opt_strs+1523)
/** Name string for the no-header option */
#define NO_HEADER_name      (gnu_pw_mgr_opt_strs+1533)
/** Compiled in flag settings for the no-header option */
#define NO_HEADER_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  select-chars option description:
 */
/** Descriptive text for the select-chars option */
#define SELECT_CHARS_DESC      (gnu_pw_mgr_opt_strs+1543)
/** Upper-cased name for the select-chars option */
#define SELECT_CHARS_NAME      (gnu_pw_mgr_opt_strs+1583)
/** Name string for the select-chars option */
#define SELECT_CHARS_name      (gnu_pw_mgr_opt_strs+1596)
/** Compiled in flag settings for the select-chars option */
#define SELECT_CHARS_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  confirm option description:
 */
/** Descriptive text for the confirm option */
#define CONFIRM_DESC      (gnu_pw_mgr_opt_strs+1609)
/** Upper-cased name for the confirm option */
#define CONFIRM_NAME      (gnu_pw_mgr_opt_strs+1654)
/** Name string for the confirm option */
#define CONFIRM_name      (gnu_pw_mgr_opt_strs+1662)
/** Compiled in flag settings for the confirm option */
#define CONFIRM_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  old-confirm option description:
 */
/** Descriptive text for the old-confirm option */
#define OLD_CONFIRM_DESC      (gnu_pw_mgr_opt_strs+1670)
/** Upper-cased name for the old-confirm option */
#define OLD_CONFIRM_NAME      (gnu_pw_mgr_opt_strs+1725)
/** Name string for the old-confirm option */
#define OLD_CONFIRM_name      (gnu_pw_mgr_opt_strs+1737)
/** Compiled in flag settings for the old-confirm option */
#define OLD_CONFIRM_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT | OPTST_DEPRECATED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  status option description:
 */
/** Descriptive text for the status option */
#define STATUS_DESC      (gnu_pw_mgr_opt_strs+1749)
/** Upper-cased name for the status option */
#define STATUS_NAME      (gnu_pw_mgr_opt_strs+1778)
/** Name string for the status option */
#define STATUS_name      (gnu_pw_mgr_opt_strs+1785)
/** Compiled in flag settings for the status option */
#define STATUS_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  delete option description:
 */
/** Descriptive text for the delete option */
#define DELETE_DESC      (gnu_pw_mgr_opt_strs+1792)
/** Upper-cased name for the delete option */
#define DELETE_NAME      (gnu_pw_mgr_opt_strs+1819)
/** Name string for the delete option */
#define DELETE_name      (gnu_pw_mgr_opt_strs+1826)
/** Compiled in flag settings for the delete option */
#define DELETE_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  domain option description:
 */
/** Descriptive text for the domain option */
#define DOMAIN_DESC      (gnu_pw_mgr_opt_strs+1833)
/** Upper-cased name for the domain option */
#define DOMAIN_NAME      (gnu_pw_mgr_opt_strs+1876)
/** Name string for the domain option */
#define DOMAIN_name      (gnu_pw_mgr_opt_strs+1883)
/** Compiled in flag settings for the domain option */
#define DOMAIN_FLAGS     (OPTST_DISABLED | OPTST_STACKED | OPTST_NO_INIT \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  config-file option description:
 */
/** Descriptive text for the config-file option */
#define CONFIG_FILE_DESC      (gnu_pw_mgr_opt_strs+1890)
/** Upper-cased name for the config-file option */
#define CONFIG_FILE_NAME      (gnu_pw_mgr_opt_strs+1917)
/** Name string for the config-file option */
#define CONFIG_FILE_name      (gnu_pw_mgr_opt_strs+1929)
/** Compiled in flag settings for the config-file option */
#define CONFIG_FILE_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT | OPTST_IMM \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  usage-options option description:
 */
/** usage-options option separation text */
#define USAGE_OPTIONS_DESC      (gnu_pw_mgr_opt_strs+1941)
#define USAGE_OPTIONS_FLAGS     (OPTST_DOCUMENT | OPTST_NO_INIT)

/*
 *  Help/More_Help/Version option descriptions:
 */
#define HELP_DESC       (gnu_pw_mgr_opt_strs+1992)
#define HELP_name       (gnu_pw_mgr_opt_strs+2036)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (gnu_pw_mgr_opt_strs+2041)
#define MORE_HELP_name  (gnu_pw_mgr_opt_strs+2086)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  HELP_DESC
#define MORE_HELP_name  HELP_name
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#ifdef NO_OPTIONAL_OPT_ARGS
#  define VER_FLAGS     (OPTST_IMM | OPTST_NO_INIT)
#else
#  define VER_FLAGS     (OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) | \
                         OPTST_ARG_OPTIONAL | OPTST_IMM | OPTST_NO_INIT)
#endif
#define VER_DESC        (gnu_pw_mgr_opt_strs+2096)
#define VER_name        (gnu_pw_mgr_opt_strs+2132)
#define LOAD_OPTS_DESC     (gnu_pw_mgr_opt_strs+2140)
#define LOAD_OPTS_NAME     (gnu_pw_mgr_opt_strs+2172)
#define NO_LOAD_OPTS_name  (gnu_pw_mgr_opt_strs+2182)
#define LOAD_OPTS_pfx      (gnu_pw_mgr_opt_strs+1049)
#define LOAD_OPTS_name     (NO_LOAD_OPTS_name + 3)
/**
 *  Declare option callback procedures
 */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doOptCclass,      doOptConfig_File, doOptLength,      doOptOld_Confirm,
    doOptRehash,      doOptSpecials,    doOptText,        doUsageOpt;
#define VER_PROC        optionPrintVersion

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Define the gnu-pw-mgr Option Descriptions.
 * This is an array of OPTION_CT entries, one for each
 * option that the gnu-pw-mgr program responds to.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, 0,
     /* equiv idx, value */ 0, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 0, 0,
     /* opt state flags  */ SEED_OPTIONS_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SEED_OPTIONS_DESC, NULL, NULL,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_SEED,
     /* equiv idx, value */ 1, VALUE_OPT_SEED,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SEED_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --seed */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNestedVal,
     /* desc, NAME, name */ SEED_DESC, SEED_NAME, SEED_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_TAG,
     /* equiv idx, value */ 2, VALUE_OPT_TAG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ TAG_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --tag */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aTagCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ TAG_DESC, TAG_NAME, TAG_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_TEXT,
     /* equiv idx, value */ 3, VALUE_OPT_TEXT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ TEXT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --text */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aTextMustList, NULL,
     /* option proc      */ doOptText,
     /* desc, NAME, name */ TEXT_DESC, TEXT_NAME, TEXT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_SHARED,
     /* equiv idx, value */ 4, VALUE_OPT_SHARED,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SHARED_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --shared */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SHARED_DESC, SHARED_NAME, SHARED_name,
     /* disablement strs */ NOT_SHARED_name, NOT_SHARED_PFX },

  {  /* entry idx, value */ 5, VALUE_OPT_DEFAULT_CCLASS,
     /* equiv idx, value */ 5, VALUE_OPT_DEFAULT_CCLASS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DEFAULT_CCLASS_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --default-cclass */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DEFAULT_CCLASS_DESC, DEFAULT_CCLASS_NAME, DEFAULT_CCLASS_name,
     /* disablement strs */ NOT_DEFAULT_CCLASS_name, NOT_DEFAULT_CCLASS_PFX },

  {  /* entry idx, value */ 0, 0,
     /* equiv idx, value */ 0, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 0, 0,
     /* opt state flags  */ PASSWORD_OPTIONS_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ PASSWORD_OPTIONS_DESC, NULL, NULL,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 7, VALUE_OPT_LOGIN_ID,
     /* equiv idx, value */ 7, VALUE_OPT_LOGIN_ID,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LOGIN_ID_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --login-id */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ LOGIN_ID_DESC, LOGIN_ID_NAME, LOGIN_ID_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_LENGTH,
     /* equiv idx, value */ 8, VALUE_OPT_LENGTH,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LENGTH_FLAGS, 0,
     /* last opt argumnt */ { LENGTH_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptLength,
     /* desc, NAME, name */ LENGTH_DESC, LENGTH_NAME, LENGTH_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_CCLASS,
     /* equiv idx, value */ 9, VALUE_OPT_CCLASS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ CCLASS_FLAGS, 0,
     /* last opt argumnt */ { CCLASS_DFT_ARG },
     /* arg list/cookie  */ CclassCookieBits,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptCclass,
     /* desc, NAME, name */ CCLASS_DESC, CCLASS_NAME, CCLASS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_REHASH,
     /* equiv idx, value */ 10, VALUE_OPT_REHASH,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ REHASH_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --rehash */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptRehash,
     /* desc, NAME, name */ REHASH_DESC, REHASH_NAME, REHASH_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_PBKDF2,
     /* equiv idx, value */ 11, VALUE_OPT_PBKDF2,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PBKDF2_FLAGS, 0,
     /* last opt argumnt */ { PBKDF2_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ PBKDF2_DESC, PBKDF2_NAME, PBKDF2_name,
     /* disablement strs */ NOT_PBKDF2_name, NOT_PBKDF2_PFX },

  {  /* entry idx, value */ 12, VALUE_OPT_SPECIALS,
     /* equiv idx, value */ 12, VALUE_OPT_SPECIALS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SPECIALS_FLAGS, 0,
     /* last opt argumnt */ { SPECIALS_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptSpecials,
     /* desc, NAME, name */ SPECIALS_DESC, SPECIALS_NAME, SPECIALS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 0, 0,
     /* equiv idx, value */ 0, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 0, 0,
     /* opt state flags  */ FORMATTING_OPTIONS_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ FORMATTING_OPTIONS_DESC, NULL, NULL,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 14, VALUE_OPT_NO_HEADER,
     /* equiv idx, value */ 14, VALUE_OPT_NO_HEADER,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NO_HEADER_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --no-header */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ NO_HEADER_DESC, NO_HEADER_NAME, NO_HEADER_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 15, VALUE_OPT_SELECT_CHARS,
     /* equiv idx, value */ 15, VALUE_OPT_SELECT_CHARS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SELECT_CHARS_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --select-chars */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SELECT_CHARS_DESC, SELECT_CHARS_NAME, SELECT_CHARS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 16, VALUE_OPT_CONFIRM,
     /* equiv idx, value */ 16, VALUE_OPT_CONFIRM,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CONFIRM_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --confirm */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ CONFIRM_DESC, CONFIRM_NAME, CONFIRM_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 17, VALUE_OPT_OLD_CONFIRM,
     /* equiv idx, value */ 17, VALUE_OPT_OLD_CONFIRM,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OLD_CONFIRM_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --old-confirm */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptOld_Confirm,
     /* desc, NAME, name */ OLD_CONFIRM_DESC, OLD_CONFIRM_NAME, OLD_CONFIRM_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 18, VALUE_OPT_STATUS,
     /* equiv idx, value */ 18, VALUE_OPT_STATUS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ STATUS_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --status */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ STATUS_DESC, STATUS_NAME, STATUS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 19, VALUE_OPT_DELETE,
     /* equiv idx, value */ 19, VALUE_OPT_DELETE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DELETE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --delete */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DELETE_DESC, DELETE_NAME, DELETE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 20, VALUE_OPT_DOMAIN,
     /* equiv idx, value */ 20, VALUE_OPT_DOMAIN,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ DOMAIN_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --domain */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionStackArg,
     /* desc, NAME, name */ DOMAIN_DESC, DOMAIN_NAME, DOMAIN_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 21, VALUE_OPT_CONFIG_FILE,
     /* equiv idx, value */ 21, VALUE_OPT_CONFIG_FILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CONFIG_FILE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --config-file */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptConfig_File,
     /* desc, NAME, name */ CONFIG_FILE_DESC, CONFIG_FILE_NAME, CONFIG_FILE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 0, 0,
     /* equiv idx, value */ 0, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 0, 0,
     /* opt state flags  */ USAGE_OPTIONS_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ USAGE_OPTIONS_DESC, NULL, NULL,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VER_FLAGS, AOUSE_VERSION,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ VER_PROC,
     /* desc, NAME, name */ VER_DESC, NULL, VER_name,
     /* disablement strs */ NULL, NULL },



  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, AOUSE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, AOUSE_MORE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_LOAD_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
			  | OPTST_DISABLE_IMM, AOUSE_LOAD_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ LOAD_OPTS_DESC, LOAD_OPTS_NAME, LOAD_OPTS_name,
     /* disablement strs */ NO_LOAD_OPTS_name, LOAD_OPTS_pfx }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/** Reference to the upper cased version of gnu-pw-mgr. */
#define zPROGNAME       (gnu_pw_mgr_opt_strs+2195)
/** Reference to the title line for gnu-pw-mgr usage. */
#define zUsageTitle     (gnu_pw_mgr_opt_strs+2206)
/** There is no gnu-pw-mgr configuration file. */
#define zRcName         NULL
/** There are no directories to search for gnu-pw-mgr config files. */
#define apzHomeList     NULL
/** The gnu-pw-mgr program bug email address. */
#define zBugsAddr       (gnu_pw_mgr_opt_strs+2331)
/** Clarification/explanation of what gnu-pw-mgr does. */
#define zExplain        (NULL)
/** Extra detail explaining what gnu-pw-mgr does. */
#define zDetail         (gnu_pw_mgr_opt_strs+2345)
/** The full version string for gnu-pw-mgr. */
#define zFullVersion    (gnu_pw_mgr_opt_strs+3983)
/* extracted from optcode.tlib near line 342 */

#define OPTPROC_BASE OPTPROC_NONE
#define translate_option_strings NULL

#define gnu_pw_mgr_full_usage (NULL)
#define gnu_pw_mgr_short_usage (NULL)

#endif /* not defined __doxygen__ */

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the optionUsage function.
 *
 * @param[in] opts the AutoOpts option description structure
 * @param[in] od   the descriptor for the "help" (usage) option.
 * @noreturn
 */
static void
doUsageOpt(tOptions * opts, tOptDesc * od)
{
    int ex_code;
    ex_code = GNU_PW_MGR_EXIT_SUCCESS;
    optionUsage(&gnu_pw_mgrOptions, ex_code);
    /* NOTREACHED */
    exit(GNU_PW_MGR_EXIT_INVALID);
    (void)opts;
    (void)od;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the text option.
 * The text for a password seed to be added to the config file.
 * This text cannot include the 7 character sequence "</text>".
 *         There must always be at least one. Multiple text seeds will
 *         cause multiple passwords to be printed out.
 *
 * This text must be at least 64 characters long.  The expectation
 * is you will write a sentence or two that you can easily remember,
 * including any capitalization, punctuation and spacing.  You should
 * include some non-alphabetic, non-digit characters here and there to
 * make a dictionary attack more difficult.  But if you need to
 * reconstruct this, you need to remember them.
 *
 * If the text is shorter than 64 characters, it will be padded out.  In
 * such a case, you will need to save the configuration file some place
 * secure or it will be extremely difficult to reconstruct it, should
 * that become necessary.
 *
 *         The original expectation was that passwords would be updated on an
 *         occasional basis. Now that I have over 100 login credentials, it is
 *         clearly infeasible to go around and update them all. Instead, I have
 *         to decide which are important to update and use the @code{--rehash}
 *         option to change the rehash count. The date of the last rehash
 * count change is recorded with the password id options.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptText(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 151 */
    char const * oops =
        strstr(pOptDesc->optArg.argString, end_text_mark);
    if (oops == NULL) return;
    die(GNU_PW_MGR_EXIT_BAD_SEED, text_has_mark_fmt,
        pOptDesc->optArg.argString);
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the length option.
 * Some web sites are more restrictive.  Some are more generous.
 * Use of this option requires a @code{<pw-id>} operand.
 *
 * Password lengths of 4 through 7 characters are limited to "pin" numbers.
 * "pin" numbers are 4 or more digits.  All other passwords must be at
 * least 8 characters long.  The default length is 16.  Use at least 24,
 * if you can.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptLength(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static struct {long rmin, rmax;} const rng[1] = {
        { 4, 128 } };
    int  ix;

    if (pOptions <= OPTPROC_EMIT_LIMIT)
        goto emit_ranges;
    optionNumericVal(pOptions, pOptDesc);

    for (ix = 0; ix < 1; ix++) {
        if (pOptDesc->optArg.argInt < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (pOptDesc->optArg.argInt == rng[ix].rmin)
            return;
        if (rng[ix].rmax == LONG_MIN)
            continue;
        if (pOptDesc->optArg.argInt <= rng[ix].rmax)
            return;
    }

    option_usage_fp = stderr;

 emit_ranges:
    optionShowRange(pOptions, pOptDesc, VOIDP(rng), 1);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the cclass option.
 * This option augments or specifies which character classes either
 * must or must not appear in the final password.
 *
 * Some sites disallow special characters, other sites require
 * them, and still others require them, but only certain ones.
 * If disallowed, specify @code{no-special} and special
 * characters will be replaced with digits.  If @code{special} is
 * specified specifically, then in the absence of a '+' or '/'
 * character (or their alternates), one character will be
 * replaced with a hyphen.  Other characters may be substituted
 * for these three special characters with the @code{--specials} option.
 *
 * @noindent
 * Explanations of the keywords:
 * @table @samp
 * @item upper
 * There must be at least one upper case letter.
 *
 * @item lower
 * There must be at least one lower case letter.
 * Both this and @samp{upper} together require one of each.
 *
 * @item alpha
 * There must be at least one alphabetic character, either upper or lower
 * If either @samp{upper} or @samp{lower} is specified, this attribute
 * is a no-op.
 *
 * @item no-alpha
 * Alphabetic characters are prohibited.  This conflicts with
 * @samp{upper}, @samp{lower} and @samp{alpha}.
 *
 * @item digit
 * There must be at least one decimal digit character.
 *
 * @item no-triplets
 * When three characters in a row are the same, the third is fiddled.
 * Letters are changed to the next letter and @code{z} becomes @code{a}.
 * Digits are handled similarly.  Special characters are replaced with
 * the third possible special character (@code{-}, unless modified with
 * @code{--specials}).  (Yes, there are a few such sites.)
 *
 * @item special
 * The password must contain at least one @samp{special character}
 * (a non-alphabetic, non-digit character).
 *
 * @item no-special
 * The password must not contain any characters that are not alphabetic
 * or decimal digits.
 *
 * @item no-sequence The password must not contain a consecutive sequence
 * of three or more characters.
 *
 * @item pin
 * The password is all digits, a Personal Identification Number.
 * This is an abbreviation for @code{no-alpha + no-special + digit}.
 *
 * @item alnum
 * This is an abbreviation for @code{alpha + digit}.
 *
 * @item two-*
 * Two of a particular character class are required.
 * Specifying this implies "at least one of" the specified type.
 * Two upper case, lower case, punctuation (special) and digit
 * characters may be specified this way.  ``two-alpha'' is not supported.
 * @end table
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptCclass(tOptions* pOptions, tOptDesc* pOptDesc)
{

/* extracted from optmain.tlib near line 1007 */
    static char const * const names[15] = {
        "alpha",        "upper",        "lower",        "digit",
        "special",      "no-special",   "no-alpha",     "no-triplets",
        "no-sequence",  "pin",          "alnum",        "two-upper",
        "two-lower",    "two-digit",    "two-special"
    };
    /*
     * The lead character is only examined from the command line
     */
    if (  (STATE_OPT(CCLASS) == OPTST_DEFINED)
       && (pOptDesc->optArg.argString != NULL)) {
        char * p = (char *)(uintptr_t)pOptDesc->optArg.argString;
        switch (pOptDesc->optArg.argString[0]) {
            case '-': tweak_prev_cclass = -1; *p = '='; break;
            case '+': tweak_prev_cclass =  1; *p = '='; break;
            default:  break;
        } // force the results to be only the specified bits
    }
    /*
     * This function handles special invalid values for "pOptions"
     */
    optionSetMembers(pOptions, pOptDesc, names, 15);
    if (pOptions == &gnu_pw_mgrOptions)
        fix_cclass_bits(pOptDesc);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the rehash option.
 *
 * Passwords are created with the SHA256 hash of the "seed
 *         string", the password id, and the tag text associated with the
 *         seed. The result is then "rehashed" with the pbkdf2 function.
 *         By default, this is done 10007 times.  This can be changed by
 *         specifying a different count between 1 and 100,000.  You can
 *         change this either directly with a count or by prefixing a
 *         number with a '+' or '-' character. The prefix will cause the
 *         previous value to be adjusted.  Changing the count will change
 *         the password and will mark the entry with the date of the most
 *         recent password change.
 *
 * Please see RFC 2898 for a specification of the PBKDF2
 * (Password-Based Key Derivation Function version 2) function.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptRehash(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static struct {long rmin, rmax;} const rng[1] = {
        { 1, 100000 } };
    int  ix;

    if (pOptions <= OPTPROC_EMIT_LIMIT)
        goto emit_ranges;
    /*
     * this option can only appear on the command line.
     */
    if (pOptDesc->optArg.argString != NULL)
        switch (pOptDesc->optArg.argString[0]) {
        case '-':
            tweak_prev_rehash = -1;
            pOptDesc->optArg.argString++;
            break;
        case '+':
            tweak_prev_rehash =  1;
            pOptDesc->optArg.argString++;
            break;
        default:
            break;
        }
    optionNumericVal(pOptions, pOptDesc);

    for (ix = 0; ix < 1; ix++) {
        if (pOptDesc->optArg.argInt < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (pOptDesc->optArg.argInt == rng[ix].rmin)
            return;
        if (rng[ix].rmax == LONG_MIN)
            continue;
        if (pOptDesc->optArg.argInt <= rng[ix].rmax)
            return;
    }

    option_usage_fp = stderr;

 emit_ranges:
    optionShowRange(pOptions, pOptDesc, VOIDP(rng), 1);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the specials option.
 * The computed password is a base64 encoding of a sha256 hash of
 * various inputs.  Base64 encoding uses '+' and '/'
 * characters. However, when this program is required to have at
 * least one special character in the result, and neither the '+'
 * nor '-' get encoded, one character will be replaced with a
 * hyphen (@code{-}).
 *
 * Some web sites require particular special characters in their
 * passwords that do not include these three default characters.
 * For those passwords, specify this option with exactly three
 * characters in the string argument.  They will be used to
 * replace the three characters above.  The first two may be the
 * same, but the third @i{must} be different from the first two.
 * This option is accepted, but serves no purpose if
 * @code{no-special} has been specified in the @code{--cclass}
 * option.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptSpecials(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 493 */
    unsigned int len = strlen(pOptDesc->optArg.argString);
    if (len != 3)
        usage_message("the --specials option must have exactly 3 "
                      "characters, not %u.\n", len);
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the old-confirm option.
 * Use this method of answering confirmation questions only if you have to.
 * When your password changes, this will change, too. Inconvenient.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptOld_Confirm(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 603 */
    SET_OPT_CONFIRM(pOptDesc->optArg.argString);
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the config-file option.
 * If you need an alternate location for storing your password
 * seed files, use this option. It must be specified on the
 *         command line every time it is needed. You are responsible to
 *         ensure that the directory already exists. The file will be
 *         left read-only when gnu-pw-mgr exits. The containing directory
 * permissions will not be checked or altered.
 * @param[in] pOptions the gnu-pw-mgr options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptConfig_File(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 669 */
    optionLoadOpt(pOptions, pOptDesc);
    pOptDesc = pOptions->pOptDesc + INDEX_OPT_LOAD_OPTS;
    pOptDesc->fOptState |= OPTST_DISABLED;
    (pOptDesc->optOccCt)++;
}
/* extracted from optmain.tlib near line 1250 */

/**
 * Print a usage message with a format and va_list argument.
 * The optionUsage function is then invoked to print
 * the error usage text (somewhat abbreviated) and then exit.
 *
 * @param[in] fmt the message format string
 * @param[in] ap  the var-arg list.
 * @noreturn
 */
noreturn extern void
vusage_message(char const * fmt, va_list ap)
{
    char const * er_leader = _("gnu-pw-mgr usage error:\n");
    fputs(er_leader, stderr);
    vfprintf(stderr, fmt, ap);
    optionUsage(&gnu_pw_mgrOptions, GNU_PW_MGR_EXIT_USAGE_ERROR);
    /* NOTREACHED, but C11 compilers cannot tell. */
    abort();
}

/**
 * Print a usage message with a format and a variable argument list.
 * vusage_message() is called to do the work.
 *
 * @param[in] fmt the message format string
 * @param[in] ... the argument list for the message
 * @noreturn
 */
noreturn extern void
usage_message(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vusage_message(fmt, ap);
}

/**
 * Print a fatal error message and die, \a va_list style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ap         the argument list for the message
 * @noreturn
 */
noreturn extern void
vdie(int exit_code, char const * fmt, va_list ap)
{
    char const * die_leader = _("gnu-pw-mgr fatal error:\n");
    fputs(die_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
    exit(exit_code);
}

/**
 * Print a fatal error message and die, var-arg style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ...        the list of arguments for the message
 * @noreturn
 */
noreturn extern void
die(int exit_code, char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vdie(exit_code, fmt, ap);
}

/**
 * Print a file system error fatal error message and die.
 *
 * @param[in] exit_code  the value to call exit(3) with.
 * @param[in] op         the operation that failed.
 * @param[in] fname      the file name the operation was on.
 * @noreturn
 */
noreturn extern void
fserr(int exit_code, char const * op, char const * fname)
{
    char const * fserr_fmt = _("fserr %d (%s) performing '%s' on %s\n");
    die(exit_code, fserr_fmt, errno, strerror(errno), op, fname);
}

/**
 * Print a warning message, \a va_list style.
 *
 * @param[in] fmt        the "something awry" message
 * @param[in] ap         the argument list for the message
 */
void
vwarning_msg(char const * fmt, va_list ap)
{
    char const * warn_leader = _("gnu-pw-mgr WARNING:\n");
    fputs(warn_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
}

/**
 * Print a warning message, var-arg style.
 *
 * @param[in] fmt        the "something awry" message
 * @param[in] ...        the list of arguments for the message
 */
void
warning_msg(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vwarning_msg(fmt, ap);
    va_end(ap);
}

/**
 * The directory containing the data associated with gnu-pw-mgr.
 */
#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

/**
 * Information about the person or institution that packaged gnu-pw-mgr
 * for the current distribution.
 */
#ifndef  WITH_PACKAGER
# define gnu_pw_mgr_packager_info NULL
#else
/** Packager information for gnu-pw-mgr. */
static char const gnu_pw_mgr_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport gnu_pw_mgr bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif
#ifndef __doxygen__

#endif /* __doxygen__ */
/**
 * The option definitions for gnu-pw-mgr.  The one structure that
 * binds them all.
 */
tOptions gnu_pw_mgrOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_NEGATIONS ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      NO_EQUIVALENT, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    27 /* full option count */, 23 /* user option count */,
    gnu_pw_mgr_full_usage, gnu_pw_mgr_short_usage,
    NULL, NULL,
    PKGDATADIR, gnu_pw_mgr_packager_info
};

#ifdef  __cplusplus
}
#endif
/* opts.c ends here */
