# Sitemap

## Getting Started

*   [Getting Started Quickly](./getting_started_quickly.md)
*   [Core Runtime](./core_runtime.md)
*   [Write Protection](./write_protection.md)
*   [EC Acronyms and Technologies](./ec_terms.md)

## EC Bringup

*   [New Board Checklist](./new_board_checklist.md)

## Case Closed Debugging (CCD)

*   [Case Closed Debugging Overview][1]
*   [Google Security Chip Case Closed Debugging][2]
*   [Tutorials][3]

## Verified Boot Troubleshooting

*   [Cr50 Verified Boot Troubleshooting][4]

## Fingerprint MCU (FPMCU)

*   [Fingerprint MCU (FPMCU)](./fingerprint/fingerprint.md)
*   [FPMCU Development for Partners](./fingerprint/fingerprint-dev-for-partners.md)
*   [FPMCU Firmware Testing for Partners](./fingerprint/fingerprint-firmware-testing-for-partners.md)
*   [FPMCU Debugging](./fingerprint/fingerprint-debugging.md)
*   [Fingerprint Authentication Design Doc](./fingerprint/fingerprint-authentication-design-doc.md)
*   [Fingerprint Factory Requirements](./fingerprint/fingerprint-factory-requirements.md)
*   [Fingerprint Quick Factory Guide](./fingerprint/fingerprint-factory-quick-guide.md)
*   [Dragonclaw Schematics and Layout](./schematics/dragonclaw)

## Testing

*   [Unit Tests](./unit_tests.md)
    *   [Porting EC unit tests to Ztest](./ztest.md)
*   [Code Coverage](./code_coverage.md)

## Updaters

*   [USB Updater](./usb_updater.md)

## USB

*   [USB-C Power Delivery and Alternate Modes](./usb-c.md)
*   [USB-A and USB-C Policies for Sourcing Power](./usb_power.md)
*   [USB-C Power Delivery TCPMv2](./usb-tcpmv2.md)

## Verified Boot

*   [Detachable Base Verified Boot](./detachable_base_verified_boot.md)

## EC-3PO

*   [EC-3PO overview](./ec-3po.md)
*   [EC-3PO design doc](./ec-3po-design.md)

## Zephyr

*   [Initialization Order](./zephyr_init.md)
*   [Proof-of-Concept-Device Bringup](./zephyr_poc_device_bringup.md)
*   [Shimming](./zephyr_shim.md)
*   [Porting EC unit tests to Ztest](./ztest.md)

## Miscellaneous

*   [Low Battery Startup](./low_battery_startup.md)
*   [I2C tracing via console commands](./i2c-debugging.md)
*   [Application Processor to EC communication](./ap-ec-comm.md)
*   [Code Reviews](./code_reviews.md)
*   [IDE Support](./ide-support.md)

[1]:https://chromium.googlesource.com/chromiumos/platform/ec/+/cr50_stab/docs/case_closed_debugging.md
[2]:https://chromium.googlesource.com/chromiumos/platform/ec/+/cr50_stab/docs/case_closed_debugging_cr50.md
[3]:https://chromium.googlesource.com/chromiumos/platform/ec/+/cr50_stab/docs/ccd_howtos.md
[4]:https://chromium.googlesource.com/chromiumos/platform/ec/+/cr50_stab/docs/cr50_vboot_troubleshooting.md
