/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: file.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    

#include "defs.h"
#include "file.h"
#include "edit.h"
#include "options.h"

int checkFileModified(char *open_file_name)
{
    int res = 0;
    if(FILE_STATE == MODIFIED)
    {
        int i = msgBox("File has been changed. Save changes?", YES|NO, INFO);
        if(i == YES)
        {
            if(NEW_FILE)
            {
                if(!openSaveFile(SAVE, YES, open_file_name))
                {
                    msgBox("Failed to save file.", OK, ERROR);
                }
                else res = 1;
            }
            else
            {
                if(!openSaveFile(SAVE, NO, open_file_name))
                {
                    msgBox("Failed to save file.", OK, ERROR);
                }
                else res = 1;
            }
        }
        else res = 1;
    } 
    else res = 1;
    return res;
}

/************************************
 * Function called when user selects
 * New from File Menu or presses
 * CTRL+N.
 * **********************************/
void fileMenu_New(char *open_file_name)
{
    if(FILE_STATE == NEW)
    {
        refreshView();
        return;
    }

    if(checkFileModified(open_file_name))
    {
        NEW_FILE = 1;
        FILE_STATE = NEW;
    }
    
    if(FILE_STATE == NEW)
    {
        initNewDocument();
        resetLineCounters();
    }
    BG_COLOR[COLOR_WINDOW] = old_window_color;
    refreshView();
}


/************************************
 * Function called when user selects
 * Open from File Menu or presses
 * CTRL+O.
 * **********************************/
void fileMenu_Open(char *open_file_name)
{
    if(checkFileModified(open_file_name))
    {
        FILE_STATE = SAVED;
    }
    
    if(!openSaveFile(OPEN, YES, open_file_name))
    {
        msgBox("Failed to open file.", OK, ERROR);
    }
    else
    {
        FILE_STATE = OPENED;
        NEW_FILE = 0;
        initEdit();
    }
    refreshView();
}

/************************************
 * Function called when user selects
 * Save from File Menu or presses
 * CTRL+S.
 * **********************************/
void fileMenu_Save(char *open_file_name)
{
    if(NEW_FILE)
    {
        //if new file is created on startup, save file with this name
        if(strcmp(documentTitle, DEFAULT_TITLE) == 0) 
        {
            if(!openSaveFile(SAVE, YES, open_file_name))
            {//show Save as.. dialog box
                msgBox("Failed to save file.", OK, ERROR);
            }
            else
            {
                FILE_STATE = SAVED;
            }
        }
        else
        {
            if(!openSaveFile(SAVE, NO, open_file_name))
            {//do not show dialog box
                msgBox("Failed to save file.", OK, ERROR);
            }
            else
            {
                FILE_STATE = SAVED;
            }
        }
    } 
    else
    { //do not show dialog box
        if(!openSaveFile(SAVE, NO, open_file_name))
        {
            msgBox("Failed to save file.", OK, ERROR);
        }
        else
        {
            FILE_STATE = SAVED;
        }
    }
    refreshView();
}

/************************************
 * Function called when user selects
 * Save As.. from File Menu.
 * **********************************/
void fileMenu_SaveAs(char *open_file_name)
{
    if(!openSaveFile(SAVE, YES, open_file_name))
    {
        msgBox("Failed to save file.", OK, ERROR);
    }
    else
    {
        FILE_STATE = SAVED;
    }
    refreshView();
}

void fileMenu_Print(char *open_file_name)
{
    msgBox("Oops! This function is not currently implemented!.", OK, INFO);
    refreshView();
}

void fileMenu_Exit(char *open_file_name)
{
    exit_gracefully(0, open_file_name);
}
