/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ReflectUtil {
    public static <T> T justInstantiate(Class<T> c) {
        try {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Cannot instantiate " + c));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)String.format("Cannot instantiate Message %s (illegal access)", c));
        }
        catch (NoSuchMethodException e) {
            if (c.isMemberClass()) {
                throw new AssertionError((Object)String.format("Can not instantiate non-static member class %s", c));
            }
            throw new AssertionError((Object)String.format("No suitable default constructor for class %s", c));
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)String.format("Exception thrown while constructing object of class %s", c));
        }
    }

    public static void justSetArray(Object arr, int i, long v) {
        Class<?> t = arr.getClass().getComponentType();
        if (t.equals(Long.TYPE)) {
            Array.setLong(arr, i, v);
        } else if (t.equals(Integer.TYPE)) {
            Array.setInt(arr, i, (int)v);
        } else if (t.equals(Short.TYPE)) {
            Array.setShort(arr, i, (short)v);
        } else if (t.equals(Byte.TYPE)) {
            Array.setByte(arr, i, (byte)v);
        } else if (t.equals(Character.TYPE)) {
            Array.setChar(arr, i, (char)v);
        }
    }

    public static long justGetArrayLong(Object arr, int i) {
        return Array.getLong(arr, i);
    }

    public static Object followFieldPath(List<Field> fl, Object obj, int depth) {
        for (int i = 0; i < depth; ++i) {
            try {
                obj = fl.get(i).get(obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)("cannot access field " + fl.get(i) + " of " + obj.getClass()));
            }
        }
        return obj;
    }

    public static Object followFieldPath(List<Field> fl, Object obj) {
        return ReflectUtil.followFieldPath(fl, obj, fl.size());
    }

    public static Object followFieldPathToParent(List<Field> fl, Object obj) {
        return ReflectUtil.followFieldPath(fl, obj, fl.size() - 1);
    }

    public static Object justGet(Object obj, Field f) {
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)String.format("Cannot access private field '%s' in class %s", f, obj.getClass()));
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)("Cannot access field '" + f.getName() + "' in class " + obj.getClass()));
        }
    }

    public static void justSet(Object obj, Field f, Object val) {
        try {
            f.set(obj, val);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)String.format("Cannot access private field %s in class %s", f, obj.getClass()));
        }
    }

    public static int justGetInt(Object obj, List<Field> path) {
        for (int i = 0; i < path.size() - 1; ++i) {
            try {
                obj = path.get(i).get(obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)("cannot access field " + path.get(i) + " of " + obj.getClass()));
            }
        }
        try {
            return path.get(path.size() - 1).getInt(obj);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("cannot access field " + path.get(path.size() - 1) + " of " + obj.getClass()));
        }
    }

    public static void justSetInt(Object obj, List<Field> path, int val) {
        for (int i = 0; i < path.size() - 1; ++i) {
            try {
                obj = path.get(i).get(obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)("cannot access field " + path.get(i) + " of " + obj.getClass()));
            }
        }
        try {
            path.get(path.size() - 1).setInt(obj, val);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("cannot access field " + path.get(path.size() - 1) + " of " + obj.getClass()));
        }
    }

    public static List<Field> getFieldPathFromString(String p, Class root) {
        Class<?> current = root;
        String[] components = p.split("[.]");
        ArrayList<Field> fp = new ArrayList<Field>(components.length);
        for (String member : components) {
            Field f;
            try {
                f = current.getField(member);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)("invalid field path, component " + member + " not found"));
            }
            fp.add(f);
            current = f.getType();
        }
        return fp;
    }

    public static class NumField {
        private final Field targetField;
        private final NumFieldType targetType;

        public NumFieldType getNumFieldType() {
            return this.targetType;
        }

        public NumField(Field f) {
            this.targetField = f;
            if (f.getType().equals(Long.TYPE)) {
                this.targetType = NumFieldType.LONG_PRIM;
            } else if (f.getType().equals(Integer.TYPE)) {
                this.targetType = NumFieldType.INT_PRIM;
            } else if (f.getType().equals(Short.TYPE)) {
                this.targetType = NumFieldType.SHORT_PRIM;
            } else if (f.getType().equals(Byte.TYPE)) {
                this.targetType = NumFieldType.BYTE_PRIM;
            } else if (f.getType().equals(Character.TYPE)) {
                this.targetType = NumFieldType.CHAR_PRIM;
            } else if (f.getType().equals(BigInteger.class)) {
                this.targetType = NumFieldType.BIGNUM;
            } else if (f.getType().equals(Boolean.TYPE)) {
                this.targetType = NumFieldType.BOOLEAN;
            } else {
                throw new AssertionError((Object)("expected numeric type, got: " + f.getType()));
            }
        }

        public void set(Object obj, long val) {
            try {
                switch (this.targetType) {
                    case LONG_PRIM: {
                        this.targetField.setLong(obj, val);
                        break;
                    }
                    case INT_PRIM: {
                        this.targetField.setInt(obj, (int)val);
                        break;
                    }
                    case SHORT_PRIM: {
                        this.targetField.setShort(obj, (short)val);
                        break;
                    }
                    case BYTE_PRIM: {
                        this.targetField.setByte(obj, (byte)val);
                        break;
                    }
                    case CHAR_PRIM: {
                        this.targetField.setChar(obj, (char)val);
                        break;
                    }
                    case BIGNUM: {
                        this.targetField.set(obj, BigInteger.valueOf(val));
                        break;
                    }
                    case BOOLEAN: {
                        this.targetField.setBoolean(obj, val != 0L);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)"cannot access field");
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"cannot access field");
            }
        }

        public void set(Object obj, BigInteger val) {
            try {
                this.targetField.set(obj, val);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"cannot access field");
            }
        }

        public long get(Object obj) {
            try {
                switch (this.targetType) {
                    case LONG_PRIM: {
                        return this.targetField.getLong(obj);
                    }
                    case INT_PRIM: {
                        return this.targetField.getInt(obj);
                    }
                    case SHORT_PRIM: {
                        return this.targetField.getShort(obj);
                    }
                    case BYTE_PRIM: {
                        return this.targetField.getByte(obj);
                    }
                    case CHAR_PRIM: {
                        return this.targetField.getChar(obj);
                    }
                    case BOOLEAN: {
                        return this.targetField.getBoolean(obj) ? 1L : 0L;
                    }
                    case BIGNUM: {
                        throw new RuntimeException("get() called on NumField that is a BigInteger (getBig() must be used instead)");
                    }
                }
                throw new AssertionError((Object)"unreachable");
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"cannot access field");
            }
        }

        public BigInteger getBig(Object obj) {
            if (this.isBig()) {
                return (BigInteger)ReflectUtil.justGet(obj, this.targetField);
            }
            return BigInteger.valueOf(this.get(obj));
        }

        public boolean isBig() {
            return this.targetType.equals((Object)NumFieldType.BIGNUM);
        }
    }

    public static enum NumFieldType {
        BIGNUM,
        BYTE_PRIM,
        SHORT_PRIM,
        INT_PRIM,
        LONG_PRIM,
        BOOLEAN,
        CHAR_PRIM;

    }
}

