/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.secretsharing;

import org.gnunet.secretsharing.SecretReadyCallback;
import org.gnunet.secretsharing.messages.GenerateMessage;
import org.gnunet.secretsharing.messages.SecretReadyMessage;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;

public class KeyGeneration {
    private Client client;
    private SecretReadyCallback secretReadyCallback;

    public KeyGeneration(Configuration configuration, PeerIdentity[] peers, HashCode sessionId, AbsoluteTime start, AbsoluteTime deadline, int threshold, SecretReadyCallback secretReadyCallback) {
        this.client = new Client("secretsharing", configuration);
        this.secretReadyCallback = secretReadyCallback;
        this.client.installReceiver(new KeyGenerationReceiver());
        GenerateMessage m = new GenerateMessage();
        m.start = start.asMessage();
        m.deadline = deadline.asMessage();
        m.threshold = threshold;
        m.numPeers = peers.length;
        m.peers = peers;
        m.sessionId = sessionId;
        this.client.send(m);
    }

    public void disconnect() {
        if (null != this.client) {
            this.client.disconnect();
            this.client = null;
        }
    }

    private class KeyGenerationReceiver
    extends RunaboutMessageReceiver {
        private KeyGenerationReceiver() {
        }

        public void visit(SecretReadyMessage m) {
            KeyGeneration.this.secretReadyCallback.onSecretReady(m.share);
            KeyGeneration.this.client.disconnect();
            KeyGeneration.this.client = null;
        }

        @Override
        public void handleError() {
            KeyGeneration.this.secretReadyCallback.onSecretReady(null);
        }
    }
}

