/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import org.gnunet.construct.Construct;
import org.gnunet.construct.Message;
import org.gnunet.construct.NestedMessage;
import org.gnunet.util.crypto.ContentWithPurposeMessage;
import org.gnunet.util.crypto.EcdsaPrivateKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.EcdsaSignature;
import org.gnunet.util.crypto.SignedContentMessage;

public class EcdsaSignedMessage<M extends SignedContentMessage>
implements Message {
    @NestedMessage
    public EcdsaSignature signature;
    @NestedMessage(newFrame=true)
    public ContentWithPurposeMessage<M> cpm;

    public EcdsaSignedMessage() {
    }

    public boolean verify(EcdsaPublicKey signerPublicKey, Class<? extends SignedContentMessage> expectedClass) {
        if (!expectedClass.isInstance(this.cpm.m)) {
            return false;
        }
        System.out.println("right class");
        byte[] data = Construct.toBinary(this.cpm);
        return this.signature.verifyRaw(data, signerPublicKey);
    }

    public EcdsaSignedMessage(M message, EcdsaPrivateKey privateKey, EcdsaPublicKey publicKey) {
        this.cpm = new ContentWithPurposeMessage();
        this.cpm.m = message;
        Construct.patch(this.cpm);
        byte[] data = Construct.toBinary(this.cpm);
        this.signature = privateKey.signRaw(publicKey, data);
    }

    public EcdsaSignedMessage(M message, EcdsaPrivateKey privateKey) {
        this(message, privateKey, privateKey.getPublicKey());
    }

    public M get() {
        return this.cpm.m;
    }
}

