/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.crypto.Ed25519;
import org.gnunet.util.crypto.EddsaPublicKey;
import org.gnunet.util.crypto.EddsaSignature;

public class EddsaPrivateKey
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] d;

    public EddsaSignature signRaw(byte[] m) {
        return this.signRaw(this.getPublicKey(), m);
    }

    public EddsaSignature signRaw(EddsaPublicKey publicKey, byte[] m) {
        MessageDigest sha512;
        if (!publicKey.asPoint().isOnCurve()) {
            throw new AssertionError();
        }
        try {
            sha512 = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm required but not provided");
        }
        byte[] h = sha512.digest(this.d);
        BigInteger a = BigInteger.valueOf(2L).pow(254);
        for (int i = 3; i < 254; ++i) {
            a = a.add(BigInteger.valueOf(2L).pow(i).multiply(BigInteger.valueOf(EddsaPrivateKey.bit(h, i))));
        }
        ByteBuffer rsub = ByteBuffer.allocate(32 + m.length);
        rsub.put(h, 32, 32).put(m);
        BigInteger r = Ed25519.Hint(rsub.array());
        Ed25519 R = Ed25519.B.scalarmult(r);
        byte[] encodedPublicKey = publicKey.asPoint().encode();
        ByteBuffer buf = ByteBuffer.allocate(32 + encodedPublicKey.length + m.length);
        buf.put(R.encode()).put(encodedPublicKey).put(m);
        BigInteger S = r.add(Ed25519.Hint(buf.array()).multiply(a)).mod(Ed25519.l);
        if (!R.isOnCurve()) {
            throw new AssertionError();
        }
        if (!publicKey.asPoint().isOnCurve()) {
            throw new AssertionError();
        }
        return new EddsaSignature(R, S);
    }

    private static int bit(byte[] h, int i) {
        return h[i / 8] >> i % 8 & 1;
    }

    private BigInteger computePublicKeyCoefficient() {
        MessageDigest sha512;
        try {
            sha512 = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm required but not provided");
        }
        byte[] h = sha512.digest(this.d);
        BigInteger a = BigInteger.valueOf(2L).pow(254);
        for (int i = 3; i < 254; ++i) {
            BigInteger apart = BigInteger.valueOf(2L).pow(i).multiply(BigInteger.valueOf(EddsaPrivateKey.bit(h, i)));
            a = a.add(apart);
        }
        return a;
    }

    public EddsaSignature sign(byte[] data, int purpose) {
        return this.sign(data, purpose, this.getPublicKey());
    }

    public EddsaSignature sign(byte[] data, int purpose, EddsaPublicKey publicKey) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length + 8);
        DataOutputStream dos = new DataOutputStream(os);
        try {
            dos.writeInt(data.length);
            dos.writeInt(purpose);
            dos.write(data);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.signRaw(publicKey, os.toByteArray());
    }

    public EddsaPublicKey getPublicKey() {
        BigInteger a = this.computePublicKeyCoefficient();
        Ed25519 A = Ed25519.B.scalarmult(a);
        return new EddsaPublicKey(A);
    }

    public static EddsaPrivateKey createRandom() {
        SecureRandom sr = new SecureRandom();
        EddsaPrivateKey privateKey = new EddsaPrivateKey();
        privateKey.d = new byte[32];
        sr.nextBytes(privateKey.d);
        return privateKey;
    }
}

