/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.vm.HasAtom;
import gnu.prolog.vm.TermConstants;

public final class Operator {
    public static final int MAX_PRIORITY = 1200;
    public static final int MIN_PRIORITY = 1;
    public static final Operator nonOperator = new Operator("", SPECIFIER.NONE, -1);
    public final String name;
    public final SPECIFIER specifier;
    public final int priority;
    public final CompoundTermTag tag;

    protected Operator(String name, SPECIFIER specifier, int priority) {
        this.name = name;
        this.specifier = specifier;
        this.priority = priority;
        switch (specifier) {
            case FX: 
            case FY: 
            case XF: 
            case YF: {
                this.tag = CompoundTermTag.get(name, 1);
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: {
                this.tag = CompoundTermTag.get(name, 2);
                break;
            }
            case NONE: {
                this.tag = null;
                break;
            }
            default: {
                this.tag = null;
                throw new IllegalArgumentException("invalid specifier = " + specifier);
            }
        }
    }

    public String toString() {
        return "Opearator[name='" + this.name + "';specifier='" + this.specifier + ";priority=" + this.priority + "]";
    }

    public static enum SPECIFIER implements HasAtom
    {
        FX{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.fxAtom;
            }
        }
        ,
        FY{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.fyAtom;
            }
        }
        ,
        XFX{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.xfxAtom;
            }
        }
        ,
        XFY{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.xfyAtom;
            }
        }
        ,
        YFX{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.yfxAtom;
            }
        }
        ,
        XF{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.xfAtom;
            }
        }
        ,
        YF{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.yfAtom;
            }
        }
        ,
        NONE{

            @Override
            public AtomTerm getAtom() {
                return null;
            }
        };


        @Override
        public abstract AtomTerm getAtom();

        public static SPECIFIER fromAtom(AtomTerm specifier) {
            if (specifier == TermConstants.fxAtom) {
                return FX;
            }
            if (specifier == TermConstants.fyAtom) {
                return FY;
            }
            if (specifier == TermConstants.xfxAtom) {
                return XFX;
            }
            if (specifier == TermConstants.xfyAtom) {
                return XFY;
            }
            if (specifier == TermConstants.yfxAtom) {
                return YFX;
            }
            if (specifier == TermConstants.xfAtom) {
                return XF;
            }
            if (specifier == TermConstants.yfAtom) {
                return YF;
            }
            return NONE;
        }
    }
}

