#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

import tmatrix
from wxPython.wx import *

# drawing primitives that are modified by the Current Transform Matrix (ctm)

class ctm(tmatrix.tmatrix):
    def __init__ (self, dc):
        tmatrix.tmatrix.__init__ (self)
        self.dc = dc

    def DrawLine (self, x1, y1, x2, y2):
        (x1_prime, y1_prime) = self.map_xy (x1, y1)
        (x2_prime, y2_prime) = self.map_xy (x2, y2)
        self.dc.DrawLine (x1_prime, y1_prime, x2_prime, y2_prime)

    def DrawLines (self, list_of_points):
        self.dc.DrawLines (self.map_point_list (list_of_points))

    def DrawPoint (self, x, y):
        (x_prime, y_prime) = self.map_xy (x, y)
        self.dc.DrawPoint (x_prime, y_prime)

    def DrawPolygon (self, list_of_points, xoffset=0, yoffset=0, fill_style=wxODDEVEN_RULE):
        (xp_off, yp_off) = self.map_xy (xoffset, yoffset)
        self.dc.DrawPolygon (self.map_point_list (list_of_points), xp_off, yp_off, fill_style)

    # The text routines only handle moving the origin.
    # The actual text drawn is not scaled or rotated as a fct of the ctm.
    # FIXME I guess the rotation portion of the ctm could be handled by
    # always using the DrawRotatedText dc method...

    def DrawText (self, text, x, y):
        (xp, yp) = sefl.map_xy (x, y)
        self.dc.DrawText (text, xp, yp)

    def DrawRotatedText (self, text, x, y, angle):
        (xp, yp) = sefl.map_xy (x, y)
        # FIXME compute rotated angle by mapping (1,0), using atan2
        # to determine the rotation of the ctm,  then adding the user specified angle
        anglep = angle
        self.dc.DrawRotatedText (text, xp, yp, anglep)

