/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _QA_FLOAT_DOTPROD_X86_H_
#define _QA_FLOAT_DOTPROD_X86_H_

#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TextTestResult.h>

class qa_float_dotprod_x86 : public CppUnit::TestCase {

 public:

  static void register_tests (CppUnit::TestSuite *suite)
  {
    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t1_3dnow", &qa_float_dotprod_x86::t1_3dnow));
    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t2_3dnow", &qa_float_dotprod_x86::t2_3dnow));
    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t3_3dnow", &qa_float_dotprod_x86::t3_3dnow));

    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t1_sse", &qa_float_dotprod_x86::t1_sse));
    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t2_sse", &qa_float_dotprod_x86::t2_sse));
    suite->addTest (new CppUnit::TestCaller<qa_float_dotprod_x86>
		    ("float_dotprod_x86: t3_sse", &qa_float_dotprod_x86::t3_sse));
  }

  void setUp            ();
  void tearDown         ();

 private:

  typedef float (*float_dotprod_t)(const float *input,
				   const float *taps,
				   unsigned n_4_float_blocks);

  void t1_base (float_dotprod_t);
  void t2_base (float_dotprod_t);
  void t3_base (float_dotprod_t);

  void t1_3dnow ();
  void t2_3dnow ();
  void t3_3dnow ();
  void t1_sse ();
  void t2_sse ();
  void t3_sse ();
  
  void zb ();

  float	*taps;		// 16-byte aligned
  float *input;		// 16-byte aligned

};


#endif /* _QA_FLOAT_DOTPROD_X86_H_ */
