/* -*- c++ -*- */
/*
 * Copyright 2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gr_message.h>
#include <assert.h>

static long s_ncurrently_allocated = 0;

gr_message_sptr
gr_make_message (long type, double arg1, double arg2, size_t length)
{
  return gr_message_sptr (new gr_message (type, arg1, arg2, length));
}

gr_message::gr_message (long type, double arg1, double arg2, size_t length)
  : d_type(type), d_arg1(arg1), d_arg2(arg2)
{
  if (length == 0)
    d_head = d_data = d_tail = d_end = 0;
  else {
    d_head = new unsigned char [length];
    d_data = d_head;
    d_tail = d_end = d_head + length;
  }
  s_ncurrently_allocated++;
}

gr_message::~gr_message ()
{
  assert (d_next == 0);
  delete [] d_head;
  d_head = d_data = d_tail = d_end = 0;
  s_ncurrently_allocated--;
}

void
gr_message::pull (size_t nb)
{
  size_t n = std::min (nb, length ());
  d_data += n;
}

void
gr_message::take (size_t nb)
{
  size_t n = std::min (nb, length ());
  d_tail -= n;
}

long
gr_message_ncurrently_allocated ()
{
  return s_ncurrently_allocated;
}
