#!/usr/bin/env python
#
# Gang - Here's a simple script that demonstrates spectrum inversion
# using the multiply by [1,-1] method (mixing with Nyquist frequency).
# Requires nothing but a sound card, and sounds just like listening
# to a SSB signal on the wrong sideband.
#

from gnuradio import gr
from gnuradio import audio

def build_graph ():

	fg = gr.flow_graph ()
	sample_rate = 8000

	src = audio.source (sample_rate)
	out = audio.sink (sample_rate)

	vec1 = [1, -1]
	vsource = gr.vector_source_f (vec1, 1)
	multiply = gr.multiply_ff ()

	fg.connect (src, (multiply, 0))
	fg.connect (vsource, (multiply, 1))
	fg.connect (multiply, out)

	return fg

def main ():
	fg = build_graph()
	fg.start ()
	raw_input ('Press Enter to quit: ')
	fg.stop()

if __name__ == '__main__':
	main ()
