#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr
from gnuradio import audio
from optparse import OptionParser

def build_graph (input_device, output_device):
    sampling_freq = 48000

    fg = gr.flow_graph ()
    src = audio.source (sampling_freq, input_device)
    dst = audio.sink (sampling_freq, output_device)

    # Determine the maximum number of outputs on the source and
    # maximum number of inputs on the sink, then connect together
    # the most channels we can without overlap
    nchan = min (src.output_signature().max_streams(),
                 dst.input_signature().max_streams())

    for i in range (nchan):
        fg.connect ((src, i), (dst, i))

    return fg

if __name__ == '__main__':
    parser = OptionParser ()
    parser.add_option ("-i", "--input-device", type="string", default="hw:0,0",
                        help="pcm input device name.  E.g., hw:0,0")
    parser.add_option ("-o", "--output-device", type="string", default="hw:0,0",
                        help="pcm output device name.  E.g., hw:0,0")
    (options, args) = parser.parse_args ()

    fg = build_graph (options.input_device, options.output_device)

    fg.start ()
    raw_input ('Press Enter to quit: ')
    fg.stop ()
