#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr
from gnuradio import usrp
from gnuradio.eng_option import eng_option
from gnuradio.wxgui import stdgui, fftsink, scopesink
from optparse import OptionParser
import wx

# FPGA register numbers...

FR_ADC_OFFSET_3_2 = 2	# hi 16: ADC3, lo 16: ADC2
FR_ADC_OFFSET_1_0 = 3


class app_flow_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        
        parser = OptionParser (option_class=eng_option)
        parser.add_option ("-d", "--decim", type="int", default=16,
                           help="set fgpa decimation rate to DECIM")
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=0,
                           help="set Rx cordic frequency to FREQ", metavar="FREQ")
        parser.add_option ("-m", "--mux", type="intx", default=0x32103210,
                           help="set fpga FR_RX_MUX register to MUX")
        parser.add_option ("-0", "--adc-offset-0", type="int", default=0,
                           help="set adc offset to OFFSET", metavar="OFFSET")
        parser.add_option ("-1", "--adc-offset-1", type="int", default=0,
                           help="set adc offset to OFFSET", metavar="OFFSET")
        parser.add_option ("-2", "--adc-offset-2", type="int", default=0,
                           help="set adc offset to OFFSET", metavar="OFFSET")
        parser.add_option ("-3", "--adc-offset-3", type="int", default=0,
                           help="set adc offset to OFFSET", metavar="OFFSET")
        (options, args) = parser.parse_args ()

        u = usrp.source_c (0, options.decim, 1, options.mux, 0)
        u.set_rx_freq (0, options.cordic_freq)

        u._write_fpga_reg (FR_ADC_OFFSET_1_0,
                           ((options.adc_offset_1 & 0xffff) << 16) | (options.adc_offset_0 & 0xffff))
        u._write_fpga_reg (FR_ADC_OFFSET_3_2,
                           ((options.adc_offset_3 & 0xffff) << 16) | (options.adc_offset_2 & 0xffff))

        input_rate = u.adc_freq () / u.decim_rate ()

        c2f = gr.complex_to_float ()

        sink, fft_win = scopesink.make_scope_sink_f (self, panel, "Rx Data", input_rate)
        vbox.Add (fft_win, 1, wx.EXPAND)

        self.connect (u, c2f)
        self.connect ((c2f, 0), (sink, 0))
        self.connect ((c2f, 1), (sink, 1))
        


def main ():
    app = stdgui.stdapp (app_flow_graph, "USRP O'scope")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
