/*
 * USRP - Universal Software Radio Peripheral
 *
 * Copyright (C) 2003 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * These are the register definitions for the Rev 0 USRP prototype
 */

#ifndef _USRP_REV0_REGS_H_
#define _USRP_REV0_REGS_H_

#include "fx2regs.h"

/*
 * Port A (bit addressable):
 *   FPGA Control Bus.
 *   Requires cable connecting SV406 to SV407
 */

#define	USRP_FPGA_CTRL_BUS	IOA 		// PORT_A
#define	USRP_FPGA_CTRL_BUS_OE	OEA

#define bmFCB_S_CLK		bmBIT0		// serial clock
#define	bmFCB_S_DATA_TO_FPGA	bmBIT1		// serial data to FPGA
#define	bmFCB_CLR_STATUS	bmBIT2		// reset the overrun and underrun flags
#define	bmFCB_S_ENABLE		bmBIT3		// serial enable (unneeded)
#define bmFCB_S_LOAD		bmBIT4		// serial data load
#define bmFCB_RESET		bmBIT5		// reset everything
#define	bmFCB_ENABLE_TX		bmBIT6		// enable fifo --> D/A
#define	bmFCB_ENABLE_RX		bmBIT7		// enable fifo <-- A/D

/* all outputs except */

#define	bmFCB_OUTPUTS  (bmFCB_S_CLK		\
			| bmFCB_S_DATA_TO_FPGA 	\
			| bmFCB_CLR_STATUS	\
			| bmFCB_S_ENABLE	\
                        | bmFCB_S_LOAD		\
			| bmFCB_RESET		\
			| bmFCB_ENABLE_RX	\
			| bmFCB_ENABLE_TX)

#define	bmFCB_INITIAL (bmFCB_RESET)

#define	bmPORT_A_OUTPUTS	bmFCB_OUTPUTS
#define	bmPORT_A_INITIAL	bmFCB_INITIAL

/* Port B: GPIF	FD[7:0]			*/

/*
 * Port C (bit addressable):
 *    5:1 FPGA configuration
 */

#define	USRP_ALTERA_CONFIG	IOC		/* PORT_C			*/
#define	USRP_ALTERA_CONFIG_OE	OEC

#define	bmALTERA_MUST_BE_ZERO	bmBIT0
#define bmALTERA_DATA0		bmBIT1
#define bmALTERA_NCONFIG	bmBIT2
#define bmALTERA_DCLK		bmBIT3
#define bmALTERA_CONF_DONE	bmBIT4
#define bmALTERA_NSTATUS	bmBIT5
#define	bmALTERA_unused6	bmBIT6
#define	bmALTERA_unused7	bmBIT7

sbit at 0xA0+1 bitALTERA_DATA0;		// 0xA0 is the bit address of PORT C
sbit at 0xA0+3 bitALTERA_DCLK;

#define	bmALTERA_OUTPUTS	(bmALTERA_MUST_BE_ZERO		\
				 | bmALTERA_DATA0 		\
				 | bmALTERA_NCONFIG		\
				 | bmALTERA_DCLK)

#define	bmALTERA_INITIAL	0

#define	bmALTERA_BITS	(bmALTERA_MUST_BE_ZERO		\
			 | bmALTERA_DATA0		\
			 | bmALTERA_NCONFIG		\
			 | bmALTERA_DCLK		\
			 | bmALTERA_CONF_DONE		\
			 | bmALTERA_NSTATUS)

#define bmPORT_C_OUTPUTS	bmALTERA_OUTPUTS
#define bmPORT_C_INITIAL	bmALTERA_INITIAL


/* Port D: GPIF	FD[15:8]		*/

/* Port E: MISC (SV411)			*/

#define	USRP_MISC		IOE		/* PORT_E			*/
#define	USRP_MISC_OE		OEE

#define	bmMISC_SLEEP_ADC0	bmBIT0
#define	bmMISC_SLEEP_ADC1	bmBIT1
#define	bmMISC_SLEEP_DAC0	bmBIT2
#define bmMISC_SLEEP_DAC1	bmBIT3
#define	bmMISC_LED0		bmBIT4
#define	bmMISC_LED1		bmBIT5
#define	bmMISC_unused6		bmBIT6
#define	bmMISC_unused7		bmBIT7

#define	bmMISC_OUTPUTS 		(bmMISC_SLEEP_ADC0 | bmMISC_SLEEP_ADC1 		\
				 | bmMISC_SLEEP_DAC0 | bmMISC_SLEEP_DAC1 	\
				 | bmMISC_LED0       | bmMISC_LED1)

#define	bmMISC_INITIAL	(bmMISC_SLEEP_ADC0 | bmMISC_SLEEP_ADC1			\
		         | bmMISC_SLEEP_DAC0 | bmMISC_SLEEP_DAC1)

#define	bmPORT_E_OUTPUTS	bmMISC_OUTPUTS
#define	bmPORT_E_INITIAL	bmMISC_INITIAL


#define	USRP_LED_REG		USRP_MISC	
#define	bmLED0			bmMISC_LED0
#define	bmLED1			bmMISC_LED1

/*
 * FPGA output lines that are tied to FX2 RDYx inputs.
 * These are readable using GPIFREADYSTAT.
 */
#define	bmFPGA_HAS_SPACE		bmBIT0	// usbrdy[0] has room for 512 byte packet
#define	bmFPGA_PKT_AVAIL		bmBIT1	// usbrdy[1] has >= 512 bytes available
#define	bmTX_UNDERRUN			bmBIT2  // usbrdy[2] D/A ran out of data
#define	bmRX_OVERRUN			bmBIT3	// usbrdy[3] A/D ran out of buffer

/*
 * FPGA input lines that are tied to the FX2 CTLx outputs.
 *
 * These are controlled by the GPIF microprogram...
 */
// WR					bmBIT0	// usbctl[0]
// RD					bmBIT1	// usbctl[1]
// OE					bmBIT2	// usbctl[2]

#endif /* _USRP_REV0_REGS_H_ */
