/*
 * USRP - Universal Software Radio Peripheral
 *
 * Copyright (C) 2003 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "usrp_common.h"

// These are the tables generated by the Cypress GPIF Designer

extern const char WaveData[128];
extern const char FlowStates[36];
extern const char InitData[7];

// The tool is kind of screwed up, in that it doesn't configure some
// of the ports correctly.  We just use their tables and handle the
// initialization ourselves.  They also declare that their static
// initialized data is in xdata, which screws us too.

void
init_gpif (void)
{
  // we've already setup IFCONFIG before calling this...

  GPIFABORT = 0xFF;  // abort any waveforms pending
  SYNCDELAY;
 
  GPIFREADYCFG = InitData[ 0 ];
  GPIFCTLCFG = InitData[ 1 ];
  GPIFIDLECS = InitData[ 2 ];
  GPIFIDLECTL = InitData[ 3 ];
  // Hmmm, what's InitData[ 4 ] ...
  GPIFWFSELECT = InitData[ 5 ];
  // GPIFREADYSTAT = InitData[ 6 ];	// I think this register is read only...
 
  {
    BYTE i;
    
    for (i = 0; i < 128; i++){
      GPIF_WAVE_DATA[i] = WaveData[i];
    }
  }
 
  FLOWSTATE = 0;		/* ensure it's off */
}
