/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.MacRefEnv;
import com.netscape.javascript.qa.drivers.RefEnv;
import com.netscape.javascript.qa.drivers.TestDriver;
import com.netscape.javascript.qa.drivers.TestEnvironment;
import com.netscape.javascript.qa.drivers.TestFile;
import com.netscape.javascript.qa.drivers.TestSuite;
import java.io.File;

public class RefDrv
extends TestDriver {
    String SUFFIX = ".js";
    boolean CODE_COVERAGE = false;
    String HELPER_STRING;

    public RefDrv(String[] stringArray) {
        super(stringArray);
        this.setSuffix(".js");
    }

    public synchronized void executeSuite(TestSuite testSuite) {
        TestDriver.p("executing suite");
        try {
            int n = 0;
            while (n < testSuite.size()) {
                TestEnvironment testEnvironment;
                TestFile testFile;
                TestSuite testSuite2 = testSuite;
                synchronized (testSuite2) {
                    testFile = (TestFile)testSuite.elementAt(n);
                    if (TestDriver.getSystemInformation()[0].startsWith("Mac")) {
                        testEnvironment = new MacRefEnv(testFile, testSuite, this);
                        ((MacRefEnv)testEnvironment).runTest();
                    } else {
                        testEnvironment = new RefEnv(testFile, testSuite, this);
                        ((RefEnv)testEnvironment).runTest();
                    }
                }
                TestDriver.writeFileResult(testFile, testSuite, this.OUTPUT_DIRECTORY);
                TestDriver.writeCaseResults(testFile, testSuite, this.OUTPUT_DIRECTORY);
                testEnvironment.close();
                testEnvironment = null;
                if (!testFile.passed) {
                    testSuite.passed = false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestDriver.writeSuiteResult(testSuite, this.OUTPUT_DIRECTORY);
        TestDriver.writeSuiteSummary(testSuite, this.OUTPUT_DIRECTORY);
    }

    public static void main(String[] stringArray) {
        RefDrv refDrv = new RefDrv(stringArray);
        refDrv.start();
    }

    public boolean processOptions() {
        int n = this.ARGS.length;
        if (this.ARGS[0].startsWith("-")) {
            int n2 = 0;
            while (n2 < this.ARGS.length) {
                if (this.ARGS[n2].equals("-d")) {
                    File file;
                    TestDriver.p("-d ");
                    if (this.ARGS[n2].endsWith(File.separator)) {
                        File file2 = new File(this.ARGS[++n2]);
                        file = file2;
                    } else {
                        File file3 = new File(String.valueOf(this.ARGS[++n2]) + File.separator);
                        file = file3;
                    }
                    this.TEST_DIRECTORY = file;
                    TestDriver.p("-d " + this.TEST_DIRECTORY);
                    if (!this.TEST_DIRECTORY.isDirectory()) {
                        TestDriver.p("error:  " + this.TEST_DIRECTORY.getAbsolutePath() + " is not a TEST_DIRECTORY.");
                        return false;
                    }
                } else {
                    if (this.ARGS[n2].equals("-s")) {
                        TestDriver.p("-s ");
                        this.FILES = new String[20];
                        int n3 = ++n2;
                        int n4 = 0;
                        while (n3 < this.ARGS.length) {
                            if (this.ARGS[n3].startsWith("-")) break;
                            this.FILES[n4++] = this.ARGS[n3];
                            ++n3;
                        }
                    }
                    if (this.ARGS[n2].equals("-h")) {
                        TestDriver.p("-h");
                        this.HELPER_STRING = new String(this.ARGS[++n2]);
                        this.HELPER_FUNCTIONS = new File(this.HELPER_STRING);
                        if (!this.HELPER_FUNCTIONS.isFile()) {
                            TestDriver.p("error:  " + this.HELPER_FUNCTIONS.getAbsolutePath() + " file not found.");
                            return false;
                        }
                        TestDriver.p("-h " + this.HELPER_FUNCTIONS);
                    }
                    if (this.ARGS[n2].equals("-c")) {
                        TestDriver.p("-c");
                        this.CODE_COVERAGE = new Boolean(this.ARGS[++n2]);
                    }
                    if (this.ARGS[n2].equals("-o")) {
                        TestDriver.p("-o");
                        this.OUTPUT_DIRECTORY = new File(String.valueOf(this.ARGS[++n2]) + File.separator);
                        if (!this.OUTPUT_DIRECTORY.exists() || !this.OUTPUT_DIRECTORY.isDirectory()) {
                            TestDriver.p("error:  " + this.OUTPUT_DIRECTORY.getAbsolutePath() + " is not a directory.");
                            return false;
                        }
                    }
                    if (this.ARGS[n2].equals("-p")) {
                        this.OPT_LEVEL = Integer.parseInt(this.ARGS[++n2]);
                    }
                    if (this.ARGS[n2].equals("-db")) {
                        this.DEBUG_LEVEL = Integer.parseInt(this.ARGS[++n2]);
                        this.OPT_LEVEL = 0;
                    }
                    if (this.ARGS[n2].equals("-e")) {
                        this.EXECUTABLE = this.ARGS[++n2];
                    }
                    if (this.ARGS[n2].equals("-t")) {
                        String string;
                        TestDriver.TINDERBOX = (string = this.ARGS[++n2]).equals("true") || string.equals("1");
                    }
                }
                ++n2;
            }
            return true;
        }
        switch (this.ARGS.length) {
            case 0: {
                TestDriver.p("error:  specify location of JavaScript tests");
                return false;
            }
            case 1: {
                TestDriver.p("error:  specify location of JavaScript HELPER_FUNCTIONS file");
                return false;
            }
            case 2: {
                this.TEST_DIRECTORY = this.ARGS[0].endsWith(File.separator) ? new File(this.ARGS[0]) : new File(String.valueOf(this.ARGS[0]) + File.separator);
                this.HELPER_FUNCTIONS = new File(this.ARGS[1]);
                if (!this.TEST_DIRECTORY.isDirectory()) {
                    TestDriver.p("error:  " + this.TEST_DIRECTORY.getAbsolutePath() + " is not a directory.");
                    return false;
                }
                if (!this.HELPER_FUNCTIONS.isFile()) {
                    TestDriver.p("error:  " + this.HELPER_FUNCTIONS.getAbsolutePath() + " file not found.");
                    return false;
                }
                return true;
            }
        }
        TestDriver.p("could not understand arguments.");
        return false;
    }
}

