/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * vim: sw=2 ts=8 et :
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Firefox.
 *
 * The Initial Developer of the Original Code is
 * the Mozilla Foundation <http://www.mozilla.org>.
 *
 * Portions created by the Initial Developer are Copyright (C) 2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef mozilla_plugins_ChildTimer_h
#define mozilla_plugins_ChildTimer_h

#include "PluginMessageUtils.h"
#include "npapi.h"
#include "base/timer.h"

namespace mozilla {
namespace plugins {

class PluginInstanceChild;
typedef void (*TimerFunc)(NPP npp, uint32_t timerID);

class ChildTimer
{
public:
  /**
   * If initialization failed, ID() will return 0.
   */
  ChildTimer(PluginInstanceChild* instance,
             uint32_t interval,
             bool repeat,
             TimerFunc func);
  ~ChildTimer() { }

  uint32_t ID() const { return mID; }

  class IDComparator
  {
  public:
    bool Equals(ChildTimer* t, uint32_t id) const {
      return t->ID() == id;
    }
  };

private:
  PluginInstanceChild* mInstance;
  TimerFunc mFunc;
  bool mRepeating;
  uint32_t mID;
  base::RepeatingTimer<ChildTimer> mTimer;

  void Run();

  static uint32_t gNextTimerID;
};

} // namespace plugins
} // namespace mozilla

#endif // mozilla_plugins_ChildTimer_h
