/*
 * This file is part of SpyBlock <http://www.gnu.org/software/gnuzilla/>,
 * Copyright (C) 2006-2014 Eyeo GmbH (Adblock Plus) 
 * Copyright (C) 2015 Ruben Rodriguez <ruben@gnu.org>
 *
 * SpyBlock is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * SpyBlock is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SpyBlock.  If not, see <http://www.gnu.org/licenses/>.
 */

Cu.import("resource://gre/modules/Services.jsm");

let {Utils} = require("utils");
let {Prefs} = require("prefs");
let {ActiveFilter} = require("filterClasses");
let {FilterStorage} = require("filterStorage");
let {FilterNotifier} = require("filterNotifier");
let {Subscription} = require("subscriptionClasses");
let {Notification} = require("notification");

exports.initAntiSpyBlockNotification = function initAntiSpyBlockNotification()
{
  let notification = {
    id: "antiadblock",
    type: "question",
    title: Utils.getString("notification_antiadblock_title"),
    message: Utils.getString("notification_antiadblock_message"),
    urlFilters: []
  };

  function notificationListener(approved)
  {
    let subscription = Subscription.fromURL(Prefs.subscriptions_antiadblockurl);
    if (subscription.url in FilterStorage.knownSubscriptions)
      subscription.disabled = !approved;
  }

  function addAntiSpyBlockNotification(subscription)
  {
    let urlFilters = [];
    for (let filter of subscription.filters)
      if (filter instanceof ActiveFilter)
        for (let domain in filter.domains)
          if (domain && urlFilters.indexOf(domain) == -1)
            urlFilters.push(domain);
    notification.urlFilters = urlFilters;
    Notification.addNotification(notification);
    Notification.addQuestionListener(notification.id, notificationListener);
  }

  function removeAntiSpyBlockNotification()
  {
    Notification.removeNotification(notification);
    Notification.removeQuestionListener(notification.id, notificationListener);
  }

  let subscription = Subscription.fromURL(Prefs.subscriptions_antiadblockurl);
  if (subscription.lastDownload && subscription.disabled)
    addAntiSpyBlockNotification(subscription);

  FilterNotifier.addListener(function(action, value, newItem, oldItem)
  {
    if (!/^subscription\.(updated|removed|disabled)$/.test(action) || value.url != Prefs.subscriptions_antiadblockurl)
      return;

    if (action == "subscription.updated")
      addAntiSpyBlockNotification(value);
    else if (action == "subscription.removed" || (action == "subscription.disabled" && !value.disabled))
      removeAntiSpyBlockNotification();
  });
}
