/* Copyright (C) 2022-2025 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.overview;

import static org.gprofng.mpmt.overview.CheckBoxBarPanel.getCheckboxFixedPosition;

import org.gprofng.mpmt.metrics.MetricNode;
import org.gprofng.mpmt.util.gui.AnUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;

public class BarPanel extends javax.swing.JPanel {
  private final MetricNode metricNode;
  private Insets insets = null;
  private String toolTipText;

  public BarPanel(
      final MetricNode metricNode,
      boolean isSelected,
      boolean hot,
      String text,
      String toolTipText,
      Bar bar,
      int maxLength,
      Color keyColor,
      int treeLevel,
      int nodeLevel) {
    //        System.out.println("BarPanel " + text);
    this.metricNode = metricNode;
    this.toolTipText = toolTipText;
    initComponents();

    setOpaque(false);
    setOpaque(false);
    setLayout(new GridBagLayout());

    JLabel label = new JLabel(text);
    AnUtility.setAccessibleContext(label.getAccessibleContext(), label.getText());
    label.setFont(Overview.defaultPlainFont);
    label.setOpaque(false);
    setLayout(new GridBagLayout());
    GridBagConstraints gridBagConstraints = new GridBagConstraints();
    int x = 0;
    gridBagConstraints.gridy = 0;

    if (keyColor != null) {
      Component colorKeyComponent = new BarColorKey(keyColor);
      gridBagConstraints.gridx = x++;
      gridBagConstraints.insets = new Insets(0, 0, 0, 4);
      add(colorKeyComponent, gridBagConstraints);
    } else {
      maxLength += BarColorKey.barWidth + 4; // make up for not painting color key
    }

    gridBagConstraints.gridx = x++;
    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
    add(label, gridBagConstraints);

    int labelLength = getCheckboxFixedPosition() + 14;
    if (treeLevel >= 1) {
      labelLength -= 14;
      labelLength -= treeLevel * 20;
    }
    if (nodeLevel >= 3) {
      labelLength -= (nodeLevel - 2) * 14;
    }
    if (bar != null) {
      labelLength -= Bar.barWidth;
    }
    if (keyColor != null) {
      labelLength -= (BarColorKey.barWidth + 4);
    }

    int w = label.getPreferredSize().width;
    Dimension dim = new Dimension(labelLength - w, 20);
    Box.Filler filler = new Box.Filler(dim, dim, dim);
    gridBagConstraints.gridx = x++;
    add(filler, gridBagConstraints);

    setToolTip();
    if (bar != null && bar.getValue() >= 0) {
      gridBagConstraints.gridx = x++;
      add(bar, gridBagConstraints);
    }
  }

  private void setToolTip() {
    if (toolTipText != null) {
      StringBuilder txt = new StringBuilder();
      txt.append(toolTipText);
      setToolTipText(txt.toString());
    }
  }

  @Override
  public Insets getInsets() {
    if (insets != null) {
      return insets;
    } else {
      return super.getInsets();
    }
  }

  public void setInsets(Insets insets) {
    this.insets = insets;
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    setLayout(new java.awt.GridBagLayout());
  } // </editor-fold>//GEN-END:initComponents
  // Variables declaration - do not modify//GEN-BEGIN:variables
  // End of variables declaration//GEN-END:variables
}
