.\"	$NetBSD: mdoc.7,v 1.14 1999/08/30 00:41:28 ross Exp $
.\"
.\" Copyright (c) 1991, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	@(#)mdoc.7	8.2 (Berkeley) 12/30/93
.\"
.Dd November 24, 1997
.Os
.Dt MDOC 7
.Sh NAME
.Nm mdoc
.Nd quick reference guide for the
.Nm \-mdoc
macro package
.Sh SYNOPSIS
.Nm groff
.Fl m Ns Ar doc
.Ar files ...
.Sh DESCRIPTION
The
.Nm \-mdoc
package is a set of content-based and domain-based macros
used to format the
.Bx
man pages.
The macro names and their meanings are
listed below for quick reference; for
a detailed explanation on using the package,
see the tutorial sampler
.Xr mdoc.samples 7 .
.Pp
The macros are described in two groups, the first
includes the structural and physical page layout macros.
The second contains the manual and general text domain
macros which differentiate the
.Nm -\mdoc
package from other
.Xr troff
formatting packages.
.Sh PAGE STRUCTURE DOMAIN
.Ss Title Macros
To create a valid manual page, these three macros, in this order,
are required:
.Bl -tag -width "xxxx.Os OPERATINGxSYSTEM [version/release]" -compact
.It Li "\&.Dd  " Ar "Month day, year"
Document date.
.It Li "\&.Dt  " Ar "DOCUMENT_TITLE [section] [volume]"
Title, in upper case.
.It Li "\&.Os  " Ar "OPERATING_SYSTEM [version/release]"
Operating system
.Pq Tn BSD .
.El
.Ss Page Layout Macros
Section headers, paragraph breaks, lists and displays.
.Bl -tag -width flag -compact
.It Li \&.Sh
Section Headers.
Valid headers, in the order of presentation:
.Bl -tag -width "RETURN VALUES" -compact
.It Ar NAME
Name section, should include the
.Ql \&.Nm
or
.Ql \&.Fn
and the
.Ql \&.Nd
macros.
.It Ar SYNOPSIS
Usage.
.It Ar DESCRIPTION
General description, should include
options and parameters.
.It Ar RETURN VALUES
Sections two and three function calls.
.It Ar ENVIRONMENT
Describe environment variables.
.It Ar FILES
Files associated with the subject.
.It Ar EXAMPLES
Examples and suggestions.
.It Ar DIAGNOSTICS
Normally used for section four device interface diagnostics.
.It Ar ERRORS
Sections two and three error and signal
handling.
.It Ar SEE ALSO
Cross references and citations.
.It Ar STANDARDS
Conformance to standards if applicable.
.It Ar HISTORY
If a standard is not applicable, the history
of the subject should be given.
.It Ar BUGS
Gotchas and caveats.
.It Ar SECURITY CONSIDERATIONS
Security issues to be aware of.
.It Ar other
Customized headers may be added at
the authors discretion.
.El
.It Li \&.Ss
Subsection Headers.
.It Li \&.Pp
Paragraph Break.
Vertical space (one line).
.It Li \&.D1
(D-one) Display-one
Indent and display one text line.
.It Li \&.Dl
(D-ell) Display-one literal.
Indent and display one line of literal text.
.It Li \&.Bd
Begin-display block.
Display options:
.Bl -tag -width "xoffset string " -compact
.It Fl ragged
Unjustified (ragged edges).
.It Fl filled
Filled, and if
.Xr troff 1 ,
also justified.
.It Fl unfilled
Unfilled, unjustified.
.It Fl literal
Literal text or code.
.It Fl file Ar name
Read in named
.Ar file
and display.
.It Fl offset Ar string
Offset display.
Acceptable
.Ar string
values:
.Bl -tag -width indent-two -compact
.It Ar left
Align block on left (default).
.It Ar center
Approximate center margin.
.It Ar indent
Six constant width spaces (a tab).
.It Ar indent-two
Two tabs.
.It Ar right
Left aligns block 2 inches from
right.
.It Ar xx Ns Cm n
Where
.Ar xx
is a number from
.No \&4 Ns Cm n
to
.No \&9\&9 Ns Cm n .
.It Ar Aa
Where
.Ar Aa
is a callable macro name.
.It Ar string
The width of
.Ar string
is used.
.El
.El
.It Li \&.Ed
End-display (matches \&.Bd).
.It Li \&.Bl
Begin-list.
Create lists or columns. Options:
.Bl -tag -width flag -compact
.It Em List-types
.Bl -column "xbullet " -compact
.It Fl bullet Ta "Bullet Item List"
.It Fl dash Ta "Dash Item List"
.It Fl hyphen Ta "(as per" Fl dash ")"
.It Fl item Ta "Unlabeled List"
.It Fl enum Ta "Enumerated List"
.It Fl tag Ta "Tag Labeled List"
.It Fl diag Ta "Diagnostic List"
.It Fl hang Ta "Hanging Labeled List"
.It Fl ohang Ta "Overhanging Labeled List"
.It Fl inset Ta "Inset or Run-on Labeled List"
.It Fl column Ta "Multiple Columns"
.El
.It Em List-parameters
.Bl -tag -width "xcompact " -compact
.It Fl offset
(All lists.) See
.Ql \&.Bd
begin-display above.
.It Fl width
.Pf ( Fl tag
and
.Fl hang
lists only.)
See
.Ql \&.Bd .
This parameter is effectively required for
.Fl tag
lists.
.It Fl compact
(All lists.)
Suppresses blank lines.
.El
.El
.It Li \&.El
End-list.
.It Li \&.It
List item.
.El
.Sh MANUAL AND GENERAL TEXT DOMAIN MACROS
The manual and general text domain macros are special in that
most of them are parsed for callable macros
for example:
.Bl -tag -width ".Op Fl s Ar filex" -offset indent
.It Li "\&.Op Fl s Ar file"
Produces
.Op Fl s Ar file
.El
.Pp
In this example, the option enclosure macro
.Ql \&.Op
is parsed, and calls the callable content macro
.Ql \&Fl
which operates on the argument
.Ql s
and then calls the callable content macro
.Ql \&Ar
which operates on the argument
.Ql file .
Some macros may be callable, but are not parsed and vice versa.
These macros are indicated in the
.Em parsed
and
.Em callable
columns below.
.Pp
Unless stated, manual domain macros share a common syntax:
.Pp
.Dl \&.Va argument [\ .\ ,\ ;\ :\ (\ )\ [\ ]\ argument \...\ ]
.Pp
.Sy Note :
Opening and closing
punctuation characters are only recognized as such if they are presented
one at a time.
The string
.Ql "),"
is not recognized as punctuation and will be output with a leading white
space and in what ever font the calling macro uses.
The
argument list
.Ql "] ) ,"
is recognized as three sequential closing punctuation characters
and a leading white space is not output between the characters
and the previous argument (if any).
The special meaning of a punctuation character may be escaped
with the string
.Ql \e& .
For example the following string,
.Bl -tag -width "&.Ar file1\ , file2\ , file3\ )\ ." -offset indent
.It Li "\&.Ar file1\ , file2\ , file3\ )\ ."
Produces
.Ar file1 , file2 , file3 ) .
.El
.ne 1i
.Ss Manual Domain Macros
.Bl -column "Name" "Parsed" "Callable" -compact
.It Em Name	Parsed	Callable	Description
.It Li \&Ad Ta Yes Ta Yes Ta Address. "(This macro may be deprecated.)"
.It Li \&Ar Ta Yes Ta Yes Ta "Command line argument."
.It Li \&Cd Ta \&No Ta \&No Ta "Configuration declaration (section four only)."
.It Li \&Cm Ta Yes Ta Yes Ta "Command line argument modifier."
.It Li \&Dv Ta Yes Ta Yes Ta "Defined variable (source code)."
.It Li \&Er Ta Yes Ta Yes Ta "Error number (source code)."
.It Li \&Ev Ta Yes Ta Yes Ta "Environment variable."
.It Li \&Fa Ta Yes Ta Yes Ta "Function argument."
.It Li \&Fd Ta \&No Ta \&No Ta "Function declaration."
.It Li \&Fl Ta Yes Ta Yes Ta "Command line flag."
.It Li \&Fn Ta Yes Ta Yes Ta "Function call (also .Fo and .Fc)."
.It Li \&Ic Ta Yes Ta Yes Ta "Interactive command."
.It Li \&Li Ta Yes Ta Yes Ta "Literal text."
.It Li \&Nm Ta Yes Ta Yes Ta "Command name."
.It Li \&Op Ta Yes Ta Yes Ta "Option (also .Oo and .Oc)."
.It Li \&Ot Ta Yes Ta Yes Ta "Old style function type (Fortran only)."
.It Li \&Pa Ta Yes Ta Yes Ta "Pathname or file name."
.It Li \&St Ta Yes Ta Yes Ta "Standards (-p1003.2, -p1003.1 or -ansiC)"
.It Li \&Va Ta Yes Ta Yes Ta "Variable name."
.It Li \&Vt Ta Yes Ta Yes Ta "Variable type (Fortran only)."
.It Li \&Xr Ta Yes Ta Yes Ta "Manual Page Cross Reference."
.El
.Ss General Text Domain Macros
.Bl -column "Name" "Parsed" "Callable" -compact
.It Em "Name	Parsed	Callable	Description"
.It Li \&%A Ta Yes Ta \&No Ta "Reference author."
.It Li \&%B Ta Yes Ta Yes Ta "Reference book title."
.It Li \&%\&C Ta \&No Ta \&No Ta "Reference place of publishing (city)."
.It Li \&%\&D Ta \&No Ta \&No Ta "Reference date."
.It Li \&%J Ta Yes Ta Yes Ta "Reference journal title."
.It Li \&%N Ta \&No Ta \&No Ta "Reference issue number."
.It Li \&%\&O Ta \&No Ta \&No Ta "Reference optional information."
.It Li \&%P Ta \&No Ta \&No Ta "Reference page number(s)."
.It Li \&%R Ta \&No Ta \&No Ta "Reference report Name."
.It Li \&%T Ta Yes Ta Yes Ta "Reference article title."
.It Li \&%V Ta \&No Ta \&No Ta "Reference volume."
.It Li \&Ac Ta Yes Ta Yes Ta "Angle close quote."
.It Li \&Ao Ta Yes Ta Yes Ta "Angle open quote."
.It Li \&Ap Ta Yes Ta Yes Ta "Insert apostrophe; switch to .No mode "
.It Li \&Aq Ta Yes Ta Yes Ta "Angle quote."
.It Li \&At Ta \&No Ta \&No Ta Tn "AT&T UNIX."
.It Li \&Bc Ta Yes Ta Yes Ta "Bracket close quote."
.It Li \&Bf Ta \&No Ta \&No Ta "Begin font mode."
.It Li \&Bo Ta Yes Ta Yes Ta "Bracket open quote."
.It Li \&Bq Ta Yes Ta Yes Ta "Bracket quote."
.It Li \&Bx Ta Yes Ta Yes Ta "BSD" .
.It Li \&Db Ta \&No Ta \&No Ta "Debug (default is \\*qoff\\*q)."
.It Li \&Dc Ta Yes Ta Yes Ta "Double close quote."
.It Li \&Do Ta Yes Ta Yes Ta "Double open quote."
.It Li \&Dq Ta Yes Ta Yes Ta "Double quote."
.It Li \&Ec Ta Yes Ta Yes Ta "Enclose string close quote."
.It Li \&Ef Ta \&No Ta \&No Ta "End font mode."
.It Li \&Em Ta Yes Ta Yes Ta "Emphasis (traditional English)."
.It Li \&Eo Ta Yes Ta Yes Ta "Enclose string open quote."
.It Li \&Fx Ta \&No Ta \&No Ta "FreeBSD."
.It Li \&No Ta Yes Ta Yes Ta "Normal text (no-op)."
.It Li \&Ns Ta Yes Ta Yes Ta "No space."
.It Li \&Nx Ta \&No Ta \&No Ta "NetBSD."
.It Li \&Pc Ta Yes Ta Yes Ta "Parenthesis close quote."
.It Li \&Pf Ta Yes Ta \&No Ta "Prefix string."
.It Li \&Po Ta Yes Ta Yes Ta "Parenthesis open quote."
.It Li \&Pq Ta Yes Ta Yes Ta "Parentheses quote."
.It Li \&Qc Ta Yes Ta Yes Ta "Strait Double close quote."
.It Li \&Ql Ta Yes Ta Yes Ta "Quoted literal."
.It Li \&Qo Ta Yes Ta Yes Ta "Strait Double open quote."
.It Li \&Qq Ta Yes Ta Yes Ta "Strait Double quote."
.It Li \&Re Ta \&No Ta \&No Ta "Reference end."
.It Li \&Rs Ta \&No Ta \&No Ta "Reference start."
.It Li \&Sc Ta Yes Ta Yes Ta "Single close quote."
.It Li \&So Ta Yes Ta Yes Ta "Single open quote."
.It Li \&Sq Ta Yes Ta Yes Ta "Single quote."
.It Li \&Sm Ta \&No Ta \&No Ta "Space mode (default is \\*qon\\*q)."
.It Li \&Sx Ta Yes Ta Yes Ta "Section Cross Reference."
.It Li \&Sy Ta Yes Ta Yes Ta "Symbolic (traditional English)."
.It Li \&Tn Ta Yes Ta Yes Ta "Trade or type name (small Caps)."
.It Li \&Ux Ta Yes Ta Yes Ta "UNIX."
.It Li \&Xc Ta Yes Ta Yes Ta "Extend argument list close."
.It Li \&Xo Ta Yes Ta Yes Ta "Extend argument list open."
.El
.\" .It Sy \&Hf Ta \&No Ta \&No Ta "Include file with header"
.Pp
Macro names ending in
.Ql q
quote remaining items on the argument list.
Macro names ending in
.Ql o
begin a quote which may span more than one line of input and
are close quoted with the matching macro name ending in
.Ql c .
Enclosure macros may be nested and are limited to
eight arguments.
.Pp
Note: the extended argument list macros
.Pf ( Ql \&.Xo ,
.Ql \&.Xc )
and the function enclosure macros
.Pf ( Ql \&.Fo ,
.Ql \&.Fc )
are irregular.
The extended list macros are used when the number of macro arguments
would exceed the
.Xr troff
limitation of nine arguments.
.Sh CONFIGURATION
For site specific configuration of the macro package,
see the file
.Pa /usr/src/share/tmac/README .
.Sh FILES
.Bl -tag -width "tmac.doc-ditroff" -compact
.It Pa tmac.doc
Manual and general text domain macros.
.It Pa tmac.doc-common
Common structural macros and definitions.
.It Pa tmac.doc-nroff
Site dependent
.Xr nroff
style file.
.It Pa tmac.doc-ditroff
Site dependent
.Xr troff
style file.
.It Pa tmac.doc-syms
Special defines (such as the standards macro).
.El
.Sh SEE ALSO
.Xr mdoc.samples 7
