#ifndef SCM_INIT_H
#define SCM_INIT_H

/* Copyright 1995-1997,2000,2006,2008,2011,2018
     Free Software Foundation, Inc.

   This file is part of Guile.

   Guile is free software: you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Guile is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
   License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with Guile.  If not, see
   <https://www.gnu.org/licenses/>.  */



#include "libguile/threads.h"


SCM_INTERNAL scm_i_pthread_mutex_t scm_i_init_mutex;
SCM_API int scm_initialized_p;

SCM_API void scm_init_guile (void);

SCM_API void scm_boot_guile (int argc, char **argv,
			     void (*main_func) (void *closure,
						int argc,
						char **argv),
			     void *closure);

SCM_INTERNAL void scm_i_init_guile (void *base);

SCM_API void scm_load_startup_files (void);

#endif  /* SCM_INIT_H */
