/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 2000 MHz Cortex-A15 with Neon (in spite of file position) */
/* FFT tuning limit = 50,736,668 */
/* Generated by tuneup.c, 2019-10-22, gcc 5.4 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          3
#define MOD_1U_TO_MOD_1_1_THRESHOLD          2
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        10
#define MOD_1_2_TO_MOD_1_4_THRESHOLD     MP_SIZE_T_MAX
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      8
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1  /* 49.14% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           17

#define DIV_1_VS_MUL_1_PERCENT             267

#define MUL_TOOM22_THRESHOLD                28
#define MUL_TOOM33_THRESHOLD               114
#define MUL_TOOM44_THRESHOLD               178
#define MUL_TOOM6H_THRESHOLD               238
#define MUL_TOOM8H_THRESHOLD               597

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     113
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     115
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     115
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     115
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     154

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 38
#define SQR_TOOM3_THRESHOLD                126
#define SQR_TOOM4_THRESHOLD                336
#define SQR_TOOM6_THRESHOLD                446
#define SQR_TOOM8_THRESHOLD                650

#define MULMID_TOOM42_THRESHOLD             52

#define MULMOD_BNM1_THRESHOLD               23
#define SQRMOD_BNM1_THRESHOLD               17

#define MUL_FFT_MODF_THRESHOLD             575  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    575, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     27, 7}, {     15, 6}, {     31, 7}, {     19, 6}, \
    {     39, 7}, {     25, 6}, {     51, 7}, {     27, 8}, \
    {     15, 7}, {     33, 8}, {     19, 7}, {     41, 8}, \
    {     23, 7}, {     51, 8}, {     27, 9}, {     15, 8}, \
    {     31, 7}, {     63, 8}, {     39, 9}, {     23, 8}, \
    {     55,10}, {     15, 9}, {     31, 8}, {     67, 9}, \
    {     39, 8}, {     79, 9}, {     47, 8}, {     95, 9}, \
    {     55,10}, {     31, 9}, {     71, 8}, {    143, 9}, \
    {     87,10}, {     47, 9}, {    111,11}, {     31,10}, \
    {     63, 9}, {    143,10}, {     79, 9}, {    159,10}, \
    {     95,11}, {     63,10}, {    143, 9}, {    287,10}, \
    {    159,11}, {     95,10}, {    191,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,10}, {    287,11}, {    159,10}, {    335, 9}, \
    {    671,10}, {    367, 9}, {    735,11}, {    191,10}, \
    {    383, 9}, {    799,10}, {    415,11}, {    223,12}, \
    {    127,10}, {    543,11}, {    287,10}, {    575,11}, \
    {    319,10}, {    639,11}, {    351,10}, {    703,12}, \
    {    191,11}, {    383,10}, {    767,11}, {    415,10}, \
    {    831,11}, {    447,13}, {    127,12}, {    255,11}, \
    {    543,10}, {   1087,11}, {    575,12}, {    319,11}, \
    {    671,10}, {   1343,11}, {    735,12}, {    383,11}, \
    {    831,12}, {    447,11}, {    959,13}, {    255,12}, \
    {    511,11}, {   1087,12}, {    575,11}, {   1151,12}, \
    {    639,11}, {   1343,12}, {    703,13}, {    383,12}, \
    {    767,11}, {   1599,12}, {    895,14}, {    255,13}, \
    {    511,12}, {   1087,13}, {    639,12}, {   1407,13}, \
    {    767,12}, {   1599,13}, {    895,14}, {    511,13}, \
    {   1023,12}, {   2111,13}, {   1151,12}, {   2431,13}, \
    {   1279,12}, {   2559,13}, {   1407,14}, {    767,13}, \
    {   1535,12}, {   3135,13}, {   1663,15}, {    511,14}, \
    {   1023,13}, {   2303,14}, {   1279,13}, {   2559,12}, \
    {   5119,13}, {   2687,14}, {   1535,13}, {   3071,12}, \
    {   6143,13}, {   3199,12}, {   6399,14}, {   1791,15}, \
    {   1023,14}, {   2047,13}, {   4095,14}, {   2303,13}, \
    {   4607,12}, {   9215,13}, {   4863,12}, {   9727,14}, \
    {   2559,13}, {   5119,15}, {   1535,14}, {   3071,13}, \
    {   8192,14}, {  16384,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 155
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             525  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    525, 5}, {     25, 6}, {     27, 7}, {     15, 6}, \
    {     31, 7}, {     17, 6}, {     35, 7}, {     19, 6}, \
    {     39, 7}, {     25, 6}, {     51, 7}, {     27, 8}, \
    {     15, 7}, {     33, 8}, {     19, 7}, {     41, 8}, \
    {     23, 7}, {     51, 8}, {     27, 7}, {     55, 9}, \
    {     15, 8}, {     31, 7}, {     63, 8}, {     39, 9}, \
    {     23, 8}, {     51,10}, {     15, 9}, {     31, 8}, \
    {     67, 9}, {     39, 8}, {     79, 9}, {     47, 8}, \
    {     99, 9}, {     55,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {     95,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     95,11}, {     63,10}, {    143, 9}, \
    {    287, 8}, {    575, 9}, {    303,10}, {    159,11}, \
    {     95,10}, {    191, 9}, {    383,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,10}, {    287,11}, {    159,10}, {    319, 9}, \
    {    639,10}, {    335, 9}, {    671,10}, {    351,11}, \
    {    191,10}, {    399, 9}, {    799,10}, {    415, 9}, \
    {    831,11}, {    223,10}, {    447,12}, {    127,10}, \
    {    543,11}, {    287,10}, {    575,11}, {    319,10}, \
    {    639,11}, {    351,10}, {    703,12}, {    191,11}, \
    {    383,10}, {    799,11}, {    415,10}, {    831,11}, \
    {    447,13}, {    127,11}, {    543,10}, {   1087,11}, \
    {    607,12}, {    319,11}, {    735,12}, {    383,11}, \
    {    831,12}, {    447,11}, {    959,12}, {    511,11}, \
    {   1023,12}, {    575,11}, {   1151,12}, {    639,11}, \
    {   1279,12}, {    703,13}, {    383,12}, {    767,11}, \
    {   1535,12}, {    831,11}, {   1663,12}, {    895,14}, \
    {    255,13}, {    511,12}, {   1087,13}, {    639,12}, \
    {   1343,13}, {    767,12}, {   1599,13}, {    895,14}, \
    {    511,13}, {   1023,12}, {   2111,13}, {   1151,12}, \
    {   2303,13}, {   1279,14}, {    767,13}, {   1535,12}, \
    {   3135,13}, {   1663,15}, {    511,14}, {   1023,13}, \
    {   2047,12}, {   4095,13}, {   2303,14}, {   1279,13}, \
    {   2559,12}, {   5119,14}, {   1535,13}, {   3071,12}, \
    {   6143,13}, {   3199,12}, {   6399,14}, {   1791,15}, \
    {   1023,14}, {   2047,13}, {   4095,14}, {   2303,13}, \
    {   4607,12}, {   9215,13}, {   4863,12}, {   9727,14}, \
    {   2559,15}, {   1535,14}, {   3071,13}, {   8192,14}, \
    {  16384,15}, {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 154
#define SQR_FFT_THRESHOLD                 5312

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  38
#define MULLO_MUL_N_THRESHOLD            10950
#define SQRLO_BASECASE_THRESHOLD            10
#define SQRLO_DC_THRESHOLD                  35
#define SQRLO_SQR_THRESHOLD              10323

#define DC_DIV_QR_THRESHOLD                 57
#define DC_DIVAPPR_Q_THRESHOLD             254
#define DC_BDIV_QR_THRESHOLD                48
#define DC_BDIV_Q_THRESHOLD                286

#define INV_MULMOD_BNM1_THRESHOLD           55
#define INV_NEWTON_THRESHOLD               252
#define INV_APPR_THRESHOLD                 252

#define BINV_NEWTON_THRESHOLD              372
#define REDC_1_TO_REDC_2_THRESHOLD          61
#define REDC_2_TO_REDC_N_THRESHOLD           0  /* always */

#define MU_DIV_QR_THRESHOLD               1858
#define MU_DIVAPPR_Q_THRESHOLD            1787
#define MUPI_DIV_QR_THRESHOLD              122
#define MU_BDIV_QR_THRESHOLD              1528
#define MU_BDIV_Q_THRESHOLD               1836

#define POWM_SEC_TABLE  1,14,200,480,1532

#define GET_STR_DC_THRESHOLD                16
#define GET_STR_PRECOMPUTE_THRESHOLD        33
#define SET_STR_DC_THRESHOLD               104
#define SET_STR_PRECOMPUTE_THRESHOLD      1120

#define FAC_DSC_THRESHOLD                  164
#define FAC_ODD_THRESHOLD                   27

#define MATRIX22_STRASSEN_THRESHOLD         19
#define HGCD2_DIV1_METHOD                    1  /* 3.70% faster than 3 */
#define HGCD_THRESHOLD                     137
#define HGCD_APPR_THRESHOLD                157
#define HGCD_REDUCE_THRESHOLD             3389
#define GCD_DC_THRESHOLD                   610
#define GCDEXT_DC_THRESHOLD                443
#define JACOBI_BASE_METHOD                   4  /* 12.66% faster than 1 */

/* Tuneup completed successfully, took 69757 seconds */
