/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionLoader;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ExpressionImage {
    public static final int BI_PL = 0;
    public static final int BI_MI = 1;
    public static final int BI_MU = 2;
    public static final int BI_DI = 3;
    public static final int BI_RE = 4;
    public static final int BI_AN = 5;
    public static final int BI_OR = 6;
    public static final int BI_XO = 7;
    public static final String[] binaryNames = new String[]{"add", "substract", "multiply", "divide", "remainder", "bitwise and", "bitwise or", "bitwise xor"};
    public static final String[] unaryNames = new String[]{"negate"};
    public static final int UN_NE = 0;
    private static final byte[] prologue;
    private int poolEntries = 1;
    private static final byte[] cp_middle;
    private static final byte[] intermezzo1;
    private byte thetype = (byte)99;
    private static final byte[] intermezzo2;
    short nameIdx = (short)9999;
    short signIdx = (short)9999;
    private static final byte[] intermezzo3;
    int max_stack = 2;
    int max_locals = 4;
    private static final byte[] konetc;
    public static final Class[] primitiveTypes;
    private static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    private static final byte[] returns;
    private static final byte[] cvt_wide;
    private static final int[][] cvt1;
    private static final int[][] cvt2;
    private static final byte[] stkoccup;
    private static final int[][] cvts;
    private static final int[][] ops;
    private static final int[] norm;
    private static final int[][] una;
    private static final byte[] stor;
    private static final byte[] load;
    private static final byte[] sladdr;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private ByteArrayOutputStream constPool;
    private DataOutputStream constPoolData;
    private Hashtable Classes = new Hashtable();
    private Hashtable Methods = new Hashtable();
    private Hashtable Longs = new Hashtable();
    private Hashtable Doubles = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    private Hashtable Strings = new Hashtable();
    private Hashtable Integers = new Hashtable();
    private Hashtable Floats = new Hashtable();
    private ByteArrayOutputStream methodText;
    private DataOutputStream methodTextData;
    private static final String classNamePrefix = "gnu.jel.generated.E_";
    private static volatile long numberGen;
    private String className;
    private boolean classFinished = false;
    private int currSSW;
    private Vector objectPool = new Vector();
    private Stack typesStk = new Stack();
    private Stack functionParams = new Stack();
    private Stack functionINTS = new Stack();
    private Stack functionRet = new Stack();

    public ExpressionImage() {
        this.constPool = new ByteArrayOutputStream();
        this.constPoolData = new DataOutputStream(this.constPool);
        this.methodText = new ByteArrayOutputStream();
        this.methodTextData = new DataOutputStream(this.methodText);
        this.className = classNamePrefix + Long.toString(numberGen++);
        int cnIndex = this.getUTFIndex(ExpressionImage.toHistoricalForm(this.className));
        Debug.assert(cnIndex == 1, "Class name Should be the first in CP");
        try {
            this.constPoolData.write(cp_middle);
            this.poolEntries += 18;
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
    }

    private final void checkAlter() {
        Debug.assert(!this.classFinished, "Attempt to modify finished class.");
    }

    private int getUTFIndex(String str) {
        Integer index = (Integer)this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(1);
                this.constPoolData.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int getLongIndex(Long val) {
        Integer index = (Integer)this.Longs.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(5);
                this.constPoolData.writeLong(val);
                ++this.poolEntries;
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Longs.put(val, index);
        }
        return index;
    }

    private int getIntIndex(Integer val) {
        Integer index = (Integer)this.Integers.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(3);
                this.constPoolData.writeInt(val);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Integers.put(val, index);
        }
        return index;
    }

    private int getFloatIndex(Float val) {
        Integer index = (Integer)this.Floats.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(4);
                this.constPoolData.writeFloat(val.floatValue());
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Floats.put(val, index);
        }
        return index;
    }

    private int getDoubleIndex(Double val) {
        Integer index = (Integer)this.Doubles.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(6);
                this.constPoolData.writeDouble(val);
                ++this.poolEntries;
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Doubles.put(val, index);
        }
        return index;
    }

    private int getStringIndex(String str) {
        Integer index = (Integer)this.Strings.get(str);
        if (index == null) {
            int UTFIndex = this.getUTFIndex(str);
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(8);
                this.constPoolData.writeShort(UTFIndex);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Strings.put(str, index);
        }
        return index;
    }

    private int getClassIndex(Class the_class) {
        Integer index = (Integer)this.Classes.get(the_class);
        if (index == null) {
            String fqcn = the_class.getName();
            String histNameStr = ExpressionImage.toHistoricalForm(fqcn);
            int UTFIndex = this.getUTFIndex(histNameStr);
            index = new Integer(this.poolEntries++);
            this.writeClassInfo(UTFIndex);
            this.Classes.put(the_class, index);
        }
        return index;
    }

    private void writeClassInfo(int nameInd) {
        try {
            this.checkAlter();
            this.constPoolData.write(7);
            this.constPoolData.writeShort(nameInd);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
    }

    private int getMethodIndex(Method the_method) {
        Integer index = (Integer)this.Methods.get(the_method);
        if (index == null) {
            int name_ind = this.getUTFIndex(the_method.getName());
            int sign_ind = this.getUTFIndex(ExpressionImage.getSignature(the_method));
            Class<?> declaringClass = the_method.getDeclaringClass();
            int cls_ind = this.getClassIndex(declaringClass);
            int nat_ind = this.poolEntries++;
            try {
                this.checkAlter();
                this.constPoolData.write(12);
                this.constPoolData.writeShort(name_ind);
                this.constPoolData.writeShort(sign_ind);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            index = new Integer(this.poolEntries++);
            int mtd_type = 10;
            if (declaringClass.isInterface()) {
                mtd_type = 11;
            }
            try {
                this.checkAlter();
                this.constPoolData.write(mtd_type);
                this.constPoolData.writeShort(cls_ind);
                this.constPoolData.writeShort(nat_ind);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Methods.put(the_method, index);
        }
        return index;
    }

    public static String getSignature(Method m) {
        StringBuffer signature = new StringBuffer();
        signature.append('(');
        Class<?>[] parameters = m.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            signature.append(ExpressionImage.getSignature(parameters[i]));
            ++i;
        }
        signature.append(')');
        signature.append(ExpressionImage.getSignature(m.getReturnType()));
        return signature.toString();
    }

    public static String getSignature(Class cls) {
        if (cls == Byte.TYPE) {
            return "B";
        }
        if (cls == Character.TYPE) {
            return "C";
        }
        if (cls == Double.TYPE) {
            return "D";
        }
        if (cls == Float.TYPE) {
            return "F";
        }
        if (cls == Integer.TYPE) {
            return "I";
        }
        if (cls == Long.TYPE) {
            return "J";
        }
        if (cls == Short.TYPE) {
            return "S";
        }
        if (cls == Boolean.TYPE) {
            return "Z";
        }
        if (cls == Void.TYPE) {
            return "V";
        }
        if (cls.isArray()) {
            return String.valueOf('[') + ExpressionImage.getSignature(cls.getComponentType());
        }
        return String.valueOf('L') + ExpressionImage.toHistoricalForm(cls.getName()) + ';';
    }

    private static String toHistoricalForm(String className) {
        StringBuffer histName = new StringBuffer(className);
        int namelen = className.length();
        int i = className.indexOf(46);
        while (i > 0 && i < namelen) {
            histName.setCharAt(i, '/');
            i = className.indexOf(46, i + 1);
        }
        return histName.toString();
    }

    byte[] getImage() {
        Debug.assert(this.classFinished, "Attempt to get the code of unfinished class.");
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        DataOutputStream imageData = new DataOutputStream(image);
        try {
            imageData.write(prologue);
            imageData.writeShort(this.poolEntries);
            this.constPool.writeTo(imageData);
            imageData.write(intermezzo1);
            imageData.write(this.thetype);
            imageData.write(intermezzo2);
            imageData.writeShort(this.nameIdx);
            imageData.writeShort(this.signIdx);
            imageData.write(intermezzo3);
            int code_len = this.methodText.size();
            imageData.writeInt(code_len + 12);
            imageData.writeShort(this.max_stack);
            imageData.writeShort(this.max_locals);
            imageData.writeInt(code_len);
            this.methodText.writeTo(imageData);
            imageData.write(konetc);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
        return image.toByteArray();
    }

    public CompiledExpression getExpression() {
        Debug.assert(this.classFinished, "Attempt to instantiate unfinished class.");
        byte[] image = this.getImage();
        try {
            ExpressionLoader el = new ExpressionLoader(this.className, image);
            Class<?> cls = el.loadClass(this.className);
            Constructor<?>[] ca = cls.getConstructors();
            Debug.assert(ca.length == 1, "There should be only one constructor of the compiled expression.");
            Object[][] constrParams = new Object[1][this.objectPool.size()];
            if (this.objectPool.size() > 0) {
                this.objectPool.copyInto(constrParams[0]);
            }
            return (CompiledExpression)ca[0].newInstance((Object[])constrParams);
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
            return null;
        }
    }

    private final void ensureStack() {
        if (this.currSSW > this.max_stack) {
            this.max_stack = this.currSSW;
        }
    }

    private final void codeOP(int op) {
        try {
            this.methodTextData.write(op);
        }
        catch (IOException iOException) {}
    }

    private final void codeINDEX(int ind) {
        try {
            this.methodTextData.writeShort(ind);
        }
        catch (IOException iOException) {}
    }

    static final int primitiveID(Class c) {
        Debug.assert(c.isPrimitive(), "PrimitiveID should be used for primitive types only.");
        int i = 0;
        while (i < primitiveTypes.length && primitiveTypes[i] != c) {
            ++i;
        }
        Debug.assert(i < primitiveTypes.length, "You IDIOT !!! You didn't put _ALL_ primitive types into primitiveTypes array.");
        return i;
    }

    private static final int stackSpace(Class c) {
        if (c.isPrimitive()) {
            return stkoccup[ExpressionImage.primitiveID(c)];
        }
        return 1;
    }

    public void asm_load_object(Object o) {
        if (o == null) {
            this.typesStk.push(null);
            this.codeOP(1);
            ++this.currSSW;
            this.ensureStack();
        } else {
            int opi = this.objectPool.indexOf(o);
            if (opi == -1) {
                this.objectPool.addElement(o);
                opi = this.objectPool.size() - 1;
            }
            this.typesStk.push(o.getClass());
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(42);
            this.codeOP(180);
            this.codeINDEX(15);
            if (opi < 255) {
                this.codeOP(16);
                this.codeOP(opi);
            } else {
                int opii = this.getIntIndex(new Integer(opi));
                this.codeOP(19);
                this.codeINDEX(opii);
            }
            this.codeOP(50);
            int clsind = this.getClassIndex(o.getClass());
            this.codeOP(192);
            this.codeINDEX(clsind);
            --this.currSSW;
        }
    }

    public void asm_load_primitive(Object o) {
        this.checkAlter();
        int opcode = -1;
        int CP_index = -1;
        int stack_occupation = 0;
        Class<Constable> type_loaded = null;
        Class<Comparable<Byte>> cvt_to_type = null;
        boolean attempt_short = false;
        if (o instanceof Double) {
            stack_occupation = 2;
            opcode = 20;
            CP_index = this.getDoubleIndex((Double)o);
            type_loaded = Double.TYPE;
        } else if (o instanceof Long) {
            stack_occupation = 2;
            opcode = 20;
            CP_index = this.getLongIndex((Long)o);
            type_loaded = Long.TYPE;
        } else if (o instanceof Float) {
            stack_occupation = 1;
            opcode = 19;
            CP_index = this.getFloatIndex((Float)o);
            type_loaded = Float.TYPE;
            attempt_short = true;
        } else if (o instanceof Integer) {
            stack_occupation = 1;
            opcode = 19;
            CP_index = this.getIntIndex((Integer)o);
            type_loaded = Integer.TYPE;
            attempt_short = true;
        } else if (o instanceof Byte) {
            stack_occupation = 1;
            opcode = 19;
            CP_index = this.getIntIndex(new Integer(((Byte)o).intValue()));
            type_loaded = Integer.TYPE;
            cvt_to_type = Byte.TYPE;
            attempt_short = true;
        } else if (o instanceof Short) {
            stack_occupation = 1;
            opcode = 19;
            CP_index = this.getIntIndex(new Integer(((Short)o).intValue()));
            type_loaded = Integer.TYPE;
            cvt_to_type = Short.TYPE;
            attempt_short = true;
        } else if (o instanceof Character) {
            stack_occupation = 1;
            opcode = 19;
            CP_index = this.getIntIndex(new Integer(((Character)o).charValue()));
            type_loaded = Integer.TYPE;
            cvt_to_type = Character.TYPE;
            attempt_short = true;
        } else if (o instanceof Boolean) {
            stack_occupation = 1;
            opcode = 19;
            int ivalue = 0;
            if (((Boolean)o).booleanValue()) {
                ivalue = 1;
            }
            CP_index = this.getIntIndex(new Integer(ivalue));
            type_loaded = Boolean.TYPE;
            attempt_short = true;
        } else {
            Debug.println("Attempt to load object as a primitive type detected.");
        }
        if (type_loaded != null) {
            if (attempt_short && CP_index < 255) {
                this.codeOP(opcode - 1);
                this.codeOP(CP_index);
            } else {
                this.codeOP(opcode);
                this.codeINDEX(CP_index);
            }
            this.currSSW += stack_occupation;
            this.ensureStack();
            this.typesStk.push(type_loaded);
            if (cvt_to_type != null) {
                this.asm_convert(cvt_to_type);
            }
        }
    }

    public static boolean canConvert(Class t1, Class t2) {
        boolean pt1 = t1.isPrimitive();
        boolean pt2 = t2.isPrimitive();
        if (pt2 && pt1) {
            int it1 = ExpressionImage.primitiveID(t1);
            int it2 = ExpressionImage.primitiveID(t2);
            return cvt1[it2][it1] != 255;
        }
        if (pt2 ^ pt1) {
            return false;
        }
        return t2.isAssignableFrom(t1);
    }

    public static boolean canConvertByWidening(Class t1, Class t2) {
        boolean pt1 = t1.isPrimitive();
        boolean pt2 = t2.isPrimitive();
        if (pt2 && pt1) {
            int it1 = ExpressionImage.primitiveID(t1);
            int it2 = ExpressionImage.primitiveID(t2);
            return (cvt_wide[it2] & 128 >> it1) > 0;
        }
        if (pt2 ^ pt1) {
            return false;
        }
        return t2.isAssignableFrom(t1);
    }

    public boolean asm_convert(Class type) {
        Class typeNOW = (Class)this.typesStk.peek();
        if (type == typeNOW) {
            return true;
        }
        boolean ptn = typeNOW.isPrimitive();
        boolean pt = type.isPrimitive();
        if (ptn && pt) {
            int tni = ExpressionImage.primitiveID(typeNOW);
            int ti = ExpressionImage.primitiveID(type);
            int op1 = cvt1[ti][tni];
            int op2 = cvt2[ti][tni];
            if (op1 == 255) {
                Debug.assert(false, "Incompatible types in asm_convert");
                return false;
            }
            this.currSSW = this.currSSW + stkoccup[ti] - stkoccup[tni];
            this.ensureStack();
            if (op1 != 0) {
                this.codeOP(op1);
            }
            if (op2 != 0) {
                this.codeOP(op2);
            }
            this.typesStk.pop();
            this.typesStk.push(type);
            return true;
        }
        if (ptn ^ pt) {
            Debug.println("Can't convert between pimitive and object types in this version.");
            return false;
        }
        this.typesStk.pop();
        this.typesStk.push(type);
        return true;
    }

    public static Class getMostGeneralType(Class c1, Class c2) {
        Debug.assert(c1.isPrimitive() && c2.isPrimitive(), "Both types for the binary OP should be primitive.");
        int ic1 = ExpressionImage.primitiveID(c1);
        int ic2 = ExpressionImage.primitiveID(c2);
        int idx = cvts[ic1][ic2];
        if (idx == 255) {
            return null;
        }
        return primitiveTypes[idx];
    }

    public static boolean canGenerateUnary(int op, Class type) {
        if (!type.isPrimitive()) {
            return false;
        }
        return una[op][ExpressionImage.primitiveID(type)] != 255;
    }

    public boolean asm_unary(int o) {
        Class a = (Class)this.typesStk.peek();
        if (!a.isPrimitive()) {
            Debug.println("Unary OPs are supported on primitive types only");
            return false;
        }
        int ia = ExpressionImage.primitiveID(a);
        int opc = una[o][ia];
        if (opc == 255) {
            Debug.println("The unary operation requested (" + o + ") is not supported" + " for type in stack (" + ia + ").");
            return false;
        }
        this.codeOP(opc);
        return true;
    }

    public static boolean canGenerateBinary(int op, Class type) {
        if (!type.isPrimitive()) {
            return false;
        }
        return ops[op][ExpressionImage.primitiveID(type)] != 255;
    }

    public static boolean canGenerateBinary(int op, Class t1, Class t2) {
        if (!t1.isPrimitive() || !t2.isPrimitive()) {
            return false;
        }
        Class ct = ExpressionImage.getMostGeneralType(t1, t2);
        if (ct == null) {
            return false;
        }
        return ExpressionImage.canGenerateBinary(op, ct);
    }

    public boolean asm_binary(int o) {
        int ia2;
        Class a2 = (Class)this.typesStk.peek();
        Object tmp = this.typesStk.pop();
        Class a1 = (Class)this.typesStk.peek();
        this.typesStk.push(tmp);
        if (!a1.isPrimitive() || !a2.isPrimitive()) {
            Debug.println("Binary OPs are supported on primitive types only");
            return false;
        }
        int ia1 = ExpressionImage.primitiveID(a1);
        if (ia1 != (ia2 = ExpressionImage.primitiveID(a2))) {
            Debug.println("Types are not the same (" + ia1 + "!=" + ia2 + "), conversion should be done prior to OP.");
            return false;
        }
        int opc = ops[o][ia1];
        if (opc == 255) {
            Debug.println("The binary operation requested (" + o + ") is not " + "supported for types in stack (" + ia1 + ") .");
            return false;
        }
        this.codeOP(opc);
        this.typesStk.pop();
        this.currSSW -= stkoccup[ia1];
        return true;
    }

    public void asm_func_start(Method f, int id) {
        Class<?>[] params = f.getParameterTypes();
        this.functionParams.push(params);
        boolean isStatic = Modifier.isStatic(f.getModifiers());
        int[] nArray = new int[5];
        nArray[0] = this.getMethodIndex(f);
        nArray[1] = isStatic ? 1 : 0;
        nArray[2] = params.length;
        nArray[4] = this.currSSW;
        int[] descr = nArray;
        this.functionINTS.push(descr);
        this.functionRet.push(f.getReturnType());
        if (!isStatic) {
            this.checkAlter();
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(43);
            if (id < 255) {
                this.codeOP(16);
                this.codeOP(id);
            } else {
                int idi = this.getIntIndex(new Integer(id));
                this.codeOP(19);
                this.codeINDEX(idi);
            }
            this.codeOP(50);
            int cls_CP = this.getClassIndex(f.getDeclaringClass());
            this.codeOP(192);
            this.codeINDEX(cls_CP);
            descr[4] = --this.currSSW;
        }
    }

    public boolean asm_func_param() {
        Debug.assert(!this.functionParams.empty(), "No function call being generated.");
        Class[] params = (Class[])this.functionParams.peek();
        int[] descr = (int[])this.functionINTS.peek();
        int currpar = descr[3];
        Debug.assert(currpar < descr[2], "Too many parameters for function");
        boolean converted = this.asm_convert(params[currpar]);
        if (!converted) {
            Debug.println("Can't convert to the required formal parameter type.");
            return false;
        }
        Debug.assert(this.currSSW == descr[4] + ExpressionImage.stackSpace(params[currpar]), "Stack mismatch. Something was left in the stack in between of function formal parameters.");
        descr[4] = this.currSSW;
        descr[3] = descr[3] + 1;
        return true;
    }

    public boolean asm_func_call() {
        Debug.assert(!this.functionParams.empty(), "No function call being generated.");
        Class[] params = (Class[])this.functionParams.pop();
        int[] descr = (int[])this.functionINTS.pop();
        Class retType = (Class)this.functionRet.pop();
        int currpar = descr[3];
        if (currpar != descr[2]) {
            Debug.println("Not all parameters were supplied for function.");
            return false;
        }
        boolean isStatic = descr[1] == 1;
        int totstk = isStatic ? 0 : 1;
        this.checkAlter();
        if (isStatic) {
            this.codeOP(184);
        } else {
            this.codeOP(182);
        }
        this.codeINDEX(descr[0]);
        int i = 0;
        while (i < params.length) {
            totstk += ExpressionImage.stackSpace(params[i]);
            this.typesStk.pop();
            ++i;
        }
        this.currSSW -= totstk;
        this.typesStk.push(retType);
        this.currSSW += ExpressionImage.stackSpace(retType);
        this.ensureStack();
        return true;
    }

    public void asm_return() {
        this.checkAlter();
        Class typeout = null;
        boolean returnvoid = false;
        try {
            typeout = (Class)this.typesStk.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.asm_load_object(null);
            returnvoid = true;
        }
        int prid = primitiveTypes.length;
        int instruction = -80;
        if (!returnvoid) {
            ++prid;
            if (typeout != null && typeout.isPrimitive()) {
                prid = ExpressionImage.primitiveID(typeout);
                instruction = returns[prid];
            }
        }
        StringBuffer mname = new StringBuffer("evaluate");
        StringBuffer signature = new StringBuffer("([Ljava/lang/Object;)");
        if (prid < primitiveTypes.length) {
            mname.append('_');
            mname.append(primitiveTypeNames[prid]);
            signature.append(primitiveCodes[prid]);
        } else {
            signature.append("Ljava/lang/Object;");
        }
        this.nameIdx = (short)this.getUTFIndex(mname.toString());
        this.signIdx = (short)this.getUTFIndex(signature.toString());
        this.thetype = (byte)prid;
        this.typesStk.pop();
        Debug.assert(this.typesStk.size() == 0, "Stack is not empty when returning.");
        Debug.assert(prid > 7 || this.currSSW == stkoccup[prid], "Words left in stack = " + this.currSSW + "should be 1.");
        this.codeOP(instruction);
        this.classFinished = true;
    }

    public void asm_ThrowReturn() {
        this.checkAlter();
        Class typeout = null;
        try {
            typeout = (Class)this.typesStk.pop();
        }
        catch (EmptyStackException e) {
            Debug.reportThrowable(e);
        }
        try {
            Class<?> thr = Class.forName("java.lang.Throwable");
            Debug.assert(thr.isAssignableFrom(typeout), "Attempt to throw non throwable.");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.codeOP(191);
        this.classFinished = true;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        ExpressionImage.test(t);
        t.summarize();
    }

    static void dumpImage(ExpressionImage ei) {
        try {
            FileOutputStream fos = new FileOutputStream("dump.class");
            fos.write(ei.getImage());
            fos.close();
        }
        catch (Exception exception) {
            Debug.println("Can't dump generated class file.");
        }
    }

    private static boolean transmitPrimitive(Object obj, Object tobe) throws Throwable {
        ExpressionImage ei = null;
        Object res = null;
        try {
            ei = new ExpressionImage();
            ei.asm_load_primitive(obj);
            ei.asm_return();
            CompiledExpression cex = ei.getExpression();
            res = cex.evaluate(null);
        }
        catch (Throwable e) {
            ExpressionImage.dumpImage(ei);
            throw e;
        }
        boolean success = res.equals(tobe);
        if (!success) {
            Debug.println("Transmit of \"" + obj.getClass().getName() + "\" failed.");
            Debug.println("Expected \"" + tobe.toString() + "\",  encountered \"" + res.toString() + "\".");
            ExpressionImage.dumpImage(ei);
        }
        return success;
    }

    public static void test(Tester t) {
        ExpressionImage e;
        t.startTest("toHistoricalForm(\"java.lang.String\")");
        t.compare(ExpressionImage.toHistoricalForm("java.lang.String"), "java/lang/String");
        t.startTest("getSignature((\"a string\").getClass())");
        t.compare(ExpressionImage.getSignature("a string".getClass()), "Ljava/lang/String;");
        t.startTest("getSignature((new int[10]).getClass())");
        t.compare(ExpressionImage.getSignature(new int[10].getClass()), "[I");
        t.startTest("getSignature((new Object[10]).getClass())");
        t.compare(ExpressionImage.getSignature(new Object[10].getClass()), "[Ljava/lang/Object;");
        ExpressionImage ei = new ExpressionImage();
        t.startTest("Add UTF twice");
        String s1 = "some string";
        int si = ei.getUTFIndex(s1);
        int sii = ei.getUTFIndex(s1);
        t.compare(sii, si);
        t.startTest("Checking the index of added UTF");
        t.compare(si, 20);
        t.startTest("Add Long twice");
        int li = ei.getLongIndex(new Long(10L));
        int lii = ei.getLongIndex(new Long(10L));
        t.compare(lii, li);
        t.startTest("Add Integer twice");
        int ii = ei.getIntIndex(new Integer(15));
        int iii = ei.getIntIndex(new Integer(15));
        t.compare(iii, ii);
        t.startTest("Add Float twice");
        int ff = ei.getFloatIndex(new Float(15.0f));
        int fff = ei.getFloatIndex(new Float(15.0f));
        t.compare(fff, ff);
        t.startTest("Add Double twice");
        int di = ei.getDoubleIndex(new Double(10.0));
        int dii = ei.getDoubleIndex(new Double(10.0));
        t.compare(dii, di);
        t.startTest("Add a new String twice");
        String s2 = "some other string";
        int s2i = ei.getStringIndex(s2);
        int s2ii = ei.getStringIndex(s2);
        t.compare(s2ii, s2i);
        t.startTest("Add a string with existing UTF twice");
        int s3i = ei.getStringIndex(s1);
        int s3ii = ei.getStringIndex(s1);
        t.compare(s3ii, s3i);
        t.startTest("Add a class twice.");
        int ci = ei.getClassIndex(ei.getClass());
        int cii = ei.getClassIndex(ei.getClass());
        t.compare(cii, ci);
        t.startTest("Add a method twice.");
        Class[] params = new Class[1];
        try {
            params[0] = Class.forName("gnu.jel.debug.Tester");
            Method a_method = ei.getClass().getMethod("test", params);
            int mi = ei.getMethodIndex(a_method);
            int mii = ei.getMethodIndex(a_method);
            t.compare(mii, mi);
        }
        catch (Exception e2) {
            t.testFail();
            Debug.reportThrowable(e2);
        }
        t.startTest("Counting added entries ");
        t.compare(ei.poolEntries, 36);
        t.startTest("Loading and executing via getExpression");
        try {
            boolean ok = true;
            ei.asm_load_object(null);
            ei.asm_return();
            CompiledExpression cell = ei.getExpression();
            boolean bl = ok = ok && cell.evaluate(null) == null;
            if (!ok) {
                ExpressionImage.dumpImage(ei);
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e3) {
            Debug.reportThrowable(e3);
            t.testFail();
        }
        t.startTest("Check transmission of Object constants");
        try {
            boolean ok;
            e = new ExpressionImage();
            e.asm_load_object(e);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean bl = ok = cell.evaluate(null) == e;
            if (!ok) {
                ExpressionImage.dumpImage(e);
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e4) {
            Debug.reportThrowable(e4);
            t.testFail();
        }
        t.startTest("Check load/return of primitives (Z,B,C,S,I,J,F,D)");
        try {
            if (!ExpressionImage.transmitPrimitive(new Long(1L), new Long(1L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Double(1.0), new Double(1.0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(1), new Integer(1))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Byte(1), new Byte(1))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Character(' '), new Character(' '))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Short(-3), new Short(-3))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Boolean(true), new Boolean(true))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Float(1.0f), new Float(1.0f))) {
                t.testFail();
            } else {
                t.testOK();
            }
        }
        catch (Throwable e5) {
            Debug.reportThrowable(e5);
            t.testFail();
        }
        t.startTest("Evaluating 2L*2L=4L");
        try {
            e = new ExpressionImage();
            e.asm_load_primitive(new Long(2L));
            e.asm_load_primitive(new Long(2L));
            e.asm_binary(2);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            if ((Long)cell.evaluate(null) == 4L) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e6) {
            Debug.reportThrowable(e6);
            t.testFail();
        }
        t.startTest("Evaluating 2D*2D=4D");
        try {
            e = new ExpressionImage();
            e.asm_load_primitive(new Double(2.0));
            e.asm_load_primitive(new Double(2.0));
            e.asm_binary(2);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            if ((Double)cell.evaluate(null) == 4.0) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e7) {
            Debug.reportThrowable(e7);
            t.testFail();
        }
        CompiledExpression cell_store = null;
        t.startTest("Evaluating Math.sin(2L+2L-4L+Math.round(1.2F))=Math.sin(1.0)");
        try {
            CompiledExpression cell;
            ExpressionImage e8 = new ExpressionImage();
            Class<?> math = Class.forName("java.lang.Math");
            Class[] prs = new Class[]{Double.TYPE};
            Method sinus = math.getDeclaredMethod("sin", prs);
            prs[0] = Float.TYPE;
            Method round = math.getDeclaredMethod("round", prs);
            e8.asm_func_start(sinus, 0);
            e8.asm_load_primitive(new Long(2L));
            e8.asm_load_primitive(new Long(2L));
            e8.asm_binary(0);
            e8.asm_load_primitive(new Long(4L));
            e8.asm_binary(1);
            e8.asm_func_start(round, 0);
            e8.asm_load_primitive(new Double(1.2));
            e8.asm_func_param();
            e8.asm_func_call();
            e8.asm_convert(Long.TYPE);
            e8.asm_binary(0);
            e8.asm_func_param();
            e8.asm_func_call();
            e8.asm_return();
            cell_store = cell = e8.getExpression();
            double result = (Double)cell.evaluate(null);
            if (Math.abs(result - Math.sin(1.0)) < 0.001) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e9) {
            Debug.reportThrowable(e9);
            t.testFail();
        }
        t.startTest("Evaluating last expression 100000 times");
        try {
            int i = 0;
            while (i < 100000) {
                cell_store.evaluate(null);
                ++i;
            }
            cell_store = null;
            t.testOK();
        }
        catch (Throwable e10) {
            Debug.reportThrowable(e10);
            t.testFail();
        }
    }

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        byArray[5] = 3;
        byArray[7] = 45;
        prologue = byArray;
        byte[] byArray2 = new byte[182];
        byArray2[0] = 7;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 26;
        byArray2[6] = 103;
        byArray2[7] = 110;
        byArray2[8] = 117;
        byArray2[9] = 47;
        byArray2[10] = 106;
        byArray2[11] = 101;
        byArray2[12] = 108;
        byArray2[13] = 47;
        byArray2[14] = 67;
        byArray2[15] = 111;
        byArray2[16] = 109;
        byArray2[17] = 112;
        byArray2[18] = 105;
        byArray2[19] = 108;
        byArray2[20] = 101;
        byArray2[21] = 100;
        byArray2[22] = 69;
        byArray2[23] = 120;
        byArray2[24] = 112;
        byArray2[25] = 114;
        byArray2[26] = 101;
        byArray2[27] = 115;
        byArray2[28] = 115;
        byArray2[29] = 105;
        byArray2[30] = 111;
        byArray2[31] = 110;
        byArray2[32] = 7;
        byArray2[34] = 3;
        byArray2[35] = 1;
        byArray2[37] = 1;
        byArray2[38] = 101;
        byArray2[39] = 1;
        byArray2[41] = 19;
        byArray2[42] = 91;
        byArray2[43] = 76;
        byArray2[44] = 106;
        byArray2[45] = 97;
        byArray2[46] = 118;
        byArray2[47] = 97;
        byArray2[48] = 47;
        byArray2[49] = 108;
        byArray2[50] = 97;
        byArray2[51] = 110;
        byArray2[52] = 103;
        byArray2[53] = 47;
        byArray2[54] = 79;
        byArray2[55] = 98;
        byArray2[56] = 106;
        byArray2[57] = 101;
        byArray2[58] = 99;
        byArray2[59] = 116;
        byArray2[60] = 59;
        byArray2[61] = 1;
        byArray2[63] = 6;
        byArray2[64] = 60;
        byArray2[65] = 105;
        byArray2[66] = 110;
        byArray2[67] = 105;
        byArray2[68] = 116;
        byArray2[69] = 62;
        byArray2[70] = 1;
        byArray2[72] = 22;
        byArray2[73] = 40;
        byArray2[74] = 91;
        byArray2[75] = 76;
        byArray2[76] = 106;
        byArray2[77] = 97;
        byArray2[78] = 118;
        byArray2[79] = 97;
        byArray2[80] = 47;
        byArray2[81] = 108;
        byArray2[82] = 97;
        byArray2[83] = 110;
        byArray2[84] = 103;
        byArray2[85] = 47;
        byArray2[86] = 79;
        byArray2[87] = 98;
        byArray2[88] = 106;
        byArray2[89] = 101;
        byArray2[90] = 99;
        byArray2[91] = 116;
        byArray2[92] = 59;
        byArray2[93] = 41;
        byArray2[94] = 86;
        byArray2[95] = 1;
        byArray2[97] = 10;
        byArray2[98] = 69;
        byArray2[99] = 120;
        byArray2[100] = 99;
        byArray2[101] = 101;
        byArray2[102] = 112;
        byArray2[103] = 116;
        byArray2[104] = 105;
        byArray2[105] = 111;
        byArray2[106] = 110;
        byArray2[107] = 115;
        byArray2[108] = 1;
        byArray2[110] = 4;
        byArray2[111] = 67;
        byArray2[112] = 111;
        byArray2[113] = 100;
        byArray2[114] = 101;
        byArray2[115] = 1;
        byArray2[117] = 3;
        byArray2[118] = 40;
        byArray2[119] = 41;
        byArray2[120] = 86;
        byArray2[121] = 12;
        byArray2[123] = 7;
        byArray2[125] = 11;
        byArray2[126] = 10;
        byArray2[128] = 4;
        byArray2[130] = 12;
        byArray2[131] = 12;
        byArray2[133] = 5;
        byArray2[135] = 6;
        byArray2[136] = 9;
        byArray2[138] = 2;
        byArray2[140] = 14;
        byArray2[141] = 1;
        byArray2[143] = 7;
        byArray2[144] = 103;
        byArray2[145] = 101;
        byArray2[146] = 116;
        byArray2[147] = 84;
        byArray2[148] = 121;
        byArray2[149] = 112;
        byArray2[150] = 101;
        byArray2[151] = 1;
        byArray2[153] = 3;
        byArray2[154] = 40;
        byArray2[155] = 41;
        byArray2[156] = 73;
        byArray2[157] = 1;
        byArray2[159] = 19;
        byArray2[160] = 106;
        byArray2[161] = 97;
        byArray2[162] = 118;
        byArray2[163] = 97;
        byArray2[164] = 47;
        byArray2[165] = 108;
        byArray2[166] = 97;
        byArray2[167] = 110;
        byArray2[168] = 103;
        byArray2[169] = 47;
        byArray2[170] = 84;
        byArray2[171] = 104;
        byArray2[172] = 114;
        byArray2[173] = 111;
        byArray2[174] = 119;
        byArray2[175] = 97;
        byArray2[176] = 98;
        byArray2[177] = 108;
        byArray2[178] = 101;
        byArray2[179] = 7;
        byArray2[181] = 18;
        cp_middle = byArray2;
        byte[] byArray3 = new byte[95];
        byArray3[1] = 33;
        byArray3[3] = 2;
        byArray3[5] = 4;
        byArray3[9] = 1;
        byArray3[11] = 2;
        byArray3[13] = 5;
        byArray3[15] = 6;
        byArray3[19] = 3;
        byArray3[21] = 1;
        byArray3[23] = 7;
        byArray3[25] = 8;
        byArray3[27] = 2;
        byArray3[29] = 9;
        byArray3[33] = 2;
        byArray3[37] = 10;
        byArray3[41] = 22;
        byArray3[43] = 2;
        byArray3[45] = 2;
        byArray3[49] = 10;
        byArray3[50] = 42;
        byArray3[51] = -73;
        byArray3[53] = 13;
        byArray3[54] = 42;
        byArray3[55] = 43;
        byArray3[56] = -75;
        byArray3[58] = 15;
        byArray3[59] = -79;
        byArray3[65] = 1;
        byArray3[67] = 16;
        byArray3[69] = 17;
        byArray3[71] = 2;
        byArray3[73] = 9;
        byArray3[77] = 2;
        byArray3[81] = 10;
        byArray3[85] = 15;
        byArray3[87] = 1;
        byArray3[89] = 1;
        byArray3[93] = 3;
        byArray3[94] = 16;
        intermezzo1 = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = -84;
        byArray4[6] = 1;
        intermezzo2 = byArray4;
        byte[] byArray5 = new byte[14];
        byArray5[1] = 2;
        byArray5[3] = 9;
        byArray5[7] = 4;
        byArray5[9] = 1;
        byArray5[11] = 19;
        byArray5[13] = 10;
        intermezzo3 = byArray5;
        konetc = new byte[6];
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        returns = new byte[]{-84, -84, -84, -84, -84, -83, -82, -81};
        cvt_wide = new byte[]{-128, 64, 96, 80, 88, 92, 94, 95};
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 145;
        nArray2[2] = 145;
        nArray2[3] = 145;
        nArray2[4] = 145;
        nArray2[5] = 136;
        nArray2[6] = 139;
        nArray2[7] = 142;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 146;
        nArray3[1] = 146;
        nArray3[3] = 146;
        nArray3[4] = 146;
        nArray3[5] = 136;
        nArray3[6] = 139;
        nArray3[7] = 142;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 147;
        nArray4[1] = 147;
        nArray4[2] = 147;
        nArray4[4] = 147;
        nArray4[5] = 136;
        nArray4[6] = 139;
        nArray4[7] = 142;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[5] = 136;
        nArray5[6] = 139;
        nArray5[7] = 142;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 133;
        nArray6[1] = 133;
        nArray6[2] = 133;
        nArray6[3] = 133;
        nArray6[4] = 133;
        nArray6[6] = 140;
        nArray6[7] = 143;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 134;
        nArray7[1] = 134;
        nArray7[2] = 134;
        nArray7[3] = 134;
        nArray7[4] = 134;
        nArray7[5] = 137;
        nArray7[7] = 144;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 135;
        nArray8[1] = 135;
        nArray8[2] = 135;
        nArray8[3] = 135;
        nArray8[4] = 135;
        nArray8[5] = 138;
        nArray8[6] = 141;
        nArrayArray[7] = nArray8;
        cvt1 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[8];
        int[] nArray9 = new int[8];
        nArray9[5] = 145;
        nArray9[6] = 145;
        nArray9[7] = 145;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[8];
        nArray10[5] = 146;
        nArray10[6] = 146;
        nArray10[7] = 146;
        nArrayArray2[2] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[5] = 147;
        nArray11[6] = 147;
        nArray11[7] = 147;
        nArrayArray2[3] = nArray11;
        nArrayArray2[4] = new int[8];
        nArrayArray2[5] = new int[8];
        nArrayArray2[6] = new int[8];
        nArrayArray2[7] = new int[8];
        cvt2 = nArrayArray2;
        stkoccup = new byte[]{1, 1, 1, 1, 1, 2, 1, 2};
        int[][] nArrayArray3 = new int[8][];
        int[] nArray12 = new int[8];
        nArray12[1] = 255;
        nArray12[2] = 255;
        nArray12[3] = 255;
        nArray12[4] = 255;
        nArray12[5] = 255;
        nArray12[6] = 255;
        nArray12[7] = 255;
        nArrayArray3[0] = nArray12;
        nArrayArray3[1] = new int[]{255, 1, 255, 3, 4, 5, 6, 7};
        nArrayArray3[2] = new int[]{255, 255, 2, 255, 255, 255, 255, 255};
        nArrayArray3[3] = new int[]{255, 3, 255, 3, 4, 5, 6, 7};
        nArrayArray3[4] = new int[]{255, 4, 255, 4, 4, 5, 6, 7};
        nArrayArray3[5] = new int[]{255, 5, 255, 5, 5, 5, 6, 7};
        nArrayArray3[6] = new int[]{255, 6, 255, 6, 6, 6, 6, 7};
        nArrayArray3[7] = new int[]{255, 7, 255, 7, 7, 7, 7, 7};
        cvts = nArrayArray3;
        ops = new int[][]{{255, 96, 255, 96, 96, 97, 98, 99}, {255, 100, 255, 100, 100, 101, 102, 103}, {255, 104, 255, 104, 104, 105, 106, 107}, {255, 108, 255, 108, 108, 109, 110, 111}, {255, 112, 255, 112, 112, 113, 114, 115}, {126, 126, 255, 126, 126, 127, 255, 255}, {128, 128, 255, 128, 128, 129, 255, 255}, {130, 130, 255, 130, 130, 131, 255, 255}};
        int[] nArray13 = new int[8];
        nArray13[1] = 145;
        nArray13[2] = 146;
        nArray13[3] = 147;
        norm = nArray13;
        una = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119}};
        stor = new byte[]{54, 54, 54, 54, 54, 55, 56, 57, 58};
        load = new byte[]{21, 21, 21, 21, 21, 22, 23, 24, 25};
        sladdr = new byte[]{4, 4, 4, 4, 4, 5, 7, 8, 10};
    }
}

