/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.Library;
import gnu.jel.Optimizer;
import gnu.jel.generated.EC;
import gnu.jel.generated.ParseException;
import gnu.jel.generated.TokenMgrError;
import java.io.StringReader;

public class Evaluator {
    public static CompiledExpression compile(String string, Library library) throws CompilationException {
        return Evaluator.compile(string, library, null);
    }

    public static CompiledExpression compile(String string, Library library, Class clazz) throws CompilationException {
        return Evaluator.compileBits(string, library, clazz).getExpression();
    }

    public static ExpressionBits compileBits(String string, Library library) throws CompilationException {
        return Evaluator.compileBits(string, library, null);
    }

    public static ExpressionBits compileBits(String string, Library library, Class clazz) throws CompilationException {
        Optimizer optimizer = Evaluator.fillOptimizer(string, library, clazz);
        optimizer.optimize(1);
        return optimizer.compileBits();
    }

    static Optimizer fillOptimizer(String string, Library library, Class clazz) throws CompilationException {
        EC eC = new EC(new StringReader(string));
        Optimizer optimizer = new Optimizer(library);
        try {
            eC.expression(optimizer, clazz);
        }
        catch (ParseException parseException) {
            throw new CompilationException(parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new CompilationException(tokenMgrError);
        }
        return optimizer;
    }
}

