/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel.debug;

import gnu.jel.debug.Debug;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class Tester {
    private int succ_tst;
    private int fail_tst;
    private long initTime;
    private long totalTestTime;
    private String doing;
    private long initTestTime;
    private OutputStream log_stream;
    private PrintWriter log;

    public Tester(OutputStream stream) {
        this.log_stream = stream;
        this.log = new PrintWriter(this.log_stream, true);
        this.initTime = System.currentTimeMillis();
    }

    public void startTest(String descr) {
        Debug.assert(this.doing == null, "Concurrent testing is not supported.");
        StringBuffer stb = new StringBuffer(descr);
        stb.append(" ______________________________________________________________________");
        stb.setLength(60);
        this.doing = stb.toString();
        this.log.print(this.doing);
        this.log.flush();
        this.initTestTime = System.currentTimeMillis();
    }

    public void testOK() {
        long elapsed = System.currentTimeMillis() - this.initTestTime;
        Debug.assert(this.doing != null, "No test to succeed.");
        ++this.succ_tst;
        this.log.print(": OK   (in ");
        this.log.print(elapsed);
        this.totalTestTime += elapsed;
        this.log.println(" ms)");
        this.doing = null;
    }

    public void testFail() {
        long elapsed = System.currentTimeMillis() - this.initTestTime;
        Debug.assert(this.doing != null, "No test to fail.");
        ++this.fail_tst;
        this.log.print(": FAIL (in ");
        this.log.print(elapsed);
        this.totalTestTime += elapsed;
        this.log.println(" ms)");
        this.doing = null;
    }

    public void testFailProgressing() {
        if (this.doing != null) {
            this.testFail();
        }
    }

    public void summarize() {
        Debug.assert(this.doing == null, "Can't summarize, while test is in progress.");
        long elapsed = System.currentTimeMillis() - this.initTime;
        this.log.println();
        this.log.println("------");
        this.log.print("Total tests : ");
        this.log.print(this.succ_tst + this.fail_tst);
        this.log.print("  Passed : ");
        this.log.print(this.succ_tst);
        this.log.print("  Failed : ");
        this.log.print(this.fail_tst);
        this.log.print("  Test run time :");
        this.log.print(this.totalTestTime);
        this.log.print("  Elapsed time :");
        this.log.print(elapsed);
        this.log.println();
        this.log.print("Date of run :");
        this.log.println(new Date());
    }

    public boolean compare(byte[] got, byte[] exp) {
        boolean OK;
        boolean bl = OK = exp.length == got.length;
        if (!OK) {
            this.testFail();
            this.log.print("ByteArray length mismatch. Expected : ");
            this.log.print(exp.length);
            this.log.print("    Got : ");
            this.log.println(got.length);
            int j = 0;
            while (j < got.length) {
                this.log.print("GOT: ");
                this.printHexLine16(this.log, got, j);
                this.log.println();
                j += 16;
            }
            this.log.println();
            return false;
        }
        int i = 0;
        while (OK && i < exp.length) {
            OK = exp[i] == got[i];
            ++i;
        }
        if (!OK) {
            this.testFail();
            this.log.print("ByteArray contents mismatch at position ");
            this.log.print(i);
            this.log.print(" (");
            this.log.print(Integer.toHexString(i));
            this.log.println(" hex ).");
            int j = 0;
            while (j < exp.length) {
                this.log.print("EXP: ");
                this.printHexLine16(this.log, exp, j);
                this.log.println();
                this.log.print("GOT: ");
                this.printHexLine16(this.log, got, j);
                this.log.println();
                if (i >= j && i < j + 16) {
                    this.log.println(this.fillLeft("^^", 13 + (i - j) / 4 + 2 * (i - j) + 1, ' '));
                } else {
                    this.log.println();
                }
                j += 16;
            }
            this.log.println();
        }
        if (OK) {
            this.testOK();
        }
        return true;
    }

    public void printHexLine16(PrintWriter o, byte[] data, int offset) {
        o.print(this.fillLeft(Integer.toHexString(offset), 8, '0'));
        int i = 0;
        while (i < 16) {
            if (i % 4 == 0) {
                o.print(' ');
            }
            if (offset + i < data.length) {
                String bstr = Integer.toHexString(data[offset + i]);
                Debug.assert(bstr.length() < 3, "Crazy !!! Bytes are bigger than 256.");
                if (bstr.length() < 2) {
                    o.print('0');
                }
                o.print(bstr);
            } else {
                o.print(' ');
                o.print(' ');
            }
            ++i;
        }
        o.print(' ');
        o.print(' ');
        o.print('|');
        int i2 = 0;
        while (i2 < 16) {
            if (offset + i2 < data.length) {
                if (data[offset + i2] < 32) {
                    o.write(46);
                } else {
                    o.write(data[offset + i2]);
                }
            } else {
                o.print(' ');
            }
            ++i2;
        }
        o.print('|');
    }

    private String fillLeft(String str, int len, char chr) {
        Debug.assert(len > str.length(), "Offset too large.");
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < len - str.length()) {
            result.append(chr);
            ++i;
        }
        result.append(str);
        return result.toString();
    }

    public boolean compare(String got, String exp) {
        if (exp.equals(got)) {
            this.testOK();
            return true;
        }
        this.testFail();
        this.log.print("EXP: \"");
        this.log.print(exp);
        this.log.println("\"");
        this.log.print("GOT: \"");
        this.log.print(got);
        this.log.println("\"");
        this.log.println();
        return false;
    }

    public boolean compare(int got, int exp) {
        if (exp == got) {
            this.testOK();
            return true;
        }
        this.testFail();
        this.log.print("EXP: ");
        this.log.print(exp);
        this.log.println();
        this.log.print("GOT: ");
        this.log.print(got);
        this.log.println();
        this.log.println();
        return false;
    }

    public static void main(String[] args) {
        Tester tester = new Tester(System.out);
        tester.startTest("Simple non standard test (should pass)");
        tester.testOK();
        tester.startTest("Simple non standard test (should fail)");
        tester.testFail();
        byte[] b1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45};
        byte[] b2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46};
        byte[] b3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 66};
        tester.startTest("Byte array test (should pass)");
        tester.compare(b1, b1);
        tester.startTest("Byte array test (should fail length)");
        tester.compare(b1, b2);
        tester.startTest("Byte array test (should fail contents)");
        tester.compare(b3, b2);
        String s1 = "a string";
        String s2 = "another string";
        String s3 = "a string";
        tester.startTest("String cmp test (should pass)");
        tester.compare(s3, s1);
        tester.startTest("String cmp test (should fail)");
        tester.compare(s2, s1);
        tester.startTest("Integer cmp test (should pass)");
        tester.compare(1, 1);
        tester.startTest("Integer cmp test (should fail)");
        tester.compare(2, 1);
        tester.summarize();
    }
}

